/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.export;

import cn.ponfee.commons.export.AbstractDataExporter;
import cn.ponfee.commons.export.Table;
import cn.ponfee.commons.export.Thead;
import cn.ponfee.commons.io.Files;
import cn.ponfee.commons.tree.FlatNode;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractCsvExporter<T>
extends AbstractDataExporter<T> {
    protected final Appendable csv;
    private final char csvSeparator;
    private final AtomicBoolean hasBuild = new AtomicBoolean(false);

    public AbstractCsvExporter(Appendable csv) {
        this(csv, ',');
    }

    public AbstractCsvExporter(Appendable csv, char csvSeparator) {
        this.csv = csv;
        this.csvSeparator = csvSeparator;
    }

    @Override
    public final <E> void build(Table<E> table) {
        if (this.hasBuild.getAndSet(true)) {
            throw new UnsupportedOperationException("Only support single table.");
        }
        List<FlatNode<Integer, Thead>> thead = table.getThead();
        if (CollectionUtils.isEmpty(thead)) {
            throw new IllegalArgumentException("Thead cannot be null.");
        }
        this.buildComplexThead(thead);
        this.rollingTbody(table, (data, i) -> {
            try {
                int m = ((Object[])data).length - 1;
                for (int j = 0; j <= m; ++j) {
                    this.csv.append(AbstractCsvExporter.toString(data[j]));
                    if (j >= m) continue;
                    this.csv.append(this.csvSeparator);
                }
                this.csv.append(Files.SYSTEM_LINE_SEPARATOR);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        try {
            if (table.isEmptyTbody()) {
                this.csv.append("No results found");
            } else {
                super.nonEmpty();
            }
            if (ArrayUtils.isNotEmpty((Object[])table.getTfoot())) {
                int i2;
                FlatNode<Integer, Thead> root = thead.get(0);
                if (table.getTfoot().length > root.getTreeLeafCount()) {
                    throw new IllegalStateException("Tfoot length cannot more than total leaf count.");
                }
                int n = root.getTreeLeafCount();
                int m = table.getTfoot().length;
                int mergeNum = n - m;
                for (i2 = 0; i2 < mergeNum; ++i2) {
                    if (i2 == mergeNum - 1) {
                        this.csv.append("\u5408\u8ba1");
                    }
                    this.csv.append(this.csvSeparator);
                }
                for (i2 = mergeNum; i2 < n; ++i2) {
                    this.csv.append(AbstractCsvExporter.toString(table.getTfoot()[i2 - mergeNum]));
                    if (i2 == n - 1) continue;
                    this.csv.append(this.csvSeparator);
                }
                this.csv.append(Files.SYSTEM_LINE_SEPARATOR);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void buildComplexThead(List<FlatNode<Integer, Thead>> thead) {
        List<Thead> leafs = super.getLeafThead(thead);
        try {
            int n = leafs.size();
            for (int i = 0; i < n; ++i) {
                this.csv.append(leafs.get(i).getName());
                if (i == n - 1) continue;
                this.csv.append(this.csvSeparator);
            }
            this.csv.append(Files.SYSTEM_LINE_SEPARATOR);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String escapeCsv(String text) {
        return AbstractCsvExporter.escapeCsv(text, ',');
    }

    public static String escapeCsv(String text, char separator) {
        if (StringUtils.isEmpty((CharSequence)text)) {
            return text;
        }
        if (text.contains("\"")) {
            text = text.replace("\"", "\"\"");
        }
        if (StringUtils.contains((CharSequence)text, (int)separator)) {
            text = new StringBuilder(text.length() + 2).append('\"').append(text).append('\"').toString();
        }
        return text;
    }

    private static String toString(Object value) {
        return value == null ? "" : value.toString();
    }
}

