/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.export;

import cn.ponfee.commons.export.AbstractDataExporter;
import cn.ponfee.commons.export.CellStyleOptions;
import cn.ponfee.commons.export.Table;
import cn.ponfee.commons.export.Thead;
import cn.ponfee.commons.export.Tmeta;
import cn.ponfee.commons.math.Numbers;
import cn.ponfee.commons.tree.FlatNode;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class HtmlExporter
extends AbstractDataExporter<String> {
    public static final String HORIZON = "<hr style=\"border:3 double #b0c4de;with:95%;margin:20px 0;\" />";
    private static final String TEMPLATE = new StringBuilder(4096).append("<!DOCTYPE html>                                                                   \n").append("<html>                                                                            \n").append("  <head lang=\"en\">                                                              \n").append("    <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />     \n").append("    <title>{0}</title>                                                            \n").append("    '<style>                                                                      \n").append("      * {font-family: Microsoft YaHei;}                                           \n").append("      .grid {overflow-x: auto;background-color: #fff;color: #555;}                \n").append("      .grid table {                                                               \n").append("        width:100%;font-size:12px;border-collapse:collapse;border-style:hidden;   \n").append("      }                                                                           \n").append("      .grid table, div.grid table caption, div.grid table tr {                    \n").append("        border: 1px solid #6d6d6d;                                                \n").append("      }                                                                           \n").append("      .grid table tr td, div.grid table tr th {border: 1px solid #6d6d6d;}        \n").append("      .grid table caption {                                                       \n").append("        font-size:14px; padding:5px;                                              \n").append("        background:#e6e6fa; font-weight:bolder; border-bottom:none;               \n").append("      }                                                                           \n").append("      .grid table thead th {padding: 5px;background: #ccc;}                       \n").append("      .grid table td {text-align: center;padding: 3px;}                           \n").append("      .grid table td.text-left, .grid table th.text-left {text-align:left;}       \n").append("      .grid table td.text-right, .grid table th.text-right {text-align:right;}    \n").append("      .grid table td.text-center, .grid table th.text-center {text-align:center;} \n").append("      .grid table tfoot th {padding: 5px;}                                        \n").append("      .grid table tr:nth-child(odd) td{background:#fff;}                          \n").append("      .grid table tr:nth-child(even) td{background: #e8e8e8}                      \n").append("      .grid p.remark {font-size: 14px;}                                           \n").append("      .grid .nowrap {                                                             \n").append("        white-space:nowrap; word-break:keep-all;                                  \n").append("        overflow:hidden; text-overflow:ellipsis; max-width:200px;                 \n").append("      }                                                                           \n").append("    </style>'                                                                     \n").append("  </head>                                                                         \n").append("  <body>{1}</body>                                                                \n").append("</html>                                                                           \n").toString().replaceAll("\\s+\n", "\n");
    private final StringBuilder html;
    private final StringBuilder style = new StringBuilder();
    private final StringBuilder clazz = new StringBuilder();

    public HtmlExporter() {
        this.html = new StringBuilder(8192);
    }

    public HtmlExporter(String initHtml) {
        this.html = new StringBuilder(initHtml);
    }

    @Override
    public <E> void build(Table<E> table) {
        List<FlatNode<Integer, Thead>> flats = table.getThead();
        if (flats == null || flats.isEmpty()) {
            throw new IllegalArgumentException("thead can't be null");
        }
        this.horizon();
        this.html.append("<div class=\"grid\"><table cellpadding=\"0\" cellspacing=\"0\">");
        if (StringUtils.isNotBlank((CharSequence)table.getCaption())) {
            this.html.append("<caption>").append(table.getCaption()).append("</caption>");
        }
        this.buildComplexThead(flats);
        List<Thead> leafs = this.getLeafThead(flats);
        this.html.append("<tbody>");
        this.rollingTbody(table, (data, i) -> {
            this.html.append("<tr>");
            int m = ((Object[])data).length;
            for (int j = 0; j < m; ++j) {
                this.html.append("<td");
                this.processMeta(data[j], this.getTmeta(leafs, j), (int)i, j, table.getOptions());
                this.html.append(">").append(HtmlExporter.formatData(data[j], this.getTmeta(leafs, j))).append("</td>");
            }
            this.html.append("</tr>");
        });
        int totalLeafCount = flats.get(0).getTreeLeafCount();
        if (table.isEmptyTbody()) {
            this.html.append("<tr><td colspan=\"").append(totalLeafCount).append("\" style=\"color:red;padding:3px;font-size:14px;\">").append("No results found").append("</td></tr>");
        } else {
            super.nonEmpty();
        }
        this.html.append("</tbody>");
        boolean hasTfoot = false;
        if (ArrayUtils.isNotEmpty((Object[])table.getTfoot())) {
            hasTfoot = true;
            this.html.append("<tfoot><tr>");
            if (table.getTfoot().length > totalLeafCount) {
                throw new IllegalStateException("tfoot data length cannot more than total leaf count.");
            }
            int mergeNum = totalLeafCount - table.getTfoot().length;
            if (mergeNum > 0) {
                this.html.append("<th colspan=\"").append(mergeNum).append("\" style=\"text-align:right;\">\u5408\u8ba1</th>");
            }
            for (int i2 = 0; i2 < table.getTfoot().length; ++i2) {
                this.html.append("<th");
                this.processMeta(table.getTfoot()[i2], this.getTmeta(leafs, mergeNum + i2));
                this.html.append(">").append(HtmlExporter.formatData(table.getTfoot()[i2], this.getTmeta(leafs, mergeNum + i2))).append("</th>");
            }
            this.html.append("</tr></tfoot>");
        }
        if (StringUtils.isNotBlank((CharSequence)table.getComment())) {
            String[] comments = table.getComment().split(";");
            StringBuilder builder = new StringBuilder("<tr><td colspan=\"").append(totalLeafCount).append("\" style=\"color:red; padding:3px;font-size:14px;\">").append("<div style=\"text-align:left;font-weight:bold;\">\u5907\u6ce8\uff1a</div>");
            for (String comment : comments) {
                builder.append("<div style=\"text-align:left;text-indent:2em;\">").append(comment).append("</div>");
            }
            builder.append("</td></tr>");
            if (hasTfoot) {
                this.html.insert(this.html.length() - "</tfoot>".length(), builder);
            } else {
                this.html.append("<tfoot>").append((CharSequence)builder).append("</tfoot>");
            }
        }
        this.html.append("</table></div>");
    }

    @Override
    public String export() {
        return MessageFormat.format(TEMPLATE, super.getName(), this.html.toString());
    }

    public String body() {
        return this.html.toString();
    }

    public HtmlExporter horizon() {
        if (this.html.length() > 0) {
            this.html.append(HORIZON);
        }
        return this;
    }

    public HtmlExporter append(String string) {
        if (StringUtils.isNotBlank((CharSequence)string)) {
            super.nonEmpty();
            this.html.append(string);
        }
        return this;
    }

    public HtmlExporter insertImage(String imageB64) {
        super.nonEmpty();
        this.html.append("<img src=\"").append(imageB64).append("\" />");
        return this;
    }

    private void buildComplexThead(List<FlatNode<Integer, Thead>> flats) {
        this.html.append("<thead><tr>");
        int lastLevel = 1;
        int treeDepth = flats.get(0).getTreeDepth() - 1;
        for (FlatNode<Integer, Thead> flat : flats.subList(1, flats.size())) {
            int cellLevel = flat.getLevel() - 1;
            if (lastLevel < cellLevel) {
                this.html.append("</tr><tr>");
                lastLevel = cellLevel;
            }
            this.html.append("<th");
            if (flat.isLeaf()) {
                if (treeDepth - cellLevel > 0) {
                    this.html.append(" rowspan=\"").append(treeDepth - cellLevel + 1).append("\"");
                }
            } else if (flat.getTreeLeafCount() > 1) {
                this.html.append(" colspan=\"").append(flat.getTreeLeafCount()).append("\"");
            }
            this.html.append(">").append(((Thead)flat.getAttach()).getName()).append("</th>");
        }
        this.html.append("</tr></thead>");
    }

    private Tmeta getTmeta(List<Thead> thead, int index) {
        return thead.get(index).getTmeta();
    }

    private void processMeta(Object value, Tmeta tmeta) {
        this.processMeta(value, tmeta, -1, -1, null);
    }

    private void processMeta(Object value, Tmeta tmeta, int tbodyRowIdx, int tbodyColIdx, Map<CellStyleOptions, Object> options) {
        this.style.setLength(0);
        this.clazz.setLength(0);
        if (tmeta != null) {
            switch (tmeta.getAlign()) {
                case LEFT: {
                    this.clazz.append("text-left ");
                    break;
                }
                case CENTER: {
                    this.clazz.append("text-center ");
                    break;
                }
                case RIGHT: {
                    this.clazz.append("text-right ");
                    break;
                }
            }
            if (tmeta.getColor() != null) {
                this.style.append("color:").append(tmeta.getColorHex()).append(";");
            }
            if (tmeta.isNowrap()) {
                this.clazz.append("nowrap ");
            }
        }
        HtmlExporter.processOptions(this.style, tbodyRowIdx, tbodyColIdx, options);
        if (this.style.length() > 0) {
            this.html.append(" style=\"").append((CharSequence)this.style).append("\"");
        }
        if (this.clazz.length() > 0) {
            this.clazz.setLength(this.clazz.length() - 1);
            this.html.append(" class=\"").append((CharSequence)this.clazz).append("\"");
        }
    }

    private static String formatData(Object data, Tmeta tmeta) {
        if (data == null) {
            return "";
        }
        if (tmeta == null) {
            return data.toString();
        }
        if (tmeta.getType() == Tmeta.Type.NUMERIC) {
            return Numbers.format(data);
        }
        return data.toString();
    }

    private static void processOptions(StringBuilder style, int dataRowIdx, int dataColIdx, Map<CellStyleOptions, Object> options) {
        Function processor;
        if (options == null || options.isEmpty()) {
            return;
        }
        Map highlight = (Map)options.get((Object)CellStyleOptions.HIGHLIGHT);
        if (highlight != null && !highlight.isEmpty()) {
            String color = "color:" + highlight.get("color") + ";font-weight:bold;";
            List cells = (List)highlight.get("cells");
            for (List cell : cells) {
                if (!((Integer)cell.get(0)).equals(dataRowIdx) || !((Integer)cell.get(1)).equals(dataColIdx)) continue;
                style.append(color);
            }
        }
        if ((processor = (Function)options.get((Object)CellStyleOptions.CELL_PROCESS)) != null) {
            style.append((String)processor.apply(new Object[]{dataRowIdx, dataColIdx}));
        }
    }
}

