/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.extract;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;

public class ExtractableDataSource
implements Closeable {
    private final Object dataSource;

    public ExtractableDataSource(@Nonnull Object dataSource) {
        if (!(dataSource instanceof InputStream) && !(dataSource instanceof File)) {
            throw new IllegalArgumentException("Invalid datasource '" + dataSource.getClass().getName() + "', only support File or InputStream.");
        }
        this.dataSource = dataSource;
    }

    @Override
    public void close() throws IOException {
        if (this.dataSource instanceof InputStream) {
            ((InputStream)this.dataSource).close();
        }
    }

    public Object getDataSource() {
        return this.dataSource;
    }

    public InputStream asInputStream() throws IOException {
        return this.dataSource instanceof File ? new FileInputStream((File)this.dataSource) : (InputStream)this.dataSource;
    }
}

