/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.jce.implementation.digest;

public class RipeMD160Digest {
    private static final int[][] ARG_ARRAY = new int[][]{{11, 14, 15, 12, 5, 8, 7, 9, 11, 13, 14, 15, 6, 7, 9, 8, 7, 6, 8, 13, 11, 9, 7, 15, 7, 12, 15, 9, 11, 7, 13, 12, 11, 13, 6, 7, 14, 9, 13, 15, 14, 8, 13, 6, 5, 12, 7, 5, 11, 12, 14, 15, 14, 15, 9, 8, 9, 14, 5, 6, 8, 6, 5, 12, 9, 15, 5, 11, 6, 8, 13, 12, 5, 12, 13, 14, 11, 8, 5, 6}, {8, 9, 9, 11, 13, 15, 15, 5, 7, 7, 8, 11, 14, 14, 12, 6, 9, 13, 15, 7, 12, 8, 9, 11, 7, 7, 12, 7, 6, 15, 13, 11, 9, 7, 15, 11, 8, 6, 6, 14, 12, 13, 5, 14, 13, 13, 7, 5, 15, 5, 8, 11, 14, 14, 6, 14, 6, 9, 12, 9, 12, 5, 15, 8, 8, 5, 12, 9, 12, 5, 14, 6, 8, 13, 6, 5, 15, 13, 11, 11}};
    private static final int[][] IDX_ARRAY = new int[][]{{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 7, 4, 13, 1, 10, 6, 15, 3, 12, 0, 9, 5, 2, 14, 11, 8, 3, 10, 14, 4, 9, 15, 8, 1, 2, 7, 0, 6, 13, 11, 5, 12, 1, 9, 11, 10, 0, 8, 12, 4, 13, 3, 7, 15, 14, 5, 6, 2, 4, 0, 5, 9, 7, 12, 2, 10, 14, 1, 3, 8, 11, 6, 15, 13}, {5, 14, 7, 0, 9, 2, 11, 4, 13, 6, 15, 8, 1, 10, 3, 12, 6, 11, 3, 7, 0, 13, 5, 10, 14, 15, 8, 12, 4, 9, 1, 2, 15, 5, 1, 3, 7, 14, 6, 9, 11, 8, 12, 2, 10, 0, 4, 13, 8, 6, 4, 1, 3, 11, 15, 0, 5, 12, 2, 13, 9, 7, 10, 14, 12, 15, 10, 4, 1, 5, 8, 7, 6, 2, 13, 14, 0, 3, 9, 11}};
    private static final int[] CHAIN_VAR = new int[]{1732584193, -271733879, -1732584194, 271733878, -1009589776};
    private static final int BLOCK_SIZE = 64;
    private static final int DIGEST_SIZE = 20;
    private final int[] digest = new int[CHAIN_VAR.length];
    private int[] working;
    private int wOffset;
    private int byteCount;

    private RipeMD160Digest() {
        this.reset();
    }

    private RipeMD160Digest(RipeMD160Digest d) {
        System.arraycopy(d.digest, 0, this.digest, 0, d.digest.length);
        System.arraycopy(d.working, 0, this.working, 0, d.working.length);
        this.wOffset = d.wOffset;
        this.byteCount = d.byteCount;
    }

    public static RipeMD160Digest getInstance() {
        return new RipeMD160Digest();
    }

    public static RipeMD160Digest getInstance(RipeMD160Digest d) {
        return new RipeMD160Digest(d);
    }

    public void reset() {
        System.arraycopy(CHAIN_VAR, 0, this.digest, 0, CHAIN_VAR.length);
        this.working = new int[16];
        this.wOffset = 0;
        this.byteCount = 0;
    }

    public void update(byte input) {
        int n = this.wOffset >> 2;
        this.working[n] = this.working[n] ^ input << ((this.wOffset & 3) << 3);
        ++this.wOffset;
        if (this.wOffset == 64) {
            this.digestBlock(this.working);
            for (int j = 0; j < 16; ++j) {
                this.working[j] = 0;
            }
            this.wOffset = 0;
        }
        ++this.byteCount;
    }

    public void update(byte[] input) {
        this.update(input, 0, input.length);
    }

    public void update(byte[] input, int offset, int len) {
        len = Math.min(len, input.length - offset);
        for (int i = offset; i < offset + len; ++i) {
            this.update(input[i]);
        }
    }

    public void update(String s) {
        byte[] array = new byte[s.length()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = (byte)s.charAt(i);
        }
        this.update(array);
    }

    public byte[] doFinal() {
        this.finish(this.working, this.byteCount, 0);
        byte[] result = new byte[this.digest.length << 2];
        for (int i = 0; i < 20; ++i) {
            result[i] = (byte)(this.digest[i >> 2] >>> ((i & 3) << 3));
        }
        this.reset();
        return result;
    }

    public byte[] doFinal(byte[] input) {
        this.update(input, 0, input.length);
        return this.doFinal();
    }

    public byte[] doFinal(byte[] input, int offset, int len) {
        this.update(input, offset, len);
        return this.doFinal();
    }

    private void digestBlock(int[] X) {
        int s;
        int temp;
        int i;
        int e;
        int d;
        int c;
        int b;
        int a;
        int A = a = this.digest[0];
        int B = b = this.digest[1];
        int C = c = this.digest[2];
        int D = d = this.digest[3];
        int E2 = e = this.digest[4];
        for (i = 0; i < 16; ++i) {
            temp = a + (b ^ c ^ d) + X[IDX_ARRAY[0][i]];
            a = e;
            e = d;
            d = c << 10 | c >>> 22;
            c = b;
            s = ARG_ARRAY[0][i];
            b = (temp << s | temp >>> 32 - s) + a;
            temp = A + (B ^ (C | ~D)) + X[IDX_ARRAY[1][i]] + 1352829926;
            A = E2;
            E2 = D;
            D = C << 10 | C >>> 22;
            C = B;
            s = ARG_ARRAY[1][i];
            B = (temp << s | temp >>> 32 - s) + A;
        }
        while (i < 32) {
            temp = a + (b & c | ~b & d) + X[IDX_ARRAY[0][i]] + 1518500249;
            a = e;
            e = d;
            d = c << 10 | c >>> 22;
            c = b;
            s = ARG_ARRAY[0][i];
            b = (temp << s | temp >>> 32 - s) + a;
            temp = A + (B & D | C & ~D) + X[IDX_ARRAY[1][i]] + 1548603684;
            A = E2;
            E2 = D;
            D = C << 10 | C >>> 22;
            C = B;
            s = ARG_ARRAY[1][i];
            B = (temp << s | temp >>> 32 - s) + A;
            ++i;
        }
        while (i < 48) {
            temp = a + ((b | ~c) ^ d) + X[IDX_ARRAY[0][i]] + 1859775393;
            a = e;
            e = d;
            d = c << 10 | c >>> 22;
            c = b;
            s = ARG_ARRAY[0][i];
            b = (temp << s | temp >>> 32 - s) + a;
            temp = A + ((B | ~C) ^ D) + X[IDX_ARRAY[1][i]] + 1836072691;
            A = E2;
            E2 = D;
            D = C << 10 | C >>> 22;
            C = B;
            s = ARG_ARRAY[1][i];
            B = (temp << s | temp >>> 32 - s) + A;
            ++i;
        }
        while (i < 64) {
            temp = a + (b & d | c & ~d) + X[IDX_ARRAY[0][i]] + -1894007588;
            a = e;
            e = d;
            d = c << 10 | c >>> 22;
            c = b;
            s = ARG_ARRAY[0][i];
            b = (temp << s | temp >>> 32 - s) + a;
            temp = A + (B & C | ~B & D) + X[IDX_ARRAY[1][i]] + 2053994217;
            A = E2;
            E2 = D;
            D = C << 10 | C >>> 22;
            C = B;
            s = ARG_ARRAY[1][i];
            B = (temp << s | temp >>> 32 - s) + A;
            ++i;
        }
        while (i < 80) {
            temp = a + (b ^ (c | ~d)) + X[IDX_ARRAY[0][i]] + -1454113458;
            a = e;
            e = d;
            d = c << 10 | c >>> 22;
            c = b;
            s = ARG_ARRAY[0][i];
            b = (temp << s | temp >>> 32 - s) + a;
            temp = A + (B ^ C ^ D) + X[IDX_ARRAY[1][i]];
            A = E2;
            E2 = D;
            D = C << 10 | C >>> 22;
            C = B;
            s = ARG_ARRAY[1][i];
            B = (temp << s | temp >>> 32 - s) + A;
            ++i;
        }
        this.digest[1] = this.digest[2] + d + E2;
        this.digest[2] = this.digest[3] + e + A;
        this.digest[3] = this.digest[4] + a + B;
        this.digest[4] = this.digest[0] + b + C;
        this.digest[0] = D += c + this.digest[1];
    }

    private void finish(int[] array, int lswlen, int mswlen) {
        int n = lswlen >> 2 & 0xF;
        array[n] = array[n] ^ 1 << ((lswlen & 3) << 3) + 7;
        if ((lswlen & 0x3F) > 55) {
            this.digestBlock(array);
            for (int i = 0; i < 14; ++i) {
                array[i] = 0;
            }
        }
        array[14] = lswlen << 3;
        array[15] = lswlen >> 29 | mswlen << 3;
        this.digestBlock(array);
    }

    public static int getDigestSize() {
        return 20;
    }
}

