/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.jce.implementation.rsa;

import cn.ponfee.commons.jce.HmacAlgorithms;
import cn.ponfee.commons.jce.Providers;
import cn.ponfee.commons.jce.digest.HmacUtils;
import cn.ponfee.commons.jce.implementation.Key;
import cn.ponfee.commons.jce.implementation.rsa.AbstractRSACryptor;
import cn.ponfee.commons.jce.implementation.rsa.RSAKey;
import cn.ponfee.commons.util.Bytes;
import cn.ponfee.commons.util.SecureRandoms;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Arrays;

public class RSAHashCryptor
extends AbstractRSACryptor {
    private static final HmacAlgorithms HMAC_ALG = HmacAlgorithms.HmacSHA3_512;

    public RSAHashCryptor() {
        super(false);
    }

    @Override
    public byte[] encrypt(byte[] input, int length, Key ek) {
        RSAKey rsaKey = (RSAKey)ek;
        int keyByteLen = rsaKey.n.bitLength() / 8;
        int count = 1;
        BigInteger exponent = this.getExponent(rsaKey);
        BigInteger key = SecureRandoms.random(rsaKey.n);
        byte[] encryptedKey = key.modPow(exponent, rsaKey.n).toByteArray();
        byte[] result = new byte[keyByteLen + length];
        Bytes.tailCopy(encryptedKey, 0, encryptedKey.length, result, 0, keyByteLen);
        byte[] keyArray = key.toByteArray();
        byte[] hashedKey = HmacUtils.crypt(keyArray, Bytes.toBytes(count), HMAC_ALG, Providers.BC);
        int keyOffset = 0;
        for (int i = 0; i < length; ++i) {
            if (keyOffset == HMAC_ALG.byteSize()) {
                keyOffset = 0;
                hashedKey = HmacUtils.crypt(keyArray, Bytes.toBytes(++count), HMAC_ALG, Providers.BC);
            }
            result[keyByteLen + i] = (byte)(input[i] ^ hashedKey[keyOffset++]);
        }
        return result;
    }

    @Override
    public byte[] decrypt(byte[] input, Key dk) {
        RSAKey rsaKey = (RSAKey)dk;
        int keyByteLen = rsaKey.n.bitLength() / 8;
        int count = 1;
        BigInteger exponent = this.getExponent(rsaKey);
        byte[] encryptedKey = Arrays.copyOfRange(input, 0, keyByteLen);
        BigInteger key = new BigInteger(1, encryptedKey).modPow(exponent, rsaKey.n);
        byte[] keyArray = key.toByteArray();
        byte[] hashedKey = HmacUtils.crypt(keyArray, Bytes.toBytes(count), HMAC_ALG, Providers.BC);
        byte[] result = new byte[input.length - keyByteLen];
        int keyOffset = 0;
        int rLen = result.length;
        for (int i = 0; i < rLen; ++i) {
            if (keyOffset == HMAC_ALG.byteSize()) {
                keyOffset = 0;
                hashedKey = HmacUtils.crypt(keyArray, Bytes.toBytes(++count), HMAC_ALG, Providers.BC);
            }
            result[i] = (byte)(input[keyByteLen + i] ^ hashedKey[keyOffset++]);
        }
        return result;
    }

    @Override
    public void encrypt(InputStream input, Key ek, OutputStream output) {
        RSAKey rsaKey = (RSAKey)ek;
        int keyByteLen = rsaKey.n.bitLength() / 8;
        int count = 1;
        BigInteger exponent = this.getExponent(rsaKey);
        BigInteger key = SecureRandoms.random(rsaKey.n);
        byte[] encryptedKey = key.modPow(exponent, rsaKey.n).toByteArray();
        byte[] encryptedKey0 = new byte[keyByteLen];
        Bytes.tailCopy(encryptedKey, 0, encryptedKey.length, encryptedKey0, 0, keyByteLen);
        byte[] keyArray = key.toByteArray();
        byte[] hashedKey = HmacUtils.crypt(keyArray, Bytes.toBytes(count), HMAC_ALG, Providers.BC);
        try {
            int len;
            output.write(encryptedKey0);
            byte[] buffer = new byte[this.getOriginBlockSize(rsaKey)];
            int keyOffset = 0;
            while ((len = input.read(buffer)) != -1) {
                for (int i = 0; i < len; ++i) {
                    if (keyOffset == HMAC_ALG.byteSize()) {
                        keyOffset = 0;
                        hashedKey = HmacUtils.crypt(keyArray, Bytes.toBytes(++count), HMAC_ALG, Providers.BC);
                    }
                    output.write((byte)(buffer[i] ^ hashedKey[keyOffset++]));
                }
            }
            output.flush();
        }
        catch (IOException e) {
            throw new SecurityException(e);
        }
    }

    @Override
    public void decrypt(InputStream input, Key dk, OutputStream output) {
        RSAKey rsaKey = (RSAKey)dk;
        int keyByteLen = rsaKey.n.bitLength() / 8;
        int count = 1;
        BigInteger exponent = this.getExponent(rsaKey);
        try {
            int len;
            if (input.available() < keyByteLen) {
                throw new IllegalArgumentException("Invalid cipher data");
            }
            byte[] encryptedKey = new byte[keyByteLen];
            input.read(encryptedKey);
            BigInteger key = new BigInteger(1, encryptedKey).modPow(exponent, rsaKey.n);
            byte[] buffer = new byte[this.getCipherBlockSize(rsaKey)];
            byte[] keyArray = key.toByteArray();
            byte[] hashedKey = HmacUtils.crypt(keyArray, Bytes.toBytes(count), HMAC_ALG, Providers.BC);
            int keyOffset = 0;
            while ((len = input.read(buffer)) != -1) {
                for (int i = 0; i < len; ++i) {
                    if (keyOffset == HMAC_ALG.byteSize()) {
                        keyOffset = 0;
                        hashedKey = HmacUtils.crypt(keyArray, Bytes.toBytes(++count), HMAC_ALG, Providers.BC);
                    }
                    output.write((byte)(buffer[i] ^ hashedKey[keyOffset++]));
                }
            }
            output.flush();
        }
        catch (IOException e) {
            throw new SecurityException(e);
        }
    }

    @Override
    public int getOriginBlockSize(RSAKey rsaKey) {
        return 4096;
    }

    @Override
    public int getCipherBlockSize(RSAKey rsaKey) {
        return this.getOriginBlockSize(rsaKey);
    }
}

