/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.jce.passwd;

import cn.ponfee.commons.jce.HmacAlgorithms;
import cn.ponfee.commons.jce.Providers;
import cn.ponfee.commons.jce.digest.HmacUtils;
import cn.ponfee.commons.util.Base64UrlSafe;
import cn.ponfee.commons.util.SecureRandoms;
import com.google.common.base.Preconditions;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.ShortBufferException;

public final class SCrypt {
    private static final char SEPARATOR = '$';

    private SCrypt() {
    }

    public static String create(String passwd, int N, int r, int p) {
        return SCrypt.create(HmacAlgorithms.HmacSHA256, passwd, N, r, p, 32);
    }

    public static String create(HmacAlgorithms alg, String passwd, int N, int r, int p, int dkLen) {
        Preconditions.checkArgument((N > 0 && N <= 15 ? 1 : 0) != 0, (Object)"N must between 1 and 15");
        Preconditions.checkArgument((r > 0 && r <= 255 ? 1 : 0) != 0, (Object)"r must between 1 and 255");
        Preconditions.checkArgument((p > 0 && p <= 255 ? 1 : 0) != 0, (Object)"p must between 1 and 255");
        int algIdx = (Integer)HmacAlgorithms.ALGORITHM_MAPPING.inverse().get((Object)alg) & 0xF;
        byte[] salt = SecureRandoms.nextBytes(16);
        byte[] derived = SCrypt.scrypt(alg, passwd.getBytes(StandardCharsets.UTF_8), salt, 1 << N, r, p, dkLen);
        String params = Integer.toString(algIdx << 20 | N << 16 | r << 8 | p, 16);
        return new StringBuilder(12 + (salt.length + derived.length << 2) / 3 + 4).append('$').append("s0").append('$').append(params).append('$').append(Base64UrlSafe.encode(salt)).append('$').append(Base64UrlSafe.encode(derived)).toString();
    }

    public static boolean check(String passwd, String hashed) {
        String[] parts = hashed.split("\\$");
        if (parts.length != 5 || !"s0".equals(parts[1])) {
            throw new IllegalArgumentException("Invalid hashed value");
        }
        int params = Integer.parseInt(parts[2], 16);
        byte[] salt = Base64UrlSafe.decode(parts[3]);
        byte[] actual = Base64UrlSafe.decode(parts[4]);
        int algIdx = params >> 20 & 0xF;
        int N = params >> 16 & 0xF;
        int r = params >> 8 & 0xFF;
        int p = params & 0xFF;
        byte[] except = SCrypt.scrypt((HmacAlgorithms)((Object)HmacAlgorithms.ALGORITHM_MAPPING.get((Object)algIdx)), passwd.getBytes(StandardCharsets.UTF_8), salt, 1 << N, r, p, actual.length);
        return Arrays.equals(actual, except);
    }

    public static byte[] pbkdf2(HmacAlgorithms alg, byte[] P, byte[] S, int c, int dkLen) {
        Mac mac = HmacUtils.getInitializedMac(alg, Providers.BC, P);
        int hLen = mac.getMacLength();
        if ((long)dkLen > 0xFFFFFFFFL * (long)hLen) {
            throw new SecurityException("Requested key length too long");
        }
        byte[] U = new byte[hLen];
        byte[] T = new byte[hLen];
        byte[] block = new byte[S.length + 4];
        int n = (int)Math.ceil((double)dkLen / (double)hLen);
        int r = dkLen - (n - 1) * hLen;
        System.arraycopy(S, 0, block, 0, S.length);
        byte[] DK = new byte[dkLen];
        for (int i = 1; i <= n; ++i) {
            block[S.length] = (byte)(i >> 24 & 0xFF);
            block[S.length + 1] = (byte)(i >> 16 & 0xFF);
            block[S.length + 2] = (byte)(i >> 8 & 0xFF);
            block[S.length + 3] = (byte)(i & 0xFF);
            mac.update(block);
            try {
                mac.doFinal(U, 0);
                System.arraycopy(U, 0, T, 0, hLen);
                for (int j = 1; j < c; ++j) {
                    mac.update(U);
                    mac.doFinal(U, 0);
                    for (int k = 0; k < hLen; ++k) {
                        int n2 = k;
                        T[n2] = (byte)(T[n2] ^ U[k]);
                    }
                }
            }
            catch (IllegalStateException | ShortBufferException e) {
                throw new SecurityException(e);
            }
            System.arraycopy(T, 0, DK, (i - 1) * hLen, i == n ? r : hLen);
        }
        return DK;
    }

    public static byte[] scrypt(HmacAlgorithms alg, byte[] P, byte[] S, int N, int r, int p, int dkLen) {
        if (r > 0xFFFFFF / p) {
            throw new IllegalArgumentException("Parameter r is too large");
        }
        if (N > 0xFFFFFF / r) {
            throw new IllegalArgumentException("Parameter N is too large");
        }
        byte[] B = SCrypt.pbkdf2(alg, P, S, 1, (p << 7) * r);
        byte[] XY = new byte[r << 8];
        byte[] V = new byte[(r << 7) * N];
        for (int i = 0; i < p; ++i) {
            SCrypt.smix(B, (i << 7) * r, r, N, V, XY);
        }
        return SCrypt.pbkdf2(alg, P, B, 1, dkLen);
    }

    private static void smix(byte[] B, int Bi, int r, int N, byte[] V, byte[] XY) {
        int i;
        int Xi = 0;
        int Yi = r << 7;
        System.arraycopy(B, Bi, XY, Xi, Yi);
        for (i = 0; i < N; ++i) {
            System.arraycopy(XY, Xi, V, i * Yi, Yi);
            SCrypt.blockmix_salsa8(XY, Xi, Yi, r);
        }
        for (i = 0; i < N; ++i) {
            int j = SCrypt.integerify(XY, Xi, r) & N - 1;
            SCrypt.blockxor(V, j * Yi, XY, Xi, Yi);
            SCrypt.blockmix_salsa8(XY, Xi, Yi, r);
        }
        System.arraycopy(XY, Xi, B, Bi, Yi);
    }

    private static void blockmix_salsa8(byte[] BY, int Bi, int Yi, int r) {
        int i;
        byte[] X = new byte[64];
        System.arraycopy(BY, Bi + (2 * r - 1 << 6), X, 0, 64);
        int n = r << 1;
        for (i = 0; i < n; ++i) {
            int m = i << 6;
            SCrypt.blockxor(BY, m, X, 0, 64);
            SCrypt.salsa20_8(X);
            System.arraycopy(X, 0, BY, Yi + m, 64);
        }
        for (i = 0; i < r; ++i) {
            System.arraycopy(BY, Yi + (i << 7), BY, Bi + (i << 6), 64);
        }
        for (i = 0; i < r; ++i) {
            System.arraycopy(BY, Yi + ((i << 1) + 1 << 6), BY, Bi + (i + r << 6), 64);
        }
    }

    private static int R(int a, int b) {
        return a << b | a >>> 32 - b;
    }

    private static void salsa20_8(byte[] B) {
        int i;
        int[] B32 = new int[16];
        int[] x = new int[16];
        for (i = 0; i < 16; ++i) {
            B32[i] = B[i << 2] & 0xFF;
            int n = i;
            B32[n] = B32[n] | (B[(i << 2) + 1] & 0xFF) << 8;
            int n2 = i;
            B32[n2] = B32[n2] | (B[(i << 2) + 2] & 0xFF) << 16;
            int n3 = i;
            B32[n3] = B32[n3] | (B[(i << 2) + 3] & 0xFF) << 24;
        }
        System.arraycopy(B32, 0, x, 0, 16);
        for (i = 8; i > 0; i -= 2) {
            x[4] = x[4] ^ SCrypt.R(x[0] + x[12], 7);
            x[8] = x[8] ^ SCrypt.R(x[4] + x[0], 9);
            x[12] = x[12] ^ SCrypt.R(x[8] + x[4], 13);
            x[0] = x[0] ^ SCrypt.R(x[12] + x[8], 18);
            x[9] = x[9] ^ SCrypt.R(x[5] + x[1], 7);
            x[13] = x[13] ^ SCrypt.R(x[9] + x[5], 9);
            x[1] = x[1] ^ SCrypt.R(x[13] + x[9], 13);
            x[5] = x[5] ^ SCrypt.R(x[1] + x[13], 18);
            x[14] = x[14] ^ SCrypt.R(x[10] + x[6], 7);
            x[2] = x[2] ^ SCrypt.R(x[14] + x[10], 9);
            x[6] = x[6] ^ SCrypt.R(x[2] + x[14], 13);
            x[10] = x[10] ^ SCrypt.R(x[6] + x[2], 18);
            x[3] = x[3] ^ SCrypt.R(x[15] + x[11], 7);
            x[7] = x[7] ^ SCrypt.R(x[3] + x[15], 9);
            x[11] = x[11] ^ SCrypt.R(x[7] + x[3], 13);
            x[15] = x[15] ^ SCrypt.R(x[11] + x[7], 18);
            x[1] = x[1] ^ SCrypt.R(x[0] + x[3], 7);
            x[2] = x[2] ^ SCrypt.R(x[1] + x[0], 9);
            x[3] = x[3] ^ SCrypt.R(x[2] + x[1], 13);
            x[0] = x[0] ^ SCrypt.R(x[3] + x[2], 18);
            x[6] = x[6] ^ SCrypt.R(x[5] + x[4], 7);
            x[7] = x[7] ^ SCrypt.R(x[6] + x[5], 9);
            x[4] = x[4] ^ SCrypt.R(x[7] + x[6], 13);
            x[5] = x[5] ^ SCrypt.R(x[4] + x[7], 18);
            x[11] = x[11] ^ SCrypt.R(x[10] + x[9], 7);
            x[8] = x[8] ^ SCrypt.R(x[11] + x[10], 9);
            x[9] = x[9] ^ SCrypt.R(x[8] + x[11], 13);
            x[10] = x[10] ^ SCrypt.R(x[9] + x[8], 18);
            x[12] = x[12] ^ SCrypt.R(x[15] + x[14], 7);
            x[13] = x[13] ^ SCrypt.R(x[12] + x[15], 9);
            x[14] = x[14] ^ SCrypt.R(x[13] + x[12], 13);
            x[15] = x[15] ^ SCrypt.R(x[14] + x[13], 18);
        }
        for (i = 0; i < 16; ++i) {
            B32[i] = x[i] + B32[i];
        }
        for (i = 0; i < 16; ++i) {
            B[i << 2] = (byte)(B32[i] & 0xFF);
            B[(i << 2) + 1] = (byte)(B32[i] >> 8 & 0xFF);
            B[(i << 2) + 2] = (byte)(B32[i] >> 16 & 0xFF);
            B[(i << 2) + 3] = (byte)(B32[i] >> 24 & 0xFF);
        }
    }

    private static void blockxor(byte[] S, int Si, byte[] D, int Di, int len) {
        for (int i = 0; i < len; ++i) {
            int n = Di + i;
            D[n] = (byte)(D[n] ^ S[Si + i]);
        }
    }

    private static int integerify(byte[] B, int Bi, int r) {
        return B[Bi += 2 * r - 1 << 6] & 0xFF | (B[Bi + 1] & 0xFF) << 8 | (B[Bi + 2] & 0xFF) << 16 | (B[Bi + 3] & 0xFF) << 24;
    }
}

