/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.jce.security;

import cn.ponfee.commons.jce.Providers;
import cn.ponfee.commons.jce.symmetric.Algorithm;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public final class DHKeyExchanger {
    private static final String ALGORITHM = "DH";

    public static Pair<DHPublicKey, DHPrivateKey> initPartAKey() {
        return DHKeyExchanger.initPartAKey(1024);
    }

    public static Pair<DHPublicKey, DHPrivateKey> initPartAKey(int keySize) {
        KeyPairGenerator keyPairGenerator = Providers.getKeyPairGenerator(ALGORITHM);
        keyPairGenerator.initialize(keySize);
        KeyPair pair = keyPairGenerator.generateKeyPair();
        return ImmutablePair.of((Object)((DHPublicKey)pair.getPublic()), (Object)((DHPrivateKey)pair.getPrivate()));
    }

    public static Pair<DHPublicKey, DHPrivateKey> initPartBKey(byte[] partAPubKey) {
        return DHKeyExchanger.initPartBKey(DHKeyExchanger.decodePublicKey(partAPubKey));
    }

    public static Pair<DHPublicKey, DHPrivateKey> initPartBKey(DHPublicKey partAPublicKey) {
        KeyPairGenerator keyPairGen = Providers.getKeyPairGenerator(partAPublicKey.getAlgorithm());
        try {
            keyPairGen.initialize(partAPublicKey.getParams());
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new SecurityException(e);
        }
        KeyPair keyPair = keyPairGen.generateKeyPair();
        return ImmutablePair.of((Object)((DHPublicKey)keyPair.getPublic()), (Object)((DHPrivateKey)keyPair.getPrivate()));
    }

    public static byte[] encode(DHPublicKey key) {
        return key.getEncoded();
    }

    public static byte[] encode(DHPrivateKey key) {
        return key.getEncoded();
    }

    public static DHPrivateKey decodePrivateKey(byte[] privateKey) {
        KeyFactory keyFactory = Providers.getKeyFactory(ALGORITHM);
        try {
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(privateKey);
            return (DHPrivateKey)keyFactory.generatePrivate(pkcs8KeySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new SecurityException(e);
        }
    }

    public static DHPublicKey decodePublicKey(byte[] publicKey) {
        KeyFactory keyFactory = Providers.getKeyFactory(ALGORITHM);
        try {
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(publicKey);
            return (DHPublicKey)keyFactory.generatePublic(x509KeySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new SecurityException(e);
        }
    }

    public static SecretKey genSecretKey(byte[] bPriKey, byte[] aPubKey) {
        return DHKeyExchanger.genSecretKey(DHKeyExchanger.decodePrivateKey(bPriKey), DHKeyExchanger.decodePublicKey(aPubKey));
    }

    public static SecretKey genSecretKey(DHPrivateKey bPriKey, DHPublicKey aPubKey) {
        KeyAgreement keyAgree = Providers.getKeyAgreement(aPubKey.getAlgorithm());
        try {
            keyAgree.init(bPriKey);
            keyAgree.doPhase(aPubKey, true);
            return keyAgree.generateSecret(Algorithm.DESede.name());
        }
        catch (IllegalStateException | InvalidKeyException | NoSuchAlgorithmException e) {
            throw new SecurityException(e);
        }
    }

    public static byte[] encrypt(byte[] data, SecretKey secretKey) {
        Cipher cipher = Providers.getCipher(secretKey.getAlgorithm());
        try {
            cipher.init(1, secretKey);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
    }

    public static byte[] decrypt(byte[] data, SecretKey secretKey) {
        Cipher cipher = Providers.getCipher(secretKey.getAlgorithm());
        try {
            cipher.init(2, secretKey);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
    }
}

