/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.jce.security;

import cn.ponfee.commons.jce.Providers;
import cn.ponfee.commons.jce.cert.X509CertUtils;
import cn.ponfee.commons.jce.security.RSAPublicKeys;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.util.Base64;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.openssl.PKCS8Generator;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.OutputEncryptor;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.PKCSException;
import org.bouncycastle.pkcs.jcajce.JcePKCSPBEInputDecryptorProviderBuilder;
import org.bouncycastle.pkcs.jcajce.JcePKCSPBEOutputEncryptorBuilder;
import org.bouncycastle.util.io.pem.PemObject;

public final class RSAPrivateKeys {
    private RSAPrivateKeys() {
    }

    public static RSAPrivateKey toRSAPrivateKey(BigInteger modulus, BigInteger privateExponent) {
        try {
            return (RSAPrivateKey)Providers.getKeyFactory("RSA").generatePrivate(new RSAPrivateKeySpec(modulus, privateExponent));
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    public static RSAPublicKey inverse(RSAPrivateKey privateKey) {
        return RSAPublicKeys.toRSAPublicKey(privateKey.getModulus(), privateKey.getPrivateExponent());
    }

    public static RSAPublicKey extractPublicKey(RSAPrivateKey privateKey) {
        if (!(privateKey instanceof RSAPrivateCrtKey)) {
            throw new ClassCastException("The key expect a java.security.interfaces.RSAPrivateCrtKey, but is " + privateKey.getClass().getCanonicalName());
        }
        RSAPrivateCrtKey key = (RSAPrivateCrtKey)privateKey;
        return RSAPublicKeys.toRSAPublicKey(key.getModulus(), key.getPublicExponent());
    }

    public static String toPkcs1(RSAPrivateKey privateKey) {
        PrivateKeyInfo privKeyInfo = PrivateKeyInfo.getInstance((Object)privateKey.getEncoded());
        try {
            return Base64.getEncoder().encodeToString(privKeyInfo.parsePrivateKey().toASN1Primitive().getEncoded());
        }
        catch (IOException e) {
            throw new SecurityException(e);
        }
    }

    public static RSAPrivateKey fromPkcs1(String pkcs1PrivateKey) {
        ASN1EncodableVector v1 = new ASN1EncodableVector();
        v1.add((ASN1Encodable)new ASN1ObjectIdentifier(PKCSObjectIdentifiers.rsaEncryption.getId()));
        v1.add((ASN1Encodable)DERNull.INSTANCE);
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        v2.add((ASN1Encodable)new ASN1Integer(0L));
        v2.add((ASN1Encodable)new DERSequence(v1));
        v2.add((ASN1Encodable)new DEROctetString(Base64.getDecoder().decode(pkcs1PrivateKey)));
        DERSequence seq = new DERSequence(v2);
        try {
            return RSAPrivateKeys.fromPkcs8(Base64.getEncoder().encodeToString(seq.getEncoded()));
        }
        catch (IOException e) {
            throw new SecurityException(e);
        }
    }

    public static String toPkcs1Pem(RSAPrivateKey privateKey) {
        return X509CertUtils.exportToPem(privateKey);
    }

    /*
     * Exception decompiling
     */
    public static RSAPrivateKey fromPkcs1Pem(String pemPrivateKey) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String toPkcs8(RSAPrivateKey privateKey) {
        return Base64.getEncoder().encodeToString(privateKey.getEncoded());
    }

    public static RSAPrivateKey fromPkcs8(String pkcs8PrivateKey) {
        byte[] bytes = Base64.getDecoder().decode(pkcs8PrivateKey);
        KeyFactory keyFactory = Providers.getKeyFactory("RSA");
        try {
            return (RSAPrivateKey)keyFactory.generatePrivate(new PKCS8EncodedKeySpec(bytes));
        }
        catch (InvalidKeySpecException e) {
            throw new SecurityException(e);
        }
    }

    /*
     * Exception decompiling
     */
    public static String toEncryptedPkcs8Pem(RSAPrivateKey privateKey, OutputEncryptor outEncryptor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String toEncryptedPkcs8Pem(RSAPrivateKey privateKey, String password) {
        JcePKCSPBEOutputEncryptorBuilder builder = new JcePKCSPBEOutputEncryptorBuilder(PKCSObjectIdentifiers.pbeWithSHAAnd3_KeyTripleDES_CBC);
        try {
            return RSAPrivateKeys.toEncryptedPkcs8Pem(privateKey, builder.build(password.toCharArray()));
        }
        catch (OperatorCreationException e) {
            throw new SecurityException(e);
        }
    }

    public static String toEncryptedPkcs8(RSAPrivateKey privateKey, String password) {
        JcePKCSPBEOutputEncryptorBuilder builder = new JcePKCSPBEOutputEncryptorBuilder(PKCSObjectIdentifiers.pbeWithSHAAnd3_KeyTripleDES_CBC);
        try {
            return RSAPrivateKeys.toEncryptedPkcs8(privateKey, builder.build(password.toCharArray()));
        }
        catch (OperatorCreationException e) {
            throw new SecurityException(e);
        }
    }

    public static String toEncryptedPkcs8(RSAPrivateKey privateKey, OutputEncryptor outEncryptor) {
        try {
            PrivateKeyInfo privKeyInfo = PrivateKeyInfo.getInstance((Object)privateKey.getEncoded());
            PemObject pem = new PKCS8Generator(privKeyInfo, outEncryptor).generate();
            return Base64.getEncoder().encodeToString(pem.getContent());
        }
        catch (IOException e) {
            throw new SecurityException(e);
        }
    }

    /*
     * Exception decompiling
     */
    public static RSAPrivateKey fromEncryptedPkcs8Pem(String encryptedPem, InputDecryptorProvider inputDecryptor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static RSAPrivateKey fromEncryptedPkcs8Pem(String encryptedPem, String password) {
        JcePKCSPBEInputDecryptorProviderBuilder builder = new JcePKCSPBEInputDecryptorProviderBuilder();
        return RSAPrivateKeys.fromEncryptedPkcs8Pem(encryptedPem, builder.build(password.toCharArray()));
    }

    public static RSAPrivateKey fromEncryptedPkcs8(String encryptedPrivateKey, String password) {
        return RSAPrivateKeys.fromEncryptedPkcs8(Base64.getDecoder().decode(encryptedPrivateKey), password);
    }

    public static RSAPrivateKey fromEncryptedPkcs8(byte[] encryptedPrivateKey, String password) {
        JcePKCSPBEInputDecryptorProviderBuilder builder = new JcePKCSPBEInputDecryptorProviderBuilder();
        return RSAPrivateKeys.fromEncryptedPkcs8(encryptedPrivateKey, builder.build(password.toCharArray()));
    }

    public static RSAPrivateKey fromEncryptedPkcs8(String encryptedPrivateKey, InputDecryptorProvider inputDecryptor) {
        return RSAPrivateKeys.fromEncryptedPkcs8(Base64.getDecoder().decode(encryptedPrivateKey), inputDecryptor);
    }

    public static RSAPrivateKey fromEncryptedPkcs8(byte[] encryptedPrivateKey, InputDecryptorProvider inputDecryptor) {
        try {
            PKCS8EncryptedPrivateKeyInfo encrypted = new PKCS8EncryptedPrivateKeyInfo(encryptedPrivateKey);
            PrivateKeyInfo pkInfo = encrypted.decryptPrivateKeyInfo(inputDecryptor);
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider(Providers.BC);
            return (RSAPrivateKey)converter.getPrivateKey(pkInfo);
        }
        catch (IOException | PKCSException e) {
            throw new SecurityException(e);
        }
    }
}

