/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.json;

import cn.ponfee.commons.reflect.GenericUtils;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import javax.money.CurrencyUnit;
import javax.money.Monetary;
import org.javamoney.moneta.Money;

public class FastjsonMoney
implements ObjectSerializer,
ObjectDeserializer {
    private static final String CURRENCY = "currency";
    private static final String NUMBER = "number";

    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        SerializeWriter writer = serializer.getWriter();
        if (object == null) {
            serializer.writeNull();
        } else {
            Money money = (Money)object;
            writer.write("{\"currency\":\"");
            writer.write(money.getCurrency().getCurrencyCode());
            writer.write("\",\"number\":");
            writer.writeLong(money.getNumberStripped().movePointRight(money.getCurrency().getDefaultFractionDigits()).longValueExact());
            writer.write("}");
        }
    }

    public Money deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
        if (GenericUtils.getRawType(type) != Money.class) {
            throw new UnsupportedOperationException("Cannot supported deserialize type: " + type);
        }
        JSONObject jsonObject = parser.parseObject();
        String currencyCode = jsonObject.getString(CURRENCY);
        long number = jsonObject.getLongValue(NUMBER);
        return Money.ofMinor((CurrencyUnit)Monetary.getCurrency((String)currencyCode, (String[])new String[0]), (long)number);
    }

    public int getFastMatchToken() {
        return 0;
    }
}

