/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.limit.request;

import cn.ponfee.commons.limit.request.RequestLimitException;
import cn.ponfee.commons.limit.request.RequestLimiter;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;

public class HttpSessionRequestLimiter
extends RequestLimiter {
    private final HttpSession session;

    private HttpSessionRequestLimiter(HttpSession session) {
        this.session = session;
    }

    public static HttpSessionRequestLimiter create(HttpSession session) {
        return new HttpSessionRequestLimiter(session);
    }

    @Override
    @Deprecated
    public HttpSessionRequestLimiter limitFrequency(String key, int period, String message) throws RequestLimitException {
        this.checkLimit("req:lmt:fre:" + key, period, 1, message);
        return this;
    }

    @Override
    @Deprecated
    public HttpSessionRequestLimiter limitThreshold(String key, int period, int limit, String message) throws RequestLimitException {
        this.checkLimit("req:lmt:thr:" + key, period, limit, message);
        return this;
    }

    @Override
    public void cacheCode(String key, String code, int ttl) {
        this.add("req:cah:code:" + key, code, ttl);
        this.remove("req:chk:code:" + key);
    }

    @Override
    public HttpSessionRequestLimiter checkCode(String key, String code, int limit) throws RequestLimitException {
        if (StringUtils.isEmpty((CharSequence)code)) {
            throw new RequestLimitException("\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String cacheKey = "req:cah:code:" + key;
        RequestLimiter.CacheValue actual = this.get(cacheKey);
        if (actual == null || actual.get() == null) {
            throw new RequestLimitException("\u9a8c\u8bc1\u7801\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\uff01");
        }
        String checkKey = "req:chk:code:" + key;
        RequestLimiter.CacheValue<?> times = this.incrementAndGet(checkKey, actual.expireTimeMillis);
        if (times.count() > limit) {
            this.remove(cacheKey, checkKey);
            throw new RequestLimitException("\u9a8c\u8bc1\u9519\u8bef\u6b21\u6570\u8fc7\u591a\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\uff01");
        }
        if (!((String)actual.get()).equals(code)) {
            throw new RequestLimitException("\u9a8c\u8bc1\u7801\u9519\u8bef\uff01");
        }
        this.remove(cacheKey, checkKey);
        return this;
    }

    @Override
    public void cacheCaptcha(String key, String captcha, int expire) {
        this.add("req:cah:cap:" + key, captcha, expire);
    }

    @Override
    public boolean checkCaptcha(String key, String captcha, boolean caseSensitive) {
        RequestLimiter.CacheValue value = this.getAndRemove("req:cah:cap:" + key);
        if (value == null || value.get() == null) {
            return false;
        }
        return caseSensitive ? ((String)value.get()).equals(captcha) : ((String)value.get()).equalsIgnoreCase(captcha);
    }

    @Override
    @Deprecated
    public void recordAction(String key, int period) {
        this.incrementAndGet("req:cnt:act:" + key, HttpSessionRequestLimiter.expire(period));
    }

    @Override
    @Deprecated
    public long countAction(String key) {
        RequestLimiter.CacheValue cache = this.get("req:cnt:act:" + key);
        return cache == null ? 0L : (long)cache.count();
    }

    @Override
    @Deprecated
    public void resetAction(String key) {
        this.remove("req:cnt:act:" + key);
    }

    private void checkLimit(String key, int ttl, int limit, String message) throws RequestLimitException {
        RequestLimiter.CacheValue<?> cache = this.incrementAndGet(key, HttpSessionRequestLimiter.expire(ttl));
        if (cache.count() > limit) {
            throw new RequestLimitException(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RequestLimiter.CacheValue<?> incrementAndGet(String key, long expireTimeMillis) {
        HttpSession httpSession = this.session;
        synchronized (httpSession) {
            RequestLimiter.CacheValue<Object> cache = (RequestLimiter.CacheValue<Object>)this.session.getAttribute(key);
            if (cache == null || cache.isExpire()) {
                cache = new RequestLimiter.CacheValue<Object>(null, expireTimeMillis);
                this.session.setAttribute(key, cache);
            } else {
                cache.increment();
            }
            return cache;
        }
    }

    private void remove(String ... keys) {
        for (String key : keys) {
            this.session.removeAttribute(key);
        }
    }

    private <T> RequestLimiter.CacheValue<T> getAndRemove(String key) {
        RequestLimiter.CacheValue cache = (RequestLimiter.CacheValue)this.session.getAttribute(key);
        if (cache == null) {
            return null;
        }
        this.session.removeAttribute(key);
        return cache.isExpire() ? null : cache;
    }

    private <T> void add(String key, T value, int ttl) {
        this.session.setAttribute(key, new RequestLimiter.CacheValue<T>(value, HttpSessionRequestLimiter.expire(ttl)));
    }

    private <T> RequestLimiter.CacheValue<T> get(String key) {
        RequestLimiter.CacheValue cache = (RequestLimiter.CacheValue)this.session.getAttribute(key);
        if (cache == null) {
            return null;
        }
        if (cache.isExpire()) {
            this.session.removeAttribute(key);
            return null;
        }
        return cache;
    }
}

