/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.model;

import cn.ponfee.commons.reflect.ClassUtils;
import com.google.common.collect.Lists;
import java.beans.Transient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.cglib.beans.BeanCopier;

public class Page<T>
implements Serializable {
    private static final long serialVersionUID = 1313118491812094979L;
    private static final BeanCopier COPIER = BeanCopier.create(Page.class, Page.class, (boolean)false);
    private int pageNum;
    private int pageSize;
    private int size;
    private long startRow;
    private long endRow;
    private long total;
    private int pages;
    private List<T> rows;
    private int prePage;
    private int nextPage;
    private Boolean firstPage = Boolean.TRUE;
    private Boolean lastPage = Boolean.FALSE;
    private Boolean hasPreviousPage = Boolean.FALSE;
    private Boolean hasNextPage = Boolean.FALSE;
    private int navigatePages;
    private int[] navigatePageNums;
    private int navigateFirstPage;
    private int navigateLastPage;

    public static <T> Page<T> empty() {
        return new Page<T>();
    }

    public static <T> Page<T> of(List<T> list) {
        return new Page<T>(list);
    }

    public static <T> Page<T> of(List<T> list, int navigatePages) {
        return new Page<T>(list, navigatePages);
    }

    public Page() {
        this(new ArrayList());
    }

    public Page(List<T> list) {
        this(list, 8);
    }

    public Page(List<T> list, int navigatePages) {
        if (list instanceof com.github.pagehelper.Page) {
            com.github.pagehelper.Page page = (com.github.pagehelper.Page)list;
            this.pageNum = page.getPageNum();
            this.pageSize = page.getPageSize();
            this.pages = page.getPages();
            this.rows = this.copy(page);
            this.size = page.size();
            this.total = page.getTotal();
            if (this.size == 0) {
                this.startRow = 0L;
                this.endRow = 0L;
            } else {
                this.startRow = page.getStartRow() + 1L;
                this.endRow = this.startRow - 1L + (long)this.size;
            }
        } else {
            if (list == null) {
                list = new ArrayList<T>();
            }
            this.pageNum = 1;
            this.pageSize = list.size();
            this.pages = this.pageSize > 0 ? 1 : 0;
            this.rows = list;
            this.size = list.size();
            this.total = list.size();
            this.startRow = 0L;
            this.endRow = list.size() > 0 ? (long)(list.size() - 1) : 0L;
        }
        this.navigatePages = navigatePages;
        this.calcNavigatePageNums();
        this.calcPage();
        this.judgePageBoudary();
    }

    private List<T> copy(com.github.pagehelper.Page<T> page) {
        return Lists.newArrayList(page);
    }

    private void calcNavigatePageNums() {
        if (this.pages <= this.navigatePages) {
            this.navigatePageNums = new int[this.pages];
            for (int i = 0; i < this.pages; ++i) {
                this.navigatePageNums[i] = i + 1;
            }
        } else {
            this.navigatePageNums = new int[this.navigatePages];
            int startNum = this.pageNum - this.navigatePages / 2;
            int endNum = this.pageNum + this.navigatePages / 2;
            if (startNum < 1) {
                startNum = 1;
                for (int i = 0; i < this.navigatePages; ++i) {
                    this.navigatePageNums[i] = startNum++;
                }
            } else if (endNum > this.pages) {
                endNum = this.pages;
                for (int i = this.navigatePages - 1; i >= 0; --i) {
                    this.navigatePageNums[i] = endNum--;
                }
            } else {
                for (int i = 0; i < this.navigatePages; ++i) {
                    this.navigatePageNums[i] = startNum++;
                }
            }
        }
    }

    private void calcPage() {
        if (this.navigatePageNums != null && this.navigatePageNums.length > 0) {
            this.navigateFirstPage = this.navigatePageNums[0];
            this.navigateLastPage = this.navigatePageNums[this.navigatePageNums.length - 1];
            if (this.pageNum > 1) {
                this.prePage = this.pageNum - 1;
            }
            if (this.pageNum < this.pages) {
                this.nextPage = this.pageNum + 1;
            }
        }
    }

    private void judgePageBoudary() {
        this.firstPage = this.pageNum == 1;
        this.lastPage = this.pageNum == this.pages;
        this.hasPreviousPage = this.pageNum > 1;
        this.hasNextPage = this.pageNum < this.pages;
    }

    @Transient
    public boolean isEmpty() {
        return CollectionUtils.isEmpty(this.rows);
    }

    public void forEach(Consumer<T> action) {
        if (this.isEmpty()) {
            return;
        }
        this.rows.forEach(action);
    }

    public <E> Page<E> map(Function<T, E> mapper) {
        Objects.requireNonNull(mapper);
        Page<E> page = this.copy();
        if (this.isEmpty()) {
            return page;
        }
        page.setRows(this.rows.stream().map(mapper).collect(Collectors.toList()));
        return page;
    }

    public <E> Page<E> copy() {
        Page<T> page = new Page<T>();
        COPIER.copy((Object)this, page, null);
        return page;
    }

    public String toString() {
        return new StringBuilder(280).append(this.getClass().getCanonicalName()).append("@").append(Integer.toHexString(this.hashCode())).append("{").append("pageNum=").append(this.pageNum).append(",pageSize=").append(this.pageSize).append(",size=").append(this.size).append(",startRow=").append(this.startRow).append(",endRow=").append(this.endRow).append(",total=").append(this.total).append(",pages=").append(this.pages).append(",rows=").append(this.rowsToString()).append(",prePage=").append(this.prePage).append(",nextPage=").append(this.nextPage).append(",navigatePages=").append(this.navigatePages).append(",navigatePageNums=").append(Arrays.toString(this.navigatePageNums)).append("}").toString();
    }

    private String rowsToString() {
        if (this.rows.isEmpty()) {
            return "List<>(0)";
        }
        Object row = this.rows.stream().filter(Objects::nonNull).findAny().orElse(null);
        if (row == null) {
            return "List<>(" + this.rows.size() + ")";
        }
        return "List<" + ClassUtils.getClassName(row.getClass()) + ">(" + this.rows.size() + ")";
    }

    public int getPageNum() {
        return this.pageNum;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getSize() {
        return this.size;
    }

    public long getStartRow() {
        return this.startRow;
    }

    public long getEndRow() {
        return this.endRow;
    }

    public long getTotal() {
        return this.total;
    }

    public int getPages() {
        return this.pages;
    }

    public List<T> getRows() {
        return this.rows;
    }

    public int getPrePage() {
        return this.prePage;
    }

    public int getNextPage() {
        return this.nextPage;
    }

    public Boolean getFirstPage() {
        return this.firstPage;
    }

    public Boolean getLastPage() {
        return this.lastPage;
    }

    public Boolean getHasPreviousPage() {
        return this.hasPreviousPage;
    }

    public Boolean getHasNextPage() {
        return this.hasNextPage;
    }

    public int getNavigatePages() {
        return this.navigatePages;
    }

    public int[] getNavigatePageNums() {
        return this.navigatePageNums;
    }

    public int getNavigateFirstPage() {
        return this.navigateFirstPage;
    }

    public int getNavigateLastPage() {
        return this.navigateLastPage;
    }

    public void setPageNum(int pageNum) {
        this.pageNum = pageNum;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setStartRow(long startRow) {
        this.startRow = startRow;
    }

    public void setEndRow(long endRow) {
        this.endRow = endRow;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public void setPages(int pages) {
        this.pages = pages;
    }

    public void setRows(List<T> rows) {
        this.rows = rows;
    }

    public void setPrePage(int prePage) {
        this.prePage = prePage;
    }

    public void setNextPage(int nextPage) {
        this.nextPage = nextPage;
    }

    public void setFirstPage(Boolean firstPage) {
        this.firstPage = firstPage;
    }

    public void setLastPage(Boolean lastPage) {
        this.lastPage = lastPage;
    }

    public void setHasPreviousPage(Boolean hasPreviousPage) {
        this.hasPreviousPage = hasPreviousPage;
    }

    public void setHasNextPage(Boolean hasNextPage) {
        this.hasNextPage = hasNextPage;
    }

    public void setNavigatePages(int navigatePages) {
        this.navigatePages = navigatePages;
    }

    public void setNavigatePageNums(int[] navigatePageNums) {
        this.navigatePageNums = navigatePageNums;
    }

    public void setNavigateFirstPage(int navigateFirstPage) {
        this.navigateFirstPage = navigateFirstPage;
    }

    public void setNavigateLastPage(int navigateLastPage) {
        this.navigateLastPage = navigateLastPage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Page)) {
            return false;
        }
        Page other = (Page)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPageNum() != other.getPageNum()) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        if (this.getStartRow() != other.getStartRow()) {
            return false;
        }
        if (this.getEndRow() != other.getEndRow()) {
            return false;
        }
        if (this.getTotal() != other.getTotal()) {
            return false;
        }
        if (this.getPages() != other.getPages()) {
            return false;
        }
        if (this.getPrePage() != other.getPrePage()) {
            return false;
        }
        if (this.getNextPage() != other.getNextPage()) {
            return false;
        }
        if (this.getNavigatePages() != other.getNavigatePages()) {
            return false;
        }
        if (this.getNavigateFirstPage() != other.getNavigateFirstPage()) {
            return false;
        }
        if (this.getNavigateLastPage() != other.getNavigateLastPage()) {
            return false;
        }
        Boolean this$firstPage = this.getFirstPage();
        Boolean other$firstPage = other.getFirstPage();
        if (this$firstPage == null ? other$firstPage != null : !((Object)this$firstPage).equals(other$firstPage)) {
            return false;
        }
        Boolean this$lastPage = this.getLastPage();
        Boolean other$lastPage = other.getLastPage();
        if (this$lastPage == null ? other$lastPage != null : !((Object)this$lastPage).equals(other$lastPage)) {
            return false;
        }
        Boolean this$hasPreviousPage = this.getHasPreviousPage();
        Boolean other$hasPreviousPage = other.getHasPreviousPage();
        if (this$hasPreviousPage == null ? other$hasPreviousPage != null : !((Object)this$hasPreviousPage).equals(other$hasPreviousPage)) {
            return false;
        }
        Boolean this$hasNextPage = this.getHasNextPage();
        Boolean other$hasNextPage = other.getHasNextPage();
        if (this$hasNextPage == null ? other$hasNextPage != null : !((Object)this$hasNextPage).equals(other$hasNextPage)) {
            return false;
        }
        List<T> this$rows = this.getRows();
        List<T> other$rows = other.getRows();
        if (this$rows == null ? other$rows != null : !((Object)this$rows).equals(other$rows)) {
            return false;
        }
        return Arrays.equals(this.getNavigatePageNums(), other.getNavigatePageNums());
    }

    protected boolean canEqual(Object other) {
        return other instanceof Page;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPageNum();
        result = result * 59 + this.getPageSize();
        result = result * 59 + this.getSize();
        long $startRow = this.getStartRow();
        result = result * 59 + (int)($startRow >>> 32 ^ $startRow);
        long $endRow = this.getEndRow();
        result = result * 59 + (int)($endRow >>> 32 ^ $endRow);
        long $total = this.getTotal();
        result = result * 59 + (int)($total >>> 32 ^ $total);
        result = result * 59 + this.getPages();
        result = result * 59 + this.getPrePage();
        result = result * 59 + this.getNextPage();
        result = result * 59 + this.getNavigatePages();
        result = result * 59 + this.getNavigateFirstPage();
        result = result * 59 + this.getNavigateLastPage();
        Boolean $firstPage = this.getFirstPage();
        result = result * 59 + ($firstPage == null ? 43 : ((Object)$firstPage).hashCode());
        Boolean $lastPage = this.getLastPage();
        result = result * 59 + ($lastPage == null ? 43 : ((Object)$lastPage).hashCode());
        Boolean $hasPreviousPage = this.getHasPreviousPage();
        result = result * 59 + ($hasPreviousPage == null ? 43 : ((Object)$hasPreviousPage).hashCode());
        Boolean $hasNextPage = this.getHasNextPage();
        result = result * 59 + ($hasNextPage == null ? 43 : ((Object)$hasNextPage).hashCode());
        List<T> $rows = this.getRows();
        result = result * 59 + ($rows == null ? 43 : ((Object)$rows).hashCode());
        result = result * 59 + Arrays.hashCode(this.getNavigatePageNums());
        return result;
    }
}

