/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.model;

import cn.ponfee.commons.model.CodeMsg;
import cn.ponfee.commons.model.ResultCode;
import cn.ponfee.commons.model.ToJsonString;
import java.beans.Transient;
import java.io.Serializable;
import java.util.function.Function;

public class Result<T>
extends ToJsonString
implements CodeMsg,
Serializable {
    private static final long serialVersionUID = -2804195259517755050L;
    public static final Result<Void> SUCCESS = new Success();
    private Integer code;
    private boolean success;
    private String msg;
    private T data;

    public Result() {
    }

    public Result(int code, boolean success, String msg, T data) {
        this.code = code;
        this.success = success;
        this.msg = msg;
        this.data = data;
    }

    public <E> Result<E> cast() {
        return this;
    }

    public <E> Result<E> from(E data) {
        return new Result<E>(this.code, this.success, this.msg, data);
    }

    public <E> Result<E> convert(Function<T, E> mapper) {
        return new Result<E>(this.code, this.success, this.msg, mapper.apply(this.data));
    }

    public static Result<Void> success() {
        return SUCCESS;
    }

    public static <T> Result<T> success(T data) {
        return new Result<T>(Success.CODE, true, "OK", data);
    }

    public static <T> Result<T> failure(CodeMsg cm) {
        if (cm.isSuccess()) {
            throw new IllegalStateException("Failure state must be 'false'.");
        }
        return new Result<Object>(cm.getCode(), cm.isSuccess(), cm.getMsg(), null);
    }

    public static <T> Result<T> failure(int code) {
        return new Result<Object>(code, false, null, null);
    }

    public static <T> Result<T> failure(int code, String msg) {
        return new Result<Object>(code, false, msg, null);
    }

    public static <T> Result<T> of(CodeMsg cm) {
        return new Result<Object>(cm.getCode(), cm.isSuccess(), cm.getMsg(), null);
    }

    public static <T> Result<T> of(CodeMsg cm, T data) {
        return new Result<T>(cm.getCode(), cm.isSuccess(), cm.getMsg(), data);
    }

    public static <T> Result<T> of(int code, boolean success, String msg) {
        return new Result<Object>(code, success, msg, null);
    }

    public static <T> Result<T> of(int code, boolean success, String msg, T data) {
        return new Result<T>(code, success, msg, data);
    }

    public static <T> Result<T> assertAffectedOne(int actualAffectedRows) {
        return Result.assertAffectedRows(actualAffectedRows, 1);
    }

    public static <T> Result<T> assertAffectedRows(int actualAffectedRows, int exceptAffectedRows) {
        return actualAffectedRows == exceptAffectedRows ? SUCCESS : Result.failure(ResultCode.OPS_CONFLICT);
    }

    public static <T> Result<T> assertOperatedState(boolean state) {
        return state ? SUCCESS : Result.failure(ResultCode.OPS_CONFLICT);
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public boolean isSuccess() {
        return this.success;
    }

    @Transient
    public boolean isFailure() {
        return !this.success;
    }

    @Override
    public String getMsg() {
        return this.msg;
    }

    public T getData() {
        return this.data;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setData(T data) {
        this.data = data;
    }

    private static final class Success
    extends Result<Void> {
        private static final long serialVersionUID = 6740650053476768729L;
        private static final int CODE = ResultCode.OK.getCode();
        private static final String MSG = "OK";

        private Success() {
            super(CODE, true, MSG, null);
        }

        @Override
        public void setCode(int code) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setMsg(String msg) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setData(Void data) {
            throw new UnsupportedOperationException();
        }

        private Object readResolve() {
            return SUCCESS;
        }
    }
}

