/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.resource;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class ResourceScanner {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceScanner.class);
    private final List<String> scanPaths = new LinkedList<String>();

    public ResourceScanner(String ... paths) {
        if (paths == null || paths.length == 0) {
            paths = new String[]{"*"};
        }
        Collections.addAll(this.scanPaths, paths);
    }

    public Set<Class<?>> scan4class() {
        return this.scan4class(new Class[0]);
    }

    public Set<Class<?>> scan4class(Class<? extends Annotation> ... annotations) {
        if (this.scanPaths.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedList<TypeFilter> typeFilters = new LinkedList<TypeFilter>();
        if (annotations != null) {
            for (Class<? extends Annotation> annotation : annotations) {
                typeFilters.add((TypeFilter)new AnnotationTypeFilter(annotation, false));
            }
        }
        HashSet result = new HashSet();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        try {
            for (String packageName : this.scanPaths) {
                packageName = packageName.replace('.', '/');
                Resource[] resources = resolver.getResources("classpath*:" + packageName + "/**/*.class");
                CachingMetadataReaderFactory mrf = new CachingMetadataReaderFactory((ResourceLoader)resolver);
                for (Resource resource : resources) {
                    MetadataReader reader;
                    if (!resource.isReadable() || !this.matchesFilter(reader = mrf.getMetadataReader(resource), typeFilters, (MetadataReaderFactory)mrf)) continue;
                    try {
                        result.add(Class.forName(reader.getClassMetadata().getClassName()));
                    }
                    catch (Throwable e) {
                        LOG.error("Load class occur error.", e);
                    }
                }
            }
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, byte[]> scan4binary() {
        return this.scan4binary("*");
    }

    public Map<String, byte[]> scan4binary(String wildcard) {
        if (wildcard == null) {
            wildcard = "*";
        }
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        try {
            for (String path : this.scanPaths) {
                Resource[] resources;
                for (Resource resource : resources = resolver.getResources("classpath*:" + path + wildcard)) {
                    if (!resource.isReadable()) continue;
                    try (InputStream in = resource.getInputStream();){
                        result.put(resource.getFilename(), IOUtils.toByteArray((InputStream)in));
                    }
                    catch (IOException e) {
                        LOG.error("scan binary error", (Throwable)e);
                    }
                }
            }
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, String> scan4text() {
        return this.scan4text(null, Charset.defaultCharset());
    }

    public Map<String, String> scan4text(String wildcard) {
        return this.scan4text(wildcard, Charset.defaultCharset());
    }

    public Map<String, String> scan4text(String wildcard, Charset charset) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, byte[]> entry : this.scan4binary(wildcard).entrySet()) {
            result.put(entry.getKey(), new String(entry.getValue(), charset));
        }
        return result;
    }

    private boolean matchesFilter(MetadataReader reader, List<TypeFilter> typeFilters, MetadataReaderFactory factory) throws IOException {
        if (typeFilters.isEmpty()) {
            return true;
        }
        for (TypeFilter filter : typeFilters) {
            if (!filter.match(reader, factory)) continue;
            return true;
        }
        return false;
    }
}

