/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.schema;

import cn.ponfee.commons.date.JavaUtilDateFormat;
import cn.ponfee.commons.math.Numbers;
import com.google.common.collect.ImmutableMap;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public enum DataType {
    BOOLEAN("\u5e03\u5c14"){

        @Override
        protected <T> T parseObject0(Object value) {
            if (value instanceof Boolean) {
                return (T)value;
            }
            return (T)BOOLEAN_MAPPING.get(value.toString());
        }
    }
    ,
    DECIMAL("\u5c0f\u6570"){

        @Override
        protected <T> T parseObject0(Object value) {
            return (T)Numbers.toWrapDouble(value);
        }
    }
    ,
    INTEGER("\u6574\u6570"){

        @Override
        protected <T> T parseObject0(Object value) {
            return (T)Numbers.toWrapLong(value);
        }
    }
    ,
    STRING("\u5b57\u7b26\u4e32"){

        @Override
        protected <T> T parseObject0(Object value) {
            return (T)value.toString();
        }

        @Override
        protected String toString0(Object value) {
            return value.toString();
        }

        @Override
        public boolean test0(Object value) {
            return true;
        }
    }
    ,
    DATE("\u65e5\u671f"){
        private final JavaUtilDateFormat format = new JavaUtilDateFormat("yyyy-MM-dd");

        @Override
        protected <T> T parseObject0(Object value) {
            return (T)DataType.parseToDate(this.format, value);
        }

        protected String convert0(Object value) {
            return this.toString0(value);
        }

        @Override
        protected String toString0(Object value) {
            return DataType.dateToString(this.format, value);
        }
    }
    ,
    DATE_TIME("\u65e5\u671f\u65f6\u95f4"){

        @Override
        protected <T> T parseObject0(Object value) {
            return (T)DataType.parseToDate(JavaUtilDateFormat.DEFAULT, value);
        }

        protected String convert0(Object value) {
            return this.toString0(value);
        }

        @Override
        protected String toString0(Object value) {
            return DataType.dateToString(JavaUtilDateFormat.DEFAULT, value);
        }
    }
    ,
    TIMESTAMP("\u65f6\u95f4\u6233\uff08\u6beb\u79d2\uff09"){

        @Override
        protected <T> T parseObject0(Object value) {
            if (value instanceof Date) {
                return (T)Long.valueOf(((Date)value).getTime());
            }
            return (T)Numbers.toWrapLong(value);
        }
    };

    private final String description;
    private static final Map<String, Boolean> BOOLEAN_MAPPING;
    private static final Pattern PATTERN_INTEGER;
    private static final Pattern PATTERN_DECIMAL;

    private DataType(String description) {
        this.description = description;
    }

    protected abstract <T> T parseObject0(Object var1);

    protected String toString0(Object value) {
        return Objects.toString(this.parseObject0(value), null);
    }

    protected <T> T convert0(Object value) {
        return this.parseObject0(value);
    }

    protected boolean test0(Object value) {
        return this.parseObject0(value) != null;
    }

    public final <T> T parseObject(Object value) {
        return value == null ? null : (T)this.parseObject0(value);
    }

    public final String toString(Object value) {
        return value == null ? null : this.toString0(value);
    }

    public final Object convert(Object value) {
        return value == null ? null : ObjectUtils.defaultIfNull(this.convert0(value), (Object)value);
    }

    public final boolean test(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof String && StringUtils.isEmpty((CharSequence)((String)value))) {
            return true;
        }
        return this.test0(value);
    }

    public String description() {
        return this.description;
    }

    public static DataType of(String name) {
        for (DataType dt : DataType.values()) {
            if (!dt.name().equalsIgnoreCase(name)) continue;
            return dt;
        }
        return STRING;
    }

    public static DataType detect(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return STRING;
        }
        if (BOOLEAN_MAPPING.containsKey(value)) {
            return BOOLEAN;
        }
        if (PATTERN_INTEGER.matcher(value).matches() && INTEGER.parseObject0(value) != null) {
            return INTEGER;
        }
        if (PATTERN_DECIMAL.matcher(value).matches() && DECIMAL.parseObject0(value) != null) {
            return DECIMAL;
        }
        if (value.length() == 10 && DATE.parseObject0(value) != null) {
            return DATE;
        }
        if (value.length() == 19 && DATE_TIME.parseObject0(value) != null) {
            return DATE_TIME;
        }
        return STRING;
    }

    public static DataType ofDatabaseType(int type) {
        switch (type) {
            case 91: {
                return DATE_TIME;
            }
            case 93: {
                return TIMESTAMP;
            }
            case -7: 
            case 16: {
                return BOOLEAN;
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: 
            case 7: {
                return INTEGER;
            }
            case 3: 
            case 6: 
            case 8: {
                return DECIMAL;
            }
        }
        return STRING;
    }

    private static String dateToString(DateFormat format, Object value) {
        if (value instanceof Date) {
            return format.format((Date)value);
        }
        String text = value.toString();
        if (StringUtils.isBlank((CharSequence)text)) {
            return null;
        }
        try {
            return format.format(format.parse(text));
        }
        catch (ParseException ignored) {
            return null;
        }
    }

    private static Date parseToDate(DateFormat format, Object value) {
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof Number) {
            return new Date(((Number)value).longValue());
        }
        String text = value.toString();
        if (StringUtils.isBlank((CharSequence)text)) {
            return null;
        }
        try {
            return format.parse(text);
        }
        catch (ParseException ignored) {
            return null;
        }
    }

    static {
        BOOLEAN_MAPPING = ImmutableMap.builder().put((Object)"TRUE", (Object)Boolean.TRUE).put((Object)"True", (Object)Boolean.TRUE).put((Object)"true", (Object)Boolean.TRUE).put((Object)"FALSE", (Object)Boolean.FALSE).put((Object)"False", (Object)Boolean.FALSE).put((Object)"false", (Object)Boolean.FALSE).build();
        PATTERN_INTEGER = Pattern.compile("^[-+]?(([1-9]\\d*)|0)$");
        PATTERN_DECIMAL = Pattern.compile("^[-+]?(([1-9]\\d*)|0)\\.\\d+$");
    }
}

