/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.schema;

import cn.ponfee.commons.schema.DataColumn;
import cn.ponfee.commons.schema.NormalStructure;
import cn.ponfee.commons.schema.TableStructure;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;

public class GridTable
implements Serializable {
    private static final long serialVersionUID = 4900630719709337101L;
    private Columns[] columns;
    private NormalStructure dataset;

    public static GridTable of(TableStructure ts) {
        if (ts == null) {
            return null;
        }
        GridTable table = new GridTable();
        table.setColumns(Columns.convert(ts.getColumns()));
        table.setDataset(ts.toNormal());
        return table;
    }

    public Columns[] getColumns() {
        return this.columns;
    }

    public void setColumns(Columns[] columns) {
        this.columns = columns;
    }

    public NormalStructure getDataset() {
        return this.dataset;
    }

    public void setDataset(NormalStructure dataset) {
        this.dataset = dataset;
    }

    public static class Columns
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String title;
        private String dataIndex;
        private String key;

        public Columns() {
        }

        public Columns(String title, String name) {
            this.title = StringUtils.isBlank((CharSequence)title) ? name : title;
            this.dataIndex = name;
            this.key = name;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getDataIndex() {
            return this.dataIndex;
        }

        public void setDataIndex(String dataIndex) {
            this.dataIndex = dataIndex;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public static Columns convert(DataColumn column) {
            return new Columns(column.getAlias(), column.getName());
        }

        public static Columns[] convert(DataColumn[] columns) {
            if (columns == null) {
                return null;
            }
            return (Columns[])Arrays.stream(columns).map(Columns::convert).toArray(Columns[]::new);
        }
    }
}

