/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.serial;

import cn.ponfee.commons.io.GzipProcessor;
import cn.ponfee.commons.reflect.ClassUtils;
import cn.ponfee.commons.serial.SerializationException;
import cn.ponfee.commons.serial.Serializer;

public class ByteArraySerializer
extends Serializer {
    protected byte[] serialize0(Object obj, boolean compress) {
        if (!(obj instanceof byte[])) {
            throw new SerializationException("Object must be byte[].class type, but it's " + ClassUtils.getClassName(obj.getClass()) + " type.");
        }
        byte[] bytes = (byte[])obj;
        return compress ? GzipProcessor.compress(bytes) : bytes;
    }

    @Override
    protected <T> T deserialize0(byte[] bytes, Class<T> clazz, boolean compress) {
        if (clazz != byte[].class) {
            throw new SerializationException("clazz must be byte[].class, but it's " + ClassUtils.getClassName(clazz) + ".class");
        }
        return (T)(compress ? GzipProcessor.decompress(bytes) : bytes);
    }

    public byte[] serialize(byte[] bytes, boolean compress) {
        if (bytes == null || bytes.length == 0) {
            return bytes;
        }
        return compress ? GzipProcessor.compress(bytes) : bytes;
    }

    public byte[] deserialize(byte[] bytes, boolean compress) {
        if (bytes == null || bytes.length == 0) {
            return bytes;
        }
        return compress ? GzipProcessor.decompress(bytes) : bytes;
    }
}

