/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.serial;

import cn.ponfee.commons.io.GzipProcessor;
import cn.ponfee.commons.reflect.ClassUtils;
import cn.ponfee.commons.serial.SerializationException;
import cn.ponfee.commons.serial.Serializer;
import java.nio.charset.Charset;

public class StringSerializer
extends Serializer {
    private final Charset charset;

    public StringSerializer() {
        this(Charset.defaultCharset());
    }

    public StringSerializer(String charset) {
        this(Charset.forName(charset));
    }

    public StringSerializer(Charset charset) {
        if (charset == null) {
            throw new IllegalArgumentException("charset cannot be null");
        }
        this.charset = charset;
    }

    protected byte[] serialize0(Object obj, boolean compress) {
        if (!(obj instanceof String)) {
            throw new SerializationException("object must be java.lang.String type, but it's " + ClassUtils.getClassName(obj.getClass()) + " type");
        }
        return this.serialize((String)obj, compress);
    }

    @Override
    protected <T> T deserialize0(byte[] bytes, Class<T> clazz, boolean compress) {
        if (clazz != String.class) {
            throw new SerializationException("clazz must be java.lang.String.class, but it's " + ClassUtils.getClassName(clazz) + ".class");
        }
        return (T)this.deserialize(bytes, compress);
    }

    public byte[] serialize(String str, boolean compress) {
        if (str == null) {
            return null;
        }
        byte[] bytes = str.getBytes(this.charset);
        return compress ? GzipProcessor.compress(bytes) : bytes;
    }

    public String deserialize(byte[] bytes, boolean compress) {
        if (bytes == null) {
            return null;
        }
        if (compress) {
            bytes = GzipProcessor.decompress(bytes);
        }
        return new String(bytes, this.charset);
    }
}

