/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.util;

import cn.ponfee.commons.base.PrimitiveTypes;
import cn.ponfee.commons.date.JavaUtilDateFormat;
import cn.ponfee.commons.math.Numbers;
import cn.ponfee.commons.reflect.ClassUtils;
import cn.ponfee.commons.reflect.Fields;
import cn.ponfee.commons.util.Base64UrlSafe;
import cn.ponfee.commons.util.Bytes;
import cn.ponfee.commons.util.Enums;
import cn.ponfee.commons.util.RegexUtils;
import com.google.common.base.Preconditions;
import java.lang.reflect.Array;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public final class ObjectUtils {
    private static final char[] URL_SAFE_BASE64_CODES = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_".toCharArray();

    public static String toString(Object obj) {
        return ObjectUtils.toString(obj, "null");
    }

    public static String toString(Object obj, String defaultStr) {
        return obj == null ? defaultStr : ToStringBuilder.reflectionToString((Object)obj, (ToStringStyle)ToStringStyle.JSON_STYLE);
    }

    public static int compare(Object a, Object b) {
        int res;
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return 1;
        }
        if (b == null) {
            return -1;
        }
        if (a instanceof Comparable && b instanceof Comparable) {
            if (a.getClass().isInstance(b)) {
                return ((Comparable)a).compareTo(b);
            }
            if (b.getClass().isInstance(a)) {
                return ((Comparable)b).compareTo(a);
            }
        }
        return (res = Integer.compare(System.identityHashCode(a.getClass()), System.identityHashCode(b.getClass()))) != 0 ? res : Integer.compare(System.identityHashCode(a), System.identityHashCode(b));
    }

    public static <T> Class<T> typeOf(T obj) {
        return obj != null ? obj.getClass() : null;
    }

    public static <T> Predicate<T> not(Predicate<T> target) {
        return target.negate();
    }

    public static boolean isEmpty(Object o) {
        if (o == null) {
            return true;
        }
        if (o instanceof CharSequence) {
            return ((CharSequence)o).length() == 0;
        }
        if (o instanceof Collection) {
            return ((Collection)o).isEmpty();
        }
        if (o.getClass().isArray()) {
            return Array.getLength(o) == 0;
        }
        if (o instanceof Map) {
            return ((Map)o).isEmpty();
        }
        if (o instanceof Dictionary) {
            return ((Dictionary)o).isEmpty();
        }
        return false;
    }

    public static Object getValue(Object obj, String name) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Map) {
            return ((Map)obj).get(name);
        }
        if (obj instanceof Dictionary) {
            return ((Dictionary)obj).get(name);
        }
        return Fields.get(obj, name);
    }

    public static <T> T cast(Object value, Class<T> type) {
        if (type.isInstance(value)) {
            return (T)value;
        }
        PrimitiveOrWrapperConvertors convertor = PrimitiveOrWrapperConvertors.of(type);
        if (convertor != null) {
            return convertor.to(value);
        }
        if (value == null) {
            return null;
        }
        if (type.isEnum()) {
            return (T)(value instanceof Number ? type.getEnumConstants()[((Number)value).intValue()] : EnumUtils.getEnumIgnoreCase(type, (String)value.toString()));
        }
        if (Date.class == type) {
            if (value instanceof Number) {
                return (T)new Date(((Number)value).longValue());
            }
            String text = value.toString();
            if (StringUtils.isNumeric((CharSequence)text) && !RegexUtils.isDatePattern(text)) {
                return (T)new Date(Numbers.toLong(text));
            }
            try {
                return (T)JavaUtilDateFormat.DEFAULT.parse(text);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        return ClassUtils.newInstance(type, new Object[]{value.toString()});
    }

    public static byte[] uuid() {
        UUID uuid = UUID.randomUUID();
        long most = uuid.getMostSignificantBits();
        long least = uuid.getLeastSignificantBits();
        return new byte[]{(byte)(most >>> 56), (byte)(most >>> 48), (byte)(most >>> 40), (byte)(most >>> 32), (byte)(most >>> 24), (byte)(most >>> 16), (byte)(most >>> 8), (byte)most, (byte)(least >>> 56), (byte)(least >>> 48), (byte)(least >>> 40), (byte)(least >>> 32), (byte)(least >>> 24), (byte)(least >>> 16), (byte)(least >>> 8), (byte)least};
    }

    public static String uuid32() {
        UUID uuid = UUID.randomUUID();
        return Bytes.toHex(uuid.getMostSignificantBits()) + Bytes.toHex(uuid.getLeastSignificantBits());
    }

    public static String uuid22() {
        return Base64UrlSafe.encode(ObjectUtils.uuid());
    }

    public static String getStackTrace(int deepPath) {
        StackTraceElement[] traces = Thread.currentThread().getStackTrace();
        if (traces.length <= deepPath) {
            return "warning: out of stack trace.";
        }
        return traces[deepPath].toString();
    }

    public static String getStackTrace() {
        return ObjectUtils.buildStackTrace(Thread.currentThread().getStackTrace());
    }

    public static String getStackTrace(Thread thread) {
        return ObjectUtils.buildStackTrace(thread.getStackTrace());
    }

    private static String buildStackTrace(StackTraceElement[] traces) {
        StringBuilder builder = new StringBuilder();
        int n = traces.length;
        for (int i = 2; i < n; ++i) {
            builder.append("--\t").append(traces[i].toString()).append("\n");
        }
        return builder.toString();
    }

    public static <T> void copy(T source, T target, String ... fields) {
        Preconditions.checkState((boolean)ArrayUtils.isNotEmpty((Object[])fields));
        for (String field : fields) {
            Fields.put(target, field, Fields.get(source, field));
        }
    }

    public static <T> T copyOf(T source, String ... fields) {
        Preconditions.checkState((boolean)ArrayUtils.isNotEmpty((Object[])fields));
        Object target = ObjectUtils.newInstance(source.getClass());
        ObjectUtils.copy(source, target, fields);
        return (T)target;
    }

    public static <T> T newInstance(Class<T> type) {
        if (Map.class == type) {
            return (T)new HashMap();
        }
        if (Set.class == type) {
            return (T)new HashSet();
        }
        if (Collection.class == type || List.class == type) {
            return (T)new ArrayList();
        }
        if (Dictionary.class == type) {
            return (T)new Hashtable();
        }
        if (type.isPrimitive() || PrimitiveTypes.isWrapperType(type)) {
            Class<?> wrapper = PrimitiveTypes.ofPrimitiveOrWrapper(type).wrapper();
            return (T)ClassUtils.newInstance(wrapper, new Class[]{String.class}, new Object[]{"0"});
        }
        return ClassUtils.newInstance(type);
    }

    public static boolean isNotBeanType(Class<?> type) {
        return null == type || Object.class == type || type.isArray() || PrimitiveTypes.ofPrimitiveOrWrapper(type) != null || CharSequence.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type) || Dictionary.class.isAssignableFrom(type) || Enumeration.class.isAssignableFrom(type) || Iterable.class.isAssignableFrom(type) || Iterator.class.isAssignableFrom(type);
    }

    private static enum PrimitiveOrWrapperConvertors {
        BOOLEAN((Class)Boolean.TYPE){

            public Boolean to(Object value) {
                return Numbers.toBoolean(value);
            }
        }
        ,
        WRAP_BOOLEAN((Class)Boolean.class){

            public Boolean to(Object value) {
                return Numbers.toWrapBoolean(value);
            }
        }
        ,
        BYTE((Class)Byte.TYPE){

            public Byte to(Object value) {
                return Numbers.toByte(value);
            }
        }
        ,
        WRAP_BYTE((Class)Byte.class){

            public Byte to(Object value) {
                return Numbers.toWrapByte(value);
            }
        }
        ,
        SHORT((Class)Short.TYPE){

            public Short to(Object value) {
                return Numbers.toShort(value);
            }
        }
        ,
        WRAP_SHORT((Class)Short.class){

            public Short to(Object value) {
                return Numbers.toWrapShort(value);
            }
        }
        ,
        CHAR((Class)Character.TYPE){

            public Character to(Object value) {
                return Character.valueOf(Numbers.toChar(value));
            }
        }
        ,
        WRAP_CHAR((Class)Character.class){

            public Character to(Object value) {
                return Numbers.toWrapChar(value);
            }
        }
        ,
        INT((Class)Integer.TYPE){

            public Integer to(Object value) {
                return Numbers.toInt(value);
            }
        }
        ,
        WRAP_INT((Class)Integer.class){

            public Integer to(Object value) {
                return Numbers.toWrapInt(value);
            }
        }
        ,
        LONG((Class)Long.TYPE){

            public Long to(Object value) {
                return Numbers.toLong(value);
            }
        }
        ,
        WRAP_LONG((Class)Long.class){

            public Long to(Object value) {
                return Numbers.toWrapLong(value);
            }
        }
        ,
        FLOAT((Class)Float.TYPE){

            public Float to(Object value) {
                return Float.valueOf(Numbers.toFloat(value));
            }
        }
        ,
        WRAP_FLOAT((Class)Float.class){

            public Float to(Object value) {
                return Numbers.toWrapFloat(value);
            }
        }
        ,
        DOUBLE((Class)Double.TYPE){

            public Double to(Object value) {
                return Numbers.toDouble(value);
            }
        }
        ,
        WRAP_DOUBLE((Class)Double.class){

            public Double to(Object value) {
                return Numbers.toWrapDouble(value);
            }
        };

        private static final Map<Class<?>, PrimitiveOrWrapperConvertors> MAPPING;
        private final Class<?> type;

        private PrimitiveOrWrapperConvertors(Class<?> type) {
            this.type = type;
        }

        abstract <T> T to(Object var1);

        public Class<?> type() {
            return this.type;
        }

        static PrimitiveOrWrapperConvertors of(Class<?> targetType) {
            return MAPPING.get(targetType);
        }

        static {
            MAPPING = Enums.toMap(PrimitiveOrWrapperConvertors.class, PrimitiveOrWrapperConvertors::type);
        }
    }
}

