/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.concurrent;

import java.util.Map;
import org.slf4j.MDC;

public final class TracedRunnable
implements Runnable {
    private final Runnable runnable;

    private TracedRunnable(Runnable runnable) {
        this.runnable = runnable;
    }

    public static TracedRunnable of(Runnable runnable) {
        return new TracedRunnable(runnable);
    }

    @Override
    public void run() {
        Map ctx = MDC.getCopyOfContextMap();
        if (ctx != null) {
            MDC.setContextMap((Map)ctx);
        }
        try {
            this.runnable.run();
        }
        finally {
            MDC.clear();
        }
    }
}

