/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.data.lookup;

import cn.ponfee.commons.collect.Collects;
import cn.ponfee.commons.data.NamedDataSource;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.sql.DataSource;
import org.apache.commons.collections4.CollectionUtils;

public final class MultipleDataSourceContext {
    private static final List<String> KEYS = new LinkedList<String>();
    private static final ThreadLocal<String> CONTEXT = new ThreadLocal();

    public static void set(String datasourceName) {
        CONTEXT.set(datasourceName);
    }

    public static String get() {
        return CONTEXT.get();
    }

    public static void clear() {
        CONTEXT.remove();
    }

    public static List<String> listDataSourceNames() {
        return KEYS.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(KEYS);
    }

    static synchronized void add(@Nonnull String key) {
        if (KEYS.contains(key)) {
            throw new IllegalArgumentException("Duplicate key: " + key);
        }
        KEYS.add(key);
    }

    static synchronized void addAll(List<String> keys) {
        if (CollectionUtils.isNotEmpty(keys)) {
            keys.forEach(MultipleDataSourceContext::add);
        }
    }

    static synchronized void remove(String key) {
        KEYS.remove(key);
    }

    static Map<String, DataSource> process(String defaultName, DataSource defaultDataSource, NamedDataSource ... othersDataSource) {
        if (othersDataSource == null) {
            othersDataSource = new NamedDataSource[]{};
        }
        List<String> names = Arrays.stream(othersDataSource).map(NamedDataSource::getName).collect(Collectors.toList());
        names.add(0, defaultName);
        List duplicates = Collects.duplicate(names);
        if (CollectionUtils.isNotEmpty(duplicates)) {
            throw new IllegalArgumentException("Duplicated data source name: " + duplicates);
        }
        MultipleDataSourceContext.addAll(names);
        LinkedHashMap<String, DataSource> dataSources = new LinkedHashMap<String, DataSource>(othersDataSource.length + 1, 1.0f);
        dataSources.put(defaultName, defaultDataSource);
        Arrays.stream(othersDataSource).forEach(ns -> dataSources.put(ns.getName(), ns.getDataSource()));
        return dataSources;
    }
}

