/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.date;

import cn.ponfee.commons.date.JavaUtilDateFormat;
import java.util.Date;
import java.util.function.ToIntFunction;
import org.joda.time.LocalDateTime;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadablePartial;
import org.springframework.util.Assert;

public enum DatePeriods {
    PER_SECOND(PeriodType.seconds(), Period::getSeconds, LocalDateTime::plusSeconds, 1),
    MINUTELY(PeriodType.minutes(), Period::getMinutes, LocalDateTime::plusMinutes, 1),
    HOURLY(PeriodType.hours(), Period::getHours, LocalDateTime::plusHours, 1),
    DAILY(PeriodType.days(), Period::getDays, LocalDateTime::plusDays, 1),
    WEEKLY(PeriodType.weeks(), Period::getWeeks, LocalDateTime::plusWeeks, 1),
    MONTHLY(PeriodType.months(), Period::getMonths, LocalDateTime::plusMonths, 1),
    QUARTERLY(PeriodType.months(), Period::getMonths, LocalDateTime::plusMonths, 3),
    SEMIANNUAL(PeriodType.months(), Period::getMonths, LocalDateTime::plusMonths, 6),
    ANNUAL(PeriodType.years(), Period::getYears, LocalDateTime::plusYears, 1);

    public static final String ORIGINAL_DATE_TIME = "2018-01-01 00:00:00.000";
    private final PeriodType type;
    private final ToIntFunction<Period> unit;
    private final PlusFunction plus;
    private final int multiple;

    private DatePeriods(PeriodType periodType, ToIntFunction<Period> unit, PlusFunction plus, int multiple) {
        this.type = periodType;
        this.unit = unit;
        this.plus = plus;
        this.multiple = multiple;
    }

    public final Segment next(LocalDateTime original, LocalDateTime target, int step, int next) {
        Assert.isTrue((step > 0 ? 1 : 0) != 0, (String)"Step must be positive number.");
        Assert.isTrue((!original.isAfter((ReadablePartial)target) ? 1 : 0) != 0, (String)"Original date cannot be after target date.");
        Period period = new Period((ReadablePartial)original, (ReadablePartial)target, this.type);
        LocalDateTime begin = this.plus.apply(original, (this.unit.applyAsInt(period) / (step *= this.multiple) + next) * step);
        return new Segment(begin, this.plus.apply(begin, step));
    }

    public final Segment next(LocalDateTime target, int step, int next) {
        return this.next(target, target, step, next);
    }

    public final Segment next(LocalDateTime target, int next) {
        return this.next(target, target, 1, next);
    }

    public final Segment next(Date original, Date target, int step, int next) {
        return this.next(new LocalDateTime((Object)original), new LocalDateTime((Object)target), step, next);
    }

    public final Segment next(Date target, int step, int next) {
        LocalDateTime original = new LocalDateTime((Object)target);
        return this.next(original, original, step, next);
    }

    public final Segment next(Date target, int next) {
        LocalDateTime original = new LocalDateTime((Object)target);
        return this.next(original, original, 1, next);
    }

    private static interface PlusFunction {
        public LocalDateTime apply(LocalDateTime var1, int var2);
    }

    public static final class Segment {
        private final Date begin;
        private final Date end;

        private Segment(LocalDateTime begin, LocalDateTime end) {
            this.begin = begin.toDate();
            this.end = end.minusMillis(1).toDate();
        }

        public Date begin() {
            return this.begin;
        }

        public Date end() {
            return this.end;
        }

        public String toString() {
            return JavaUtilDateFormat.PATTERN_51.format(this.begin) + " ~ " + JavaUtilDateFormat.PATTERN_51.format(this.end);
        }
    }
}

