/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.exception;

import java.util.Comparator;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CheckedThrowing {
    private static final Logger LOG = LoggerFactory.getLogger(CheckedThrowing.class);

    public static <T extends Throwable> Runnable runnable(ThrowingRunnable<T> runnable) {
        return ThrowingRunnable.checked(runnable);
    }

    public static <R, T extends Throwable> Callable<R> callable(ThrowingCallable<R, T> callable) {
        return ThrowingCallable.checked(callable);
    }

    public static <E, T extends Throwable> Consumer<E> consumer(ThrowingConsumer<E, T> consumer) {
        return ThrowingConsumer.checked(consumer);
    }

    public static <E, R, T extends Throwable> Function<E, R> function(ThrowingFunction<E, R, T> function) {
        return ThrowingFunction.checked(function);
    }

    public static <R, T extends Throwable> Supplier<R> supplier(ThrowingSupplier<R, T> supplier) {
        return ThrowingSupplier.checked(supplier);
    }

    public static <E, T extends Throwable> Comparator<? super E> comparator(ThrowingComparator<E, T> comparator) {
        return ThrowingComparator.checked(comparator);
    }

    public static void caught(ThrowingRunnable runnable) {
        block2: {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                LOG.error(t.getMessage(), t);
                if (!(t instanceof InterruptedException)) break block2;
                Thread.currentThread().interrupt();
            }
        }
    }

    public static <R> R caught(ThrowingSupplier<R, ?> supplier) {
        try {
            return supplier.get();
        }
        catch (Throwable t) {
            LOG.error(t.getMessage(), t);
            if (t instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            return null;
        }
    }

    public static <E> void caught(ThrowingConsumer<E, ?> consumer, E arg) {
        block2: {
            try {
                consumer.accept(arg);
            }
            catch (Throwable t) {
                LOG.error(t.getMessage(), t);
                if (!(t instanceof InterruptedException)) break block2;
                Thread.currentThread().interrupt();
            }
        }
    }

    public static <E, R> R caught(ThrowingFunction<E, R, ?> function, E arg) {
        return CheckedThrowing.caught(function, arg, null);
    }

    public static <E, R> R caught(ThrowingFunction<E, R, ?> function, E arg, R defaultValue) {
        try {
            return function.apply(arg);
        }
        catch (Throwable t) {
            LOG.error(t.getMessage(), t);
            if (t instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            return defaultValue;
        }
    }

    private static RuntimeException toRuntimeException(Throwable t) {
        return t instanceof RuntimeException ? (RuntimeException)t : new RuntimeException(t);
    }

    @FunctionalInterface
    public static interface ThrowingComparator<E, T extends Throwable> {
        public int compare(E var1, E var2) throws T;

        public static <E, T extends Throwable> Comparator<? super E> checked(ThrowingComparator<E, T> comparator) {
            return (e1, e2) -> {
                try {
                    return comparator.compare(e1, e2);
                }
                catch (Throwable t) {
                    throw CheckedThrowing.toRuntimeException(t);
                }
            };
        }
    }

    @FunctionalInterface
    public static interface ThrowingSupplier<R, T extends Throwable> {
        public R get() throws T;

        public static <R, T extends Throwable> Supplier<R> checked(ThrowingSupplier<R, T> supplier) {
            return () -> {
                try {
                    return supplier.get();
                }
                catch (Throwable t) {
                    throw CheckedThrowing.toRuntimeException(t);
                }
            };
        }
    }

    @FunctionalInterface
    public static interface ThrowingFunction<E, R, T extends Throwable> {
        public R apply(E var1) throws T;

        public static <E, R, T extends Throwable> Function<E, R> checked(ThrowingFunction<E, R, T> function) {
            return e -> {
                try {
                    return function.apply(e);
                }
                catch (Throwable t) {
                    throw CheckedThrowing.toRuntimeException(t);
                }
            };
        }
    }

    public static interface ThrowingConsumer<E, T extends Throwable> {
        public void accept(E var1) throws T;

        public static <E, T extends Throwable> Consumer<E> checked(ThrowingConsumer<E, T> consumer) {
            return e -> {
                try {
                    consumer.accept(e);
                }
                catch (Throwable t) {
                    throw CheckedThrowing.toRuntimeException(t);
                }
            };
        }
    }

    @FunctionalInterface
    public static interface ThrowingCallable<R, T extends Throwable> {
        public R call() throws T;

        public static <R, T extends Throwable> Callable<R> checked(ThrowingCallable<R, T> callable) {
            return () -> {
                try {
                    return callable.call();
                }
                catch (Throwable t) {
                    throw CheckedThrowing.toRuntimeException(t);
                }
            };
        }
    }

    @FunctionalInterface
    public static interface ThrowingRunnable<T extends Throwable> {
        public void run() throws T;

        public static <T extends Throwable> Runnable checked(ThrowingRunnable<T> runnable) {
            return () -> {
                try {
                    runnable.run();
                }
                catch (Throwable t) {
                    throw CheckedThrowing.toRuntimeException(t);
                }
            };
        }
    }
}

