/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.export;

import cn.ponfee.commons.export.AbstractDataExporter;
import cn.ponfee.commons.export.AbstractSplitExporter;
import cn.ponfee.commons.export.ExcelExporter;
import cn.ponfee.commons.export.Table;
import java.util.concurrent.Executor;

public class SplitExcelExporter
extends AbstractSplitExporter {
    public SplitExcelExporter(int batchSize, String savingFilePathPrefix, Executor executor) {
        super(batchSize, savingFilePathPrefix, ".xlsx", executor);
    }

    @Override
    protected AbstractSplitExporter.AbstractAsyncSplitExporter splitExporter(Table<Object[]> subTable, String savingFilePath) {
        return new AsnycExcelExporter(subTable, savingFilePath, super.getName());
    }

    private static class AsnycExcelExporter
    extends AbstractSplitExporter.AbstractAsyncSplitExporter {
        final String sheetName;

        AsnycExcelExporter(Table<Object[]> subTable, String savingFilePath, String sheetName) {
            super(subTable, savingFilePath);
            this.sheetName = sheetName;
        }

        @Override
        protected AbstractDataExporter<?> createExporter() {
            ExcelExporter excel = new ExcelExporter();
            excel.setName(this.sheetName);
            return excel;
        }

        @Override
        protected void complete(AbstractDataExporter<?> exporter) {
            ((ExcelExporter)exporter).write(this.savingFilePath);
        }
    }
}

