/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.export;

import cn.ponfee.commons.export.CellStyleOptions;
import cn.ponfee.commons.export.Thead;
import cn.ponfee.commons.tree.FlatNode;
import cn.ponfee.commons.tree.PlainNode;
import cn.ponfee.commons.tree.TreeNodeBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.commons.collections4.CollectionUtils;

public class Table<E>
implements Serializable {
    private static final long serialVersionUID = 1600567917100486004L;
    private static final int ROOT_PID = 0;
    private final List<FlatNode<Integer, Thead>> thead;
    private final Function<E, Object[]> converter;
    private String caption;
    private Object[] tfoot;
    private String comment;
    private Map<CellStyleOptions, Object> options;
    private final LinkedBlockingQueue<E> tbody = new LinkedBlockingQueue();
    private volatile boolean empty = true;
    private volatile boolean end = false;

    public Table(List<FlatNode<Integer, Thead>> thead, Function<E, Object[]> converter, String caption, Object[] tfoot, String comment, Map<CellStyleOptions, Object> options) {
        this.thead = thead;
        this.converter = converter;
        this.caption = caption;
        this.tfoot = tfoot;
        this.comment = comment;
        this.options = options;
    }

    public Table(List<PlainNode<Integer, Thead>> list) {
        this(list, null);
    }

    public Table(List<PlainNode<Integer, Thead>> list, Function<E, Object[]> converter) {
        this.thead = TreeNodeBuilder.newBuilder(0).build().mount(list).flatCFS();
        this.converter = converter;
    }

    public Table(String[] names) {
        this(names, null);
    }

    public Table(String[] names, Function<E, Object[]> converter) {
        ArrayList<PlainNode<Integer, Thead>> list = new ArrayList<PlainNode<Integer, Thead>>(names.length);
        for (int i = 0; i < names.length; ++i) {
            list.add(new PlainNode<Integer, Thead>(i + 1, 0, new Thead(names[i])));
        }
        this.thead = TreeNodeBuilder.newBuilder(0).build().mount(list).flatCFS();
        this.converter = converter;
    }

    public Table<E> copyOfWithoutTbody() {
        return new Table<E>(this.thead, this.converter, this.caption, this.tfoot, this.comment, this.options);
    }

    public <H> Table<H> copyOfWithoutTbody(Function<H, Object[]> converter) {
        return new Table<H>(this.thead, converter, this.caption, this.tfoot, this.comment, this.options);
    }

    public List<FlatNode<Integer, Thead>> getThead() {
        return this.thead;
    }

    public Function<E, Object[]> getConverter() {
        return this.converter;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public Object[] getTfoot() {
        return this.tfoot;
    }

    public void setTfoot(Object[] tfoot) {
        this.tfoot = tfoot;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Map<CellStyleOptions, Object> getOptions() {
        return this.options;
    }

    public void setOptions(Map<CellStyleOptions, Object> options) {
        this.options = options;
    }

    public void addRowsAndEnd(List<E> rows) {
        this.addRows(rows);
        this.toEnd();
    }

    public void addRows(List<E> rows) {
        if (CollectionUtils.isEmpty(rows)) {
            return;
        }
        try {
            for (E row : rows) {
                this.tbody.put(row);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Put an element to queue failed.", e);
        }
        this.empty = false;
    }

    public void addRowAndEnd(E row) {
        this.addRow(row);
        this.toEnd();
    }

    public void addRow(E row) {
        if (row == null) {
            return;
        }
        try {
            this.tbody.put(row);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Put an element to queue failed.", e);
        }
        this.empty = false;
    }

    public synchronized Table<E> toEnd() {
        this.end = true;
        return this;
    }

    boolean isEnd() {
        return this.end && this.tbody.isEmpty();
    }

    boolean isNotEnd() {
        return !this.isEnd();
    }

    boolean isEmptyTbody() {
        return this.empty && this.isEnd();
    }

    E getRow(long timeoutMillis) throws InterruptedException {
        return this.tbody.poll(timeoutMillis, TimeUnit.MILLISECONDS);
    }
}

