/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.extract;

import cn.ponfee.commons.extract.DataExtractor;
import cn.ponfee.commons.extract.ExtractableDataSource;
import cn.ponfee.commons.io.ByteOrderMarks;
import cn.ponfee.commons.io.CharsetDetector;
import cn.ponfee.commons.io.PrereadInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.function.BiConsumer;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;

public class CsvExtractor
extends DataExtractor {
    private final CSVFormat csvFormat;
    private final boolean withHeader;
    private final int startRow;
    private final Charset charset;

    protected CsvExtractor(ExtractableDataSource dataSource, String[] headers, CSVFormat csvFormat, int startRow, Charset charset) {
        super(dataSource, headers);
        this.withHeader = ArrayUtils.isNotEmpty((Object[])headers);
        this.startRow = startRow;
        this.charset = charset;
        CSVFormat.Builder builder = CSVFormat.Builder.create((CSVFormat)((CSVFormat)ObjectUtils.defaultIfNull((Object)csvFormat, (Object)CSVFormat.DEFAULT)));
        if (this.withHeader) {
            builder.setHeader(headers);
        }
        this.csvFormat = builder.build();
    }

    @Override
    public void extract(BiConsumer<Integer, String[]> processor) throws IOException {
        PrereadInputStream bris;
        Charset encoding = this.charset != null ? this.charset : CharsetDetector.detect(bris.heads());
        ByteOrderMarks bom = ByteOrderMarks.of(encoding, (bris = new PrereadInputStream(this.dataSource.asInputStream(), 3600)).heads());
        if (bom != null) {
            bris.skip(bom.length());
        }
        try (InputStreamReader reader = new InputStreamReader((InputStream)bris, encoding);){
            int columnSize = this.withHeader ? this.headers.length : 0;
            CSVParser records = this.csvFormat.parse((Reader)reader);
            int i = 0;
            int start = this.startRow;
            for (CSVRecord record : records) {
                int j;
                if (this.end) {
                    break;
                }
                if (start > 0) {
                    --start;
                    continue;
                }
                if (!this.withHeader && i == 0) {
                    columnSize = record.size();
                }
                int n = record.size();
                String[] data = new String[columnSize];
                for (j = 0; j < n && j < columnSize; ++j) {
                    data[j] = record.get(j);
                }
                while (j < columnSize) {
                    data[j] = null;
                    ++j;
                }
                if (!this.isNotEmpty(data)) continue;
                processor.accept(i++, data);
            }
        }
    }
}

