/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.io;

import cn.ponfee.commons.io.CharsetDetector;
import cn.ponfee.commons.io.Files;
import cn.ponfee.commons.util.Enums;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.bouncycastle.util.Arrays;

public enum ByteOrderMarks {
    UTF_8(StandardCharsets.UTF_8, -17, -69, -65),
    UTF_16LE(StandardCharsets.UTF_16LE, -1, -2),
    UTF_16BE(StandardCharsets.UTF_16BE, -2, -1),
    UTF_32LE(Charset.forName("UTF-32LE"), -1, -2, 0, 0),
    UTF_32BE(Charset.forName("UTF-32BE"), 0, 0, -2, -1);

    private static final Map<Charset, ByteOrderMarks> MAPPING;
    private final Charset charset;
    private final byte[] bytes;

    private ByteOrderMarks(Charset charset, byte ... bytes) {
        this.charset = charset;
        this.bytes = bytes;
    }

    public static ByteOrderMarks of(String path) throws IOException {
        return ByteOrderMarks.of(new File(path));
    }

    public static ByteOrderMarks of(File file) throws IOException {
        return ByteOrderMarks.of(Files.readByteArray(file, 3600));
    }

    public static ByteOrderMarks of(InputStream input) throws IOException {
        return ByteOrderMarks.of(Files.readByteArray(input, 3600));
    }

    public static ByteOrderMarks of(byte[] bytes) {
        return ByteOrderMarks.of(CharsetDetector.detect(bytes, 3600), bytes);
    }

    public static ByteOrderMarks of(Charset charset, String path) throws IOException {
        return ByteOrderMarks.of(charset, new File(path));
    }

    public static ByteOrderMarks of(Charset charset, File file) throws IOException {
        ByteOrderMarks bom = MAPPING.get(charset);
        if (bom == null) {
            return null;
        }
        return bom.match(Files.readByteArray(file, bom.length())) ? bom : null;
    }

    public static ByteOrderMarks of(Charset charset, InputStream input) throws IOException {
        ByteOrderMarks bom = MAPPING.get(charset);
        if (bom == null) {
            return null;
        }
        return bom.match(Files.readByteArray(input, bom.length())) ? bom : null;
    }

    public static ByteOrderMarks of(Charset charset, byte[] bytes) {
        ByteOrderMarks bom = MAPPING.get(charset);
        if (bom == null) {
            return null;
        }
        return bom.match(bytes) ? bom : null;
    }

    public static boolean has(String path) throws IOException {
        return ByteOrderMarks.has(new File(path));
    }

    public static boolean has(File file) throws IOException {
        return ByteOrderMarks.has(Files.readByteArray(file, 3600));
    }

    public static boolean has(InputStream input) throws IOException {
        return ByteOrderMarks.has(Files.readByteArray(input, 3600));
    }

    public static boolean has(byte[] bytes) {
        return ByteOrderMarks.has(CharsetDetector.detect(bytes, 3600), bytes);
    }

    public static boolean has(Charset charset, String path) throws IOException {
        return ByteOrderMarks.has(charset, new File(path));
    }

    public static boolean has(Charset charset, File file) throws IOException {
        return ByteOrderMarks.of(charset, file) != null;
    }

    public static boolean has(Charset charset, InputStream input) throws IOException {
        return ByteOrderMarks.of(charset, input) != null;
    }

    public static boolean has(Charset charset, byte[] bytes) {
        return ByteOrderMarks.of(charset, bytes) != null;
    }

    public static ByteOrderMarks add(String path) throws IOException {
        return ByteOrderMarks.add(null, new File(path));
    }

    public static ByteOrderMarks add(File file) throws IOException {
        return ByteOrderMarks.add(null, file);
    }

    public static ByteOrderMarks add(Charset charset, String path) throws IOException {
        return ByteOrderMarks.add(charset, new File(path));
    }

    public static ByteOrderMarks add(Charset charset, File file) throws IOException {
        try (RandomAccessFile raf = new RandomAccessFile(file, "rw");){
            int n;
            ByteOrderMarks bom;
            int count;
            byte[] headBytes;
            if (charset == null) {
                headBytes = new byte[(int)Math.min(file.length(), 3600L)];
                charset = CharsetDetector.detect(headBytes, count = raf.read(headBytes));
                bom = MAPPING.get(charset);
                if (bom == null) {
                    ByteOrderMarks byteOrderMarks = null;
                    return byteOrderMarks;
                }
            } else {
                bom = MAPPING.get(charset);
                if (bom == null) {
                    ByteOrderMarks byteOrderMarks = null;
                    return byteOrderMarks;
                }
                headBytes = new byte[bom.length()];
                count = raf.read(headBytes);
            }
            if (bom.match(headBytes, count)) {
                ByteOrderMarks byteOrderMarks = bom;
                return byteOrderMarks;
            }
            ByteArrayOutputStream tailBytes = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            while ((n = raf.read(buffer)) != -1) {
                tailBytes.write(buffer, 0, n);
            }
            raf.seek(0L);
            raf.write(bom.bytes);
            raf.write(headBytes, 0, count);
            raf.write(tailBytes.toByteArray());
            tailBytes.close();
            ByteOrderMarks byteOrderMarks = bom;
            return byteOrderMarks;
        }
    }

    public static ByteOrderMarks remove(String path) throws IOException {
        return ByteOrderMarks.remove(null, new File(path));
    }

    public static ByteOrderMarks remove(File file) throws IOException {
        return ByteOrderMarks.remove(null, file);
    }

    public static ByteOrderMarks remove(Charset charset, String path) throws IOException {
        return ByteOrderMarks.remove(charset, new File(path));
    }

    public static ByteOrderMarks remove(Charset charset, File file) throws IOException {
        try (RandomAccessFile raf = new RandomAccessFile(file, "rw");){
            int n;
            ByteOrderMarks bom;
            int count;
            byte[] headBytes;
            long length = raf.length();
            if (charset == null) {
                headBytes = new byte[(int)Math.min(file.length(), 3600L)];
                charset = CharsetDetector.detect(headBytes, count = raf.read(headBytes));
                bom = MAPPING.get(charset);
                if (bom == null) {
                    ByteOrderMarks byteOrderMarks = null;
                    return byteOrderMarks;
                }
            } else {
                bom = MAPPING.get(charset);
                if (bom == null) {
                    ByteOrderMarks byteOrderMarks = null;
                    return byteOrderMarks;
                }
                headBytes = new byte[bom.length()];
                count = raf.read(headBytes);
            }
            if (!bom.match(headBytes, count)) {
                ByteOrderMarks byteOrderMarks = bom;
                return byteOrderMarks;
            }
            ByteArrayOutputStream tailBytes = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            while ((n = raf.read(buffer)) != -1) {
                tailBytes.write(buffer, 0, n);
            }
            raf.seek(0L);
            raf.write(headBytes, bom.length(), count - bom.length());
            raf.write(tailBytes.toByteArray());
            raf.setLength(length - (long)bom.length());
            tailBytes.close();
            ByteOrderMarks byteOrderMarks = bom;
            return byteOrderMarks;
        }
    }

    public static byte[] get(Charset charset) {
        ByteOrderMarks bom = MAPPING.get(charset);
        return bom == null ? null : bom.bytes();
    }

    public Charset charset() {
        return this.charset;
    }

    public byte[] bytes() {
        return Arrays.copyOf((byte[])this.bytes, (int)this.bytes.length);
    }

    public int length() {
        return this.bytes.length;
    }

    private boolean match(byte[] array) {
        return this.match(array, array.length);
    }

    private boolean match(byte[] array, int count) {
        int n = this.length();
        if (count < n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (array[i] == this.bytes[i]) continue;
            return false;
        }
        return true;
    }

    static {
        MAPPING = Enums.toMap(ByteOrderMarks.class, ByteOrderMarks::charset);
    }
}

