/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.io;

import cn.ponfee.commons.io.CharsetDetector;
import cn.ponfee.commons.tree.PlainNode;
import cn.ponfee.commons.tree.TreeNode;
import cn.ponfee.commons.tree.TreeNodeBuilder;
import cn.ponfee.commons.tree.print.MultiwayTreePrinter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.output.StringBuilderWriter;

public final class Files {
    public static final int EOF = -1;
    public static final int BUFF_SIZE = 8192;
    public static final String TOP_PATH = "..";
    public static final String CURRENT_PATH = ".";
    public static final Charset DEFAULT_CHARSET = Charset.defaultCharset();
    public static final String DEFAULT_CHARSET_NAME = DEFAULT_CHARSET.name();
    public static final String UTF_8 = "UTF-8";
    public static final String WINDOWS_FOLDER_SEPARATOR = "\\";
    public static final String UNIX_FOLDER_SEPARATOR = "/";
    public static final String SYSTEM_FOLDER_SEPARATOR = File.separator;
    public static final String UNIX_LINE_SEPARATOR = "\n";
    public static final String WINDOWS_LINE_SEPARATOR = "\r\n";
    public static final String MAC_LINE_SEPARATOR = "\r";
    public static final String SYSTEM_LINE_SEPARATOR;

    public static File mkdir(String filePath) {
        File file = new File(filePath);
        Files.mkdir(file);
        return file;
    }

    public static void mkdir(File file) {
        if (file.isFile()) {
            throw new IllegalStateException(file.getAbsolutePath() + " is a directory.");
        }
        if (file.exists()) {
            return;
        }
        if (file.mkdirs()) {
            file.setLastModified(System.currentTimeMillis());
        }
    }

    public static void touch(File file) {
        if (file.isDirectory()) {
            throw new IllegalStateException(file.getAbsolutePath() + " is a directory.");
        }
        if (file.exists()) {
            return;
        }
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        try {
            if (file.createNewFile()) {
                file.setLastModified(System.currentTimeMillis());
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String toString(File file) throws IOException {
        return Files.toString(file, CharsetDetector.detect(file));
    }

    /*
     * Exception decompiling
     */
    public static String toString(File file, Charset charset) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static byte[] toByteArray(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static byte[] readByteArray(String filePath, int count) throws IOException {
        return Files.readByteArray(new File(filePath), count);
    }

    public static byte[] readByteArray(File file, int count) throws IOException {
        try (FileInputStream input = new FileInputStream(file);){
            byte[] byArray = Files.readByteArray(input, count);
            return byArray;
        }
    }

    public static byte[] readByteArray(InputStream input, int count) throws IOException {
        int index;
        int n;
        byte[] bytes = new byte[count];
        for (index = 0; index < count && (n = input.read(bytes, index, count - index)) != -1; index += n) {
        }
        return index == count ? bytes : Arrays.copyOf(bytes, index);
    }

    public static TreeNode<Integer, File> listFiles(String filePath) {
        return Files.listFiles(new File(filePath));
    }

    public static TreeNode<Integer, File> listFiles(File file) {
        LinkedList<PlainNode> files = new LinkedList<PlainNode>();
        AtomicInteger counter = new AtomicInteger(1);
        Integer dummyRootPid = 0;
        LinkedList<PlainNode<Integer, File>> stack = new LinkedList<PlainNode<Integer, File>>();
        stack.push(new PlainNode<Integer, File>(counter.getAndIncrement(), dummyRootPid, file));
        while (!stack.isEmpty()) {
            PlainNode node = (PlainNode)stack.pop();
            files.add(node);
            if (!((File)node.getAttach()).isDirectory()) continue;
            Arrays.stream(((File)node.getAttach()).listFiles()).sorted(Comparator.comparing(File::getName)).forEach(f -> stack.push(new PlainNode<Integer, File>(counter.getAndIncrement(), (Integer)node.getNid(), (File)f)));
        }
        return TreeNodeBuilder.newBuilder(dummyRootPid).build().mount(files).getChildren().get(0);
    }

    public static String tree(String filePath) throws IOException {
        return Files.tree(new File(filePath));
    }

    public static String tree(File file) throws IOException {
        StringBuilder builder = new StringBuilder();
        new MultiwayTreePrinter<File>(builder, File::getName, f -> f.isDirectory() ? Arrays.asList(f.listFiles()) : null).print(file);
        return builder.toString();
    }

    static {
        StringBuilderWriter buffer = new StringBuilderWriter(4);
        PrintWriter out = new PrintWriter((Writer)buffer);
        out.println();
        out.flush();
        SYSTEM_LINE_SEPARATOR = buffer.toString();
        out.close();
    }
}

