/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.jce.cert;

import cn.ponfee.commons.jce.Providers;
import cn.ponfee.commons.jce.cert.CertSignedVerifier;
import cn.ponfee.commons.jce.cert.X509CertInfo;
import cn.ponfee.commons.jce.cert.X509CertUtils;
import java.security.InvalidKeyException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;

public class CertPKCS1Verifier
extends CertSignedVerifier {
    public CertPKCS1Verifier(X509Certificate rootCert, X509CRL crl, X509Certificate subject, byte[] info, byte[] signed) {
        super(rootCert, crl, info);
        this.subjects = new X509Certificate[]{subject};
        this.signedInfos.add(signed);
    }

    @Override
    public void verifySigned() {
        String subjectCN = null;
        Signature sign = Providers.getSignature(this.subjects[0].getSigAlgName());
        try {
            subjectCN = X509CertUtils.getCertInfo(this.subjects[0], X509CertInfo.SUBJECT_CN);
            sign.initVerify(this.subjects[0].getPublicKey());
            sign.update(this.info);
            if (!sign.verify((byte[])this.signedInfos.get(0))) {
                throw new SecurityException("[" + subjectCN + "]\u9a8c\u7b7e\u4e0d\u901a\u8fc7");
            }
        }
        catch (SignatureException e) {
            throw new SecurityException("[" + subjectCN + "]\u8bc1\u4e66\u7b7e\u540d\u4fe1\u606f\u9519\u8bef", e);
        }
        catch (InvalidKeyException e) {
            throw new SecurityException("\u8bc1\u4e66\u9a8c\u7b7e\u51fa\u9519", e);
        }
    }
}

