/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.jce.cert;

import cn.ponfee.commons.jce.cert.CertSignedVerifier;
import cn.ponfee.commons.jce.cert.X509CertInfo;
import cn.ponfee.commons.jce.cert.X509CertUtils;
import cn.ponfee.commons.jce.pkcs.PKCS7Signature;
import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.SignerInfo;

public class CertPKCS7Verifier
extends CertSignedVerifier {
    private final PKCS7 pkcs7;

    public CertPKCS7Verifier(X509Certificate rootCert, X509CRL crl, byte[] pkcs7Data, byte[] info) {
        this(rootCert, crl, PKCS7Signature.getPkcs7(pkcs7Data), info);
    }

    public CertPKCS7Verifier(X509Certificate rootCert, X509CRL crl, byte[] pkcs7Data) {
        this(rootCert, crl, PKCS7Signature.getPkcs7(pkcs7Data));
    }

    public CertPKCS7Verifier(X509Certificate rootCert, X509CRL crl, PKCS7 pkcs7) {
        this(rootCert, crl, pkcs7, PKCS7Signature.getContent(pkcs7));
    }

    public CertPKCS7Verifier(X509Certificate rootCert, X509CRL crl, PKCS7 pkcs7, byte[] info) {
        super(rootCert, crl, info);
        this.pkcs7 = pkcs7;
        SignerInfo[] signs = pkcs7.getSignerInfos();
        HashMap<BigInteger, X509Certificate> certs = new HashMap<BigInteger, X509Certificate>(signs.length << 1);
        for (X509Certificate cert : pkcs7.getCertificates()) {
            certs.put(cert.getSerialNumber(), cert);
        }
        this.subjects = new X509Certificate[signs.length];
        for (int i = 0; i < signs.length; ++i) {
            X509Certificate cert = (X509Certificate)certs.get(signs[i].getCertificateSerialNumber());
            if (cert == null) {
                throw new IllegalArgumentException("cannot found the sign cert: " + signs[i].getCertificateSerialNumber());
            }
            this.subjects[i++] = cert;
            this.signedInfos.add(signs[i].getEncryptedDigest());
        }
    }

    @Override
    public void verifySigned() {
        String subjectCN = null;
        try {
            for (SignerInfo signer : this.pkcs7.getSignerInfos()) {
                subjectCN = X509CertUtils.getCertInfo(signer.getCertificate(this.pkcs7), X509CertInfo.SUBJECT_CN);
                if (this.pkcs7.verify(signer, this.info) != null) continue;
                throw new SecurityException("[" + subjectCN + "]\u9a8c\u7b7e\u4e0d\u901a\u8fc7");
            }
        }
        catch (SignatureException e) {
            throw new SecurityException("[" + subjectCN + "]\u7b7e\u540d\u4fe1\u606f\u9519\u8bef", e);
        }
        catch (IOException e) {
            throw new SecurityException("\u83b7\u53d6\u8bc1\u4e66\u4e3b\u9898\u5f02\u5e38", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecurityException("\u8bc1\u4e66\u9a8c\u7b7e\u51fa\u9519", e);
        }
    }
}

