/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.jce.cert;

import java.io.ByteArrayInputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import javax.security.auth.x500.X500Principal;

public class RepairX500Principal
implements Principal {
    private static final byte[][] OID_ARRAY = new byte[][]{{85, 4, 6}, {85, 4, 8}, {85, 4, 7}, {85, 4, 10}, {85, 4, 11}, {85, 4, 3}, {42, -122, 72, -122, -9, 13, 1, 9, 1}};
    private static final String[] DN_STR = new String[]{"C", "ST", "L", "O", "OU", "CN", "E"};
    private final ByteArrayInputStream input;

    public RepairX500Principal(X500Principal principal) {
        this.input = new ByteArrayInputStream(principal.getEncoded());
    }

    @Override
    public String getName() {
        int len;
        if (this.preLen(48) != this.input.available()) {
            return null;
        }
        byte[] oid = new byte[9];
        StringBuilder builder = new StringBuilder();
        while (this.preLen(49) != 0 && this.preLen(48) != 0 && (len = this.preLen(6)) != 0) {
            int oidType;
            if (len > 9) {
                oidType = -1;
                this.input.skip(len);
            } else {
                this.input.read(oid, 0, len);
                for (oidType = DN_STR.length - 1; oidType > -1; --oidType) {
                    for (len = OID_ARRAY[oidType].length - 1; len > -1 && oid[len] == OID_ARRAY[oidType][len]; --len) {
                    }
                    if (len < 0) break;
                }
            }
            Charset charset = this.input.read() == 30 ? StandardCharsets.UTF_16BE : StandardCharsets.UTF_8;
            len = this.preLen(-1);
            if (oidType > -1) {
                byte[] value = new byte[len];
                this.input.read(value, 0, value.length);
                if (builder.length() > 0) {
                    builder.append(',');
                }
                builder.append(DN_STR[oidType]).append('=').append(new String(value, charset));
                continue;
            }
            this.input.skip(len);
        }
        return builder.length() == 0 ? null : builder.toString();
    }

    private int preLen(int tag) {
        int itag;
        if (tag != -1 && (itag = this.input.read()) != tag) {
            return 0;
        }
        itag = this.input.read();
        if (itag < 128) {
            return itag;
        }
        if (itag == 129) {
            return this.input.read();
        }
        if (itag == 130) {
            itag = this.input.read();
            return (itag << 8) + this.input.read();
        }
        return 0;
    }
}

