/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.jce.cert;

import cn.ponfee.commons.io.Closeables;
import cn.ponfee.commons.jce.Providers;
import cn.ponfee.commons.jce.cert.X509CertInfo;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.jce.provider.X509CRLObject;
import org.bouncycastle.jce.provider.X509CRLParser;
import org.bouncycastle.jce.provider.X509CertificateObject;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;

public class X509CertUtils {
    private static final String X509 = "X.509";
    private static final char[] ENDBOUNDARY = "-----END".toCharArray();
    private static final FastDateFormat DATE_FORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZ");

    public static X509Certificate loadPemCert(String pem) {
        return X509CertUtils.loadX509Cert(pem.getBytes());
    }

    public static X509Certificate loadX509Cert(byte[] bytes) {
        CertificateFactory cf = Providers.getCertificateFactory(X509);
        try {
            return (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(bytes));
        }
        catch (Exception e) {
            X509CertificateObject x509CertificateObject;
            ASN1InputStream input = null;
            try {
                if (X509CertUtils.isBase64(new ByteArrayInputStream(bytes))) {
                    bytes = X509CertUtils.base64ToBinary(new ByteArrayInputStream(bytes));
                }
                input = new ASN1InputStream((InputStream)new ByteArrayInputStream(bytes));
                ASN1Sequence seq = (ASN1Sequence)input.readObject();
                Certificate struct = Certificate.getInstance((Object)seq);
                x509CertificateObject = new X509CertificateObject(struct);
            }
            catch (Exception ex) {
                try {
                    SecurityException se = new SecurityException(e.getMessage() + "; " + ex.getMessage());
                    se.setStackTrace((StackTraceElement[])ArrayUtils.addAll((Object[])e.getStackTrace(), (Object[])ex.getStackTrace()));
                    throw se;
                }
                catch (Throwable throwable) {
                    Closeables.console(input);
                    throw throwable;
                }
            }
            Closeables.console((AutoCloseable)input);
            return x509CertificateObject;
        }
    }

    public static X509Certificate loadX509Cert(InputStream input) throws IOException {
        return X509CertUtils.loadX509Cert(IOUtils.toByteArray((InputStream)input));
    }

    public static X509Certificate loadX509Cert(File certFile) throws IOException {
        return X509CertUtils.loadX509Cert(IOUtils.toByteArray((InputStream)new FileInputStream(certFile)));
    }

    /*
     * Exception decompiling
     */
    public static String exportToPem(Object obj) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static X509CRL loadX509Crl(byte[] bytes) {
        CertificateFactory cf = Providers.getCertificateFactory(X509);
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            return (X509CRL)cf.generateCRL(bais);
        }
        catch (Exception e) {
            X509CRLParser parser = new X509CRLParser();
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(bytes);
                parser.engineInit((InputStream)in);
                return (X509CRLObject)parser.engineRead();
            }
            catch (Exception ex) {
                SecurityException se = new SecurityException(e.getMessage() + "; " + ex.getMessage());
                se.setStackTrace((StackTraceElement[])ArrayUtils.addAll((Object[])e.getStackTrace(), (Object[])ex.getStackTrace()));
                throw se;
            }
        }
    }

    public static X509CRL loadX509Crl(InputStream is) throws IOException {
        return X509CertUtils.loadX509Crl(IOUtils.toByteArray((InputStream)is));
    }

    public static X509CRL loadX509Crl(File crlFile) throws IOException {
        return X509CertUtils.loadX509Crl(IOUtils.toByteArray((InputStream)new FileInputStream(crlFile)));
    }

    public static X509CRLEntry getX509CrlEntry(File crlFile, File certFile) throws IOException {
        X509CRL crl = X509CertUtils.loadX509Crl(crlFile);
        X509Certificate cert = X509CertUtils.loadX509Cert(certFile);
        return crl.getRevokedCertificate(cert);
    }

    public static String getCertExtVal(X509Certificate cert, String oid) {
        byte[] bytes = cert.getExtensionValue(oid);
        String reuslt = null;
        if (null != bytes && bytes.length > 0) {
            String value = new String(bytes);
            reuslt = value.substring(4);
        }
        return reuslt;
    }

    public static String getCertInfo(X509Certificate cert, X509CertInfo info) {
        try {
            switch (info) {
                case VERSION: {
                    return Integer.toString(cert.getVersion());
                }
                case CERT_SN: {
                    return Hex.encodeHexString((byte[])cert.getSerialNumber().toByteArray(), (boolean)false);
                }
                case ALG_NAME: {
                    return cert.getSigAlgName();
                }
                case START_TM: {
                    return DATE_FORMAT.format(cert.getNotBefore());
                }
                case END_TM: {
                    return DATE_FORMAT.format(cert.getNotAfter());
                }
                case SUBJECT_DN: {
                    return cert.getSubjectDN().getName();
                }
                case ISSUER_DN: {
                    return cert.getIssuerDN().getName();
                }
                case PUBLIC_KEY: {
                    return Base64.getEncoder().encodeToString(cert.getPublicKey().getEncoded());
                }
                case USAGE: {
                    if (cert.getKeyUsage()[0]) {
                        return "signature";
                    }
                    if (cert.getKeyUsage()[3]) {
                        return "encipherment";
                    }
                    return null;
                }
                case SUBJECT_C: 
                case SUBJECT_CN: 
                case SUBJECT_L: 
                case SUBJECT_O: 
                case SUBJECT_OU: 
                case SUBJECT_ST: {
                    return X509CertUtils.parseCertDN(cert.getSubjectDN().getName(), info);
                }
                case ISSUER_C: 
                case ISSUER_CN: 
                case ISSUER_L: 
                case ISSUER_O: 
                case ISSUER_OU: 
                case ISSUER_ST: {
                    return X509CertUtils.parseCertDN(cert.getIssuerDN().getName(), info);
                }
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String parseCertDN(String certDN, X509CertInfo ci) {
        String[] split;
        String type = ci.attr() + "=";
        for (String x : split = certDN.split(",")) {
            if (!x.contains(type)) continue;
            return x.trim().substring(type.length());
        }
        return null;
    }

    public static Map<String, Object> parseP7(byte[] p7bytes) {
        try {
            HashMap<String, Object> result = new HashMap<String, Object>(3);
            CMSSignedData cms = new CMSSignedData(p7bytes);
            result.put("content", cms.getSignedContent().getContent());
            Store certStore = cms.getCertificates();
            SignerInformationStore signerStore = cms.getSignerInfos();
            Collection signers = signerStore.getSigners();
            X509CertificateObject[] certs = new X509CertificateObject[signers.size()];
            int i = 0;
            for (SignerInformation signer : signers) {
                Collection certChain = certStore.getMatches((Selector)signer.getSID());
                Certificate cert = ((X509CertificateHolder)certChain.iterator().next()).toASN1Structure();
                certs[i++] = new X509CertificateObject(cert);
            }
            result.put("certs", certs);
            result.put("signers", cms.getSignerInfos().getSigners());
            return result;
        }
        catch (Exception e) {
            throw new SecurityException("\u89e3\u6790P7S\u5f02\u5e38", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isBase64(InputStream inputstream) throws IOException {
        try {
            if (!inputstream.markSupported()) {
                byte[] abyte0 = X509CertUtils.getTotalBytes(new BufferedInputStream(inputstream));
                inputstream = new ByteArrayInputStream(abyte0);
            }
            if (inputstream.available() >= 10) {
                inputstream.mark(10);
                int i = inputstream.read();
                int j = inputstream.read();
                int k = inputstream.read();
                int l = inputstream.read();
                int i1 = inputstream.read();
                int j1 = inputstream.read();
                int k1 = inputstream.read();
                int l1 = inputstream.read();
                int i2 = inputstream.read();
                int j2 = inputstream.read();
                inputstream.reset();
                boolean bl = i == 45 && j == 45 && k == 45 && l == 45 && i1 == 45 && j1 == 66 && k1 == 69 && l1 == 71 && i2 == 73 && j2 == 78;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            Closeables.console(inputstream);
        }
    }

    private static byte[] getTotalBytes(InputStream input) throws IOException {
        int len;
        byte[] abyte0 = new byte[8192];
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
        baos.reset();
        while ((len = input.read(abyte0, 0, abyte0.length)) != -1) {
            baos.write(abyte0, 0, len);
        }
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] base64ToBinary(InputStream input) throws IOException {
        try {
            long len = 0L;
            input.mark(input.available());
            BufferedInputStream bufferedinputstream = new BufferedInputStream(input);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)bufferedinputstream, StandardCharsets.US_ASCII));
            String s = X509CertUtils.readLine(reader);
            if (s == null || !s.startsWith("-----BEGIN")) {
                throw new IOException("Unsupported encoding");
            }
            len += (long)s.length();
            StringBuilder sb = new StringBuilder();
            while ((s = X509CertUtils.readLine(reader)) != null && !s.startsWith("-----END")) {
                sb.append(s);
            }
            if (s == null) {
                throw new IOException("Unsupported encoding");
            }
            len += (long)s.length();
            input.reset();
            input.skip(len += (long)sb.length());
            byte[] byArray = Base64.getDecoder().decode(sb.toString());
            return byArray;
        }
        finally {
            Closeables.console(input);
        }
    }

    private static String readLine(BufferedReader bufferedreader) throws IOException {
        int i;
        int j = 0;
        boolean flag = true;
        boolean flag1 = false;
        StringBuilder builder = new StringBuilder(80);
        do {
            i = bufferedreader.read();
            if (flag && j < ENDBOUNDARY.length) {
                boolean bl = flag = (char)i == ENDBOUNDARY[j++];
            }
            if (!flag1) {
                flag1 = flag && j == ENDBOUNDARY.length;
            }
            builder.append((char)i);
        } while (i != -1 && i != 10 && i != 13);
        if (!flag1 && i == -1) {
            return null;
        }
        if (i == 13) {
            bufferedreader.mark(1);
            int k = bufferedreader.read();
            if (k == 10) {
                builder.append((char)i);
            } else {
                bufferedreader.reset();
            }
        }
        return builder.toString();
    }
}

