/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.jce.implementation.digest;

import cn.ponfee.commons.math.Maths;
import cn.ponfee.commons.util.Bytes;
import java.util.Arrays;

public class SHA1Digest {
    private static final int BLOCK_SIZE = 64;
    private static final int DIGEST_SIZE = 20;
    private static final int WORK_SIZE = 80;
    private static final int PADDING_BOUNDS = 56;
    private static final int K0 = 1518500249;
    private static final int K1 = 1859775393;
    private static final int K2 = -1894007588;
    private static final int K3 = -899497514;
    private final int[] work = new int[80];
    private final byte[] block = new byte[64];
    private int H0;
    private int H1;
    private int H2;
    private int H3;
    private int H4;
    private int blockOffset;
    private long dataByteCount;

    private SHA1Digest() {
        this.reset();
    }

    private SHA1Digest(SHA1Digest d) {
        this.H0 = d.H0;
        this.H1 = d.H1;
        this.H2 = d.H2;
        this.H3 = d.H3;
        this.H4 = d.H4;
        System.arraycopy(d.block, 0, this.block, 0, 64);
        this.blockOffset = d.blockOffset;
        this.dataByteCount = d.dataByteCount;
    }

    public static SHA1Digest getInstance() {
        return new SHA1Digest();
    }

    public static SHA1Digest getInstance(SHA1Digest d) {
        return new SHA1Digest(d);
    }

    public void update(byte input) {
        this.block[this.blockOffset++] = input;
        if (this.blockOffset == 64) {
            this.digestBlock(this.block);
            this.blockOffset = 0;
            this.dataByteCount += 64L;
        }
    }

    public void update(byte[] input) {
        this.update(input, 0, input.length);
    }

    public void update(byte[] input, int offset, int length) {
        length = Math.min(input.length - offset, length);
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            this.update(input[i]);
        }
    }

    public byte[] doFinal(byte[] data) {
        this.update(data, 0, data.length);
        return this.doFinal();
    }

    public byte[] doFinal() {
        this.dataByteCount += (long)this.blockOffset;
        this.block[this.blockOffset++] = -128;
        if (this.blockOffset > 56) {
            Arrays.fill(this.block, this.blockOffset, 64, (byte)0);
            this.digestBlock(this.block);
            this.blockOffset = 0;
        }
        Arrays.fill(this.block, this.blockOffset, 56, (byte)0);
        long dataLongBitLen = this.dataByteCount << 3;
        int i = 0;
        int j = 56;
        while (i < 8) {
            this.block[56 + i] = (byte)(dataLongBitLen >>> j);
            ++i;
            j -= 8;
        }
        this.digestBlock(this.block);
        byte[] digest = new byte[20];
        Bytes.putInt(this.H0, digest, 0);
        Bytes.putInt(this.H1, digest, 4);
        Bytes.putInt(this.H2, digest, 8);
        Bytes.putInt(this.H3, digest, 12);
        Bytes.putInt(this.H4, digest, 16);
        this.reset();
        return digest;
    }

    public void reset() {
        this.H0 = 1732584193;
        this.H1 = -271733879;
        this.H2 = -1732584194;
        this.H3 = 271733878;
        this.H4 = -1009589776;
        this.blockOffset = 0;
        this.dataByteCount = 0L;
    }

    public static int getDigestSize() {
        return 20;
    }

    private void digestBlock(byte[] block) {
        int tmp;
        int t;
        int i = 0;
        int j = 0;
        while (i < 16) {
            this.work[i++] = Bytes.toInt(block, j);
            j += 4;
        }
        while (i < 80) {
            this.work[i] = Maths.rotateLeft(this.work[i - 3] ^ this.work[i - 8] ^ this.work[i - 14] ^ this.work[i - 16], 1);
            ++i;
        }
        int A = this.H0;
        int B = this.H1;
        int C = this.H2;
        int D = this.H3;
        int E2 = this.H4;
        for (t = 0; t < 20; ++t) {
            tmp = 1518500249 + SHA1Digest.f0(B, C, D) + Maths.rotateLeft(A, 5) + E2 + this.work[t];
            E2 = D;
            D = C;
            C = Maths.rotateLeft(B, 30);
            B = A;
            A = tmp;
        }
        while (t < 40) {
            tmp = 1859775393 + SHA1Digest.f1(B, C, D) + Maths.rotateLeft(A, 5) + E2 + this.work[t];
            E2 = D;
            D = C;
            C = Maths.rotateLeft(B, 30);
            B = A;
            A = tmp;
            ++t;
        }
        while (t < 60) {
            tmp = -1894007588 + SHA1Digest.f2(B, C, D) + Maths.rotateLeft(A, 5) + E2 + this.work[t];
            E2 = D;
            D = C;
            C = Maths.rotateLeft(B, 30);
            B = A;
            A = tmp;
            ++t;
        }
        while (t < 80) {
            tmp = -899497514 + SHA1Digest.f3(B, C, D) + Maths.rotateLeft(A, 5) + E2 + this.work[t];
            E2 = D;
            D = C;
            C = Maths.rotateLeft(B, 30);
            B = A;
            A = tmp;
            ++t;
        }
        this.H0 += A;
        this.H1 += B;
        this.H2 += C;
        this.H3 += D;
        this.H4 += E2;
    }

    private static int f0(int b, int c, int d) {
        return b & c | ~b & d;
    }

    private static int f1(int b, int c, int d) {
        return b ^ c ^ d;
    }

    private static int f2(int b, int c, int d) {
        return b & c | b & d | c & d;
    }

    private static int f3(int b, int c, int d) {
        return SHA1Digest.f1(b, c, d);
    }
}

