/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.jce.security;

import cn.ponfee.commons.jce.Providers;
import cn.ponfee.commons.util.ObjectUtils;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public final class DSASigner {
    private static final String ALGORITHM = "DSA";

    public static Pair<DSAPublicKey, DSAPrivateKey> initKey() {
        return DSASigner.initKey(ObjectUtils.uuid32(), 1024);
    }

    public static Pair<DSAPublicKey, DSAPrivateKey> initKey(String seed, int keySize) {
        KeyPairGenerator keygen = Providers.getKeyPairGenerator(ALGORITHM);
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.setSeed(seed.getBytes());
        keygen.initialize(keySize, secureRandom);
        KeyPair pair = keygen.genKeyPair();
        return ImmutablePair.of((Object)((DSAPublicKey)pair.getPublic()), (Object)((DSAPrivateKey)pair.getPrivate()));
    }

    public static DSAPrivateKey decodePrivateKey(byte[] privateKey) {
        KeyFactory keyFactory = Providers.getKeyFactory(ALGORITHM);
        try {
            return (DSAPrivateKey)keyFactory.generatePrivate(new PKCS8EncodedKeySpec(privateKey));
        }
        catch (InvalidKeySpecException e) {
            throw new SecurityException(e);
        }
    }

    public static DSAPublicKey decodePublicKey(byte[] publicKey) {
        KeyFactory keyFactory = Providers.getKeyFactory(ALGORITHM);
        try {
            return (DSAPublicKey)keyFactory.generatePublic(new X509EncodedKeySpec(publicKey));
        }
        catch (InvalidKeySpecException e) {
            throw new SecurityException(e);
        }
    }

    public static byte[] sign(byte[] data, byte[] privateKey) {
        return DSASigner.sign(data, DSASigner.decodePrivateKey(privateKey));
    }

    public static byte[] sign(byte[] data, DSAPrivateKey privateKey) {
        Signature signature = Providers.getSignature(privateKey.getAlgorithm());
        try {
            signature.initSign(privateKey);
            signature.update(data);
            return signature.sign();
        }
        catch (InvalidKeyException | SignatureException e) {
            throw new SecurityException(e);
        }
    }

    public static boolean verify(byte[] origin, byte[] publicKey, byte[] signed) {
        return DSASigner.verify(origin, DSASigner.decodePublicKey(publicKey), signed);
    }

    public static boolean verify(byte[] origin, DSAPublicKey publicKey, byte[] signed) {
        Signature signature = Providers.getSignature(publicKey.getAlgorithm());
        try {
            signature.initVerify(publicKey);
            signature.update(origin);
            return signature.verify(signed);
        }
        catch (InvalidKeyException | SignatureException e) {
            throw new SecurityException(e);
        }
    }
}

