/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.json;

import cn.ponfee.commons.date.JavaUtilDateFormat;
import cn.ponfee.commons.date.LocalDateTimeFormat;
import cn.ponfee.commons.json.CustomLocalDateTimeDeserializer;
import cn.ponfee.commons.json.JacksonDate;
import cn.ponfee.commons.json.JacksonMoney;
import cn.ponfee.commons.json.JsonException;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.json.JsonWriteFeature;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.StringUtils;
import org.javamoney.moneta.Money;

@ThreadSafe
public final class Jsons {
    public static final Jsons NORMAL = new Jsons(JsonInclude.Include.NON_NULL);
    public static final Jsons ALL = new Jsons(null);
    private final ObjectMapper mapper;

    private Jsons(JsonInclude.Include include) {
        this.mapper = Jsons.createObjectMapper(include);
    }

    public void write(OutputStream output, Object target) throws JsonException {
        try {
            this.mapper.writeValue(output, target);
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
    }

    public String string(Object target) throws JsonException {
        try {
            return this.mapper.writeValueAsString(target);
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
    }

    public byte[] bytes(Object target) throws JsonException {
        try {
            return this.mapper.writeValueAsBytes(target);
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
    }

    public <T> T parse(String json, JavaType javaType) throws JsonException {
        if (StringUtils.isEmpty((CharSequence)json)) {
            return null;
        }
        try {
            return (T)this.mapper.readValue(json, javaType);
        }
        catch (Exception e) {
            throw new JsonException(e);
        }
    }

    public <T> T parse(byte[] json, JavaType javaType) throws JsonException {
        if (json == null || json.length == 0) {
            return null;
        }
        try {
            return (T)this.mapper.readValue(json, javaType);
        }
        catch (Exception e) {
            throw new JsonException(e);
        }
    }

    public <T> T parse(String json, Class<T> target) throws JsonException {
        return this.parse(json, this.mapper.constructType(target));
    }

    public <T> T parse(byte[] json, Class<T> target) throws JsonException {
        return this.parse(json, this.mapper.constructType(target));
    }

    public <T> T parse(String json, Type type) throws JsonException {
        return this.parse(json, this.mapper.constructType(type));
    }

    public <T> T parse(byte[] json, Type type) throws JsonException {
        return this.parse(json, this.mapper.constructType(type));
    }

    public <T> T parse(String json, TypeReference<T> type) throws JsonException {
        return this.parse(json, this.mapper.constructType(type));
    }

    public <T> T parse(byte[] json, TypeReference<T> type) throws JsonException {
        return this.parse(json, this.mapper.constructType(type));
    }

    public static String toJson(Object target) {
        return NORMAL.string(target);
    }

    public static byte[] toBytes(Object target) {
        return NORMAL.bytes(target);
    }

    public static <T> T fromJson(String json, JavaType javaType) {
        return NORMAL.parse(json, javaType);
    }

    public static <T> T fromJson(byte[] json, JavaType javaType) {
        return NORMAL.parse(json, javaType);
    }

    public static <T> T fromJson(String json, Class<T> target) {
        return NORMAL.parse(json, target);
    }

    public static <T> T fromJson(byte[] json, Class<T> target) {
        return NORMAL.parse(json, target);
    }

    public static <T> T fromJson(String json, Type target) {
        return NORMAL.parse(json, target);
    }

    public static <T> T fromJson(byte[] json, Type target) {
        return NORMAL.parse(json, target);
    }

    public static <T> T fromJson(String json, TypeReference<T> type) {
        return NORMAL.parse(json, type);
    }

    public static <T> T fromJson(byte[] json, TypeReference<T> type) {
        return NORMAL.parse(json, type);
    }

    public static ObjectMapper createObjectMapper(JsonInclude.Include include) {
        ObjectMapper mapper = new ObjectMapper();
        if (include != null) {
            mapper.setSerializationInclusion(include);
        }
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.configure(JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN, true);
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, false);
        mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, false);
        mapper.configure(JsonWriteFeature.QUOTE_FIELD_NAMES.mappedFeature(), true);
        mapper.setTimeZone(JavaUtilDateFormat.DEFAULT.getTimeZone());
        mapper.setDateFormat((DateFormat)JavaUtilDateFormat.DEFAULT);
        SimpleModule module = new SimpleModule();
        module.addSerializer(Date.class, JacksonDate.INSTANCE.serializer());
        module.addDeserializer(Date.class, JacksonDate.INSTANCE.deserializer());
        module.addSerializer(Money.class, JacksonMoney.INSTANCE.serializer());
        module.addDeserializer(Money.class, JacksonMoney.INSTANCE.deserializer());
        mapper.registerModule((Module)module);
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("HH:mm:ss");
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(LocalDateTimeFormat.PATTERN_11));
        javaTimeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)CustomLocalDateTimeDeserializer.INSTANCE);
        javaTimeModule.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer(dateFormatter));
        javaTimeModule.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(dateFormatter));
        javaTimeModule.addSerializer(LocalTime.class, (JsonSerializer)new LocalTimeSerializer(timeFormatter));
        javaTimeModule.addDeserializer(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer(timeFormatter));
        mapper.registerModule((Module)javaTimeModule);
        return mapper;
    }
}

