/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.math;

import java.util.BitSet;
import java.util.List;
import java.util.stream.IntStream;

public class FailureRatioActuary {
    private final BitSet bitset;
    private final int size;
    private int position = 0;

    public FailureRatioActuary(int size) {
        this.size = (size + 63) / 64 * 64;
        this.bitset = new BitSet(size);
        IntStream.range(0, size).forEach(this.bitset::set);
    }

    public int size() {
        return this.size;
    }

    public void set(boolean value) {
        this.bitset.set(this.position++, value);
        if (this.position == this.size) {
            this.position = 0;
        }
    }

    public void set(Boolean value) {
        this.bitset.set(this.position++, value != null && value != false);
        if (this.position == this.size) {
            this.position = 0;
        }
    }

    public <T> double ratio(T[] array, ToBooleanFunction<T> mapper) {
        for (T val : array) {
            this.set(mapper.apply(val));
        }
        return this.ratio();
    }

    public <T> double set(List<T> array, ToBooleanFunction<T> mapper) {
        for (T val : array) {
            this.set(mapper.apply(val));
        }
        return this.ratio();
    }

    public double ratio(boolean[] array) {
        for (boolean val : array) {
            this.set(val);
        }
        return this.ratio();
    }

    public double ratio() {
        return (double)(this.size - this.bitset.cardinality()) / (double)this.size;
    }

    public String toString() {
        return "(" + this.position + ", " + this.bitset + ")";
    }

    @FunctionalInterface
    public static interface ToBooleanFunction<T> {
        public boolean apply(T var1);
    }
}

