/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.math;

import cn.ponfee.commons.base.tuple.Tuple2;
import com.google.common.base.Strings;
import com.google.common.primitives.Chars;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.util.Assert;

public final class Numbers {
    public static final int INT_ZERO = 0;
    public static final Integer INTEGER_ZERO = 0;
    public static final byte BYTE_ZERO = 0;
    public static final char CHAR_ZERO = '\u0000';
    public static final double DOUBLE_ZERO = 0.0;
    public static final double DOUBLE_ONE = 1.0;
    private static final String[] CN_UPPER_NUMBER = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
    private static final String[] CN_UPPER_MONETARY_UNIT = new String[]{"\u5206", "\u89d2", "\u5143", "\u62fe", "\u4f70", "\u4edf", "\u4e07", "\u62fe", "\u4f70", "\u4edf", "\u4ebf", "\u62fe", "\u4f70", "\u4edf", "\u5146", "\u62fe", "\u4f70", "\u4edf"};
    private static final BigDecimal MAX_VALUE = new BigDecimal("9999999999999999.995");

    public static char toChar(Object obj) {
        return Numbers.toChar(obj, '\u0000');
    }

    public static char toChar(Object obj, char defaultVal) {
        Character value = Numbers.toWrapChar(obj);
        return value == null ? defaultVal : value.charValue();
    }

    public static Character toWrapChar(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Character) {
            return (Character)obj;
        }
        if (obj instanceof Number) {
            return Character.valueOf((char)((Number)obj).intValue());
        }
        if (obj instanceof byte[]) {
            return Character.valueOf(Chars.fromByteArray((byte[])((byte[])obj)));
        }
        if (obj instanceof Boolean) {
            return Character.valueOf((char)((Boolean)obj != false ? 255 : 0));
        }
        String str = obj.toString();
        return str.length() == 1 ? Character.valueOf(str.charAt(0)) : null;
    }

    public static boolean toBoolean(Object obj) {
        return Numbers.toBoolean(obj, false);
    }

    public static boolean toBoolean(Object obj, boolean defaultVal) {
        Boolean value = Numbers.toWrapBoolean(obj);
        return value == null ? defaultVal : value;
    }

    public static Boolean toWrapBoolean(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof Number) {
            return ((Number)obj).byteValue() != 0;
        }
        return Boolean.parseBoolean(obj.toString());
    }

    public static byte toByte(Object obj) {
        return Numbers.toByte(obj, (byte)0);
    }

    public static byte toByte(Object obj, byte defaultVal) {
        if (obj instanceof Number) {
            return ((Number)obj).byteValue();
        }
        Long value = Numbers.parseLong(obj);
        return value == null ? defaultVal : value.byteValue();
    }

    public static Byte toWrapByte(Object obj) {
        if (obj instanceof Byte) {
            return (Byte)obj;
        }
        if (obj instanceof Number) {
            return ((Number)obj).byteValue();
        }
        Long value = Numbers.parseLong(obj);
        return value == null ? null : Byte.valueOf(value.byteValue());
    }

    public static short toShort(Object obj) {
        return Numbers.toShort(obj, (short)0);
    }

    public static short toShort(Object obj, short defaultVal) {
        if (obj instanceof Number) {
            return ((Number)obj).shortValue();
        }
        Long value = Numbers.parseLong(obj);
        return value == null ? defaultVal : value.shortValue();
    }

    public static Short toWrapShort(Object obj) {
        if (obj instanceof Short) {
            return (Short)obj;
        }
        if (obj instanceof Number) {
            return ((Number)obj).shortValue();
        }
        Long value = Numbers.parseLong(obj);
        return value == null ? null : Short.valueOf(value.shortValue());
    }

    public static int toInt(Object obj) {
        return Numbers.toInt(obj, 0);
    }

    public static int toInt(Object obj, int defaultVal) {
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        Long value = Numbers.parseLong(obj);
        return value == null ? defaultVal : value.intValue();
    }

    public static Integer toWrapInt(Object obj) {
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        Long value = Numbers.parseLong(obj);
        return value == null ? null : Integer.valueOf(value.intValue());
    }

    public static long toLong(Object obj) {
        return Numbers.toLong(obj, 0L);
    }

    public static long toLong(Object obj, long defaultVal) {
        if (obj instanceof Number) {
            return ((Number)obj).longValue();
        }
        Long value = Numbers.parseLong(obj);
        return value == null ? defaultVal : value;
    }

    public static Long toWrapLong(Object obj) {
        if (obj instanceof Long) {
            return (Long)obj;
        }
        if (obj instanceof Number) {
            return ((Number)obj).longValue();
        }
        return Numbers.parseLong(obj);
    }

    public static float toFloat(Object obj) {
        return Numbers.toFloat(obj, 0.0f);
    }

    public static float toFloat(Object obj, float defaultVal) {
        if (obj instanceof Number) {
            return ((Number)obj).floatValue();
        }
        Double value = Numbers.parseDouble(obj);
        return value == null ? defaultVal : value.floatValue();
    }

    public static Float toWrapFloat(Object obj) {
        if (obj instanceof Float) {
            return (Float)obj;
        }
        if (obj instanceof Number) {
            return Float.valueOf(((Number)obj).floatValue());
        }
        Double value = Numbers.parseDouble(obj);
        return value == null ? null : Float.valueOf(value.floatValue());
    }

    public static double toDouble(Object obj) {
        return Numbers.toDouble(obj, 0.0);
    }

    public static double toDouble(Object obj, double defaultVal) {
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue();
        }
        Double value = Numbers.parseDouble(obj);
        return value == null ? defaultVal : value;
    }

    public static Double toWrapDouble(Object obj) {
        if (obj instanceof Double) {
            return (Double)obj;
        }
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue();
        }
        return Numbers.parseDouble(obj);
    }

    public static double scale(Object value, int scale) {
        double val = Numbers.toDouble(value);
        if (scale < 0) {
            return val;
        }
        return BigDecimal.valueOf(val).setScale(scale, RoundingMode.HALF_UP).doubleValue();
    }

    public static double lower(double value, int pow) {
        return BigDecimal.valueOf(value / Math.pow(10.0, pow)).doubleValue();
    }

    public static double lower(double value, int pow, int scale) {
        return BigDecimal.valueOf(value / Math.pow(10.0, pow)).setScale(scale, RoundingMode.HALF_UP).doubleValue();
    }

    public static double upper(double value, int pow) {
        return BigDecimal.valueOf(value * Math.pow(10.0, pow)).doubleValue();
    }

    public static double upper(double value, int pow, int scale) {
        return BigDecimal.valueOf(value * Math.pow(10.0, pow)).setScale(scale, RoundingMode.HALF_UP).doubleValue();
    }

    public static String percent(double numerator, double denominator, int scale) {
        if (denominator == 0.0) {
            return "--";
        }
        return Numbers.percent(numerator / denominator, scale);
    }

    public static String percent(double value, int scale) {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            return "--";
        }
        String format = "#,##0";
        if (scale > 0) {
            format = format + "." + Strings.repeat((String)"0", (int)scale);
        }
        return new DecimalFormat(format + "%").format(value);
    }

    public static String format(Object obj) {
        return Numbers.format(obj, "###,###.###");
    }

    public static String format(Object obj, String format) {
        DecimalFormat fmt = new DecimalFormat(format);
        if (obj instanceof CharSequence) {
            String str = obj.toString().replace(",", "");
            if (str.endsWith("%")) {
                str = str.substring(0, str.length() - 1);
                return fmt.format(Double.parseDouble(str)) + "%";
            }
            return fmt.format(Double.parseDouble(str));
        }
        return fmt.format(obj);
    }

    public static String format(double d, int scale) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(scale);
        nf.setGroupingUsed(false);
        return nf.format(d);
    }

    public static int bounds(Integer value, int min, int max) {
        if (value == null || value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static int sum(Integer a, Integer b) {
        return (Integer)ObjectUtils.defaultIfNull((Object)a, (Object)0) + (Integer)ObjectUtils.defaultIfNull((Object)b, (Object)0);
    }

    public static long sum(Long a, Long b) {
        return (Long)ObjectUtils.defaultIfNull((Object)a, (Object)0L) + (Long)ObjectUtils.defaultIfNull((Object)b, (Object)0L);
    }

    public static double sum(Double a, Double b) {
        return (Double)ObjectUtils.defaultIfNull((Object)a, (Object)0.0) + (Double)ObjectUtils.defaultIfNull((Object)b, (Object)0.0);
    }

    public static int[] slice(int quantity, int segment) {
        int[] result = new int[segment];
        int quotient = quantity / segment;
        int remainder = quantity % segment;
        int moreValue = quotient + 1;
        Arrays.fill(result, 0, remainder, moreValue);
        Arrays.fill(result, remainder, segment, quotient);
        return result;
    }

    public static List<Tuple2<Integer, Integer>> partition(int number, int size) {
        Assert.isTrue((number >= 0 ? 1 : 0) != 0, (String)"Number must be greater than 0.");
        Assert.isTrue((size > 0 ? 1 : 0) != 0, (String)"Size must be greater than 0.");
        if (number == 0) {
            return Collections.singletonList(Tuple2.of(0, 0));
        }
        ArrayList<Tuple2<Integer, Integer>> result = new ArrayList<Tuple2<Integer, Integer>>(size);
        int last = -1;
        for (int a : Numbers.slice(number, size)) {
            if (a == 0) break;
            result.add(Tuple2.of(++last, last += a - 1));
        }
        return result;
    }

    public static int[] split(int[] bills, int value) {
        int i;
        int total = IntStream.of(bills).sum();
        if (total < value) {
            throw new IllegalArgumentException("Total bill amount[" + total + "] cannot less than coupon amount[" + value + "]");
        }
        int[] result = new int[bills.length];
        if (bills.length == 0 || value == 0) {
            return result;
        }
        int n = bills.length - 1;
        for (i = 0; i < n; ++i) {
            float rate = (float)value / (float)total;
            result[i] = Math.min((int)Math.ceil((float)bills[i] * rate), value);
            total -= bills[i];
            if ((value -= result[i]) == 0) break;
        }
        if (i == n) {
            result[i] = value;
        }
        return result;
    }

    public static boolean equals(Long a, Integer b) {
        if (a == null && b == null) {
            return true;
        }
        return a != null && b != null && a == (long)b.intValue();
    }

    public static String toHex(BigInteger num) {
        String hex = Hex.encodeHexString((byte[])num.toByteArray(), (boolean)false);
        if (hex.matches("^0+$")) {
            return "0";
        }
        return hex.replaceFirst("^0*", "");
    }

    public static String chinesize(BigDecimal amount) {
        int numIndex;
        if (amount.compareTo(MAX_VALUE) >= 0) {
            throw new IllegalArgumentException("The amount value too large.");
        }
        int signum = amount.signum();
        if (signum == 0) {
            return "\u96f6\u5143\u6574";
        }
        long number = amount.movePointRight(2).setScale(0, RoundingMode.HALF_UP).abs().longValue();
        int scale = (int)(number % 100L);
        if (scale == 0) {
            numIndex = 2;
            number /= 100L;
        } else if (scale % 10 == 0) {
            numIndex = 1;
            number /= 10L;
        } else {
            numIndex = 0;
        }
        boolean getZero = numIndex != 0;
        StringBuilder builder = new StringBuilder();
        int zeroSize = 0;
        while (number > 0L) {
            int numUnit = (int)(number % 10L);
            if (numUnit > 0) {
                if (numIndex == 9 && zeroSize >= 3) {
                    builder.insert(0, CN_UPPER_MONETARY_UNIT[6]);
                }
                if (numIndex == 13 && zeroSize >= 3) {
                    builder.insert(0, CN_UPPER_MONETARY_UNIT[10]);
                }
                builder.insert(0, CN_UPPER_MONETARY_UNIT[numIndex]);
                builder.insert(0, CN_UPPER_NUMBER[numUnit]);
                getZero = false;
                zeroSize = 0;
            } else {
                ++zeroSize;
                if (!getZero) {
                    builder.insert(0, CN_UPPER_NUMBER[numUnit]);
                }
                if (numIndex == 2) {
                    if (number > 0L) {
                        builder.insert(0, CN_UPPER_MONETARY_UNIT[numIndex]);
                    }
                } else if ((numIndex - 2 & 3) == 0 && number % 1000L > 0L) {
                    builder.insert(0, CN_UPPER_MONETARY_UNIT[numIndex]);
                }
                getZero = true;
            }
            number /= 10L;
            ++numIndex;
        }
        if (signum == -1) {
            builder.insert(0, "\u8d1f");
        }
        if (scale == 0) {
            builder.append("\u6574");
        }
        return builder.toString();
    }

    private static Long parseLong(Object obj) {
        if (obj == null) {
            return null;
        }
        try {
            String val = obj.toString();
            return val.indexOf(46) == -1 ? Long.parseLong(val) : (long)Double.parseDouble(val);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    private static Double parseDouble(Object obj) {
        if (obj == null) {
            return null;
        }
        try {
            return Double.parseDouble(obj.toString());
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }
}

