/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.resource;

import cn.ponfee.commons.io.Closeables;
import cn.ponfee.commons.resource.Resource;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ClassPathResourceLoader {
    private static final String URL_PROTOCOL_FILE = "file";
    private static final String URL_PROTOCOL_JAR = "jar";
    private static final String URL_PROTOCOL_ZIP = "zip";
    private static final String JAR_URL_SEPARATOR = "!/";
    private static final Logger LOG = LoggerFactory.getLogger(ClassPathResourceLoader.class);

    ClassPathResourceLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Resource getResource(String filePath, Class<?> contextClass, String encoding) {
        Resource resource;
        ZipFile zip;
        JarFile jar;
        block26: {
            Resource resource2;
            block25: {
                Resource resource3;
                block24: {
                    jar = null;
                    zip = null;
                    try {
                        URL url;
                        Enumeration<URL> urls = contextClass != null ? contextClass.getClassLoader().getResources(filePath) : Thread.currentThread().getContextClassLoader().getResources(filePath);
                        block18: while (urls.hasMoreElements()) {
                            url = urls.nextElement();
                            switch (url.getProtocol()) {
                                case "file": {
                                    String path = URLDecoder.decode(url.getFile(), encoding);
                                    if (ClassPathResourceLoader.checkWithoutClass(contextClass, path.substring(0, path.length() - filePath.length()), encoding)) continue block18;
                                    resource3 = new Resource(path, new File(path).getName(), new FileInputStream(path));
                                    Closeables.console(jar);
                                    break block24;
                                }
                                case "jar": {
                                    jar = ((JarURLConnection)url.openConnection()).getJarFile();
                                    if (ClassPathResourceLoader.checkWithoutClass(contextClass, jar.getName(), encoding)) continue block18;
                                    Enumeration<JarEntry> entries = jar.entries();
                                    while (entries.hasMoreElements()) {
                                        JarEntry entry = entries.nextElement();
                                        if (!filePath.equals(entry.getName())) continue;
                                        String fileName = entry.getName();
                                        if ((fileName = fileName.replace("\\", "/")).contains("/")) {
                                            fileName = fileName.substring(fileName.lastIndexOf("/") + 1);
                                        }
                                        resource2 = new Resource(URLDecoder.decode(url.getFile(), encoding), fileName, ClassPathResourceLoader.transform(jar.getInputStream(entry)));
                                        Closeables.console(jar);
                                        break block25;
                                    }
                                    jar.close();
                                    jar = null;
                                    continue block18;
                                }
                                case "zip": {
                                    String zipPath = URLDecoder.decode(url.getFile(), encoding);
                                    if (zipPath.startsWith("file:")) {
                                        zipPath = zipPath.substring("file:".length());
                                    }
                                    if (!zipPath.contains(JAR_URL_SEPARATOR) || ClassPathResourceLoader.checkWithoutClass(contextClass, zipPath = zipPath.substring(0, zipPath.lastIndexOf(JAR_URL_SEPARATOR)), encoding)) continue block18;
                                    zip = new ZipFile(zipPath);
                                    Enumeration<? extends ZipEntry> entries0 = zip.entries();
                                    while (entries0.hasMoreElements()) {
                                        ZipEntry entry = entries0.nextElement();
                                        if (!filePath.equals(entry.getName())) continue;
                                        String fileName = entry.getName();
                                        if ((fileName = fileName.replace("\\", "/")).contains("/")) {
                                            fileName = fileName.substring(fileName.lastIndexOf("/") + 1);
                                        }
                                        resource = new Resource(URLDecoder.decode(url.getFile(), encoding), fileName, ClassPathResourceLoader.transform(zip.getInputStream(entry)));
                                        Closeables.console(jar);
                                        break block26;
                                    }
                                    zip.close();
                                    zip = null;
                                    continue block18;
                                }
                                default: {
                                    throw new UnsupportedOperationException("Unsupported protocol: " + url.getProtocol());
                                }
                            }
                        }
                        url = null;
                        return url;
                    }
                    catch (IOException e) {
                        LOG.error("load resource from jar file occur error", (Throwable)e);
                        String string = null;
                        return string;
                    }
                }
                Closeables.console(zip);
                return resource3;
            }
            Closeables.console(zip);
            return resource2;
        }
        Closeables.console(zip);
        return resource;
        finally {
            Closeables.console(jar);
            Closeables.console(zip);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Resource> listResources(String directory, String[] extensions, boolean recursive, Class<?> contextClass, String encoding) {
        ArrayList<Resource> list = new ArrayList<Resource>();
        JarFile jar = null;
        ZipFile zip = null;
        try {
            Serializable url;
            Enumeration<URL> dirs = contextClass != null ? contextClass.getClassLoader().getResources(directory) : Thread.currentThread().getContextClassLoader().getResources(directory);
            block15: while (dirs.hasMoreElements()) {
                url = dirs.nextElement();
                switch (((URL)url).getProtocol()) {
                    case "file": {
                        Collection files;
                        String path = URLDecoder.decode(((URL)url).getFile(), encoding);
                        if (ClassPathResourceLoader.checkWithoutClass(contextClass, path.substring(0, path.length() - directory.length()), encoding) || (files = FileUtils.listFiles((File)new File(path), (String[])extensions, (boolean)recursive)) == null || files.isEmpty()) continue block15;
                        for (File file : files) {
                            list.add(new Resource(file.getAbsolutePath(), file.getName(), new FileInputStream(file)));
                        }
                        continue block15;
                    }
                    case "jar": {
                        jar = ((JarURLConnection)((URL)url).openConnection()).getJarFile();
                        if (ClassPathResourceLoader.checkWithoutClass(contextClass, jar.getName(), encoding)) continue block15;
                        Enumeration<JarEntry> entries = jar.entries();
                        while (entries.hasMoreElements()) {
                            boolean isSufx;
                            JarEntry entry = entries.nextElement();
                            if (entry.isDirectory()) continue;
                            String name = entry.getName();
                            int idx = name.lastIndexOf(47);
                            boolean isDir = idx != -1 && name.substring(0, idx).equals(directory) || recursive && name.startsWith(directory);
                            boolean bl = isSufx = ArrayUtils.isEmpty((Object[])extensions) || name.toLowerCase().matches("^(.+\\.)(" + StringUtils.join((Object[])extensions, (String)"|") + ")$");
                            if (!isDir || !isSufx) continue;
                            list.add(new Resource(URLDecoder.decode(((URL)url).getFile(), encoding), entry.getName(), ClassPathResourceLoader.transform(jar.getInputStream(entry))));
                        }
                        jar.close();
                        jar = null;
                        break;
                    }
                    case "zip": {
                        String zipPath = URLDecoder.decode(((URL)url).getFile(), encoding);
                        if (zipPath.startsWith("file:")) {
                            zipPath = zipPath.substring("file:".length());
                        }
                        if (!zipPath.contains(JAR_URL_SEPARATOR) || ClassPathResourceLoader.checkWithoutClass(contextClass, zipPath = zipPath.substring(0, zipPath.lastIndexOf(JAR_URL_SEPARATOR)), encoding)) continue block15;
                        zip = new ZipFile(zipPath);
                        Enumeration<? extends ZipEntry> entries0 = zip.entries();
                        while (entries0.hasMoreElements()) {
                            boolean isSuffix;
                            ZipEntry entry = entries0.nextElement();
                            String name = entry.getName();
                            int idx = name.lastIndexOf(47);
                            boolean isDir = idx != -1 && name.substring(0, idx).equals(directory) || recursive && name.startsWith(directory);
                            boolean bl = isSuffix = ArrayUtils.isEmpty((Object[])extensions) || name.toLowerCase().matches("^(.+\\.)(" + StringUtils.join((Object[])extensions, (String)"|") + ")$");
                            if (!isDir || !isSuffix) continue;
                            list.add(new Resource(URLDecoder.decode(((URL)url).getFile(), encoding), entry.getName(), ClassPathResourceLoader.transform(zip.getInputStream(entry))));
                        }
                        zip.close();
                        zip = null;
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("un supported process " + ((URL)url).getProtocol());
                    }
                }
            }
            url = list;
            return url;
        }
        catch (IOException e) {
            LOG.error("load resource from jar file occur error", (Throwable)e);
            ArrayList<Resource> arrayList = list;
            return arrayList;
        }
        finally {
            Closeables.console(jar);
            Closeables.console(zip);
        }
    }

    private static boolean checkWithoutClass(Class<?> contextClass, String filepath, String encoding) throws IOException {
        if (contextClass == null) {
            return false;
        }
        String destPath = contextClass.getProtectionDomain().getCodeSource().getLocation().getFile();
        return !new File(destPath = URLDecoder.decode(destPath, encoding)).getCanonicalFile().equals(new File(filepath).getCanonicalFile());
    }

    private static ByteArrayInputStream transform(InputStream input) throws IOException {
        if (input instanceof ByteArrayInputStream) {
            return (ByteArrayInputStream)input;
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(IOUtils.toByteArray((InputStream)input));
            return byteArrayInputStream;
        }
        finally {
            Closeables.console(input);
        }
    }
}

