/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.resource;

import cn.ponfee.commons.resource.Resource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FileSystemResourceLoader {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemResourceLoader.class);

    FileSystemResourceLoader() {
    }

    Resource getResource(String filePath, String encoding) {
        try {
            File f = new File(filePath);
            return new Resource(f.getAbsolutePath(), f.getName(), new FileInputStream(f));
        }
        catch (FileNotFoundException e) {
            LOG.error("file not found: " + filePath, (Throwable)e);
            return null;
        }
    }

    List<Resource> listResources(String directory, String[] extensions, boolean recursive) {
        ArrayList<Resource> list = new ArrayList<Resource>();
        try {
            File fileDir = new File(directory);
            Collection files = FileUtils.listFiles((File)fileDir, (String[])extensions, (boolean)recursive);
            if (files != null && !files.isEmpty()) {
                for (File f : files) {
                    list.add(new Resource(f.getAbsolutePath(), f.getName(), new FileInputStream(f)));
                }
            }
        }
        catch (FileNotFoundException e) {
            LOG.error("file not found: " + directory, (Throwable)e);
        }
        return list;
    }
}

