/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.schema.json;

import cn.ponfee.commons.collect.Collects;
import cn.ponfee.commons.json.Jsons;
import cn.ponfee.commons.model.Null;
import cn.ponfee.commons.model.ToJsonString;
import cn.ponfee.commons.schema.DataType;
import cn.ponfee.commons.schema.json.JsonId;
import cn.ponfee.commons.tree.NodePath;
import cn.ponfee.commons.tree.TreeNode;
import cn.ponfee.commons.tree.TreeTrait;
import com.alibaba.fastjson.annotation.JSONField;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class JsonTree
extends ToJsonString
implements Serializable,
Comparable<JsonTree>,
TreeTrait<JsonId, Null, JsonTree> {
    private static final long serialVersionUID = 2185766536906561848L;
    @JSONField(deserializeUsing=NodePath.FastjsonDeserializer.class)
    private NodePath<String> path;
    private String name;
    private int orders;
    private boolean checked;
    private DataType type;
    private List<JsonTree> children;

    @Override
    public int compareTo(JsonTree o) {
        return this.path.compareTo(o.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof JsonTree)) {
            return false;
        }
        JsonTree other = (JsonTree)obj;
        if (!this.path.equals(other.path)) {
            return false;
        }
        if (CollectionUtils.isEmpty(this.children) && CollectionUtils.isEmpty(other.children)) {
            return true;
        }
        if (CollectionUtils.isEmpty(this.children) || CollectionUtils.isEmpty(other.children) || this.children.size() != other.children.size()) {
            return false;
        }
        try {
            this.sortByName();
            other.sortByName();
            int n = this.children.size();
            for (int i = 0; i < n; ++i) {
                if (this.children.get(i).equals(other.children.get(i))) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.sortByOrders();
            other.sortByOrders();
        }
    }

    @Override
    public String toString() {
        return Jsons.toJson(this);
    }

    @Override
    public void setChildren(List<JsonTree> children) {
        List<String> duplicated;
        if (CollectionUtils.isNotEmpty(children) && CollectionUtils.isNotEmpty(duplicated = Collects.duplicate(children, JsonTree::getName))) {
            throw new IllegalStateException("Duplicated child name " + duplicated);
        }
        this.children = children;
    }

    public void sortByOrders() {
        this.sortChildren(Comparator.comparing(JsonTree::getOrders));
    }

    public void sortByName() {
        this.sortChildren(Comparator.comparing(JsonTree::getName));
    }

    public void sortChildren(Comparator<JsonTree> comparator) {
        if (CollectionUtils.isNotEmpty(this.children)) {
            this.children.sort(comparator);
            for (JsonTree node : this.children) {
                node.sortChildren(comparator);
            }
        }
    }

    public Map<NodePath<String>, JsonTree> toFlatMap() {
        HashMap<NodePath<String>, JsonTree> map = new HashMap<NodePath<String>, JsonTree>();
        this.toFlatMap(map);
        return map;
    }

    public static JsonTree convert(TreeNode<JsonId, Null> tree) {
        JsonId id = (JsonId)tree.getNid();
        JsonTree jt = new JsonTree();
        jt.setName(id.getName());
        jt.setOrders(id.getOrders());
        jt.setChecked(false);
        jt.setType(id.getType());
        jt.setPath(new NodePath<String>(tree.getPath().stream().map(JsonId::getName).collect(Collectors.toList())));
        return jt;
    }

    public static boolean hasChoose(JsonTree root) {
        if (root == null) {
            return false;
        }
        JsonTree.checkChoose(root);
        return root.checked;
    }

    public NodePath<String> getPath() {
        return this.path;
    }

    public void setPath(NodePath<String> path) {
        this.path = path;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getOrders() {
        return this.orders;
    }

    public void setOrders(int orders) {
        this.orders = orders;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }

    @Override
    public List<JsonTree> getChildren() {
        return this.children;
    }

    public DataType getType() {
        return this.type;
    }

    public void setType(DataType type) {
        this.type = type;
    }

    private static boolean checkChoose(JsonTree node) {
        if (CollectionUtils.isEmpty(node.children)) {
            return node.checked;
        }
        boolean hasLeafChildChoose = false;
        for (JsonTree child : node.children) {
            if (child.checked && !node.checked) {
                throw new IllegalStateException("Child is checked but parent is unchecked: " + child.path.toString());
            }
            if (CollectionUtils.isEmpty(child.children)) {
                if (child.checked && "[--]".equals(child.name)) {
                    throw new IllegalStateException("Empty array cannot be checked: " + child.path.toString());
                }
                hasLeafChildChoose |= child.checked;
                continue;
            }
            hasLeafChildChoose |= JsonTree.checkChoose(child);
        }
        if (node.checked && !hasLeafChildChoose) {
            throw new IllegalStateException("Parent is checked but not checked children: " + node.path.toString());
        }
        return hasLeafChildChoose;
    }

    private void toFlatMap(Map<NodePath<String>, JsonTree> map) {
        map.put(this.getPath(), this);
        if (CollectionUtils.isNotEmpty(this.children)) {
            for (JsonTree node : this.children) {
                node.toFlatMap(map);
            }
        }
    }
}

