/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.serial;

import cn.ponfee.commons.io.GzipProcessor;
import cn.ponfee.commons.serial.Serializer;
import org.apache.commons.lang3.ClassUtils;
import org.nustaq.serialization.FSTConfiguration;

public class FstSerializer
extends Serializer {
    private static final ThreadLocal<FSTConfiguration> FST_CFG = ThreadLocal.withInitial(FSTConfiguration::createStructConfiguration);

    protected byte[] serialize0(Object obj, boolean compress) {
        byte[] bytes = FST_CFG.get().asByteArray(obj);
        return compress ? GzipProcessor.compress(bytes) : bytes;
    }

    @Override
    protected <T> T deserialize0(byte[] bytes, Class<T> clazz, boolean compress) {
        Object obj;
        if (compress) {
            bytes = GzipProcessor.decompress(bytes);
        }
        if ((obj = FST_CFG.get().asObject(bytes)) != null && !ClassUtils.isAssignable(obj.getClass(), clazz)) {
            throw new ClassCastException(ClassUtils.getName(obj.getClass()) + " can't be cast to " + ClassUtils.getName(clazz));
        }
        return (T)obj;
    }
}

