/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.serial;

import cn.ponfee.commons.io.Closeables;
import cn.ponfee.commons.io.ExtendedGZIPOutputStream;
import cn.ponfee.commons.serial.SerializationException;
import cn.ponfee.commons.serial.Serializer;
import com.caucho.hessian.io.HessianSerializerInput;
import com.caucho.hessian.io.HessianSerializerOutput;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HessianSerializer
extends Serializer {
    private static final Logger LOG = LoggerFactory.getLogger(HessianSerializer.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected byte[] serialize0(Object obj, boolean compress) {
        byte[] byArray;
        ExtendedGZIPOutputStream gzout;
        block12: {
            gzout = null;
            HessianSerializerOutput hessian = null;
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
                if (compress) {
                    gzout = new ExtendedGZIPOutputStream(baos);
                    hessian = new HessianSerializerOutput((OutputStream)gzout);
                } else {
                    hessian = new HessianSerializerOutput((OutputStream)baos);
                }
                hessian.writeObject(obj);
                hessian.close();
                hessian = null;
                if (gzout != null) {
                    gzout.close();
                    gzout = null;
                }
                byArray = baos.toByteArray();
                if (hessian == null) break block12;
            }
            catch (IOException e) {
                try {
                    throw new SerializationException(e);
                }
                catch (Throwable throwable) {
                    if (hessian != null) {
                        try {
                            hessian.close();
                        }
                        catch (IOException e2) {
                            LOG.error("close hessian exception", (Throwable)e2);
                        }
                    }
                    Closeables.log(gzout, "close GZIPOutputStream exception");
                    throw throwable;
                }
            }
            try {
                hessian.close();
            }
            catch (IOException e) {
                LOG.error("close hessian exception", (Throwable)e);
            }
        }
        Closeables.log(gzout, "close GZIPOutputStream exception");
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected <T> T deserialize0(byte[] bytes, Class<T> clazz, boolean compress) {
        Object object;
        GZIPInputStream gzin;
        block12: {
            gzin = null;
            HessianSerializerInput hessian = null;
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                if (compress) {
                    gzin = new GZIPInputStream(bais);
                    hessian = new HessianSerializerInput((InputStream)gzin);
                } else {
                    hessian = new HessianSerializerInput((InputStream)bais);
                }
                Object t = hessian.readObject();
                if (t != null && !ClassUtils.isAssignable(t.getClass(), clazz)) {
                    throw new ClassCastException(ClassUtils.getName(t.getClass()) + " can't be cast to " + ClassUtils.getName(clazz));
                }
                object = t;
                if (hessian == null) break block12;
            }
            catch (IOException e) {
                try {
                    throw new SerializationException(e);
                }
                catch (Throwable throwable) {
                    if (hessian != null) {
                        try {
                            hessian.close();
                        }
                        catch (Exception e2) {
                            LOG.error("close hessian exception", (Throwable)e2);
                        }
                    }
                    Closeables.log(gzin, "close GZIPInputStream exception");
                    throw throwable;
                }
            }
            try {
                hessian.close();
            }
            catch (Exception e) {
                LOG.error("close hessian exception", (Throwable)e);
            }
        }
        Closeables.log(gzin, "close GZIPInputStream exception");
        return (T)object;
    }
}

