/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.serial;

import cn.ponfee.commons.io.Closeables;
import cn.ponfee.commons.io.ExtendedGZIPOutputStream;
import cn.ponfee.commons.serial.SerializationException;
import cn.ponfee.commons.serial.Serializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.ByteBufferInput;
import com.esotericsoftware.kryo.io.ByteBufferOutput;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.util.Pool;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KryoSerializer
extends Serializer {
    private static final Logger LOG = LoggerFactory.getLogger(KryoSerializer.class);
    public static final KryoSerializer INSTANCE = new KryoSerializer();
    private static final Pool<Kryo> KRYO_POOL = new Pool<Kryo>(true, false, 32){

        protected Kryo create() {
            Kryo kryo = new Kryo();
            kryo.setRegistrationRequired(false);
            return kryo;
        }
    };

    protected byte[] serialize0(Object obj, boolean compress) {
        byte[] byArray;
        ExtendedGZIPOutputStream gzout = null;
        ByteBufferOutput output = null;
        Kryo kryo = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
            if (compress) {
                gzout = new ExtendedGZIPOutputStream(baos);
                output = new ByteBufferOutput((OutputStream)gzout, 8192);
            } else {
                output = new ByteBufferOutput((OutputStream)baos, 8192);
            }
            kryo = this.obtain();
            kryo.writeObject((Output)output, obj);
            output.close();
            output = null;
            if (gzout != null) {
                gzout.close();
                gzout = null;
            }
            byArray = baos.toByteArray();
            this.free(kryo);
        }
        catch (IOException e) {
            try {
                throw new SerializationException(e);
            }
            catch (Throwable throwable) {
                this.free(kryo);
                Closeables.log(output, "close Output exception");
                Closeables.log(gzout, "close GZIPOutputStream exception");
                throw throwable;
            }
        }
        Closeables.log((AutoCloseable)output, "close Output exception");
        Closeables.log(gzout, "close GZIPOutputStream exception");
        return byArray;
    }

    @Override
    protected <T> T deserialize0(byte[] bytes, Class<T> clazz, boolean compress) {
        Object object;
        GZIPInputStream gzin = null;
        ByteBufferInput input = null;
        Kryo kryo = null;
        try {
            if (compress) {
                gzin = new GZIPInputStream(new ByteArrayInputStream(bytes));
                input = new ByteBufferInput((InputStream)gzin);
            } else {
                input = new ByteBufferInput(bytes);
            }
            kryo = this.obtain();
            object = kryo.readObject((Input)input, clazz);
            this.free(kryo);
        }
        catch (IOException e) {
            try {
                throw new SerializationException(e);
            }
            catch (Throwable throwable) {
                this.free(kryo);
                Closeables.log((AutoCloseable)input, "close Input exception");
                Closeables.log(gzin, "close GZIPInputStream exception");
                throw throwable;
            }
        }
        Closeables.log((AutoCloseable)input, "close Input exception");
        Closeables.log(gzin, "close GZIPInputStream exception");
        return (T)object;
    }

    private Kryo obtain() {
        return (Kryo)KRYO_POOL.obtain();
    }

    private void free(Kryo kryo) {
        if (kryo == null) {
            return;
        }
        try {
            KRYO_POOL.free((Object)kryo);
        }
        catch (Throwable t) {
            LOG.error("release kryo occur error", t);
        }
    }
}

