/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.tree;

import cn.ponfee.commons.tree.BaseNode;
import cn.ponfee.commons.tree.TreeNode;
import java.io.Serializable;
import java.util.function.Function;
import org.apache.commons.collections4.CollectionUtils;

public final class FlatNode<T extends Serializable & Comparable<? super T>, A extends Serializable>
extends BaseNode<T, A> {
    private static final long serialVersionUID = 5191371614061952661L;
    private final boolean leaf;

    FlatNode(TreeNode<T, A> n) {
        super(n.nid, n.pid, n.enabled, n.available, n.attach);
        this.level = n.level;
        this.degree = n.degree;
        this.path = n.path;
        this.leftLeafCount = n.leftLeafCount;
        this.treeDepth = n.treeDepth;
        this.treeNodeCount = n.treeNodeCount;
        this.treeMaxDegree = n.treeMaxDegree;
        this.treeLeafCount = n.treeLeafCount;
        this.childrenCount = n.childrenCount;
        this.siblingOrder = n.siblingOrder;
        this.leaf = CollectionUtils.isEmpty(n.getChildren());
    }

    public <R> R convert(Function<FlatNode<T, A>, R> convertor) {
        return convertor.apply(this);
    }

    public boolean isLeaf() {
        return this.leaf;
    }
}

