/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.tree;

import cn.ponfee.commons.tree.BaseNode;
import cn.ponfee.commons.tree.TreeNode;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;

public final class TreeNodeBuilder<T extends Serializable & Comparable<? super T>, A extends Serializable> {
    private final T nid;
    private final Comparator<? super TreeNode<T, A>> siblingNodeSort;
    private T pid = null;
    private boolean enabled = true;
    private boolean available = true;
    private A attach = null;
    private boolean buildPath = true;

    private TreeNodeBuilder(T nid, Comparator<? super TreeNode<T, A>> siblingNodeSort) {
        this.nid = (Serializable)Objects.requireNonNull(nid);
        this.siblingNodeSort = Objects.requireNonNull(siblingNodeSort);
    }

    public static <T extends Serializable & Comparable<? super T>, A extends Serializable> TreeNodeBuilder<T, A> newBuilder(T nid) {
        return TreeNodeBuilder.newBuilder(nid, Comparator.comparing(BaseNode::getNid));
    }

    public static <T extends Serializable & Comparable<? super T>, A extends Serializable> TreeNodeBuilder<T, A> newBuilder(T nid, Comparator<? super TreeNode<T, A>> siblingNodeSort) {
        return new TreeNodeBuilder<T, A>(nid, siblingNodeSort);
    }

    public TreeNodeBuilder<T, A> pid(T pid) {
        this.pid = pid;
        return this;
    }

    public TreeNodeBuilder<T, A> enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public TreeNodeBuilder<T, A> available(boolean available) {
        this.available = available;
        return this;
    }

    public TreeNodeBuilder<T, A> attach(A attach) {
        this.attach = attach;
        return this;
    }

    public TreeNodeBuilder<T, A> buildPath(boolean buildPath) {
        this.buildPath = buildPath;
        return this;
    }

    public TreeNode<T, A> build() {
        return new TreeNode<T, A>(this.nid, this.pid, this.enabled, this.available, this.attach, this.siblingNodeSort, this.buildPath, true);
    }
}

