/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.util;

import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

public class Asserts
extends Assert {
    public static void notEmpty(String text, String msg) {
        if (StringUtils.isEmpty((CharSequence)text)) {
            throw new IllegalArgumentException(msg);
        }
    }

    public static void notBlank(String text, String msg) {
        if (StringUtils.isBlank((CharSequence)text)) {
            throw new IllegalArgumentException(msg);
        }
    }

    public static void minLen(String text, int min, String msg) {
        if (text != null && text.length() < min) {
            throw new IllegalArgumentException(msg);
        }
    }

    public static void maxLen(String text, int max, String msg) {
        if (text != null && text.length() > max) {
            throw new IllegalArgumentException(msg);
        }
    }

    public static void range(int value, int min, int max, String msg) {
        if (value < min || value > max) {
            throw new IllegalArgumentException(msg);
        }
    }

    public static void rangeLen(String text, int min, int max, String msg) {
        if (text == null) {
            return;
        }
        Asserts.range(text.length(), min, max, msg);
    }
}

