/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.util;

import cn.ponfee.commons.util.SecureRandoms;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ThreadLocalRandom;
import javax.imageio.ImageIO;

public class Captchas {
    private static final char[] CODES = "23456789ABCDEFGHJKLMNPQRSTUVWXYZ".toCharArray();
    private static final Color[] COLOR_SPACES = new Color[]{Color.RED, Color.GRAY, Color.YELLOW, Color.WHITE, Color.GREEN, Color.CYAN, Color.PINK, Color.BLUE, Color.MAGENTA, Color.ORANGE, Color.LIGHT_GRAY};

    public static String random(int size) {
        return Captchas.random(size, CODES);
    }

    public static String random(int size, char[] sources) {
        if (sources == null || sources.length == 0) {
            sources = CODES;
        }
        StringBuilder codes = new StringBuilder(size);
        int length = sources.length;
        for (int i = 0; i < size; ++i) {
            codes.append(sources[SecureRandoms.nextInt(length)]);
        }
        return codes.toString();
    }

    public static void generate(int width, OutputStream out, String code) {
        Captchas.generate(width, (int)Math.ceil((double)width * 0.618), out, code);
    }

    public static void generate(int width, int height, OutputStream out, String code) {
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics2D g2 = image.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color[] colors = new Color[5];
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = COLOR_SPACES[ThreadLocalRandom.current().nextInt(COLOR_SPACES.length)];
        }
        g2.setColor(Color.GRAY);
        g2.fillRect(0, 0, width, height);
        Color c = Captchas.getRandColor(200, 250);
        g2.setColor(c);
        g2.fillRect(0, 2, width, height - 4);
        g2.setColor(Captchas.getRandColor(160, 200));
        for (int i = 0; i < 15; ++i) {
            int x = ThreadLocalRandom.current().nextInt(width - 1);
            int y = ThreadLocalRandom.current().nextInt(height - 1);
            int xl = ThreadLocalRandom.current().nextInt(6) + 1;
            int yl = ThreadLocalRandom.current().nextInt(12) + 1;
            g2.drawLine(x, y, x + xl + 40, y + yl + 20);
        }
        float yawpRate = 0.03f;
        int area = (int)(yawpRate * (float)width * (float)height);
        for (int i = 0; i < area; ++i) {
            int x = ThreadLocalRandom.current().nextInt(width);
            int y = ThreadLocalRandom.current().nextInt(height);
            int rgb = Captchas.getRandomIntColor();
            image.setRGB(x, y, rgb);
        }
        Captchas.shear(g2, width, height, c);
        g2.setColor(Captchas.getRandColor(100, 160));
        int fontSize = height - 14;
        g2.setFont(new Font("Algerian", 2, fontSize));
        char[] chars = code.toCharArray();
        int size = code.length();
        for (int i = 0; i < size; ++i) {
            AffineTransform affine = new AffineTransform();
            int signum = ThreadLocalRandom.current().nextBoolean() ? 1 : -1;
            affine.setToRotation(0.7853981633974483 * ThreadLocalRandom.current().nextDouble() * (double)signum, width / size * i + fontSize / 2, height / 2);
            g2.setTransform(affine);
            int x = 1;
            int y = 4;
            g2.drawChars(chars, i, 1, (width - 7) / size * i + x, height / 2 + fontSize / 2 - y);
        }
        g2.dispose();
        try {
            ImageIO.write((RenderedImage)image, "JPEG", out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Color getRandColor(int fc, int bc) {
        fc = Math.min(fc, 255);
        bc = Math.min(bc, 255);
        int r = fc + ThreadLocalRandom.current().nextInt(bc - fc);
        int g = fc + ThreadLocalRandom.current().nextInt(bc - fc);
        int b = fc + ThreadLocalRandom.current().nextInt(bc - fc);
        return new Color(r, g, b);
    }

    private static int getRandomIntColor() {
        int color = 0;
        for (int c : Captchas.getRandomRgb()) {
            color = color << 8 | c;
        }
        return color;
    }

    private static int[] getRandomRgb() {
        return new int[]{ThreadLocalRandom.current().nextInt(256), ThreadLocalRandom.current().nextInt(256), ThreadLocalRandom.current().nextInt(256)};
    }

    private static void shear(Graphics g, int w1, int h1, Color color) {
        Captchas.shearX(g, w1, h1, color);
        Captchas.shearY(g, w1, h1, color);
    }

    private static void shearX(Graphics g, int w, int h, Color color) {
        int period = ThreadLocalRandom.current().nextInt(2);
        int phase = ThreadLocalRandom.current().nextInt(2);
        double frames = Math.PI * 2 * (double)phase;
        for (int i = 0; i < h; ++i) {
            int d = (int)((double)(period >> 1) * Math.sin((double)i / (double)period + frames));
            g.copyArea(0, i, w, 1, d, 0);
            g.setColor(color);
            g.drawLine(d, i, 0, i);
            g.drawLine(d + w, i, w, i);
        }
    }

    private static void shearY(Graphics g, int w, int h, Color color) {
        int period = ThreadLocalRandom.current().nextInt(40) + 10;
        int phase = 7;
        double frames = Math.PI * 2 * (double)phase / 20.0;
        for (int i = 0; i < w; ++i) {
            int d = (int)((double)(period >> 1) * Math.sin((double)i / (double)period + frames));
            g.copyArea(i, 0, 1, h, 0, d);
            g.setColor(color);
            g.drawLine(i, d, i, 0);
            g.drawLine(i, d + h, i, h);
        }
    }
}

