/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.util;

import cn.ponfee.commons.date.Dates;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Pattern;

public class IdcardResolver {
    private static final long ORIGINAL = Dates.toDate("1950-01-01 00:00:00").getTime();
    private String idcard;
    private boolean isValid = false;
    private CertType type;
    private String province;
    private String district;
    private Date birthday;
    private Integer age;
    private Sex sex;
    private static final Pattern FIRST = Pattern.compile("^[0-9]{15}$");
    private static final Pattern SECOND = Pattern.compile("^[0-9]{17}[0-9X]$");
    private static final Pattern PASSPORT_REGEX = Pattern.compile("^1[45][0-9]{7}|G[0-9]{8}|P[0-9]{7}|S[0-9]{7,8}|D[0-9]+$");
    private static final Pattern HONGKONG = Pattern.compile("^[A-Z]{1,2}[0-9]{6}\\(?[0-9A]\\)?$");
    private static final Pattern MACO = Pattern.compile("^([157])[0-9]{6}\\(?[0-9A-Z]\\)?$");
    private static final Pattern TAIWAN = Pattern.compile("^[a-zA-Z][0-9]{9}$");
    private static final int[] POWER = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
    private static final String[] JUXTAPOSE = new String[]{"1", "0", "X", "9", "8", "7", "6", "5", "4", "3", "2"};
    private static final Map<String, String> CITY_CODES = new ImmutableMap.Builder().put((Object)"11", (Object)"\u5317\u4eac").put((Object)"12", (Object)"\u5929\u6d25").put((Object)"13", (Object)"\u6cb3\u5317").put((Object)"14", (Object)"\u5c71\u897f").put((Object)"15", (Object)"\u5185\u8499\u53e4").put((Object)"21", (Object)"\u8fbd\u5b81").put((Object)"22", (Object)"\u5409\u6797").put((Object)"23", (Object)"\u9ed1\u9f99\u6c5f").put((Object)"31", (Object)"\u4e0a\u6d77").put((Object)"32", (Object)"\u6c5f\u82cf").put((Object)"33", (Object)"\u6d59\u6c5f").put((Object)"34", (Object)"\u5b89\u5fbd").put((Object)"35", (Object)"\u798f\u5efa").put((Object)"36", (Object)"\u6c5f\u897f").put((Object)"37", (Object)"\u5c71\u4e1c").put((Object)"41", (Object)"\u6cb3\u5357").put((Object)"42", (Object)"\u6e56\u5317").put((Object)"43", (Object)"\u6e56\u5357").put((Object)"44", (Object)"\u5e7f\u4e1c").put((Object)"45", (Object)"\u5e7f\u897f").put((Object)"46", (Object)"\u6d77\u5357").put((Object)"50", (Object)"\u91cd\u5e86").put((Object)"51", (Object)"\u56db\u5ddd").put((Object)"52", (Object)"\u8d35\u5dde").put((Object)"53", (Object)"\u4e91\u5357").put((Object)"54", (Object)"\u897f\u85cf").put((Object)"61", (Object)"\u9655\u897f").put((Object)"62", (Object)"\u7518\u8083").put((Object)"63", (Object)"\u9752\u6d77").put((Object)"64", (Object)"\u5b81\u590f").put((Object)"65", (Object)"\u65b0\u7586").put((Object)"71", (Object)"\u53f0\u6e7e").put((Object)"81", (Object)"\u9999\u6e2f").put((Object)"82", (Object)"\u6fb3\u95e8").put((Object)"91", (Object)"\u56fd\u5916").build();
    private static final Map<String, Integer> TW_FIRST_CODE = new ImmutableMap.Builder().put((Object)"A", (Object)10).put((Object)"B", (Object)11).put((Object)"C", (Object)12).put((Object)"D", (Object)13).put((Object)"E", (Object)14).put((Object)"F", (Object)15).put((Object)"G", (Object)16).put((Object)"H", (Object)17).put((Object)"J", (Object)18).put((Object)"K", (Object)19).put((Object)"L", (Object)20).put((Object)"M", (Object)21).put((Object)"N", (Object)22).put((Object)"P", (Object)23).put((Object)"Q", (Object)24).put((Object)"R", (Object)25).put((Object)"S", (Object)26).put((Object)"T", (Object)27).put((Object)"U", (Object)28).put((Object)"V", (Object)29).put((Object)"X", (Object)30).put((Object)"Y", (Object)31).put((Object)"W", (Object)32).put((Object)"Z", (Object)33).put((Object)"I", (Object)34).put((Object)"O", (Object)35).build();
    public static final Map<Integer, String> DISTRICT_CODE_MAPPING;
    private static final List<Integer> AREA_CODE_LIST;

    public static String generate() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        StringBuilder builder = new StringBuilder(18);
        builder.append(AREA_CODE_LIST.get(((Random)random).nextInt(AREA_CODE_LIST.size())));
        builder.append(Dates.format(Dates.random(ORIGINAL, System.currentTimeMillis()), "yyyyMMdd"));
        builder.append(String.format("%03d", ((Random)random).nextInt(1000)));
        builder.append(IdcardResolver.genPowerSum(builder.toString().toCharArray()));
        return builder.toString();
    }

    public IdcardResolver(String idcard) {
        if (idcard == null) {
            return;
        }
        this.idcard = idcard.trim().toUpperCase();
        this.isValid = this.resolve(this.idcard);
    }

    private boolean resolve(String idcard) {
        return this.isSecond(idcard) || this.isFirst(idcard) || this.isPassport(idcard) || this.isOther(idcard);
    }

    private boolean isFirst(String idcard) {
        if (!FIRST.matcher(idcard).matches()) {
            return false;
        }
        idcard = idcard.substring(0, 6) + "19" + idcard.substring(6);
        if (this.isSecond(idcard = idcard + IdcardResolver.genPowerSum(idcard.toCharArray()))) {
            this.type = CertType.FIRST;
            return true;
        }
        return false;
    }

    private boolean isSecond(String idcard) {
        if (!SECOND.matcher(idcard).matches()) {
            return false;
        }
        this.province = CITY_CODES.get(idcard.substring(0, 2));
        if (this.province == null) {
            return false;
        }
        this.district = DISTRICT_CODE_MAPPING.get(Integer.parseInt(idcard.substring(0, 6)));
        String prefix17 = idcard.substring(0, 17);
        String checkCode = IdcardResolver.genPowerSum(prefix17.toCharArray());
        if (!checkCode.equals(idcard.substring(17))) {
            return false;
        }
        if (!this.verifyBirthday(idcard.substring(6, 14))) {
            return false;
        }
        this.sex = (Character.getNumericValue(idcard.charAt(16)) & 1) == 1 ? Sex.M : Sex.F;
        this.type = CertType.SECOND;
        return true;
    }

    private boolean isPassport(String idcard) {
        if (PASSPORT_REGEX.matcher(idcard).matches()) {
            this.type = CertType.PASSPORT;
            return true;
        }
        return false;
    }

    private boolean isOther(String idcard) {
        if (HONGKONG.matcher(idcard = idcard.replaceAll("[(|)]", "")).matches()) {
            this.type = CertType.HONGKONG;
            this.sex = Sex.N;
            return this.validateHKCard(idcard);
        }
        if (MACO.matcher(idcard).matches()) {
            this.type = CertType.MACAO;
            this.sex = Sex.N;
            return true;
        }
        if (TAIWAN.matcher(idcard).matches()) {
            this.type = CertType.TAIWAN;
            String sex = idcard.substring(1, 2);
            this.sex = "1".equals(sex) ? Sex.M : ("2".equals(sex) ? Sex.F : Sex.N);
            return this.validateTWCard(idcard);
        }
        return false;
    }

    private boolean validateTWCard(String idCard) {
        String start = idCard.substring(0, 1);
        String mid = idCard.substring(1, 9);
        String end = idCard.substring(9, 10);
        int iStart = TW_FIRST_CODE.get(start);
        int sum = iStart / 10 + iStart % 10 * 9;
        int iteration = 8;
        for (char c : mid.toCharArray()) {
            sum += c * iteration--;
        }
        return (10 - sum % 10) % 10 == Integer.parseInt(end);
    }

    private boolean validateHKCard(String idCard) {
        int sum;
        String card = idCard.replaceAll("[\\(|\\)]", "");
        if (card.length() == 9) {
            sum = (card.substring(0, 1).toUpperCase().toCharArray()[0] - 55) * 9 + (card.substring(1, 2).toUpperCase().toCharArray()[0] - 55) * 8;
            card = card.substring(1, 9);
        } else {
            sum = 522 + (card.substring(0, 1).toUpperCase().toCharArray()[0] - 55) * 8;
        }
        String mid = card.substring(1, 7);
        String end = card.substring(7, 8);
        int iteration = 7;
        for (char c : mid.toCharArray()) {
            sum += c * iteration--;
        }
        sum = "A".equalsIgnoreCase(end) ? (sum += 10) : (sum += Integer.parseInt(end));
        return sum % 11 == 0;
    }

    private static String genPowerSum(char[] chars) {
        int i;
        int[] n = new int[chars.length];
        int result = 0;
        for (i = 0; i < n.length; ++i) {
            n[i] = Character.getNumericValue(chars[i]);
        }
        for (i = 0; i < n.length; ++i) {
            result += POWER[i] * n[i];
        }
        return JUXTAPOSE[result % 11];
    }

    private boolean verifyBirthday(String date) {
        try {
            this.birthday = Dates.toDate(date, "yyyyMMdd");
            if (this.birthday.after(new Date())) {
                return false;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.birthday);
            this.age = Calendar.getInstance().get(1) - calendar.get(1);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getIdcard() {
        return this.idcard;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public CertType getType() {
        return this.type;
    }

    public String getProvince() {
        return this.province;
    }

    public String getDistrict() {
        return this.district;
    }

    public Date getBirthday() {
        return this.birthday;
    }

    public Sex getSex() {
        return this.sex;
    }

    public int getAge() {
        return this.age;
    }

    public String toString() {
        return "IdcardResolver {idcard=" + this.idcard + ", isValid=" + this.isValid + ", type=" + (Object)((Object)this.type) + ", province=" + this.province + ", district=" + this.district + ", birthday=" + this.birthday + ", age=" + this.age + ", sex=" + (Object)((Object)this.sex) + "}";
    }

    /*
     * Opcode count of 19694 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    static {
        ImmutableMap.Builder b = new ImmutableMap.Builder();
        b.put((Object)110000, (Object)"\u5317\u4eac\u5e02");
        b.put((Object)110101, (Object)"\u4e1c\u57ce\u533a");
        b.put((Object)110102, (Object)"\u897f\u57ce\u533a");
        b.put((Object)110105, (Object)"\u671d\u9633\u533a");
        b.put((Object)110106, (Object)"\u4e30\u53f0\u533a");
        b.put((Object)110107, (Object)"\u77f3\u666f\u5c71\u533a");
        b.put((Object)110108, (Object)"\u6d77\u6dc0\u533a");
        b.put((Object)110109, (Object)"\u95e8\u5934\u6c9f\u533a");
        b.put((Object)110111, (Object)"\u623f\u5c71\u533a");
        b.put((Object)110112, (Object)"\u901a\u5dde\u533a");
        b.put((Object)110113, (Object)"\u987a\u4e49\u533a");
        b.put((Object)110114, (Object)"\u660c\u5e73\u533a");
        b.put((Object)110115, (Object)"\u5927\u5174\u533a");
        b.put((Object)110116, (Object)"\u6000\u67d4\u533a");
        b.put((Object)110117, (Object)"\u5e73\u8c37\u533a");
        b.put((Object)110118, (Object)"\u5bc6\u4e91\u533a");
        b.put((Object)110119, (Object)"\u5ef6\u5e86\u533a");
        b.put((Object)120000, (Object)"\u5929\u6d25\u5e02");
        b.put((Object)120101, (Object)"\u548c\u5e73\u533a");
        b.put((Object)120102, (Object)"\u6cb3\u4e1c\u533a");
        b.put((Object)120103, (Object)"\u6cb3\u897f\u533a");
        b.put((Object)120104, (Object)"\u5357\u5f00\u533a");
        b.put((Object)120105, (Object)"\u6cb3\u5317\u533a");
        b.put((Object)120106, (Object)"\u7ea2\u6865\u533a");
        b.put((Object)120110, (Object)"\u4e1c\u4e3d\u533a");
        b.put((Object)120111, (Object)"\u897f\u9752\u533a");
        b.put((Object)120112, (Object)"\u6d25\u5357\u533a");
        b.put((Object)120113, (Object)"\u5317\u8fb0\u533a");
        b.put((Object)120114, (Object)"\u6b66\u6e05\u533a");
        b.put((Object)120115, (Object)"\u5b9d\u577b\u533a");
        b.put((Object)120116, (Object)"\u6ee8\u6d77\u65b0\u533a");
        b.put((Object)120117, (Object)"\u5b81\u6cb3\u533a");
        b.put((Object)120118, (Object)"\u9759\u6d77\u533a");
        b.put((Object)120119, (Object)"\u84df\u5dde\u533a");
        b.put((Object)130000, (Object)"\u6cb3\u5317\u7701");
        b.put((Object)130100, (Object)"\u77f3\u5bb6\u5e84\u5e02");
        b.put((Object)130102, (Object)"\u957f\u5b89\u533a");
        b.put((Object)130104, (Object)"\u6865\u897f\u533a");
        b.put((Object)130105, (Object)"\u65b0\u534e\u533a");
        b.put((Object)130107, (Object)"\u4e95\u9649\u77ff\u533a");
        b.put((Object)130108, (Object)"\u88d5\u534e\u533a");
        b.put((Object)130109, (Object)"\u85c1\u57ce\u533a");
        b.put((Object)130110, (Object)"\u9e7f\u6cc9\u533a");
        b.put((Object)130111, (Object)"\u683e\u57ce\u533a");
        b.put((Object)130121, (Object)"\u4e95\u9649\u53bf");
        b.put((Object)130123, (Object)"\u6b63\u5b9a\u53bf");
        b.put((Object)130125, (Object)"\u884c\u5510\u53bf");
        b.put((Object)130126, (Object)"\u7075\u5bff\u53bf");
        b.put((Object)130127, (Object)"\u9ad8\u9091\u53bf");
        b.put((Object)130128, (Object)"\u6df1\u6cfd\u53bf");
        b.put((Object)130129, (Object)"\u8d5e\u7687\u53bf");
        b.put((Object)130130, (Object)"\u65e0\u6781\u53bf");
        b.put((Object)130131, (Object)"\u5e73\u5c71\u53bf");
        b.put((Object)130132, (Object)"\u5143\u6c0f\u53bf");
        b.put((Object)130133, (Object)"\u8d75\u53bf");
        b.put((Object)130181, (Object)"\u8f9b\u96c6\u5e02");
        b.put((Object)130183, (Object)"\u664b\u5dde\u5e02");
        b.put((Object)130184, (Object)"\u65b0\u4e50\u5e02");
        b.put((Object)130200, (Object)"\u5510\u5c71\u5e02");
        b.put((Object)130202, (Object)"\u8def\u5357\u533a");
        b.put((Object)130203, (Object)"\u8def\u5317\u533a");
        b.put((Object)130204, (Object)"\u53e4\u51b6\u533a");
        b.put((Object)130205, (Object)"\u5f00\u5e73\u533a");
        b.put((Object)130207, (Object)"\u4e30\u5357\u533a");
        b.put((Object)130208, (Object)"\u4e30\u6da6\u533a");
        b.put((Object)130209, (Object)"\u66f9\u5983\u7538\u533a");
        b.put((Object)130223, (Object)"\u6ee6\u53bf");
        b.put((Object)130224, (Object)"\u6ee6\u5357\u53bf");
        b.put((Object)130225, (Object)"\u4e50\u4ead\u53bf");
        b.put((Object)130227, (Object)"\u8fc1\u897f\u53bf");
        b.put((Object)130229, (Object)"\u7389\u7530\u53bf");
        b.put((Object)130281, (Object)"\u9075\u5316\u5e02");
        b.put((Object)130283, (Object)"\u8fc1\u5b89\u5e02");
        b.put((Object)130300, (Object)"\u79e6\u7687\u5c9b\u5e02");
        b.put((Object)130302, (Object)"\u6d77\u6e2f\u533a");
        b.put((Object)130303, (Object)"\u5c71\u6d77\u5173\u533a");
        b.put((Object)130304, (Object)"\u5317\u6234\u6cb3\u533a");
        b.put((Object)130306, (Object)"\u629a\u5b81\u533a");
        b.put((Object)130321, (Object)"\u9752\u9f99\u6ee1\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)130322, (Object)"\u660c\u9ece\u53bf");
        b.put((Object)130324, (Object)"\u5362\u9f99\u53bf");
        b.put((Object)130400, (Object)"\u90af\u90f8\u5e02");
        b.put((Object)130402, (Object)"\u90af\u5c71\u533a");
        b.put((Object)130403, (Object)"\u4e1b\u53f0\u533a");
        b.put((Object)130404, (Object)"\u590d\u5174\u533a");
        b.put((Object)130406, (Object)"\u5cf0\u5cf0\u77ff\u533a");
        b.put((Object)130407, (Object)"\u80a5\u4e61\u533a");
        b.put((Object)130408, (Object)"\u6c38\u5e74\u533a");
        b.put((Object)130423, (Object)"\u4e34\u6f33\u53bf");
        b.put((Object)130424, (Object)"\u6210\u5b89\u53bf");
        b.put((Object)130425, (Object)"\u5927\u540d\u53bf");
        b.put((Object)130426, (Object)"\u6d89\u53bf");
        b.put((Object)130427, (Object)"\u78c1\u53bf");
        b.put((Object)130430, (Object)"\u90b1\u53bf");
        b.put((Object)130431, (Object)"\u9e21\u6cfd\u53bf");
        b.put((Object)130432, (Object)"\u5e7f\u5e73\u53bf");
        b.put((Object)130433, (Object)"\u9986\u9676\u53bf");
        b.put((Object)130434, (Object)"\u9b4f\u53bf");
        b.put((Object)130435, (Object)"\u66f2\u5468\u53bf");
        b.put((Object)130481, (Object)"\u6b66\u5b89\u5e02");
        b.put((Object)130500, (Object)"\u90a2\u53f0\u5e02");
        b.put((Object)130502, (Object)"\u6865\u4e1c\u533a");
        b.put((Object)130503, (Object)"\u6865\u897f\u533a");
        b.put((Object)130521, (Object)"\u90a2\u53f0\u53bf");
        b.put((Object)130522, (Object)"\u4e34\u57ce\u53bf");
        b.put((Object)130523, (Object)"\u5185\u4e18\u53bf");
        b.put((Object)130524, (Object)"\u67cf\u4e61\u53bf");
        b.put((Object)130525, (Object)"\u9686\u5c27\u53bf");
        b.put((Object)130526, (Object)"\u4efb\u53bf");
        b.put((Object)130527, (Object)"\u5357\u548c\u53bf");
        b.put((Object)130528, (Object)"\u5b81\u664b\u53bf");
        b.put((Object)130529, (Object)"\u5de8\u9e7f\u53bf");
        b.put((Object)130530, (Object)"\u65b0\u6cb3\u53bf");
        b.put((Object)130531, (Object)"\u5e7f\u5b97\u53bf");
        b.put((Object)130532, (Object)"\u5e73\u4e61\u53bf");
        b.put((Object)130533, (Object)"\u5a01\u53bf");
        b.put((Object)130534, (Object)"\u6e05\u6cb3\u53bf");
        b.put((Object)130535, (Object)"\u4e34\u897f\u53bf");
        b.put((Object)130581, (Object)"\u5357\u5bab\u5e02");
        b.put((Object)130582, (Object)"\u6c99\u6cb3\u5e02");
        b.put((Object)130600, (Object)"\u4fdd\u5b9a\u5e02");
        b.put((Object)130602, (Object)"\u7ade\u79c0\u533a");
        b.put((Object)130606, (Object)"\u83b2\u6c60\u533a");
        b.put((Object)130607, (Object)"\u6ee1\u57ce\u533a");
        b.put((Object)130608, (Object)"\u6e05\u82d1\u533a");
        b.put((Object)130609, (Object)"\u5f90\u6c34\u533a");
        b.put((Object)130623, (Object)"\u6d9e\u6c34\u53bf");
        b.put((Object)130624, (Object)"\u961c\u5e73\u53bf");
        b.put((Object)130626, (Object)"\u5b9a\u5174\u53bf");
        b.put((Object)130627, (Object)"\u5510\u53bf");
        b.put((Object)130628, (Object)"\u9ad8\u9633\u53bf");
        b.put((Object)130629, (Object)"\u5bb9\u57ce\u53bf");
        b.put((Object)130630, (Object)"\u6d9e\u6e90\u53bf");
        b.put((Object)130631, (Object)"\u671b\u90fd\u53bf");
        b.put((Object)130632, (Object)"\u5b89\u65b0\u53bf");
        b.put((Object)130633, (Object)"\u6613\u53bf");
        b.put((Object)130634, (Object)"\u66f2\u9633\u53bf");
        b.put((Object)130635, (Object)"\u8821\u53bf");
        b.put((Object)130636, (Object)"\u987a\u5e73\u53bf");
        b.put((Object)130637, (Object)"\u535a\u91ce\u53bf");
        b.put((Object)130638, (Object)"\u96c4\u53bf");
        b.put((Object)130681, (Object)"\u6dbf\u5dde\u5e02");
        b.put((Object)130682, (Object)"\u5b9a\u5dde\u5e02");
        b.put((Object)130683, (Object)"\u5b89\u56fd\u5e02");
        b.put((Object)130684, (Object)"\u9ad8\u7891\u5e97\u5e02");
        b.put((Object)130700, (Object)"\u5f20\u5bb6\u53e3\u5e02");
        b.put((Object)130702, (Object)"\u6865\u4e1c\u533a");
        b.put((Object)130703, (Object)"\u6865\u897f\u533a");
        b.put((Object)130705, (Object)"\u5ba3\u5316\u533a");
        b.put((Object)130706, (Object)"\u4e0b\u82b1\u56ed\u533a");
        b.put((Object)130708, (Object)"\u4e07\u5168\u533a");
        b.put((Object)130709, (Object)"\u5d07\u793c\u533a");
        b.put((Object)130722, (Object)"\u5f20\u5317\u53bf");
        b.put((Object)130723, (Object)"\u5eb7\u4fdd\u53bf");
        b.put((Object)130724, (Object)"\u6cbd\u6e90\u53bf");
        b.put((Object)130725, (Object)"\u5c1a\u4e49\u53bf");
        b.put((Object)130726, (Object)"\u851a\u53bf");
        b.put((Object)130727, (Object)"\u9633\u539f\u53bf");
        b.put((Object)130728, (Object)"\u6000\u5b89\u53bf");
        b.put((Object)130730, (Object)"\u6000\u6765\u53bf");
        b.put((Object)130731, (Object)"\u6dbf\u9e7f\u53bf");
        b.put((Object)130732, (Object)"\u8d64\u57ce\u53bf");
        b.put((Object)130800, (Object)"\u627f\u5fb7\u5e02");
        b.put((Object)130802, (Object)"\u53cc\u6865\u533a");
        b.put((Object)130803, (Object)"\u53cc\u6ee6\u533a");
        b.put((Object)130804, (Object)"\u9e70\u624b\u8425\u5b50\u77ff\u533a");
        b.put((Object)130821, (Object)"\u627f\u5fb7\u53bf");
        b.put((Object)130822, (Object)"\u5174\u9686\u53bf");
        b.put((Object)130824, (Object)"\u6ee6\u5e73\u53bf");
        b.put((Object)130825, (Object)"\u9686\u5316\u53bf");
        b.put((Object)130826, (Object)"\u4e30\u5b81\u6ee1\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)130827, (Object)"\u5bbd\u57ce\u6ee1\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)130828, (Object)"\u56f4\u573a\u6ee1\u65cf\u8499\u53e4\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)130881, (Object)"\u5e73\u6cc9\u5e02");
        b.put((Object)130900, (Object)"\u6ca7\u5dde\u5e02");
        b.put((Object)130902, (Object)"\u65b0\u534e\u533a");
        b.put((Object)130903, (Object)"\u8fd0\u6cb3\u533a");
        b.put((Object)130921, (Object)"\u6ca7\u53bf");
        b.put((Object)130922, (Object)"\u9752\u53bf");
        b.put((Object)130923, (Object)"\u4e1c\u5149\u53bf");
        b.put((Object)130924, (Object)"\u6d77\u5174\u53bf");
        b.put((Object)130925, (Object)"\u76d0\u5c71\u53bf");
        b.put((Object)130926, (Object)"\u8083\u5b81\u53bf");
        b.put((Object)130927, (Object)"\u5357\u76ae\u53bf");
        b.put((Object)130928, (Object)"\u5434\u6865\u53bf");
        b.put((Object)130929, (Object)"\u732e\u53bf");
        b.put((Object)130930, (Object)"\u5b5f\u6751\u56de\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)130981, (Object)"\u6cca\u5934\u5e02");
        b.put((Object)130982, (Object)"\u4efb\u4e18\u5e02");
        b.put((Object)130983, (Object)"\u9ec4\u9a85\u5e02");
        b.put((Object)130984, (Object)"\u6cb3\u95f4\u5e02");
        b.put((Object)131000, (Object)"\u5eca\u574a\u5e02");
        b.put((Object)131002, (Object)"\u5b89\u6b21\u533a");
        b.put((Object)131003, (Object)"\u5e7f\u9633\u533a");
        b.put((Object)131022, (Object)"\u56fa\u5b89\u53bf");
        b.put((Object)131023, (Object)"\u6c38\u6e05\u53bf");
        b.put((Object)131024, (Object)"\u9999\u6cb3\u53bf");
        b.put((Object)131025, (Object)"\u5927\u57ce\u53bf");
        b.put((Object)131026, (Object)"\u6587\u5b89\u53bf");
        b.put((Object)131028, (Object)"\u5927\u5382\u56de\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)131081, (Object)"\u9738\u5dde\u5e02");
        b.put((Object)131082, (Object)"\u4e09\u6cb3\u5e02");
        b.put((Object)131100, (Object)"\u8861\u6c34\u5e02");
        b.put((Object)131102, (Object)"\u6843\u57ce\u533a");
        b.put((Object)131103, (Object)"\u5180\u5dde\u533a");
        b.put((Object)131121, (Object)"\u67a3\u5f3a\u53bf");
        b.put((Object)131122, (Object)"\u6b66\u9091\u53bf");
        b.put((Object)131123, (Object)"\u6b66\u5f3a\u53bf");
        b.put((Object)131124, (Object)"\u9976\u9633\u53bf");
        b.put((Object)131125, (Object)"\u5b89\u5e73\u53bf");
        b.put((Object)131126, (Object)"\u6545\u57ce\u53bf");
        b.put((Object)131127, (Object)"\u666f\u53bf");
        b.put((Object)131128, (Object)"\u961c\u57ce\u53bf");
        b.put((Object)131182, (Object)"\u6df1\u5dde\u5e02");
        b.put((Object)140000, (Object)"\u5c71\u897f\u7701");
        b.put((Object)140100, (Object)"\u592a\u539f\u5e02");
        b.put((Object)140105, (Object)"\u5c0f\u5e97\u533a");
        b.put((Object)140106, (Object)"\u8fce\u6cfd\u533a");
        b.put((Object)140107, (Object)"\u674f\u82b1\u5cad\u533a");
        b.put((Object)140108, (Object)"\u5c16\u8349\u576a\u533a");
        b.put((Object)140109, (Object)"\u4e07\u67cf\u6797\u533a");
        b.put((Object)140110, (Object)"\u664b\u6e90\u533a");
        b.put((Object)140121, (Object)"\u6e05\u5f90\u53bf");
        b.put((Object)140122, (Object)"\u9633\u66f2\u53bf");
        b.put((Object)140123, (Object)"\u5a04\u70e6\u53bf");
        b.put((Object)140181, (Object)"\u53e4\u4ea4\u5e02");
        b.put((Object)140200, (Object)"\u5927\u540c\u5e02");
        b.put((Object)140212, (Object)"\u65b0\u8363\u533a");
        b.put((Object)140213, (Object)"\u5e73\u57ce\u533a");
        b.put((Object)140214, (Object)"\u4e91\u5188\u533a");
        b.put((Object)140215, (Object)"\u4e91\u5dde\u533a");
        b.put((Object)140221, (Object)"\u9633\u9ad8\u53bf");
        b.put((Object)140222, (Object)"\u5929\u9547\u53bf");
        b.put((Object)140223, (Object)"\u5e7f\u7075\u53bf");
        b.put((Object)140224, (Object)"\u7075\u4e18\u53bf");
        b.put((Object)140225, (Object)"\u6d51\u6e90\u53bf");
        b.put((Object)140226, (Object)"\u5de6\u4e91\u53bf");
        b.put((Object)140300, (Object)"\u9633\u6cc9\u5e02");
        b.put((Object)140302, (Object)"\u57ce\u533a");
        b.put((Object)140303, (Object)"\u77ff\u533a");
        b.put((Object)140311, (Object)"\u90ca\u533a");
        b.put((Object)140321, (Object)"\u5e73\u5b9a\u53bf");
        b.put((Object)140322, (Object)"\u76c2\u53bf");
        b.put((Object)140400, (Object)"\u957f\u6cbb\u5e02");
        b.put((Object)140402, (Object)"\u57ce\u533a");
        b.put((Object)140411, (Object)"\u90ca\u533a");
        b.put((Object)140421, (Object)"\u957f\u6cbb\u53bf");
        b.put((Object)140423, (Object)"\u8944\u57a3\u53bf");
        b.put((Object)140424, (Object)"\u5c6f\u7559\u53bf");
        b.put((Object)140425, (Object)"\u5e73\u987a\u53bf");
        b.put((Object)140426, (Object)"\u9ece\u57ce\u53bf");
        b.put((Object)140427, (Object)"\u58f6\u5173\u53bf");
        b.put((Object)140428, (Object)"\u957f\u5b50\u53bf");
        b.put((Object)140429, (Object)"\u6b66\u4e61\u53bf");
        b.put((Object)140430, (Object)"\u6c81\u53bf");
        b.put((Object)140431, (Object)"\u6c81\u6e90\u53bf");
        b.put((Object)140481, (Object)"\u6f5e\u57ce\u5e02");
        b.put((Object)140500, (Object)"\u664b\u57ce\u5e02");
        b.put((Object)140502, (Object)"\u57ce\u533a");
        b.put((Object)140521, (Object)"\u6c81\u6c34\u53bf");
        b.put((Object)140522, (Object)"\u9633\u57ce\u53bf");
        b.put((Object)140524, (Object)"\u9675\u5ddd\u53bf");
        b.put((Object)140525, (Object)"\u6cfd\u5dde\u53bf");
        b.put((Object)140581, (Object)"\u9ad8\u5e73\u5e02");
        b.put((Object)140600, (Object)"\u6714\u5dde\u5e02");
        b.put((Object)140602, (Object)"\u6714\u57ce\u533a");
        b.put((Object)140603, (Object)"\u5e73\u9c81\u533a");
        b.put((Object)140621, (Object)"\u5c71\u9634\u53bf");
        b.put((Object)140622, (Object)"\u5e94\u53bf");
        b.put((Object)140623, (Object)"\u53f3\u7389\u53bf");
        b.put((Object)140681, (Object)"\u6000\u4ec1\u5e02");
        b.put((Object)140700, (Object)"\u664b\u4e2d\u5e02");
        b.put((Object)140702, (Object)"\u6986\u6b21\u533a");
        b.put((Object)140721, (Object)"\u6986\u793e\u53bf");
        b.put((Object)140722, (Object)"\u5de6\u6743\u53bf");
        b.put((Object)140723, (Object)"\u548c\u987a\u53bf");
        b.put((Object)140724, (Object)"\u6614\u9633\u53bf");
        b.put((Object)140725, (Object)"\u5bff\u9633\u53bf");
        b.put((Object)140726, (Object)"\u592a\u8c37\u53bf");
        b.put((Object)140727, (Object)"\u7941\u53bf");
        b.put((Object)140728, (Object)"\u5e73\u9065\u53bf");
        b.put((Object)140729, (Object)"\u7075\u77f3\u53bf");
        b.put((Object)140781, (Object)"\u4ecb\u4f11\u5e02");
        b.put((Object)140800, (Object)"\u8fd0\u57ce\u5e02");
        b.put((Object)140802, (Object)"\u76d0\u6e56\u533a");
        b.put((Object)140821, (Object)"\u4e34\u7317\u53bf");
        b.put((Object)140822, (Object)"\u4e07\u8363\u53bf");
        b.put((Object)140823, (Object)"\u95fb\u559c\u53bf");
        b.put((Object)140824, (Object)"\u7a37\u5c71\u53bf");
        b.put((Object)140825, (Object)"\u65b0\u7edb\u53bf");
        b.put((Object)140826, (Object)"\u7edb\u53bf");
        b.put((Object)140827, (Object)"\u57a3\u66f2\u53bf");
        b.put((Object)140828, (Object)"\u590f\u53bf");
        b.put((Object)140829, (Object)"\u5e73\u9646\u53bf");
        b.put((Object)140830, (Object)"\u82ae\u57ce\u53bf");
        b.put((Object)140881, (Object)"\u6c38\u6d4e\u5e02");
        b.put((Object)140882, (Object)"\u6cb3\u6d25\u5e02");
        b.put((Object)140900, (Object)"\u5ffb\u5dde\u5e02");
        b.put((Object)140902, (Object)"\u5ffb\u5e9c\u533a");
        b.put((Object)140921, (Object)"\u5b9a\u8944\u53bf");
        b.put((Object)140922, (Object)"\u4e94\u53f0\u53bf");
        b.put((Object)140923, (Object)"\u4ee3\u53bf");
        b.put((Object)140924, (Object)"\u7e41\u5cd9\u53bf");
        b.put((Object)140925, (Object)"\u5b81\u6b66\u53bf");
        b.put((Object)140926, (Object)"\u9759\u4e50\u53bf");
        b.put((Object)140927, (Object)"\u795e\u6c60\u53bf");
        b.put((Object)140928, (Object)"\u4e94\u5be8\u53bf");
        b.put((Object)140929, (Object)"\u5ca2\u5c9a\u53bf");
        b.put((Object)140930, (Object)"\u6cb3\u66f2\u53bf");
        b.put((Object)140931, (Object)"\u4fdd\u5fb7\u53bf");
        b.put((Object)140932, (Object)"\u504f\u5173\u53bf");
        b.put((Object)140981, (Object)"\u539f\u5e73\u5e02");
        b.put((Object)141000, (Object)"\u4e34\u6c7e\u5e02");
        b.put((Object)141002, (Object)"\u5c27\u90fd\u533a");
        b.put((Object)141021, (Object)"\u66f2\u6c83\u53bf");
        b.put((Object)141022, (Object)"\u7ffc\u57ce\u53bf");
        b.put((Object)141023, (Object)"\u8944\u6c7e\u53bf");
        b.put((Object)141024, (Object)"\u6d2a\u6d1e\u53bf");
        b.put((Object)141025, (Object)"\u53e4\u53bf");
        b.put((Object)141026, (Object)"\u5b89\u6cfd\u53bf");
        b.put((Object)141027, (Object)"\u6d6e\u5c71\u53bf");
        b.put((Object)141028, (Object)"\u5409\u53bf");
        b.put((Object)141029, (Object)"\u4e61\u5b81\u53bf");
        b.put((Object)141030, (Object)"\u5927\u5b81\u53bf");
        b.put((Object)141031, (Object)"\u96b0\u53bf");
        b.put((Object)141032, (Object)"\u6c38\u548c\u53bf");
        b.put((Object)141033, (Object)"\u84b2\u53bf");
        b.put((Object)141034, (Object)"\u6c7e\u897f\u53bf");
        b.put((Object)141081, (Object)"\u4faf\u9a6c\u5e02");
        b.put((Object)141082, (Object)"\u970d\u5dde\u5e02");
        b.put((Object)141100, (Object)"\u5415\u6881\u5e02");
        b.put((Object)141102, (Object)"\u79bb\u77f3\u533a");
        b.put((Object)141121, (Object)"\u6587\u6c34\u53bf");
        b.put((Object)141122, (Object)"\u4ea4\u57ce\u53bf");
        b.put((Object)141123, (Object)"\u5174\u53bf");
        b.put((Object)141124, (Object)"\u4e34\u53bf");
        b.put((Object)141125, (Object)"\u67f3\u6797\u53bf");
        b.put((Object)141126, (Object)"\u77f3\u697c\u53bf");
        b.put((Object)141127, (Object)"\u5c9a\u53bf");
        b.put((Object)141128, (Object)"\u65b9\u5c71\u53bf");
        b.put((Object)141129, (Object)"\u4e2d\u9633\u53bf");
        b.put((Object)141130, (Object)"\u4ea4\u53e3\u53bf");
        b.put((Object)141181, (Object)"\u5b5d\u4e49\u5e02");
        b.put((Object)141182, (Object)"\u6c7e\u9633\u5e02");
        b.put((Object)150000, (Object)"\u5185\u8499\u53e4\u81ea\u6cbb\u533a");
        b.put((Object)150100, (Object)"\u547c\u548c\u6d69\u7279\u5e02");
        b.put((Object)150102, (Object)"\u65b0\u57ce\u533a");
        b.put((Object)150103, (Object)"\u56de\u6c11\u533a");
        b.put((Object)150104, (Object)"\u7389\u6cc9\u533a");
        b.put((Object)150105, (Object)"\u8d5b\u7f55\u533a");
        b.put((Object)150121, (Object)"\u571f\u9ed8\u7279\u5de6\u65d7");
        b.put((Object)150122, (Object)"\u6258\u514b\u6258\u53bf");
        b.put((Object)150123, (Object)"\u548c\u6797\u683c\u5c14\u53bf");
        b.put((Object)150124, (Object)"\u6e05\u6c34\u6cb3\u53bf");
        b.put((Object)150125, (Object)"\u6b66\u5ddd\u53bf");
        b.put((Object)150200, (Object)"\u5305\u5934\u5e02");
        b.put((Object)150202, (Object)"\u4e1c\u6cb3\u533a");
        b.put((Object)150203, (Object)"\u6606\u90fd\u4ed1\u533a");
        b.put((Object)150204, (Object)"\u9752\u5c71\u533a");
        b.put((Object)150205, (Object)"\u77f3\u62d0\u533a");
        b.put((Object)150206, (Object)"\u767d\u4e91\u9102\u535a\u77ff\u533a");
        b.put((Object)150207, (Object)"\u4e5d\u539f\u533a");
        b.put((Object)150221, (Object)"\u571f\u9ed8\u7279\u53f3\u65d7");
        b.put((Object)150222, (Object)"\u56fa\u9633\u53bf");
        b.put((Object)150223, (Object)"\u8fbe\u5c14\u7f55\u8302\u660e\u5b89\u8054\u5408\u65d7");
        b.put((Object)150300, (Object)"\u4e4c\u6d77\u5e02");
        b.put((Object)150302, (Object)"\u6d77\u52c3\u6e7e\u533a");
        b.put((Object)150303, (Object)"\u6d77\u5357\u533a");
        b.put((Object)150304, (Object)"\u4e4c\u8fbe\u533a");
        b.put((Object)150400, (Object)"\u8d64\u5cf0\u5e02");
        b.put((Object)150402, (Object)"\u7ea2\u5c71\u533a");
        b.put((Object)150403, (Object)"\u5143\u5b9d\u5c71\u533a");
        b.put((Object)150404, (Object)"\u677e\u5c71\u533a");
        b.put((Object)150421, (Object)"\u963f\u9c81\u79d1\u5c14\u6c81\u65d7");
        b.put((Object)150422, (Object)"\u5df4\u6797\u5de6\u65d7");
        b.put((Object)150423, (Object)"\u5df4\u6797\u53f3\u65d7");
        b.put((Object)150424, (Object)"\u6797\u897f\u53bf");
        b.put((Object)150425, (Object)"\u514b\u4ec0\u514b\u817e\u65d7");
        b.put((Object)150426, (Object)"\u7fc1\u725b\u7279\u65d7");
        b.put((Object)150428, (Object)"\u5580\u5587\u6c81\u65d7");
        b.put((Object)150429, (Object)"\u5b81\u57ce\u53bf");
        b.put((Object)150430, (Object)"\u6556\u6c49\u65d7");
        b.put((Object)150500, (Object)"\u901a\u8fbd\u5e02");
        b.put((Object)150502, (Object)"\u79d1\u5c14\u6c81\u533a");
        b.put((Object)150521, (Object)"\u79d1\u5c14\u6c81\u5de6\u7ffc\u4e2d\u65d7");
        b.put((Object)150522, (Object)"\u79d1\u5c14\u6c81\u5de6\u7ffc\u540e\u65d7");
        b.put((Object)150523, (Object)"\u5f00\u9c81\u53bf");
        b.put((Object)150524, (Object)"\u5e93\u4f26\u65d7");
        b.put((Object)150525, (Object)"\u5948\u66fc\u65d7");
        b.put((Object)150526, (Object)"\u624e\u9c81\u7279\u65d7");
        b.put((Object)150581, (Object)"\u970d\u6797\u90ed\u52d2\u5e02");
        b.put((Object)150600, (Object)"\u9102\u5c14\u591a\u65af\u5e02");
        b.put((Object)150602, (Object)"\u4e1c\u80dc\u533a");
        b.put((Object)150603, (Object)"\u5eb7\u5df4\u4ec0\u533a");
        b.put((Object)150621, (Object)"\u8fbe\u62c9\u7279\u65d7");
        b.put((Object)150622, (Object)"\u51c6\u683c\u5c14\u65d7");
        b.put((Object)150623, (Object)"\u9102\u6258\u514b\u524d\u65d7");
        b.put((Object)150624, (Object)"\u9102\u6258\u514b\u65d7");
        b.put((Object)150625, (Object)"\u676d\u9526\u65d7");
        b.put((Object)150626, (Object)"\u4e4c\u5ba1\u65d7");
        b.put((Object)150627, (Object)"\u4f0a\u91d1\u970d\u6d1b\u65d7");
        b.put((Object)150700, (Object)"\u547c\u4f26\u8d1d\u5c14\u5e02");
        b.put((Object)150702, (Object)"\u6d77\u62c9\u5c14\u533a");
        b.put((Object)150703, (Object)"\u624e\u8d49\u8bfa\u5c14\u533a");
        b.put((Object)150721, (Object)"\u963f\u8363\u65d7");
        b.put((Object)150722, (Object)"\u83ab\u529b\u8fbe\u74e6\u8fbe\u65a1\u5c14\u65cf\u81ea\u6cbb\u65d7");
        b.put((Object)150723, (Object)"\u9102\u4f26\u6625\u81ea\u6cbb\u65d7");
        b.put((Object)150724, (Object)"\u9102\u6e29\u514b\u65cf\u81ea\u6cbb\u65d7");
        b.put((Object)150725, (Object)"\u9648\u5df4\u5c14\u864e\u65d7");
        b.put((Object)150726, (Object)"\u65b0\u5df4\u5c14\u864e\u5de6\u65d7");
        b.put((Object)150727, (Object)"\u65b0\u5df4\u5c14\u864e\u53f3\u65d7");
        b.put((Object)150781, (Object)"\u6ee1\u6d32\u91cc\u5e02");
        b.put((Object)150782, (Object)"\u7259\u514b\u77f3\u5e02");
        b.put((Object)150783, (Object)"\u624e\u5170\u5c6f\u5e02");
        b.put((Object)150784, (Object)"\u989d\u5c14\u53e4\u7eb3\u5e02");
        b.put((Object)150785, (Object)"\u6839\u6cb3\u5e02");
        b.put((Object)150800, (Object)"\u5df4\u5f66\u6dd6\u5c14\u5e02");
        b.put((Object)150802, (Object)"\u4e34\u6cb3\u533a");
        b.put((Object)150821, (Object)"\u4e94\u539f\u53bf");
        b.put((Object)150822, (Object)"\u78f4\u53e3\u53bf");
        b.put((Object)150823, (Object)"\u4e4c\u62c9\u7279\u524d\u65d7");
        b.put((Object)150824, (Object)"\u4e4c\u62c9\u7279\u4e2d\u65d7");
        b.put((Object)150825, (Object)"\u4e4c\u62c9\u7279\u540e\u65d7");
        b.put((Object)150826, (Object)"\u676d\u9526\u540e\u65d7");
        b.put((Object)150900, (Object)"\u4e4c\u5170\u5bdf\u5e03\u5e02");
        b.put((Object)150902, (Object)"\u96c6\u5b81\u533a");
        b.put((Object)150921, (Object)"\u5353\u8d44\u53bf");
        b.put((Object)150922, (Object)"\u5316\u5fb7\u53bf");
        b.put((Object)150923, (Object)"\u5546\u90fd\u53bf");
        b.put((Object)150924, (Object)"\u5174\u548c\u53bf");
        b.put((Object)150925, (Object)"\u51c9\u57ce\u53bf");
        b.put((Object)150926, (Object)"\u5bdf\u54c8\u5c14\u53f3\u7ffc\u524d\u65d7");
        b.put((Object)150927, (Object)"\u5bdf\u54c8\u5c14\u53f3\u7ffc\u4e2d\u65d7");
        b.put((Object)150928, (Object)"\u5bdf\u54c8\u5c14\u53f3\u7ffc\u540e\u65d7");
        b.put((Object)150929, (Object)"\u56db\u5b50\u738b\u65d7");
        b.put((Object)150981, (Object)"\u4e30\u9547\u5e02");
        b.put((Object)152200, (Object)"\u5174\u5b89\u76df");
        b.put((Object)152201, (Object)"\u4e4c\u5170\u6d69\u7279\u5e02");
        b.put((Object)152202, (Object)"\u963f\u5c14\u5c71\u5e02");
        b.put((Object)152221, (Object)"\u79d1\u5c14\u6c81\u53f3\u7ffc\u524d\u65d7");
        b.put((Object)152222, (Object)"\u79d1\u5c14\u6c81\u53f3\u7ffc\u4e2d\u65d7");
        b.put((Object)152223, (Object)"\u624e\u8d49\u7279\u65d7");
        b.put((Object)152224, (Object)"\u7a81\u6cc9\u53bf");
        b.put((Object)152500, (Object)"\u9521\u6797\u90ed\u52d2\u76df");
        b.put((Object)152501, (Object)"\u4e8c\u8fde\u6d69\u7279\u5e02");
        b.put((Object)152502, (Object)"\u9521\u6797\u6d69\u7279\u5e02");
        b.put((Object)152522, (Object)"\u963f\u5df4\u560e\u65d7");
        b.put((Object)152523, (Object)"\u82cf\u5c3c\u7279\u5de6\u65d7");
        b.put((Object)152524, (Object)"\u82cf\u5c3c\u7279\u53f3\u65d7");
        b.put((Object)152525, (Object)"\u4e1c\u4e4c\u73e0\u7a46\u6c81\u65d7");
        b.put((Object)152526, (Object)"\u897f\u4e4c\u73e0\u7a46\u6c81\u65d7");
        b.put((Object)152527, (Object)"\u592a\u4ec6\u5bfa\u65d7");
        b.put((Object)152528, (Object)"\u9576\u9ec4\u65d7");
        b.put((Object)152529, (Object)"\u6b63\u9576\u767d\u65d7");
        b.put((Object)152530, (Object)"\u6b63\u84dd\u65d7");
        b.put((Object)152531, (Object)"\u591a\u4f26\u53bf");
        b.put((Object)152900, (Object)"\u963f\u62c9\u5584\u76df");
        b.put((Object)152921, (Object)"\u963f\u62c9\u5584\u5de6\u65d7");
        b.put((Object)152922, (Object)"\u963f\u62c9\u5584\u53f3\u65d7");
        b.put((Object)152923, (Object)"\u989d\u6d4e\u7eb3\u65d7");
        b.put((Object)210000, (Object)"\u8fbd\u5b81\u7701");
        b.put((Object)210100, (Object)"\u6c88\u9633\u5e02");
        b.put((Object)210102, (Object)"\u548c\u5e73\u533a");
        b.put((Object)210103, (Object)"\u6c88\u6cb3\u533a");
        b.put((Object)210104, (Object)"\u5927\u4e1c\u533a");
        b.put((Object)210105, (Object)"\u7687\u59d1\u533a");
        b.put((Object)210106, (Object)"\u94c1\u897f\u533a");
        b.put((Object)210111, (Object)"\u82cf\u5bb6\u5c6f\u533a");
        b.put((Object)210112, (Object)"\u6d51\u5357\u533a");
        b.put((Object)210113, (Object)"\u6c88\u5317\u65b0\u533a");
        b.put((Object)210114, (Object)"\u4e8e\u6d2a\u533a");
        b.put((Object)210115, (Object)"\u8fbd\u4e2d\u533a");
        b.put((Object)210123, (Object)"\u5eb7\u5e73\u53bf");
        b.put((Object)210124, (Object)"\u6cd5\u5e93\u53bf");
        b.put((Object)210181, (Object)"\u65b0\u6c11\u5e02");
        b.put((Object)210200, (Object)"\u5927\u8fde\u5e02");
        b.put((Object)210202, (Object)"\u4e2d\u5c71\u533a");
        b.put((Object)210203, (Object)"\u897f\u5c97\u533a");
        b.put((Object)210204, (Object)"\u6c99\u6cb3\u53e3\u533a");
        b.put((Object)210211, (Object)"\u7518\u4e95\u5b50\u533a");
        b.put((Object)210212, (Object)"\u65c5\u987a\u53e3\u533a");
        b.put((Object)210213, (Object)"\u91d1\u5dde\u533a");
        b.put((Object)210214, (Object)"\u666e\u5170\u5e97\u533a");
        b.put((Object)210224, (Object)"\u957f\u6d77\u53bf");
        b.put((Object)210281, (Object)"\u74e6\u623f\u5e97\u5e02");
        b.put((Object)210283, (Object)"\u5e84\u6cb3\u5e02");
        b.put((Object)210300, (Object)"\u978d\u5c71\u5e02");
        b.put((Object)210302, (Object)"\u94c1\u4e1c\u533a");
        b.put((Object)210303, (Object)"\u94c1\u897f\u533a");
        b.put((Object)210304, (Object)"\u7acb\u5c71\u533a");
        b.put((Object)210311, (Object)"\u5343\u5c71\u533a");
        b.put((Object)210321, (Object)"\u53f0\u5b89\u53bf");
        b.put((Object)210323, (Object)"\u5cab\u5ca9\u6ee1\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)210381, (Object)"\u6d77\u57ce\u5e02");
        b.put((Object)210400, (Object)"\u629a\u987a\u5e02");
        b.put((Object)210402, (Object)"\u65b0\u629a\u533a");
        b.put((Object)210403, (Object)"\u4e1c\u6d32\u533a");
        b.put((Object)210404, (Object)"\u671b\u82b1\u533a");
        b.put((Object)210411, (Object)"\u987a\u57ce\u533a");
        b.put((Object)210421, (Object)"\u629a\u987a\u53bf");
        b.put((Object)210422, (Object)"\u65b0\u5bbe\u6ee1\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)210423, (Object)"\u6e05\u539f\u6ee1\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)210500, (Object)"\u672c\u6eaa\u5e02");
        b.put((Object)210502, (Object)"\u5e73\u5c71\u533a");
        b.put((Object)210503, (Object)"\u6eaa\u6e56\u533a");
        b.put((Object)210504, (Object)"\u660e\u5c71\u533a");
        b.put((Object)210505, (Object)"\u5357\u82ac\u533a");
        b.put((Object)210521, (Object)"\u672c\u6eaa\u6ee1\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)210522, (Object)"\u6853\u4ec1\u6ee1\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)210600, (Object)"\u4e39\u4e1c\u5e02");
        b.put((Object)210602, (Object)"\u5143\u5b9d\u533a");
        b.put((Object)210603, (Object)"\u632f\u5174\u533a");
        b.put((Object)210604, (Object)"\u632f\u5b89\u533a");
        b.put((Object)210624, (Object)"\u5bbd\u7538\u6ee1\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)210681, (Object)"\u4e1c\u6e2f\u5e02");
        b.put((Object)210682, (Object)"\u51e4\u57ce\u5e02");
        b.put((Object)210700, (Object)"\u9526\u5dde\u5e02");
        b.put((Object)210702, (Object)"\u53e4\u5854\u533a");
        b.put((Object)210703, (Object)"\u51cc\u6cb3\u533a");
        b.put((Object)210711, (Object)"\u592a\u548c\u533a");
        b.put((Object)210726, (Object)"\u9ed1\u5c71\u53bf");
        b.put((Object)210727, (Object)"\u4e49\u53bf");
        b.put((Object)210781, (Object)"\u51cc\u6d77\u5e02");
        b.put((Object)210782, (Object)"\u5317\u9547\u5e02");
        b.put((Object)210800, (Object)"\u8425\u53e3\u5e02");
        b.put((Object)210802, (Object)"\u7ad9\u524d\u533a");
        b.put((Object)210803, (Object)"\u897f\u5e02\u533a");
        b.put((Object)210804, (Object)"\u9c85\u9c7c\u5708\u533a");
        b.put((Object)210811, (Object)"\u8001\u8fb9\u533a");
        b.put((Object)210881, (Object)"\u76d6\u5dde\u5e02");
        b.put((Object)210882, (Object)"\u5927\u77f3\u6865\u5e02");
        b.put((Object)210900, (Object)"\u961c\u65b0\u5e02");
        b.put((Object)210902, (Object)"\u6d77\u5dde\u533a");
        b.put((Object)210903, (Object)"\u65b0\u90b1\u533a");
        b.put((Object)210904, (Object)"\u592a\u5e73\u533a");
        b.put((Object)210905, (Object)"\u6e05\u6cb3\u95e8\u533a");
        b.put((Object)210911, (Object)"\u7ec6\u6cb3\u533a");
        b.put((Object)210921, (Object)"\u961c\u65b0\u8499\u53e4\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)210922, (Object)"\u5f70\u6b66\u53bf");
        b.put((Object)211000, (Object)"\u8fbd\u9633\u5e02");
        b.put((Object)211002, (Object)"\u767d\u5854\u533a");
        b.put((Object)211003, (Object)"\u6587\u5723\u533a");
        b.put((Object)211004, (Object)"\u5b8f\u4f1f\u533a");
        b.put((Object)211005, (Object)"\u5f13\u957f\u5cad\u533a");
        b.put((Object)211011, (Object)"\u592a\u5b50\u6cb3\u533a");
        b.put((Object)211021, (Object)"\u8fbd\u9633\u53bf");
        b.put((Object)211081, (Object)"\u706f\u5854\u5e02");
        b.put((Object)211100, (Object)"\u76d8\u9526\u5e02");
        b.put((Object)211102, (Object)"\u53cc\u53f0\u5b50\u533a");
        b.put((Object)211103, (Object)"\u5174\u9686\u53f0\u533a");
        b.put((Object)211104, (Object)"\u5927\u6d3c\u533a");
        b.put((Object)211122, (Object)"\u76d8\u5c71\u53bf");
        b.put((Object)211200, (Object)"\u94c1\u5cad\u5e02");
        b.put((Object)211202, (Object)"\u94f6\u5dde\u533a");
        b.put((Object)211204, (Object)"\u6e05\u6cb3\u533a");
        b.put((Object)211221, (Object)"\u94c1\u5cad\u53bf");
        b.put((Object)211223, (Object)"\u897f\u4e30\u53bf");
        b.put((Object)211224, (Object)"\u660c\u56fe\u53bf");
        b.put((Object)211281, (Object)"\u8c03\u5175\u5c71\u5e02");
        b.put((Object)211282, (Object)"\u5f00\u539f\u5e02");
        b.put((Object)211300, (Object)"\u671d\u9633\u5e02");
        b.put((Object)211302, (Object)"\u53cc\u5854\u533a");
        b.put((Object)211303, (Object)"\u9f99\u57ce\u533a");
        b.put((Object)211321, (Object)"\u671d\u9633\u53bf");
        b.put((Object)211322, (Object)"\u5efa\u5e73\u53bf");
        b.put((Object)211324, (Object)"\u5580\u5587\u6c81\u5de6\u7ffc\u8499\u53e4\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)211381, (Object)"\u5317\u7968\u5e02");
        b.put((Object)211382, (Object)"\u51cc\u6e90\u5e02");
        b.put((Object)211400, (Object)"\u846b\u82a6\u5c9b\u5e02");
        b.put((Object)211402, (Object)"\u8fde\u5c71\u533a");
        b.put((Object)211403, (Object)"\u9f99\u6e2f\u533a");
        b.put((Object)211404, (Object)"\u5357\u7968\u533a");
        b.put((Object)211421, (Object)"\u7ee5\u4e2d\u53bf");
        b.put((Object)211422, (Object)"\u5efa\u660c\u53bf");
        b.put((Object)211481, (Object)"\u5174\u57ce\u5e02");
        b.put((Object)220000, (Object)"\u5409\u6797\u7701");
        b.put((Object)220100, (Object)"\u957f\u6625\u5e02");
        b.put((Object)220102, (Object)"\u5357\u5173\u533a");
        b.put((Object)220103, (Object)"\u5bbd\u57ce\u533a");
        b.put((Object)220104, (Object)"\u671d\u9633\u533a");
        b.put((Object)220105, (Object)"\u4e8c\u9053\u533a");
        b.put((Object)220106, (Object)"\u7eff\u56ed\u533a");
        b.put((Object)220112, (Object)"\u53cc\u9633\u533a");
        b.put((Object)220113, (Object)"\u4e5d\u53f0\u533a");
        b.put((Object)220122, (Object)"\u519c\u5b89\u53bf");
        b.put((Object)220182, (Object)"\u6986\u6811\u5e02");
        b.put((Object)220183, (Object)"\u5fb7\u60e0\u5e02");
        b.put((Object)220200, (Object)"\u5409\u6797\u5e02");
        b.put((Object)220202, (Object)"\u660c\u9091\u533a");
        b.put((Object)220203, (Object)"\u9f99\u6f6d\u533a");
        b.put((Object)220204, (Object)"\u8239\u8425\u533a");
        b.put((Object)220211, (Object)"\u4e30\u6ee1\u533a");
        b.put((Object)220221, (Object)"\u6c38\u5409\u53bf");
        b.put((Object)220281, (Object)"\u86df\u6cb3\u5e02");
        b.put((Object)220282, (Object)"\u6866\u7538\u5e02");
        b.put((Object)220283, (Object)"\u8212\u5170\u5e02");
        b.put((Object)220284, (Object)"\u78d0\u77f3\u5e02");
        b.put((Object)220300, (Object)"\u56db\u5e73\u5e02");
        b.put((Object)220302, (Object)"\u94c1\u897f\u533a");
        b.put((Object)220303, (Object)"\u94c1\u4e1c\u533a");
        b.put((Object)220322, (Object)"\u68a8\u6811\u53bf");
        b.put((Object)220323, (Object)"\u4f0a\u901a\u6ee1\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)220381, (Object)"\u516c\u4e3b\u5cad\u5e02");
        b.put((Object)220382, (Object)"\u53cc\u8fbd\u5e02");
        b.put((Object)220400, (Object)"\u8fbd\u6e90\u5e02");
        b.put((Object)220402, (Object)"\u9f99\u5c71\u533a");
        b.put((Object)220403, (Object)"\u897f\u5b89\u533a");
        b.put((Object)220421, (Object)"\u4e1c\u4e30\u53bf");
        b.put((Object)220422, (Object)"\u4e1c\u8fbd\u53bf");
        b.put((Object)220500, (Object)"\u901a\u5316\u5e02");
        b.put((Object)220502, (Object)"\u4e1c\u660c\u533a");
        b.put((Object)220503, (Object)"\u4e8c\u9053\u6c5f\u533a");
        b.put((Object)220521, (Object)"\u901a\u5316\u53bf");
        b.put((Object)220523, (Object)"\u8f89\u5357\u53bf");
        b.put((Object)220524, (Object)"\u67f3\u6cb3\u53bf");
        b.put((Object)220581, (Object)"\u6885\u6cb3\u53e3\u5e02");
        b.put((Object)220582, (Object)"\u96c6\u5b89\u5e02");
        b.put((Object)220600, (Object)"\u767d\u5c71\u5e02");
        b.put((Object)220602, (Object)"\u6d51\u6c5f\u533a");
        b.put((Object)220605, (Object)"\u6c5f\u6e90\u533a");
        b.put((Object)220621, (Object)"\u629a\u677e\u53bf");
        b.put((Object)220622, (Object)"\u9756\u5b87\u53bf");
        b.put((Object)220623, (Object)"\u957f\u767d\u671d\u9c9c\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)220681, (Object)"\u4e34\u6c5f\u5e02");
        b.put((Object)220700, (Object)"\u677e\u539f\u5e02");
        b.put((Object)220702, (Object)"\u5b81\u6c5f\u533a");
        b.put((Object)220721, (Object)"\u524d\u90ed\u5c14\u7f57\u65af\u8499\u53e4\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)220722, (Object)"\u957f\u5cad\u53bf");
        b.put((Object)220723, (Object)"\u4e7e\u5b89\u53bf");
        b.put((Object)220781, (Object)"\u6276\u4f59\u5e02");
        b.put((Object)220800, (Object)"\u767d\u57ce\u5e02");
        b.put((Object)220802, (Object)"\u6d2e\u5317\u533a");
        b.put((Object)220821, (Object)"\u9547\u8d49\u53bf");
        b.put((Object)220822, (Object)"\u901a\u6986\u53bf");
        b.put((Object)220881, (Object)"\u6d2e\u5357\u5e02");
        b.put((Object)220882, (Object)"\u5927\u5b89\u5e02");
        b.put((Object)222400, (Object)"\u5ef6\u8fb9\u671d\u9c9c\u65cf\u81ea\u6cbb\u5dde");
        b.put((Object)222401, (Object)"\u5ef6\u5409\u5e02");
        b.put((Object)222402, (Object)"\u56fe\u4eec\u5e02");
        b.put((Object)222403, (Object)"\u6566\u5316\u5e02");
        b.put((Object)222404, (Object)"\u73f2\u6625\u5e02");
        b.put((Object)222405, (Object)"\u9f99\u4e95\u5e02");
        b.put((Object)222406, (Object)"\u548c\u9f99\u5e02");
        b.put((Object)222424, (Object)"\u6c6a\u6e05\u53bf");
        b.put((Object)222426, (Object)"\u5b89\u56fe\u53bf");
        b.put((Object)230000, (Object)"\u9ed1\u9f99\u6c5f\u7701");
        b.put((Object)230100, (Object)"\u54c8\u5c14\u6ee8\u5e02");
        b.put((Object)230102, (Object)"\u9053\u91cc\u533a");
        b.put((Object)230103, (Object)"\u5357\u5c97\u533a");
        b.put((Object)230104, (Object)"\u9053\u5916\u533a");
        b.put((Object)230108, (Object)"\u5e73\u623f\u533a");
        b.put((Object)230109, (Object)"\u677e\u5317\u533a");
        b.put((Object)230110, (Object)"\u9999\u574a\u533a");
        b.put((Object)230111, (Object)"\u547c\u5170\u533a");
        b.put((Object)230112, (Object)"\u963f\u57ce\u533a");
        b.put((Object)230113, (Object)"\u53cc\u57ce\u533a");
        b.put((Object)230123, (Object)"\u4f9d\u5170\u53bf");
        b.put((Object)230124, (Object)"\u65b9\u6b63\u53bf");
        b.put((Object)230125, (Object)"\u5bbe\u53bf");
        b.put((Object)230126, (Object)"\u5df4\u5f66\u53bf");
        b.put((Object)230127, (Object)"\u6728\u5170\u53bf");
        b.put((Object)230128, (Object)"\u901a\u6cb3\u53bf");
        b.put((Object)230129, (Object)"\u5ef6\u5bff\u53bf");
        b.put((Object)230183, (Object)"\u5c1a\u5fd7\u5e02");
        b.put((Object)230184, (Object)"\u4e94\u5e38\u5e02");
        b.put((Object)230200, (Object)"\u9f50\u9f50\u54c8\u5c14\u5e02");
        b.put((Object)230202, (Object)"\u9f99\u6c99\u533a");
        b.put((Object)230203, (Object)"\u5efa\u534e\u533a");
        b.put((Object)230204, (Object)"\u94c1\u950b\u533a");
        b.put((Object)230205, (Object)"\u6602\u6602\u6eaa\u533a");
        b.put((Object)230206, (Object)"\u5bcc\u62c9\u5c14\u57fa\u533a");
        b.put((Object)230207, (Object)"\u78be\u5b50\u5c71\u533a");
        b.put((Object)230208, (Object)"\u6885\u91cc\u65af\u8fbe\u65a1\u5c14\u65cf\u533a");
        b.put((Object)230221, (Object)"\u9f99\u6c5f\u53bf");
        b.put((Object)230223, (Object)"\u4f9d\u5b89\u53bf");
        b.put((Object)230224, (Object)"\u6cf0\u6765\u53bf");
        b.put((Object)230225, (Object)"\u7518\u5357\u53bf");
        b.put((Object)230227, (Object)"\u5bcc\u88d5\u53bf");
        b.put((Object)230229, (Object)"\u514b\u5c71\u53bf");
        b.put((Object)230230, (Object)"\u514b\u4e1c\u53bf");
        b.put((Object)230231, (Object)"\u62dc\u6cc9\u53bf");
        b.put((Object)230281, (Object)"\u8bb7\u6cb3\u5e02");
        b.put((Object)230300, (Object)"\u9e21\u897f\u5e02");
        b.put((Object)230302, (Object)"\u9e21\u51a0\u533a");
        b.put((Object)230303, (Object)"\u6052\u5c71\u533a");
        b.put((Object)230304, (Object)"\u6ef4\u9053\u533a");
        b.put((Object)230305, (Object)"\u68a8\u6811\u533a");
        b.put((Object)230306, (Object)"\u57ce\u5b50\u6cb3\u533a");
        b.put((Object)230307, (Object)"\u9ebb\u5c71\u533a");
        b.put((Object)230321, (Object)"\u9e21\u4e1c\u53bf");
        b.put((Object)230381, (Object)"\u864e\u6797\u5e02");
        b.put((Object)230382, (Object)"\u5bc6\u5c71\u5e02");
        b.put((Object)230400, (Object)"\u9e64\u5c97\u5e02");
        b.put((Object)230402, (Object)"\u5411\u9633\u533a");
        b.put((Object)230403, (Object)"\u5de5\u519c\u533a");
        b.put((Object)230404, (Object)"\u5357\u5c71\u533a");
        b.put((Object)230405, (Object)"\u5174\u5b89\u533a");
        b.put((Object)230406, (Object)"\u4e1c\u5c71\u533a");
        b.put((Object)230407, (Object)"\u5174\u5c71\u533a");
        b.put((Object)230421, (Object)"\u841d\u5317\u53bf");
        b.put((Object)230422, (Object)"\u7ee5\u6ee8\u53bf");
        b.put((Object)230500, (Object)"\u53cc\u9e2d\u5c71\u5e02");
        b.put((Object)230502, (Object)"\u5c16\u5c71\u533a");
        b.put((Object)230503, (Object)"\u5cad\u4e1c\u533a");
        b.put((Object)230505, (Object)"\u56db\u65b9\u53f0\u533a");
        b.put((Object)230506, (Object)"\u5b9d\u5c71\u533a");
        b.put((Object)230521, (Object)"\u96c6\u8d24\u53bf");
        b.put((Object)230522, (Object)"\u53cb\u8c0a\u53bf");
        b.put((Object)230523, (Object)"\u5b9d\u6e05\u53bf");
        b.put((Object)230524, (Object)"\u9976\u6cb3\u53bf");
        b.put((Object)230600, (Object)"\u5927\u5e86\u5e02");
        b.put((Object)230602, (Object)"\u8428\u5c14\u56fe\u533a");
        b.put((Object)230603, (Object)"\u9f99\u51e4\u533a");
        b.put((Object)230604, (Object)"\u8ba9\u80e1\u8def\u533a");
        b.put((Object)230605, (Object)"\u7ea2\u5c97\u533a");
        b.put((Object)230606, (Object)"\u5927\u540c\u533a");
        b.put((Object)230621, (Object)"\u8087\u5dde\u53bf");
        b.put((Object)230622, (Object)"\u8087\u6e90\u53bf");
        b.put((Object)230623, (Object)"\u6797\u7538\u53bf");
        b.put((Object)230624, (Object)"\u675c\u5c14\u4f2f\u7279\u8499\u53e4\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)230700, (Object)"\u4f0a\u6625\u5e02");
        b.put((Object)230702, (Object)"\u4f0a\u6625\u533a");
        b.put((Object)230703, (Object)"\u5357\u5c94\u533a");
        b.put((Object)230704, (Object)"\u53cb\u597d\u533a");
        b.put((Object)230705, (Object)"\u897f\u6797\u533a");
        b.put((Object)230706, (Object)"\u7fe0\u5ce6\u533a");
        b.put((Object)230707, (Object)"\u65b0\u9752\u533a");
        b.put((Object)230708, (Object)"\u7f8e\u6eaa\u533a");
        b.put((Object)230709, (Object)"\u91d1\u5c71\u5c6f\u533a");
        b.put((Object)230710, (Object)"\u4e94\u8425\u533a");
        b.put((Object)230711, (Object)"\u4e4c\u9a6c\u6cb3\u533a");
        b.put((Object)230712, (Object)"\u6c64\u65fa\u6cb3\u533a");
        b.put((Object)230713, (Object)"\u5e26\u5cad\u533a");
        b.put((Object)230714, (Object)"\u4e4c\u4f0a\u5cad\u533a");
        b.put((Object)230715, (Object)"\u7ea2\u661f\u533a");
        b.put((Object)230716, (Object)"\u4e0a\u7518\u5cad\u533a");
        b.put((Object)230722, (Object)"\u5609\u836b\u53bf");
        b.put((Object)230781, (Object)"\u94c1\u529b\u5e02");
        b.put((Object)230800, (Object)"\u4f73\u6728\u65af\u5e02");
        b.put((Object)230803, (Object)"\u5411\u9633\u533a");
        b.put((Object)230804, (Object)"\u524d\u8fdb\u533a");
        b.put((Object)230805, (Object)"\u4e1c\u98ce\u533a");
        b.put((Object)230811, (Object)"\u90ca\u533a");
        b.put((Object)230822, (Object)"\u6866\u5357\u53bf");
        b.put((Object)230826, (Object)"\u6866\u5ddd\u53bf");
        b.put((Object)230828, (Object)"\u6c64\u539f\u53bf");
        b.put((Object)230881, (Object)"\u540c\u6c5f\u5e02");
        b.put((Object)230882, (Object)"\u5bcc\u9526\u5e02");
        b.put((Object)230883, (Object)"\u629a\u8fdc\u5e02");
        b.put((Object)230900, (Object)"\u4e03\u53f0\u6cb3\u5e02");
        b.put((Object)230902, (Object)"\u65b0\u5174\u533a");
        b.put((Object)230903, (Object)"\u6843\u5c71\u533a");
        b.put((Object)230904, (Object)"\u8304\u5b50\u6cb3\u533a");
        b.put((Object)230921, (Object)"\u52c3\u5229\u53bf");
        b.put((Object)231000, (Object)"\u7261\u4e39\u6c5f\u5e02");
        b.put((Object)231002, (Object)"\u4e1c\u5b89\u533a");
        b.put((Object)231003, (Object)"\u9633\u660e\u533a");
        b.put((Object)231004, (Object)"\u7231\u6c11\u533a");
        b.put((Object)231005, (Object)"\u897f\u5b89\u533a");
        b.put((Object)231025, (Object)"\u6797\u53e3\u53bf");
        b.put((Object)231081, (Object)"\u7ee5\u82ac\u6cb3\u5e02");
        b.put((Object)231083, (Object)"\u6d77\u6797\u5e02");
        b.put((Object)231084, (Object)"\u5b81\u5b89\u5e02");
        b.put((Object)231085, (Object)"\u7a46\u68f1\u5e02");
        b.put((Object)231086, (Object)"\u4e1c\u5b81\u5e02");
        b.put((Object)231100, (Object)"\u9ed1\u6cb3\u5e02");
        b.put((Object)231102, (Object)"\u7231\u8f89\u533a");
        b.put((Object)231121, (Object)"\u5ae9\u6c5f\u53bf");
        b.put((Object)231123, (Object)"\u900a\u514b\u53bf");
        b.put((Object)231124, (Object)"\u5b59\u5434\u53bf");
        b.put((Object)231181, (Object)"\u5317\u5b89\u5e02");
        b.put((Object)231182, (Object)"\u4e94\u5927\u8fde\u6c60\u5e02");
        b.put((Object)231200, (Object)"\u7ee5\u5316\u5e02");
        b.put((Object)231202, (Object)"\u5317\u6797\u533a");
        b.put((Object)231221, (Object)"\u671b\u594e\u53bf");
        b.put((Object)231222, (Object)"\u5170\u897f\u53bf");
        b.put((Object)231223, (Object)"\u9752\u5188\u53bf");
        b.put((Object)231224, (Object)"\u5e86\u5b89\u53bf");
        b.put((Object)231225, (Object)"\u660e\u6c34\u53bf");
        b.put((Object)231226, (Object)"\u7ee5\u68f1\u53bf");
        b.put((Object)231281, (Object)"\u5b89\u8fbe\u5e02");
        b.put((Object)231282, (Object)"\u8087\u4e1c\u5e02");
        b.put((Object)231283, (Object)"\u6d77\u4f26\u5e02");
        b.put((Object)232700, (Object)"\u5927\u5174\u5b89\u5cad\u5730\u533a");
        b.put((Object)232701, (Object)"\u6f20\u6cb3\u5e02");
        b.put((Object)232721, (Object)"\u547c\u739b\u53bf");
        b.put((Object)232722, (Object)"\u5854\u6cb3\u53bf");
        b.put((Object)310000, (Object)"\u4e0a\u6d77\u5e02");
        b.put((Object)310101, (Object)"\u9ec4\u6d66\u533a");
        b.put((Object)310104, (Object)"\u5f90\u6c47\u533a");
        b.put((Object)310105, (Object)"\u957f\u5b81\u533a");
        b.put((Object)310106, (Object)"\u9759\u5b89\u533a");
        b.put((Object)310107, (Object)"\u666e\u9640\u533a");
        b.put((Object)310109, (Object)"\u8679\u53e3\u533a");
        b.put((Object)310110, (Object)"\u6768\u6d66\u533a");
        b.put((Object)310112, (Object)"\u95f5\u884c\u533a");
        b.put((Object)310113, (Object)"\u5b9d\u5c71\u533a");
        b.put((Object)310114, (Object)"\u5609\u5b9a\u533a");
        b.put((Object)310115, (Object)"\u6d66\u4e1c\u65b0\u533a");
        b.put((Object)310116, (Object)"\u91d1\u5c71\u533a");
        b.put((Object)310117, (Object)"\u677e\u6c5f\u533a");
        b.put((Object)310118, (Object)"\u9752\u6d66\u533a");
        b.put((Object)310120, (Object)"\u5949\u8d24\u533a");
        b.put((Object)310151, (Object)"\u5d07\u660e\u533a");
        b.put((Object)320000, (Object)"\u6c5f\u82cf\u7701");
        b.put((Object)320100, (Object)"\u5357\u4eac\u5e02");
        b.put((Object)320102, (Object)"\u7384\u6b66\u533a");
        b.put((Object)320104, (Object)"\u79e6\u6dee\u533a");
        b.put((Object)320105, (Object)"\u5efa\u90ba\u533a");
        b.put((Object)320106, (Object)"\u9f13\u697c\u533a");
        b.put((Object)320111, (Object)"\u6d66\u53e3\u533a");
        b.put((Object)320113, (Object)"\u6816\u971e\u533a");
        b.put((Object)320114, (Object)"\u96e8\u82b1\u53f0\u533a");
        b.put((Object)320115, (Object)"\u6c5f\u5b81\u533a");
        b.put((Object)320116, (Object)"\u516d\u5408\u533a");
        b.put((Object)320117, (Object)"\u6ea7\u6c34\u533a");
        b.put((Object)320118, (Object)"\u9ad8\u6df3\u533a");
        b.put((Object)320200, (Object)"\u65e0\u9521\u5e02");
        b.put((Object)320205, (Object)"\u9521\u5c71\u533a");
        b.put((Object)320206, (Object)"\u60e0\u5c71\u533a");
        b.put((Object)320211, (Object)"\u6ee8\u6e56\u533a");
        b.put((Object)320213, (Object)"\u6881\u6eaa\u533a");
        b.put((Object)320214, (Object)"\u65b0\u5434\u533a");
        b.put((Object)320281, (Object)"\u6c5f\u9634\u5e02");
        b.put((Object)320282, (Object)"\u5b9c\u5174\u5e02");
        b.put((Object)320300, (Object)"\u5f90\u5dde\u5e02");
        b.put((Object)320302, (Object)"\u9f13\u697c\u533a");
        b.put((Object)320303, (Object)"\u4e91\u9f99\u533a");
        b.put((Object)320305, (Object)"\u8d3e\u6c6a\u533a");
        b.put((Object)320311, (Object)"\u6cc9\u5c71\u533a");
        b.put((Object)320312, (Object)"\u94dc\u5c71\u533a");
        b.put((Object)320321, (Object)"\u4e30\u53bf");
        b.put((Object)320322, (Object)"\u6c9b\u53bf");
        b.put((Object)320324, (Object)"\u7762\u5b81\u53bf");
        b.put((Object)320381, (Object)"\u65b0\u6c82\u5e02");
        b.put((Object)320382, (Object)"\u90b3\u5dde\u5e02");
        b.put((Object)320400, (Object)"\u5e38\u5dde\u5e02");
        b.put((Object)320402, (Object)"\u5929\u5b81\u533a");
        b.put((Object)320404, (Object)"\u949f\u697c\u533a");
        b.put((Object)320411, (Object)"\u65b0\u5317\u533a");
        b.put((Object)320412, (Object)"\u6b66\u8fdb\u533a");
        b.put((Object)320413, (Object)"\u91d1\u575b\u533a");
        b.put((Object)320481, (Object)"\u6ea7\u9633\u5e02");
        b.put((Object)320500, (Object)"\u82cf\u5dde\u5e02");
        b.put((Object)320505, (Object)"\u864e\u4e18\u533a");
        b.put((Object)320506, (Object)"\u5434\u4e2d\u533a");
        b.put((Object)320507, (Object)"\u76f8\u57ce\u533a");
        b.put((Object)320508, (Object)"\u59d1\u82cf\u533a");
        b.put((Object)320509, (Object)"\u5434\u6c5f\u533a");
        b.put((Object)320581, (Object)"\u5e38\u719f\u5e02");
        b.put((Object)320582, (Object)"\u5f20\u5bb6\u6e2f\u5e02");
        b.put((Object)320583, (Object)"\u6606\u5c71\u5e02");
        b.put((Object)320585, (Object)"\u592a\u4ed3\u5e02");
        b.put((Object)320600, (Object)"\u5357\u901a\u5e02");
        b.put((Object)320602, (Object)"\u5d07\u5ddd\u533a");
        b.put((Object)320611, (Object)"\u6e2f\u95f8\u533a");
        b.put((Object)320612, (Object)"\u901a\u5dde\u533a");
        b.put((Object)320623, (Object)"\u5982\u4e1c\u53bf");
        b.put((Object)320681, (Object)"\u542f\u4e1c\u5e02");
        b.put((Object)320682, (Object)"\u5982\u768b\u5e02");
        b.put((Object)320684, (Object)"\u6d77\u95e8\u5e02");
        b.put((Object)320685, (Object)"\u6d77\u5b89\u5e02");
        b.put((Object)320700, (Object)"\u8fde\u4e91\u6e2f\u5e02");
        b.put((Object)320703, (Object)"\u8fde\u4e91\u533a");
        b.put((Object)320706, (Object)"\u6d77\u5dde\u533a");
        b.put((Object)320707, (Object)"\u8d63\u6986\u533a");
        b.put((Object)320722, (Object)"\u4e1c\u6d77\u53bf");
        b.put((Object)320723, (Object)"\u704c\u4e91\u53bf");
        b.put((Object)320724, (Object)"\u704c\u5357\u53bf");
        b.put((Object)320800, (Object)"\u6dee\u5b89\u5e02");
        b.put((Object)320803, (Object)"\u6dee\u5b89\u533a");
        b.put((Object)320804, (Object)"\u6dee\u9634\u533a");
        b.put((Object)320812, (Object)"\u6e05\u6c5f\u6d66\u533a");
        b.put((Object)320813, (Object)"\u6d2a\u6cfd\u533a");
        b.put((Object)320826, (Object)"\u6d9f\u6c34\u53bf");
        b.put((Object)320830, (Object)"\u76f1\u7719\u53bf");
        b.put((Object)320831, (Object)"\u91d1\u6e56\u53bf");
        b.put((Object)320900, (Object)"\u76d0\u57ce\u5e02");
        b.put((Object)320902, (Object)"\u4ead\u6e56\u533a");
        b.put((Object)320903, (Object)"\u76d0\u90fd\u533a");
        b.put((Object)320904, (Object)"\u5927\u4e30\u533a");
        b.put((Object)320921, (Object)"\u54cd\u6c34\u53bf");
        b.put((Object)320922, (Object)"\u6ee8\u6d77\u53bf");
        b.put((Object)320923, (Object)"\u961c\u5b81\u53bf");
        b.put((Object)320924, (Object)"\u5c04\u9633\u53bf");
        b.put((Object)320925, (Object)"\u5efa\u6e56\u53bf");
        b.put((Object)320981, (Object)"\u4e1c\u53f0\u5e02");
        b.put((Object)321000, (Object)"\u626c\u5dde\u5e02");
        b.put((Object)321002, (Object)"\u5e7f\u9675\u533a");
        b.put((Object)321003, (Object)"\u9097\u6c5f\u533a");
        b.put((Object)321012, (Object)"\u6c5f\u90fd\u533a");
        b.put((Object)321023, (Object)"\u5b9d\u5e94\u53bf");
        b.put((Object)321081, (Object)"\u4eea\u5f81\u5e02");
        b.put((Object)321084, (Object)"\u9ad8\u90ae\u5e02");
        b.put((Object)321100, (Object)"\u9547\u6c5f\u5e02");
        b.put((Object)321102, (Object)"\u4eac\u53e3\u533a");
        b.put((Object)321111, (Object)"\u6da6\u5dde\u533a");
        b.put((Object)321112, (Object)"\u4e39\u5f92\u533a");
        b.put((Object)321181, (Object)"\u4e39\u9633\u5e02");
        b.put((Object)321182, (Object)"\u626c\u4e2d\u5e02");
        b.put((Object)321183, (Object)"\u53e5\u5bb9\u5e02");
        b.put((Object)321200, (Object)"\u6cf0\u5dde\u5e02");
        b.put((Object)321202, (Object)"\u6d77\u9675\u533a");
        b.put((Object)321203, (Object)"\u9ad8\u6e2f\u533a");
        b.put((Object)321204, (Object)"\u59dc\u5830\u533a");
        b.put((Object)321281, (Object)"\u5174\u5316\u5e02");
        b.put((Object)321282, (Object)"\u9756\u6c5f\u5e02");
        b.put((Object)321283, (Object)"\u6cf0\u5174\u5e02");
        b.put((Object)321300, (Object)"\u5bbf\u8fc1\u5e02");
        b.put((Object)321302, (Object)"\u5bbf\u57ce\u533a");
        b.put((Object)321311, (Object)"\u5bbf\u8c6b\u533a");
        b.put((Object)321322, (Object)"\u6cad\u9633\u53bf");
        b.put((Object)321323, (Object)"\u6cd7\u9633\u53bf");
        b.put((Object)321324, (Object)"\u6cd7\u6d2a\u53bf");
        b.put((Object)330000, (Object)"\u6d59\u6c5f\u7701");
        b.put((Object)330100, (Object)"\u676d\u5dde\u5e02");
        b.put((Object)330102, (Object)"\u4e0a\u57ce\u533a");
        b.put((Object)330103, (Object)"\u4e0b\u57ce\u533a");
        b.put((Object)330104, (Object)"\u6c5f\u5e72\u533a");
        b.put((Object)330105, (Object)"\u62f1\u5885\u533a");
        b.put((Object)330106, (Object)"\u897f\u6e56\u533a");
        b.put((Object)330108, (Object)"\u6ee8\u6c5f\u533a");
        b.put((Object)330109, (Object)"\u8427\u5c71\u533a");
        b.put((Object)330110, (Object)"\u4f59\u676d\u533a");
        b.put((Object)330111, (Object)"\u5bcc\u9633\u533a");
        b.put((Object)330112, (Object)"\u4e34\u5b89\u533a");
        b.put((Object)330122, (Object)"\u6850\u5e90\u53bf");
        b.put((Object)330127, (Object)"\u6df3\u5b89\u53bf");
        b.put((Object)330182, (Object)"\u5efa\u5fb7\u5e02");
        b.put((Object)330200, (Object)"\u5b81\u6ce2\u5e02");
        b.put((Object)330203, (Object)"\u6d77\u66d9\u533a");
        b.put((Object)330205, (Object)"\u6c5f\u5317\u533a");
        b.put((Object)330206, (Object)"\u5317\u4ed1\u533a");
        b.put((Object)330211, (Object)"\u9547\u6d77\u533a");
        b.put((Object)330212, (Object)"\u911e\u5dde\u533a");
        b.put((Object)330213, (Object)"\u5949\u5316\u533a");
        b.put((Object)330225, (Object)"\u8c61\u5c71\u53bf");
        b.put((Object)330226, (Object)"\u5b81\u6d77\u53bf");
        b.put((Object)330281, (Object)"\u4f59\u59da\u5e02");
        b.put((Object)330282, (Object)"\u6148\u6eaa\u5e02");
        b.put((Object)330300, (Object)"\u6e29\u5dde\u5e02");
        b.put((Object)330302, (Object)"\u9e7f\u57ce\u533a");
        b.put((Object)330303, (Object)"\u9f99\u6e7e\u533a");
        b.put((Object)330304, (Object)"\u74ef\u6d77\u533a");
        b.put((Object)330305, (Object)"\u6d1e\u5934\u533a");
        b.put((Object)330324, (Object)"\u6c38\u5609\u53bf");
        b.put((Object)330326, (Object)"\u5e73\u9633\u53bf");
        b.put((Object)330327, (Object)"\u82cd\u5357\u53bf");
        b.put((Object)330328, (Object)"\u6587\u6210\u53bf");
        b.put((Object)330329, (Object)"\u6cf0\u987a\u53bf");
        b.put((Object)330381, (Object)"\u745e\u5b89\u5e02");
        b.put((Object)330382, (Object)"\u4e50\u6e05\u5e02");
        b.put((Object)330400, (Object)"\u5609\u5174\u5e02");
        b.put((Object)330402, (Object)"\u5357\u6e56\u533a");
        b.put((Object)330411, (Object)"\u79c0\u6d32\u533a");
        b.put((Object)330421, (Object)"\u5609\u5584\u53bf");
        b.put((Object)330424, (Object)"\u6d77\u76d0\u53bf");
        b.put((Object)330481, (Object)"\u6d77\u5b81\u5e02");
        b.put((Object)330482, (Object)"\u5e73\u6e56\u5e02");
        b.put((Object)330483, (Object)"\u6850\u4e61\u5e02");
        b.put((Object)330500, (Object)"\u6e56\u5dde\u5e02");
        b.put((Object)330502, (Object)"\u5434\u5174\u533a");
        b.put((Object)330503, (Object)"\u5357\u6d54\u533a");
        b.put((Object)330521, (Object)"\u5fb7\u6e05\u53bf");
        b.put((Object)330522, (Object)"\u957f\u5174\u53bf");
        b.put((Object)330523, (Object)"\u5b89\u5409\u53bf");
        b.put((Object)330600, (Object)"\u7ecd\u5174\u5e02");
        b.put((Object)330602, (Object)"\u8d8a\u57ce\u533a");
        b.put((Object)330603, (Object)"\u67ef\u6865\u533a");
        b.put((Object)330604, (Object)"\u4e0a\u865e\u533a");
        b.put((Object)330624, (Object)"\u65b0\u660c\u53bf");
        b.put((Object)330681, (Object)"\u8bf8\u66a8\u5e02");
        b.put((Object)330683, (Object)"\u5d4a\u5dde\u5e02");
        b.put((Object)330700, (Object)"\u91d1\u534e\u5e02");
        b.put((Object)330702, (Object)"\u5a7a\u57ce\u533a");
        b.put((Object)330703, (Object)"\u91d1\u4e1c\u533a");
        b.put((Object)330723, (Object)"\u6b66\u4e49\u53bf");
        b.put((Object)330726, (Object)"\u6d66\u6c5f\u53bf");
        b.put((Object)330727, (Object)"\u78d0\u5b89\u53bf");
        b.put((Object)330781, (Object)"\u5170\u6eaa\u5e02");
        b.put((Object)330782, (Object)"\u4e49\u4e4c\u5e02");
        b.put((Object)330783, (Object)"\u4e1c\u9633\u5e02");
        b.put((Object)330784, (Object)"\u6c38\u5eb7\u5e02");
        b.put((Object)330800, (Object)"\u8862\u5dde\u5e02");
        b.put((Object)330802, (Object)"\u67ef\u57ce\u533a");
        b.put((Object)330803, (Object)"\u8862\u6c5f\u533a");
        b.put((Object)330822, (Object)"\u5e38\u5c71\u53bf");
        b.put((Object)330824, (Object)"\u5f00\u5316\u53bf");
        b.put((Object)330825, (Object)"\u9f99\u6e38\u53bf");
        b.put((Object)330881, (Object)"\u6c5f\u5c71\u5e02");
        b.put((Object)330900, (Object)"\u821f\u5c71\u5e02");
        b.put((Object)330902, (Object)"\u5b9a\u6d77\u533a");
        b.put((Object)330903, (Object)"\u666e\u9640\u533a");
        b.put((Object)330921, (Object)"\u5cb1\u5c71\u53bf");
        b.put((Object)330922, (Object)"\u5d4a\u6cd7\u53bf");
        b.put((Object)331000, (Object)"\u53f0\u5dde\u5e02");
        b.put((Object)331002, (Object)"\u6912\u6c5f\u533a");
        b.put((Object)331003, (Object)"\u9ec4\u5ca9\u533a");
        b.put((Object)331004, (Object)"\u8def\u6865\u533a");
        b.put((Object)331022, (Object)"\u4e09\u95e8\u53bf");
        b.put((Object)331023, (Object)"\u5929\u53f0\u53bf");
        b.put((Object)331024, (Object)"\u4ed9\u5c45\u53bf");
        b.put((Object)331081, (Object)"\u6e29\u5cad\u5e02");
        b.put((Object)331082, (Object)"\u4e34\u6d77\u5e02");
        b.put((Object)331083, (Object)"\u7389\u73af\u5e02");
        b.put((Object)331100, (Object)"\u4e3d\u6c34\u5e02");
        b.put((Object)331102, (Object)"\u83b2\u90fd\u533a");
        b.put((Object)331121, (Object)"\u9752\u7530\u53bf");
        b.put((Object)331122, (Object)"\u7f19\u4e91\u53bf");
        b.put((Object)331123, (Object)"\u9042\u660c\u53bf");
        b.put((Object)331124, (Object)"\u677e\u9633\u53bf");
        b.put((Object)331125, (Object)"\u4e91\u548c\u53bf");
        b.put((Object)331126, (Object)"\u5e86\u5143\u53bf");
        b.put((Object)331127, (Object)"\u666f\u5b81\u7572\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)331181, (Object)"\u9f99\u6cc9\u5e02");
        b.put((Object)340000, (Object)"\u5b89\u5fbd\u7701");
        b.put((Object)340100, (Object)"\u5408\u80a5\u5e02");
        b.put((Object)340102, (Object)"\u7476\u6d77\u533a");
        b.put((Object)340103, (Object)"\u5e90\u9633\u533a");
        b.put((Object)340104, (Object)"\u8700\u5c71\u533a");
        b.put((Object)340111, (Object)"\u5305\u6cb3\u533a");
        b.put((Object)340121, (Object)"\u957f\u4e30\u53bf");
        b.put((Object)340122, (Object)"\u80a5\u4e1c\u53bf");
        b.put((Object)340123, (Object)"\u80a5\u897f\u53bf");
        b.put((Object)340124, (Object)"\u5e90\u6c5f\u53bf");
        b.put((Object)340181, (Object)"\u5de2\u6e56\u5e02");
        b.put((Object)340200, (Object)"\u829c\u6e56\u5e02");
        b.put((Object)340202, (Object)"\u955c\u6e56\u533a");
        b.put((Object)340203, (Object)"\u5f0b\u6c5f\u533a");
        b.put((Object)340207, (Object)"\u9e20\u6c5f\u533a");
        b.put((Object)340208, (Object)"\u4e09\u5c71\u533a");
        b.put((Object)340221, (Object)"\u829c\u6e56\u53bf");
        b.put((Object)340222, (Object)"\u7e41\u660c\u53bf");
        b.put((Object)340223, (Object)"\u5357\u9675\u53bf");
        b.put((Object)340225, (Object)"\u65e0\u4e3a\u53bf");
        b.put((Object)340300, (Object)"\u868c\u57e0\u5e02");
        b.put((Object)340302, (Object)"\u9f99\u5b50\u6e56\u533a");
        b.put((Object)340303, (Object)"\u868c\u5c71\u533a");
        b.put((Object)340304, (Object)"\u79b9\u4f1a\u533a");
        b.put((Object)340311, (Object)"\u6dee\u4e0a\u533a");
        b.put((Object)340321, (Object)"\u6000\u8fdc\u53bf");
        b.put((Object)340322, (Object)"\u4e94\u6cb3\u53bf");
        b.put((Object)340323, (Object)"\u56fa\u9547\u53bf");
        b.put((Object)340400, (Object)"\u6dee\u5357\u5e02");
        b.put((Object)340402, (Object)"\u5927\u901a\u533a");
        b.put((Object)340403, (Object)"\u7530\u5bb6\u5eb5\u533a");
        b.put((Object)340404, (Object)"\u8c22\u5bb6\u96c6\u533a");
        b.put((Object)340405, (Object)"\u516b\u516c\u5c71\u533a");
        b.put((Object)340406, (Object)"\u6f58\u96c6\u533a");
        b.put((Object)340421, (Object)"\u51e4\u53f0\u53bf");
        b.put((Object)340422, (Object)"\u5bff\u53bf");
        b.put((Object)340500, (Object)"\u9a6c\u978d\u5c71\u5e02");
        b.put((Object)340503, (Object)"\u82b1\u5c71\u533a");
        b.put((Object)340504, (Object)"\u96e8\u5c71\u533a");
        b.put((Object)340506, (Object)"\u535a\u671b\u533a");
        b.put((Object)340521, (Object)"\u5f53\u6d82\u53bf");
        b.put((Object)340522, (Object)"\u542b\u5c71\u53bf");
        b.put((Object)340523, (Object)"\u548c\u53bf");
        b.put((Object)340600, (Object)"\u6dee\u5317\u5e02");
        b.put((Object)340602, (Object)"\u675c\u96c6\u533a");
        b.put((Object)340603, (Object)"\u76f8\u5c71\u533a");
        b.put((Object)340604, (Object)"\u70c8\u5c71\u533a");
        b.put((Object)340621, (Object)"\u6fc9\u6eaa\u53bf");
        b.put((Object)340700, (Object)"\u94dc\u9675\u5e02");
        b.put((Object)340705, (Object)"\u94dc\u5b98\u533a");
        b.put((Object)340706, (Object)"\u4e49\u5b89\u533a");
        b.put((Object)340711, (Object)"\u90ca\u533a");
        b.put((Object)340722, (Object)"\u679e\u9633\u53bf");
        b.put((Object)340800, (Object)"\u5b89\u5e86\u5e02");
        b.put((Object)340802, (Object)"\u8fce\u6c5f\u533a");
        b.put((Object)340803, (Object)"\u5927\u89c2\u533a");
        b.put((Object)340811, (Object)"\u5b9c\u79c0\u533a");
        b.put((Object)340822, (Object)"\u6000\u5b81\u53bf");
        b.put((Object)340824, (Object)"\u6f5c\u5c71\u53bf");
        b.put((Object)340825, (Object)"\u592a\u6e56\u53bf");
        b.put((Object)340826, (Object)"\u5bbf\u677e\u53bf");
        b.put((Object)340827, (Object)"\u671b\u6c5f\u53bf");
        b.put((Object)340828, (Object)"\u5cb3\u897f\u53bf");
        b.put((Object)340881, (Object)"\u6850\u57ce\u5e02");
        b.put((Object)341000, (Object)"\u9ec4\u5c71\u5e02");
        b.put((Object)341002, (Object)"\u5c6f\u6eaa\u533a");
        b.put((Object)341003, (Object)"\u9ec4\u5c71\u533a");
        b.put((Object)341004, (Object)"\u5fbd\u5dde\u533a");
        b.put((Object)341021, (Object)"\u6b59\u53bf");
        b.put((Object)341022, (Object)"\u4f11\u5b81\u53bf");
        b.put((Object)341023, (Object)"\u9edf\u53bf");
        b.put((Object)341024, (Object)"\u7941\u95e8\u53bf");
        b.put((Object)341100, (Object)"\u6ec1\u5dde\u5e02");
        b.put((Object)341102, (Object)"\u7405\u740a\u533a");
        b.put((Object)341103, (Object)"\u5357\u8c2f\u533a");
        b.put((Object)341122, (Object)"\u6765\u5b89\u53bf");
        b.put((Object)341124, (Object)"\u5168\u6912\u53bf");
        b.put((Object)341125, (Object)"\u5b9a\u8fdc\u53bf");
        b.put((Object)341126, (Object)"\u51e4\u9633\u53bf");
        b.put((Object)341181, (Object)"\u5929\u957f\u5e02");
        b.put((Object)341182, (Object)"\u660e\u5149\u5e02");
        b.put((Object)341200, (Object)"\u961c\u9633\u5e02");
        b.put((Object)341202, (Object)"\u988d\u5dde\u533a");
        b.put((Object)341203, (Object)"\u988d\u4e1c\u533a");
        b.put((Object)341204, (Object)"\u988d\u6cc9\u533a");
        b.put((Object)341221, (Object)"\u4e34\u6cc9\u53bf");
        b.put((Object)341222, (Object)"\u592a\u548c\u53bf");
        b.put((Object)341225, (Object)"\u961c\u5357\u53bf");
        b.put((Object)341226, (Object)"\u988d\u4e0a\u53bf");
        b.put((Object)341282, (Object)"\u754c\u9996\u5e02");
        b.put((Object)341300, (Object)"\u5bbf\u5dde\u5e02");
        b.put((Object)341302, (Object)"\u57c7\u6865\u533a");
        b.put((Object)341321, (Object)"\u7800\u5c71\u53bf");
        b.put((Object)341322, (Object)"\u8427\u53bf");
        b.put((Object)341323, (Object)"\u7075\u74a7\u53bf");
        b.put((Object)341324, (Object)"\u6cd7\u53bf");
        b.put((Object)341500, (Object)"\u516d\u5b89\u5e02");
        b.put((Object)341502, (Object)"\u91d1\u5b89\u533a");
        b.put((Object)341503, (Object)"\u88d5\u5b89\u533a");
        b.put((Object)341504, (Object)"\u53f6\u96c6\u533a");
        b.put((Object)341522, (Object)"\u970d\u90b1\u53bf");
        b.put((Object)341523, (Object)"\u8212\u57ce\u53bf");
        b.put((Object)341524, (Object)"\u91d1\u5be8\u53bf");
        b.put((Object)341525, (Object)"\u970d\u5c71\u53bf");
        b.put((Object)341600, (Object)"\u4eb3\u5dde\u5e02");
        b.put((Object)341602, (Object)"\u8c2f\u57ce\u533a");
        b.put((Object)341621, (Object)"\u6da1\u9633\u53bf");
        b.put((Object)341622, (Object)"\u8499\u57ce\u53bf");
        b.put((Object)341623, (Object)"\u5229\u8f9b\u53bf");
        b.put((Object)341700, (Object)"\u6c60\u5dde\u5e02");
        b.put((Object)341702, (Object)"\u8d35\u6c60\u533a");
        b.put((Object)341721, (Object)"\u4e1c\u81f3\u53bf");
        b.put((Object)341722, (Object)"\u77f3\u53f0\u53bf");
        b.put((Object)341723, (Object)"\u9752\u9633\u53bf");
        b.put((Object)341800, (Object)"\u5ba3\u57ce\u5e02");
        b.put((Object)341802, (Object)"\u5ba3\u5dde\u533a");
        b.put((Object)341821, (Object)"\u90ce\u6eaa\u53bf");
        b.put((Object)341822, (Object)"\u5e7f\u5fb7\u53bf");
        b.put((Object)341823, (Object)"\u6cfe\u53bf");
        b.put((Object)341824, (Object)"\u7ee9\u6eaa\u53bf");
        b.put((Object)341825, (Object)"\u65cc\u5fb7\u53bf");
        b.put((Object)341881, (Object)"\u5b81\u56fd\u5e02");
        b.put((Object)350000, (Object)"\u798f\u5efa\u7701");
        b.put((Object)350100, (Object)"\u798f\u5dde\u5e02");
        b.put((Object)350102, (Object)"\u9f13\u697c\u533a");
        b.put((Object)350103, (Object)"\u53f0\u6c5f\u533a");
        b.put((Object)350104, (Object)"\u4ed3\u5c71\u533a");
        b.put((Object)350105, (Object)"\u9a6c\u5c3e\u533a");
        b.put((Object)350111, (Object)"\u664b\u5b89\u533a");
        b.put((Object)350112, (Object)"\u957f\u4e50\u533a");
        b.put((Object)350121, (Object)"\u95fd\u4faf\u53bf");
        b.put((Object)350122, (Object)"\u8fde\u6c5f\u53bf");
        b.put((Object)350123, (Object)"\u7f57\u6e90\u53bf");
        b.put((Object)350124, (Object)"\u95fd\u6e05\u53bf");
        b.put((Object)350125, (Object)"\u6c38\u6cf0\u53bf");
        b.put((Object)350128, (Object)"\u5e73\u6f6d\u53bf");
        b.put((Object)350181, (Object)"\u798f\u6e05\u5e02");
        b.put((Object)350200, (Object)"\u53a6\u95e8\u5e02");
        b.put((Object)350203, (Object)"\u601d\u660e\u533a");
        b.put((Object)350205, (Object)"\u6d77\u6ca7\u533a");
        b.put((Object)350206, (Object)"\u6e56\u91cc\u533a");
        b.put((Object)350211, (Object)"\u96c6\u7f8e\u533a");
        b.put((Object)350212, (Object)"\u540c\u5b89\u533a");
        b.put((Object)350213, (Object)"\u7fd4\u5b89\u533a");
        b.put((Object)350300, (Object)"\u8386\u7530\u5e02");
        b.put((Object)350302, (Object)"\u57ce\u53a2\u533a");
        b.put((Object)350303, (Object)"\u6db5\u6c5f\u533a");
        b.put((Object)350304, (Object)"\u8354\u57ce\u533a");
        b.put((Object)350305, (Object)"\u79c0\u5c7f\u533a");
        b.put((Object)350322, (Object)"\u4ed9\u6e38\u53bf");
        b.put((Object)350400, (Object)"\u4e09\u660e\u5e02");
        b.put((Object)350402, (Object)"\u6885\u5217\u533a");
        b.put((Object)350403, (Object)"\u4e09\u5143\u533a");
        b.put((Object)350421, (Object)"\u660e\u6eaa\u53bf");
        b.put((Object)350423, (Object)"\u6e05\u6d41\u53bf");
        b.put((Object)350424, (Object)"\u5b81\u5316\u53bf");
        b.put((Object)350425, (Object)"\u5927\u7530\u53bf");
        b.put((Object)350426, (Object)"\u5c24\u6eaa\u53bf");
        b.put((Object)350427, (Object)"\u6c99\u53bf");
        b.put((Object)350428, (Object)"\u5c06\u4e50\u53bf");
        b.put((Object)350429, (Object)"\u6cf0\u5b81\u53bf");
        b.put((Object)350430, (Object)"\u5efa\u5b81\u53bf");
        b.put((Object)350481, (Object)"\u6c38\u5b89\u5e02");
        b.put((Object)350500, (Object)"\u6cc9\u5dde\u5e02");
        b.put((Object)350502, (Object)"\u9ca4\u57ce\u533a");
        b.put((Object)350503, (Object)"\u4e30\u6cfd\u533a");
        b.put((Object)350504, (Object)"\u6d1b\u6c5f\u533a");
        b.put((Object)350505, (Object)"\u6cc9\u6e2f\u533a");
        b.put((Object)350521, (Object)"\u60e0\u5b89\u53bf");
        b.put((Object)350524, (Object)"\u5b89\u6eaa\u53bf");
        b.put((Object)350525, (Object)"\u6c38\u6625\u53bf");
        b.put((Object)350526, (Object)"\u5fb7\u5316\u53bf");
        b.put((Object)350527, (Object)"\u91d1\u95e8\u53bf");
        b.put((Object)350581, (Object)"\u77f3\u72ee\u5e02");
        b.put((Object)350582, (Object)"\u664b\u6c5f\u5e02");
        b.put((Object)350583, (Object)"\u5357\u5b89\u5e02");
        b.put((Object)350600, (Object)"\u6f33\u5dde\u5e02");
        b.put((Object)350602, (Object)"\u8297\u57ce\u533a");
        b.put((Object)350603, (Object)"\u9f99\u6587\u533a");
        b.put((Object)350622, (Object)"\u4e91\u9704\u53bf");
        b.put((Object)350623, (Object)"\u6f33\u6d66\u53bf");
        b.put((Object)350624, (Object)"\u8bcf\u5b89\u53bf");
        b.put((Object)350625, (Object)"\u957f\u6cf0\u53bf");
        b.put((Object)350626, (Object)"\u4e1c\u5c71\u53bf");
        b.put((Object)350627, (Object)"\u5357\u9756\u53bf");
        b.put((Object)350628, (Object)"\u5e73\u548c\u53bf");
        b.put((Object)350629, (Object)"\u534e\u5b89\u53bf");
        b.put((Object)350681, (Object)"\u9f99\u6d77\u5e02");
        b.put((Object)350700, (Object)"\u5357\u5e73\u5e02");
        b.put((Object)350702, (Object)"\u5ef6\u5e73\u533a");
        b.put((Object)350703, (Object)"\u5efa\u9633\u533a");
        b.put((Object)350721, (Object)"\u987a\u660c\u53bf");
        b.put((Object)350722, (Object)"\u6d66\u57ce\u53bf");
        b.put((Object)350723, (Object)"\u5149\u6cfd\u53bf");
        b.put((Object)350724, (Object)"\u677e\u6eaa\u53bf");
        b.put((Object)350725, (Object)"\u653f\u548c\u53bf");
        b.put((Object)350781, (Object)"\u90b5\u6b66\u5e02");
        b.put((Object)350782, (Object)"\u6b66\u5937\u5c71\u5e02");
        b.put((Object)350783, (Object)"\u5efa\u74ef\u5e02");
        b.put((Object)350800, (Object)"\u9f99\u5ca9\u5e02");
        b.put((Object)350802, (Object)"\u65b0\u7f57\u533a");
        b.put((Object)350803, (Object)"\u6c38\u5b9a\u533a");
        b.put((Object)350821, (Object)"\u957f\u6c40\u53bf");
        b.put((Object)350823, (Object)"\u4e0a\u676d\u53bf");
        b.put((Object)350824, (Object)"\u6b66\u5e73\u53bf");
        b.put((Object)350825, (Object)"\u8fde\u57ce\u53bf");
        b.put((Object)350881, (Object)"\u6f33\u5e73\u5e02");
        b.put((Object)350900, (Object)"\u5b81\u5fb7\u5e02");
        b.put((Object)350902, (Object)"\u8549\u57ce\u533a");
        b.put((Object)350921, (Object)"\u971e\u6d66\u53bf");
        b.put((Object)350922, (Object)"\u53e4\u7530\u53bf");
        b.put((Object)350923, (Object)"\u5c4f\u5357\u53bf");
        b.put((Object)350924, (Object)"\u5bff\u5b81\u53bf");
        b.put((Object)350925, (Object)"\u5468\u5b81\u53bf");
        b.put((Object)350926, (Object)"\u67d8\u8363\u53bf");
        b.put((Object)350981, (Object)"\u798f\u5b89\u5e02");
        b.put((Object)350982, (Object)"\u798f\u9f0e\u5e02");
        b.put((Object)360000, (Object)"\u6c5f\u897f\u7701");
        b.put((Object)360100, (Object)"\u5357\u660c\u5e02");
        b.put((Object)360102, (Object)"\u4e1c\u6e56\u533a");
        b.put((Object)360103, (Object)"\u897f\u6e56\u533a");
        b.put((Object)360104, (Object)"\u9752\u4e91\u8c31\u533a");
        b.put((Object)360105, (Object)"\u6e7e\u91cc\u533a");
        b.put((Object)360111, (Object)"\u9752\u5c71\u6e56\u533a");
        b.put((Object)360112, (Object)"\u65b0\u5efa\u533a");
        b.put((Object)360121, (Object)"\u5357\u660c\u53bf");
        b.put((Object)360123, (Object)"\u5b89\u4e49\u53bf");
        b.put((Object)360124, (Object)"\u8fdb\u8d24\u53bf");
        b.put((Object)360200, (Object)"\u666f\u5fb7\u9547\u5e02");
        b.put((Object)360202, (Object)"\u660c\u6c5f\u533a");
        b.put((Object)360203, (Object)"\u73e0\u5c71\u533a");
        b.put((Object)360222, (Object)"\u6d6e\u6881\u53bf");
        b.put((Object)360281, (Object)"\u4e50\u5e73\u5e02");
        b.put((Object)360300, (Object)"\u840d\u4e61\u5e02");
        b.put((Object)360302, (Object)"\u5b89\u6e90\u533a");
        b.put((Object)360313, (Object)"\u6e58\u4e1c\u533a");
        b.put((Object)360321, (Object)"\u83b2\u82b1\u53bf");
        b.put((Object)360322, (Object)"\u4e0a\u6817\u53bf");
        b.put((Object)360323, (Object)"\u82a6\u6eaa\u53bf");
        b.put((Object)360400, (Object)"\u4e5d\u6c5f\u5e02");
        b.put((Object)360402, (Object)"\u6fc2\u6eaa\u533a");
        b.put((Object)360403, (Object)"\u6d54\u9633\u533a");
        b.put((Object)360404, (Object)"\u67f4\u6851\u533a");
        b.put((Object)360423, (Object)"\u6b66\u5b81\u53bf");
        b.put((Object)360424, (Object)"\u4fee\u6c34\u53bf");
        b.put((Object)360425, (Object)"\u6c38\u4fee\u53bf");
        b.put((Object)360426, (Object)"\u5fb7\u5b89\u53bf");
        b.put((Object)360428, (Object)"\u90fd\u660c\u53bf");
        b.put((Object)360429, (Object)"\u6e56\u53e3\u53bf");
        b.put((Object)360430, (Object)"\u5f6d\u6cfd\u53bf");
        b.put((Object)360481, (Object)"\u745e\u660c\u5e02");
        b.put((Object)360482, (Object)"\u5171\u9752\u57ce\u5e02");
        b.put((Object)360483, (Object)"\u5e90\u5c71\u5e02");
        b.put((Object)360500, (Object)"\u65b0\u4f59\u5e02");
        b.put((Object)360502, (Object)"\u6e1d\u6c34\u533a");
        b.put((Object)360521, (Object)"\u5206\u5b9c\u53bf");
        b.put((Object)360600, (Object)"\u9e70\u6f6d\u5e02");
        b.put((Object)360602, (Object)"\u6708\u6e56\u533a");
        b.put((Object)360603, (Object)"\u4f59\u6c5f\u533a");
        b.put((Object)360681, (Object)"\u8d35\u6eaa\u5e02");
        b.put((Object)360700, (Object)"\u8d63\u5dde\u5e02");
        b.put((Object)360702, (Object)"\u7ae0\u8d21\u533a");
        b.put((Object)360703, (Object)"\u5357\u5eb7\u533a");
        b.put((Object)360704, (Object)"\u8d63\u53bf\u533a");
        b.put((Object)360722, (Object)"\u4fe1\u4e30\u53bf");
        b.put((Object)360723, (Object)"\u5927\u4f59\u53bf");
        b.put((Object)360724, (Object)"\u4e0a\u72b9\u53bf");
        b.put((Object)360725, (Object)"\u5d07\u4e49\u53bf");
        b.put((Object)360726, (Object)"\u5b89\u8fdc\u53bf");
        b.put((Object)360727, (Object)"\u9f99\u5357\u53bf");
        b.put((Object)360728, (Object)"\u5b9a\u5357\u53bf");
        b.put((Object)360729, (Object)"\u5168\u5357\u53bf");
        b.put((Object)360730, (Object)"\u5b81\u90fd\u53bf");
        b.put((Object)360731, (Object)"\u4e8e\u90fd\u53bf");
        b.put((Object)360732, (Object)"\u5174\u56fd\u53bf");
        b.put((Object)360733, (Object)"\u4f1a\u660c\u53bf");
        b.put((Object)360734, (Object)"\u5bfb\u4e4c\u53bf");
        b.put((Object)360735, (Object)"\u77f3\u57ce\u53bf");
        b.put((Object)360781, (Object)"\u745e\u91d1\u5e02");
        b.put((Object)360800, (Object)"\u5409\u5b89\u5e02");
        b.put((Object)360802, (Object)"\u5409\u5dde\u533a");
        b.put((Object)360803, (Object)"\u9752\u539f\u533a");
        b.put((Object)360821, (Object)"\u5409\u5b89\u53bf");
        b.put((Object)360822, (Object)"\u5409\u6c34\u53bf");
        b.put((Object)360823, (Object)"\u5ce1\u6c5f\u53bf");
        b.put((Object)360824, (Object)"\u65b0\u5e72\u53bf");
        b.put((Object)360825, (Object)"\u6c38\u4e30\u53bf");
        b.put((Object)360826, (Object)"\u6cf0\u548c\u53bf");
        b.put((Object)360827, (Object)"\u9042\u5ddd\u53bf");
        b.put((Object)360828, (Object)"\u4e07\u5b89\u53bf");
        b.put((Object)360829, (Object)"\u5b89\u798f\u53bf");
        b.put((Object)360830, (Object)"\u6c38\u65b0\u53bf");
        b.put((Object)360881, (Object)"\u4e95\u5188\u5c71\u5e02");
        b.put((Object)360900, (Object)"\u5b9c\u6625\u5e02");
        b.put((Object)360902, (Object)"\u8881\u5dde\u533a");
        b.put((Object)360921, (Object)"\u5949\u65b0\u53bf");
        b.put((Object)360922, (Object)"\u4e07\u8f7d\u53bf");
        b.put((Object)360923, (Object)"\u4e0a\u9ad8\u53bf");
        b.put((Object)360924, (Object)"\u5b9c\u4e30\u53bf");
        b.put((Object)360925, (Object)"\u9756\u5b89\u53bf");
        b.put((Object)360926, (Object)"\u94dc\u9f13\u53bf");
        b.put((Object)360981, (Object)"\u4e30\u57ce\u5e02");
        b.put((Object)360982, (Object)"\u6a1f\u6811\u5e02");
        b.put((Object)360983, (Object)"\u9ad8\u5b89\u5e02");
        b.put((Object)361000, (Object)"\u629a\u5dde\u5e02");
        b.put((Object)361002, (Object)"\u4e34\u5ddd\u533a");
        b.put((Object)361003, (Object)"\u4e1c\u4e61\u533a");
        b.put((Object)361021, (Object)"\u5357\u57ce\u53bf");
        b.put((Object)361022, (Object)"\u9ece\u5ddd\u53bf");
        b.put((Object)361023, (Object)"\u5357\u4e30\u53bf");
        b.put((Object)361024, (Object)"\u5d07\u4ec1\u53bf");
        b.put((Object)361025, (Object)"\u4e50\u5b89\u53bf");
        b.put((Object)361026, (Object)"\u5b9c\u9ec4\u53bf");
        b.put((Object)361027, (Object)"\u91d1\u6eaa\u53bf");
        b.put((Object)361028, (Object)"\u8d44\u6eaa\u53bf");
        b.put((Object)361030, (Object)"\u5e7f\u660c\u53bf");
        b.put((Object)361100, (Object)"\u4e0a\u9976\u5e02");
        b.put((Object)361102, (Object)"\u4fe1\u5dde\u533a");
        b.put((Object)361103, (Object)"\u5e7f\u4e30\u533a");
        b.put((Object)361121, (Object)"\u4e0a\u9976\u53bf");
        b.put((Object)361123, (Object)"\u7389\u5c71\u53bf");
        b.put((Object)361124, (Object)"\u94c5\u5c71\u53bf");
        b.put((Object)361125, (Object)"\u6a2a\u5cf0\u53bf");
        b.put((Object)361126, (Object)"\u5f0b\u9633\u53bf");
        b.put((Object)361127, (Object)"\u4f59\u5e72\u53bf");
        b.put((Object)361128, (Object)"\u9131\u9633\u53bf");
        b.put((Object)361129, (Object)"\u4e07\u5e74\u53bf");
        b.put((Object)361130, (Object)"\u5a7a\u6e90\u53bf");
        b.put((Object)361181, (Object)"\u5fb7\u5174\u5e02");
        b.put((Object)370000, (Object)"\u5c71\u4e1c\u7701");
        b.put((Object)370100, (Object)"\u6d4e\u5357\u5e02");
        b.put((Object)370102, (Object)"\u5386\u4e0b\u533a");
        b.put((Object)370103, (Object)"\u5e02\u4e2d\u533a");
        b.put((Object)370104, (Object)"\u69d0\u836b\u533a");
        b.put((Object)370105, (Object)"\u5929\u6865\u533a");
        b.put((Object)370112, (Object)"\u5386\u57ce\u533a");
        b.put((Object)370113, (Object)"\u957f\u6e05\u533a");
        b.put((Object)370114, (Object)"\u7ae0\u4e18\u533a");
        b.put((Object)370124, (Object)"\u5e73\u9634\u53bf");
        b.put((Object)370125, (Object)"\u6d4e\u9633\u53bf");
        b.put((Object)370126, (Object)"\u5546\u6cb3\u53bf");
        b.put((Object)370200, (Object)"\u9752\u5c9b\u5e02");
        b.put((Object)370202, (Object)"\u5e02\u5357\u533a");
        b.put((Object)370203, (Object)"\u5e02\u5317\u533a");
        b.put((Object)370211, (Object)"\u9ec4\u5c9b\u533a");
        b.put((Object)370212, (Object)"\u5d02\u5c71\u533a");
        b.put((Object)370213, (Object)"\u674e\u6ca7\u533a");
        b.put((Object)370214, (Object)"\u57ce\u9633\u533a");
        b.put((Object)370215, (Object)"\u5373\u58a8\u533a");
        b.put((Object)370281, (Object)"\u80f6\u5dde\u5e02");
        b.put((Object)370283, (Object)"\u5e73\u5ea6\u5e02");
        b.put((Object)370285, (Object)"\u83b1\u897f\u5e02");
        b.put((Object)370300, (Object)"\u6dc4\u535a\u5e02");
        b.put((Object)370302, (Object)"\u6dc4\u5ddd\u533a");
        b.put((Object)370303, (Object)"\u5f20\u5e97\u533a");
        b.put((Object)370304, (Object)"\u535a\u5c71\u533a");
        b.put((Object)370305, (Object)"\u4e34\u6dc4\u533a");
        b.put((Object)370306, (Object)"\u5468\u6751\u533a");
        b.put((Object)370321, (Object)"\u6853\u53f0\u53bf");
        b.put((Object)370322, (Object)"\u9ad8\u9752\u53bf");
        b.put((Object)370323, (Object)"\u6c82\u6e90\u53bf");
        b.put((Object)370400, (Object)"\u67a3\u5e84\u5e02");
        b.put((Object)370402, (Object)"\u5e02\u4e2d\u533a");
        b.put((Object)370403, (Object)"\u859b\u57ce\u533a");
        b.put((Object)370404, (Object)"\u5cc4\u57ce\u533a");
        b.put((Object)370405, (Object)"\u53f0\u513f\u5e84\u533a");
        b.put((Object)370406, (Object)"\u5c71\u4ead\u533a");
        b.put((Object)370481, (Object)"\u6ed5\u5dde\u5e02");
        b.put((Object)370500, (Object)"\u4e1c\u8425\u5e02");
        b.put((Object)370502, (Object)"\u4e1c\u8425\u533a");
        b.put((Object)370503, (Object)"\u6cb3\u53e3\u533a");
        b.put((Object)370505, (Object)"\u57a6\u5229\u533a");
        b.put((Object)370522, (Object)"\u5229\u6d25\u53bf");
        b.put((Object)370523, (Object)"\u5e7f\u9976\u53bf");
        b.put((Object)370600, (Object)"\u70df\u53f0\u5e02");
        b.put((Object)370602, (Object)"\u829d\u7f58\u533a");
        b.put((Object)370611, (Object)"\u798f\u5c71\u533a");
        b.put((Object)370612, (Object)"\u725f\u5e73\u533a");
        b.put((Object)370613, (Object)"\u83b1\u5c71\u533a");
        b.put((Object)370634, (Object)"\u957f\u5c9b\u53bf");
        b.put((Object)370681, (Object)"\u9f99\u53e3\u5e02");
        b.put((Object)370682, (Object)"\u83b1\u9633\u5e02");
        b.put((Object)370683, (Object)"\u83b1\u5dde\u5e02");
        b.put((Object)370684, (Object)"\u84ec\u83b1\u5e02");
        b.put((Object)370685, (Object)"\u62db\u8fdc\u5e02");
        b.put((Object)370686, (Object)"\u6816\u971e\u5e02");
        b.put((Object)370687, (Object)"\u6d77\u9633\u5e02");
        b.put((Object)370700, (Object)"\u6f4d\u574a\u5e02");
        b.put((Object)370702, (Object)"\u6f4d\u57ce\u533a");
        b.put((Object)370703, (Object)"\u5bd2\u4ead\u533a");
        b.put((Object)370704, (Object)"\u574a\u5b50\u533a");
        b.put((Object)370705, (Object)"\u594e\u6587\u533a");
        b.put((Object)370724, (Object)"\u4e34\u6710\u53bf");
        b.put((Object)370725, (Object)"\u660c\u4e50\u53bf");
        b.put((Object)370781, (Object)"\u9752\u5dde\u5e02");
        b.put((Object)370782, (Object)"\u8bf8\u57ce\u5e02");
        b.put((Object)370783, (Object)"\u5bff\u5149\u5e02");
        b.put((Object)370784, (Object)"\u5b89\u4e18\u5e02");
        b.put((Object)370785, (Object)"\u9ad8\u5bc6\u5e02");
        b.put((Object)370786, (Object)"\u660c\u9091\u5e02");
        b.put((Object)370800, (Object)"\u6d4e\u5b81\u5e02");
        b.put((Object)370811, (Object)"\u4efb\u57ce\u533a");
        b.put((Object)370812, (Object)"\u5156\u5dde\u533a");
        b.put((Object)370826, (Object)"\u5fae\u5c71\u53bf");
        b.put((Object)370827, (Object)"\u9c7c\u53f0\u53bf");
        b.put((Object)370828, (Object)"\u91d1\u4e61\u53bf");
        b.put((Object)370829, (Object)"\u5609\u7965\u53bf");
        b.put((Object)370830, (Object)"\u6c76\u4e0a\u53bf");
        b.put((Object)370831, (Object)"\u6cd7\u6c34\u53bf");
        b.put((Object)370832, (Object)"\u6881\u5c71\u53bf");
        b.put((Object)370881, (Object)"\u66f2\u961c\u5e02");
        b.put((Object)370883, (Object)"\u90b9\u57ce\u5e02");
        b.put((Object)370900, (Object)"\u6cf0\u5b89\u5e02");
        b.put((Object)370902, (Object)"\u6cf0\u5c71\u533a");
        b.put((Object)370911, (Object)"\u5cb1\u5cb3\u533a");
        b.put((Object)370921, (Object)"\u5b81\u9633\u53bf");
        b.put((Object)370923, (Object)"\u4e1c\u5e73\u53bf");
        b.put((Object)370982, (Object)"\u65b0\u6cf0\u5e02");
        b.put((Object)370983, (Object)"\u80a5\u57ce\u5e02");
        b.put((Object)371000, (Object)"\u5a01\u6d77\u5e02");
        b.put((Object)371002, (Object)"\u73af\u7fe0\u533a");
        b.put((Object)371003, (Object)"\u6587\u767b\u533a");
        b.put((Object)371082, (Object)"\u8363\u6210\u5e02");
        b.put((Object)371083, (Object)"\u4e73\u5c71\u5e02");
        b.put((Object)371100, (Object)"\u65e5\u7167\u5e02");
        b.put((Object)371102, (Object)"\u4e1c\u6e2f\u533a");
        b.put((Object)371103, (Object)"\u5c9a\u5c71\u533a");
        b.put((Object)371121, (Object)"\u4e94\u83b2\u53bf");
        b.put((Object)371122, (Object)"\u8392\u53bf");
        b.put((Object)371200, (Object)"\u83b1\u829c\u5e02");
        b.put((Object)371202, (Object)"\u83b1\u57ce\u533a");
        b.put((Object)371203, (Object)"\u94a2\u57ce\u533a");
        b.put((Object)371300, (Object)"\u4e34\u6c82\u5e02");
        b.put((Object)371302, (Object)"\u5170\u5c71\u533a");
        b.put((Object)371311, (Object)"\u7f57\u5e84\u533a");
        b.put((Object)371312, (Object)"\u6cb3\u4e1c\u533a");
        b.put((Object)371321, (Object)"\u6c82\u5357\u53bf");
        b.put((Object)371322, (Object)"\u90ef\u57ce\u53bf");
        b.put((Object)371323, (Object)"\u6c82\u6c34\u53bf");
        b.put((Object)371324, (Object)"\u5170\u9675\u53bf");
        b.put((Object)371325, (Object)"\u8d39\u53bf");
        b.put((Object)371326, (Object)"\u5e73\u9091\u53bf");
        b.put((Object)371327, (Object)"\u8392\u5357\u53bf");
        b.put((Object)371328, (Object)"\u8499\u9634\u53bf");
        b.put((Object)371329, (Object)"\u4e34\u6cad\u53bf");
        b.put((Object)371400, (Object)"\u5fb7\u5dde\u5e02");
        b.put((Object)371402, (Object)"\u5fb7\u57ce\u533a");
        b.put((Object)371403, (Object)"\u9675\u57ce\u533a");
        b.put((Object)371422, (Object)"\u5b81\u6d25\u53bf");
        b.put((Object)371423, (Object)"\u5e86\u4e91\u53bf");
        b.put((Object)371424, (Object)"\u4e34\u9091\u53bf");
        b.put((Object)371425, (Object)"\u9f50\u6cb3\u53bf");
        b.put((Object)371426, (Object)"\u5e73\u539f\u53bf");
        b.put((Object)371427, (Object)"\u590f\u6d25\u53bf");
        b.put((Object)371428, (Object)"\u6b66\u57ce\u53bf");
        b.put((Object)371481, (Object)"\u4e50\u9675\u5e02");
        b.put((Object)371482, (Object)"\u79b9\u57ce\u5e02");
        b.put((Object)371500, (Object)"\u804a\u57ce\u5e02");
        b.put((Object)371502, (Object)"\u4e1c\u660c\u5e9c\u533a");
        b.put((Object)371521, (Object)"\u9633\u8c37\u53bf");
        b.put((Object)371522, (Object)"\u8398\u53bf");
        b.put((Object)371523, (Object)"\u830c\u5e73\u53bf");
        b.put((Object)371524, (Object)"\u4e1c\u963f\u53bf");
        b.put((Object)371525, (Object)"\u51a0\u53bf");
        b.put((Object)371526, (Object)"\u9ad8\u5510\u53bf");
        b.put((Object)371581, (Object)"\u4e34\u6e05\u5e02");
        b.put((Object)371600, (Object)"\u6ee8\u5dde\u5e02");
        b.put((Object)371602, (Object)"\u6ee8\u57ce\u533a");
        b.put((Object)371603, (Object)"\u6cbe\u5316\u533a");
        b.put((Object)371621, (Object)"\u60e0\u6c11\u53bf");
        b.put((Object)371622, (Object)"\u9633\u4fe1\u53bf");
        b.put((Object)371623, (Object)"\u65e0\u68e3\u53bf");
        b.put((Object)371625, (Object)"\u535a\u5174\u53bf");
        b.put((Object)371626, (Object)"\u90b9\u5e73\u53bf");
        b.put((Object)371700, (Object)"\u83cf\u6cfd\u5e02");
        b.put((Object)371702, (Object)"\u7261\u4e39\u533a");
        b.put((Object)371703, (Object)"\u5b9a\u9676\u533a");
        b.put((Object)371721, (Object)"\u66f9\u53bf");
        b.put((Object)371722, (Object)"\u5355\u53bf");
        b.put((Object)371723, (Object)"\u6210\u6b66\u53bf");
        b.put((Object)371724, (Object)"\u5de8\u91ce\u53bf");
        b.put((Object)371725, (Object)"\u90d3\u57ce\u53bf");
        b.put((Object)371726, (Object)"\u9104\u57ce\u53bf");
        b.put((Object)371728, (Object)"\u4e1c\u660e\u53bf");
        b.put((Object)410000, (Object)"\u6cb3\u5357\u7701");
        b.put((Object)410100, (Object)"\u90d1\u5dde\u5e02");
        b.put((Object)410102, (Object)"\u4e2d\u539f\u533a");
        b.put((Object)410103, (Object)"\u4e8c\u4e03\u533a");
        b.put((Object)410104, (Object)"\u7ba1\u57ce\u56de\u65cf\u533a");
        b.put((Object)410105, (Object)"\u91d1\u6c34\u533a");
        b.put((Object)410106, (Object)"\u4e0a\u8857\u533a");
        b.put((Object)410108, (Object)"\u60e0\u6d4e\u533a");
        b.put((Object)410122, (Object)"\u4e2d\u725f\u53bf");
        b.put((Object)410181, (Object)"\u5de9\u4e49\u5e02");
        b.put((Object)410182, (Object)"\u8365\u9633\u5e02");
        b.put((Object)410183, (Object)"\u65b0\u5bc6\u5e02");
        b.put((Object)410184, (Object)"\u65b0\u90d1\u5e02");
        b.put((Object)410185, (Object)"\u767b\u5c01\u5e02");
        b.put((Object)410200, (Object)"\u5f00\u5c01\u5e02");
        b.put((Object)410202, (Object)"\u9f99\u4ead\u533a");
        b.put((Object)410203, (Object)"\u987a\u6cb3\u56de\u65cf\u533a");
        b.put((Object)410204, (Object)"\u9f13\u697c\u533a");
        b.put((Object)410205, (Object)"\u79b9\u738b\u53f0\u533a");
        b.put((Object)410212, (Object)"\u7965\u7b26\u533a");
        b.put((Object)410221, (Object)"\u675e\u53bf");
        b.put((Object)410222, (Object)"\u901a\u8bb8\u53bf");
        b.put((Object)410223, (Object)"\u5c09\u6c0f\u53bf");
        b.put((Object)410225, (Object)"\u5170\u8003\u53bf");
        b.put((Object)410300, (Object)"\u6d1b\u9633\u5e02");
        b.put((Object)410302, (Object)"\u8001\u57ce\u533a");
        b.put((Object)410303, (Object)"\u897f\u5de5\u533a");
        b.put((Object)410304, (Object)"\u700d\u6cb3\u56de\u65cf\u533a");
        b.put((Object)410305, (Object)"\u6da7\u897f\u533a");
        b.put((Object)410306, (Object)"\u5409\u5229\u533a");
        b.put((Object)410311, (Object)"\u6d1b\u9f99\u533a");
        b.put((Object)410322, (Object)"\u5b5f\u6d25\u53bf");
        b.put((Object)410323, (Object)"\u65b0\u5b89\u53bf");
        b.put((Object)410324, (Object)"\u683e\u5ddd\u53bf");
        b.put((Object)410325, (Object)"\u5d69\u53bf");
        b.put((Object)410326, (Object)"\u6c5d\u9633\u53bf");
        b.put((Object)410327, (Object)"\u5b9c\u9633\u53bf");
        b.put((Object)410328, (Object)"\u6d1b\u5b81\u53bf");
        b.put((Object)410329, (Object)"\u4f0a\u5ddd\u53bf");
        b.put((Object)410381, (Object)"\u5043\u5e08\u5e02");
        b.put((Object)410400, (Object)"\u5e73\u9876\u5c71\u5e02");
        b.put((Object)410402, (Object)"\u65b0\u534e\u533a");
        b.put((Object)410403, (Object)"\u536b\u4e1c\u533a");
        b.put((Object)410404, (Object)"\u77f3\u9f99\u533a");
        b.put((Object)410411, (Object)"\u6e5b\u6cb3\u533a");
        b.put((Object)410421, (Object)"\u5b9d\u4e30\u53bf");
        b.put((Object)410422, (Object)"\u53f6\u53bf");
        b.put((Object)410423, (Object)"\u9c81\u5c71\u53bf");
        b.put((Object)410425, (Object)"\u90cf\u53bf");
        b.put((Object)410481, (Object)"\u821e\u94a2\u5e02");
        b.put((Object)410482, (Object)"\u6c5d\u5dde\u5e02");
        b.put((Object)410500, (Object)"\u5b89\u9633\u5e02");
        b.put((Object)410502, (Object)"\u6587\u5cf0\u533a");
        b.put((Object)410503, (Object)"\u5317\u5173\u533a");
        b.put((Object)410505, (Object)"\u6bb7\u90fd\u533a");
        b.put((Object)410506, (Object)"\u9f99\u5b89\u533a");
        b.put((Object)410522, (Object)"\u5b89\u9633\u53bf");
        b.put((Object)410523, (Object)"\u6c64\u9634\u53bf");
        b.put((Object)410526, (Object)"\u6ed1\u53bf");
        b.put((Object)410527, (Object)"\u5185\u9ec4\u53bf");
        b.put((Object)410581, (Object)"\u6797\u5dde\u5e02");
        b.put((Object)410600, (Object)"\u9e64\u58c1\u5e02");
        b.put((Object)410602, (Object)"\u9e64\u5c71\u533a");
        b.put((Object)410603, (Object)"\u5c71\u57ce\u533a");
        b.put((Object)410611, (Object)"\u6dc7\u6ee8\u533a");
        b.put((Object)410621, (Object)"\u6d5a\u53bf");
        b.put((Object)410622, (Object)"\u6dc7\u53bf");
        b.put((Object)410700, (Object)"\u65b0\u4e61\u5e02");
        b.put((Object)410702, (Object)"\u7ea2\u65d7\u533a");
        b.put((Object)410703, (Object)"\u536b\u6ee8\u533a");
        b.put((Object)410704, (Object)"\u51e4\u6cc9\u533a");
        b.put((Object)410711, (Object)"\u7267\u91ce\u533a");
        b.put((Object)410721, (Object)"\u65b0\u4e61\u53bf");
        b.put((Object)410724, (Object)"\u83b7\u5609\u53bf");
        b.put((Object)410725, (Object)"\u539f\u9633\u53bf");
        b.put((Object)410726, (Object)"\u5ef6\u6d25\u53bf");
        b.put((Object)410727, (Object)"\u5c01\u4e18\u53bf");
        b.put((Object)410728, (Object)"\u957f\u57a3\u53bf");
        b.put((Object)410781, (Object)"\u536b\u8f89\u5e02");
        b.put((Object)410782, (Object)"\u8f89\u53bf\u5e02");
        b.put((Object)410800, (Object)"\u7126\u4f5c\u5e02");
        b.put((Object)410802, (Object)"\u89e3\u653e\u533a");
        b.put((Object)410803, (Object)"\u4e2d\u7ad9\u533a");
        b.put((Object)410804, (Object)"\u9a6c\u6751\u533a");
        b.put((Object)410811, (Object)"\u5c71\u9633\u533a");
        b.put((Object)410821, (Object)"\u4fee\u6b66\u53bf");
        b.put((Object)410822, (Object)"\u535a\u7231\u53bf");
        b.put((Object)410823, (Object)"\u6b66\u965f\u53bf");
        b.put((Object)410825, (Object)"\u6e29\u53bf");
        b.put((Object)410882, (Object)"\u6c81\u9633\u5e02");
        b.put((Object)410883, (Object)"\u5b5f\u5dde\u5e02");
        b.put((Object)410900, (Object)"\u6fee\u9633\u5e02");
        b.put((Object)410902, (Object)"\u534e\u9f99\u533a");
        b.put((Object)410922, (Object)"\u6e05\u4e30\u53bf");
        b.put((Object)410923, (Object)"\u5357\u4e50\u53bf");
        b.put((Object)410926, (Object)"\u8303\u53bf");
        b.put((Object)410927, (Object)"\u53f0\u524d\u53bf");
        b.put((Object)410928, (Object)"\u6fee\u9633\u53bf");
        b.put((Object)411000, (Object)"\u8bb8\u660c\u5e02");
        b.put((Object)411002, (Object)"\u9b4f\u90fd\u533a");
        b.put((Object)411003, (Object)"\u5efa\u5b89\u533a");
        b.put((Object)411024, (Object)"\u9122\u9675\u53bf");
        b.put((Object)411025, (Object)"\u8944\u57ce\u53bf");
        b.put((Object)411081, (Object)"\u79b9\u5dde\u5e02");
        b.put((Object)411082, (Object)"\u957f\u845b\u5e02");
        b.put((Object)411100, (Object)"\u6f2f\u6cb3\u5e02");
        b.put((Object)411102, (Object)"\u6e90\u6c47\u533a");
        b.put((Object)411103, (Object)"\u90fe\u57ce\u533a");
        b.put((Object)411104, (Object)"\u53ec\u9675\u533a");
        b.put((Object)411121, (Object)"\u821e\u9633\u53bf");
        b.put((Object)411122, (Object)"\u4e34\u988d\u53bf");
        b.put((Object)411200, (Object)"\u4e09\u95e8\u5ce1\u5e02");
        b.put((Object)411202, (Object)"\u6e56\u6ee8\u533a");
        b.put((Object)411203, (Object)"\u9655\u5dde\u533a");
        b.put((Object)411221, (Object)"\u6e11\u6c60\u53bf");
        b.put((Object)411224, (Object)"\u5362\u6c0f\u53bf");
        b.put((Object)411281, (Object)"\u4e49\u9a6c\u5e02");
        b.put((Object)411282, (Object)"\u7075\u5b9d\u5e02");
        b.put((Object)411300, (Object)"\u5357\u9633\u5e02");
        b.put((Object)411302, (Object)"\u5b9b\u57ce\u533a");
        b.put((Object)411303, (Object)"\u5367\u9f99\u533a");
        b.put((Object)411321, (Object)"\u5357\u53ec\u53bf");
        b.put((Object)411322, (Object)"\u65b9\u57ce\u53bf");
        b.put((Object)411323, (Object)"\u897f\u5ce1\u53bf");
        b.put((Object)411324, (Object)"\u9547\u5e73\u53bf");
        b.put((Object)411325, (Object)"\u5185\u4e61\u53bf");
        b.put((Object)411326, (Object)"\u6dc5\u5ddd\u53bf");
        b.put((Object)411327, (Object)"\u793e\u65d7\u53bf");
        b.put((Object)411328, (Object)"\u5510\u6cb3\u53bf");
        b.put((Object)411329, (Object)"\u65b0\u91ce\u53bf");
        b.put((Object)411330, (Object)"\u6850\u67cf\u53bf");
        b.put((Object)411381, (Object)"\u9093\u5dde\u5e02");
        b.put((Object)411400, (Object)"\u5546\u4e18\u5e02");
        b.put((Object)411402, (Object)"\u6881\u56ed\u533a");
        b.put((Object)411403, (Object)"\u7762\u9633\u533a");
        b.put((Object)411421, (Object)"\u6c11\u6743\u53bf");
        b.put((Object)411422, (Object)"\u7762\u53bf");
        b.put((Object)411423, (Object)"\u5b81\u9675\u53bf");
        b.put((Object)411424, (Object)"\u67d8\u57ce\u53bf");
        b.put((Object)411425, (Object)"\u865e\u57ce\u53bf");
        b.put((Object)411426, (Object)"\u590f\u9091\u53bf");
        b.put((Object)411481, (Object)"\u6c38\u57ce\u5e02");
        b.put((Object)411500, (Object)"\u4fe1\u9633\u5e02");
        b.put((Object)411502, (Object)"\u6d49\u6cb3\u533a");
        b.put((Object)411503, (Object)"\u5e73\u6865\u533a");
        b.put((Object)411521, (Object)"\u7f57\u5c71\u53bf");
        b.put((Object)411522, (Object)"\u5149\u5c71\u53bf");
        b.put((Object)411523, (Object)"\u65b0\u53bf");
        b.put((Object)411524, (Object)"\u5546\u57ce\u53bf");
        b.put((Object)411525, (Object)"\u56fa\u59cb\u53bf");
        b.put((Object)411526, (Object)"\u6f62\u5ddd\u53bf");
        b.put((Object)411527, (Object)"\u6dee\u6ee8\u53bf");
        b.put((Object)411528, (Object)"\u606f\u53bf");
        b.put((Object)411600, (Object)"\u5468\u53e3\u5e02");
        b.put((Object)411602, (Object)"\u5ddd\u6c47\u533a");
        b.put((Object)411621, (Object)"\u6276\u6c9f\u53bf");
        b.put((Object)411622, (Object)"\u897f\u534e\u53bf");
        b.put((Object)411623, (Object)"\u5546\u6c34\u53bf");
        b.put((Object)411624, (Object)"\u6c88\u4e18\u53bf");
        b.put((Object)411625, (Object)"\u90f8\u57ce\u53bf");
        b.put((Object)411626, (Object)"\u6dee\u9633\u53bf");
        b.put((Object)411627, (Object)"\u592a\u5eb7\u53bf");
        b.put((Object)411628, (Object)"\u9e7f\u9091\u53bf");
        b.put((Object)411681, (Object)"\u9879\u57ce\u5e02");
        b.put((Object)411700, (Object)"\u9a7b\u9a6c\u5e97\u5e02");
        b.put((Object)411702, (Object)"\u9a7f\u57ce\u533a");
        b.put((Object)411721, (Object)"\u897f\u5e73\u53bf");
        b.put((Object)411722, (Object)"\u4e0a\u8521\u53bf");
        b.put((Object)411723, (Object)"\u5e73\u8206\u53bf");
        b.put((Object)411724, (Object)"\u6b63\u9633\u53bf");
        b.put((Object)411725, (Object)"\u786e\u5c71\u53bf");
        b.put((Object)411726, (Object)"\u6ccc\u9633\u53bf");
        b.put((Object)411727, (Object)"\u6c5d\u5357\u53bf");
        b.put((Object)411728, (Object)"\u9042\u5e73\u53bf");
        b.put((Object)411729, (Object)"\u65b0\u8521\u53bf");
        b.put((Object)419001, (Object)"\u6d4e\u6e90\u5e02");
        b.put((Object)420000, (Object)"\u6e56\u5317\u7701");
        b.put((Object)420100, (Object)"\u6b66\u6c49\u5e02");
        b.put((Object)420102, (Object)"\u6c5f\u5cb8\u533a");
        b.put((Object)420103, (Object)"\u6c5f\u6c49\u533a");
        b.put((Object)420104, (Object)"\u785a\u53e3\u533a");
        b.put((Object)420105, (Object)"\u6c49\u9633\u533a");
        b.put((Object)420106, (Object)"\u6b66\u660c\u533a");
        b.put((Object)420107, (Object)"\u9752\u5c71\u533a");
        b.put((Object)420111, (Object)"\u6d2a\u5c71\u533a");
        b.put((Object)420112, (Object)"\u4e1c\u897f\u6e56\u533a");
        b.put((Object)420113, (Object)"\u6c49\u5357\u533a");
        b.put((Object)420114, (Object)"\u8521\u7538\u533a");
        b.put((Object)420115, (Object)"\u6c5f\u590f\u533a");
        b.put((Object)420116, (Object)"\u9ec4\u9642\u533a");
        b.put((Object)420117, (Object)"\u65b0\u6d32\u533a");
        b.put((Object)420200, (Object)"\u9ec4\u77f3\u5e02");
        b.put((Object)420202, (Object)"\u9ec4\u77f3\u6e2f\u533a");
        b.put((Object)420203, (Object)"\u897f\u585e\u5c71\u533a");
        b.put((Object)420204, (Object)"\u4e0b\u9646\u533a");
        b.put((Object)420205, (Object)"\u94c1\u5c71\u533a");
        b.put((Object)420222, (Object)"\u9633\u65b0\u53bf");
        b.put((Object)420281, (Object)"\u5927\u51b6\u5e02");
        b.put((Object)420300, (Object)"\u5341\u5830\u5e02");
        b.put((Object)420302, (Object)"\u8305\u7bad\u533a");
        b.put((Object)420303, (Object)"\u5f20\u6e7e\u533a");
        b.put((Object)420304, (Object)"\u90e7\u9633\u533a");
        b.put((Object)420322, (Object)"\u90e7\u897f\u53bf");
        b.put((Object)420323, (Object)"\u7af9\u5c71\u53bf");
        b.put((Object)420324, (Object)"\u7af9\u6eaa\u53bf");
        b.put((Object)420325, (Object)"\u623f\u53bf");
        b.put((Object)420381, (Object)"\u4e39\u6c5f\u53e3\u5e02");
        b.put((Object)420500, (Object)"\u5b9c\u660c\u5e02");
        b.put((Object)420502, (Object)"\u897f\u9675\u533a");
        b.put((Object)420503, (Object)"\u4f0d\u5bb6\u5c97\u533a");
        b.put((Object)420504, (Object)"\u70b9\u519b\u533a");
        b.put((Object)420505, (Object)"\u7307\u4ead\u533a");
        b.put((Object)420506, (Object)"\u5937\u9675\u533a");
        b.put((Object)420525, (Object)"\u8fdc\u5b89\u53bf");
        b.put((Object)420526, (Object)"\u5174\u5c71\u53bf");
        b.put((Object)420527, (Object)"\u79ed\u5f52\u53bf");
        b.put((Object)420528, (Object)"\u957f\u9633\u571f\u5bb6\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)420529, (Object)"\u4e94\u5cf0\u571f\u5bb6\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)420581, (Object)"\u5b9c\u90fd\u5e02");
        b.put((Object)420582, (Object)"\u5f53\u9633\u5e02");
        b.put((Object)420583, (Object)"\u679d\u6c5f\u5e02");
        b.put((Object)420600, (Object)"\u8944\u9633\u5e02");
        b.put((Object)420602, (Object)"\u8944\u57ce\u533a");
        b.put((Object)420606, (Object)"\u6a0a\u57ce\u533a");
        b.put((Object)420607, (Object)"\u8944\u5dde\u533a");
        b.put((Object)420624, (Object)"\u5357\u6f33\u53bf");
        b.put((Object)420625, (Object)"\u8c37\u57ce\u53bf");
        b.put((Object)420626, (Object)"\u4fdd\u5eb7\u53bf");
        b.put((Object)420682, (Object)"\u8001\u6cb3\u53e3\u5e02");
        b.put((Object)420683, (Object)"\u67a3\u9633\u5e02");
        b.put((Object)420684, (Object)"\u5b9c\u57ce\u5e02");
        b.put((Object)420700, (Object)"\u9102\u5dde\u5e02");
        b.put((Object)420702, (Object)"\u6881\u5b50\u6e56\u533a");
        b.put((Object)420703, (Object)"\u534e\u5bb9\u533a");
        b.put((Object)420704, (Object)"\u9102\u57ce\u533a");
        b.put((Object)420800, (Object)"\u8346\u95e8\u5e02");
        b.put((Object)420802, (Object)"\u4e1c\u5b9d\u533a");
        b.put((Object)420804, (Object)"\u6387\u5200\u533a");
        b.put((Object)420822, (Object)"\u6c99\u6d0b\u53bf");
        b.put((Object)420881, (Object)"\u949f\u7965\u5e02");
        b.put((Object)420882, (Object)"\u4eac\u5c71\u5e02");
        b.put((Object)420900, (Object)"\u5b5d\u611f\u5e02");
        b.put((Object)420902, (Object)"\u5b5d\u5357\u533a");
        b.put((Object)420921, (Object)"\u5b5d\u660c\u53bf");
        b.put((Object)420922, (Object)"\u5927\u609f\u53bf");
        b.put((Object)420923, (Object)"\u4e91\u68a6\u53bf");
        b.put((Object)420981, (Object)"\u5e94\u57ce\u5e02");
        b.put((Object)420982, (Object)"\u5b89\u9646\u5e02");
        b.put((Object)420984, (Object)"\u6c49\u5ddd\u5e02");
        b.put((Object)421000, (Object)"\u8346\u5dde\u5e02");
        b.put((Object)421002, (Object)"\u6c99\u5e02\u533a");
        b.put((Object)421003, (Object)"\u8346\u5dde\u533a");
        b.put((Object)421022, (Object)"\u516c\u5b89\u53bf");
        b.put((Object)421023, (Object)"\u76d1\u5229\u53bf");
        b.put((Object)421024, (Object)"\u6c5f\u9675\u53bf");
        b.put((Object)421081, (Object)"\u77f3\u9996\u5e02");
        b.put((Object)421083, (Object)"\u6d2a\u6e56\u5e02");
        b.put((Object)421087, (Object)"\u677e\u6ecb\u5e02");
        b.put((Object)421100, (Object)"\u9ec4\u5188\u5e02");
        b.put((Object)421102, (Object)"\u9ec4\u5dde\u533a");
        b.put((Object)421121, (Object)"\u56e2\u98ce\u53bf");
        b.put((Object)421122, (Object)"\u7ea2\u5b89\u53bf");
        b.put((Object)421123, (Object)"\u7f57\u7530\u53bf");
        b.put((Object)421124, (Object)"\u82f1\u5c71\u53bf");
        b.put((Object)421125, (Object)"\u6d60\u6c34\u53bf");
        b.put((Object)421126, (Object)"\u8572\u6625\u53bf");
        b.put((Object)421127, (Object)"\u9ec4\u6885\u53bf");
        b.put((Object)421181, (Object)"\u9ebb\u57ce\u5e02");
        b.put((Object)421182, (Object)"\u6b66\u7a74\u5e02");
        b.put((Object)421200, (Object)"\u54b8\u5b81\u5e02");
        b.put((Object)421202, (Object)"\u54b8\u5b89\u533a");
        b.put((Object)421221, (Object)"\u5609\u9c7c\u53bf");
        b.put((Object)421222, (Object)"\u901a\u57ce\u53bf");
        b.put((Object)421223, (Object)"\u5d07\u9633\u53bf");
        b.put((Object)421224, (Object)"\u901a\u5c71\u53bf");
        b.put((Object)421281, (Object)"\u8d64\u58c1\u5e02");
        b.put((Object)421300, (Object)"\u968f\u5dde\u5e02");
        b.put((Object)421303, (Object)"\u66fe\u90fd\u533a");
        b.put((Object)421321, (Object)"\u968f\u53bf");
        b.put((Object)421381, (Object)"\u5e7f\u6c34\u5e02");
        b.put((Object)422800, (Object)"\u6069\u65bd\u571f\u5bb6\u65cf\u82d7\u65cf\u81ea\u6cbb\u5dde");
        b.put((Object)422801, (Object)"\u6069\u65bd\u5e02");
        b.put((Object)422802, (Object)"\u5229\u5ddd\u5e02");
        b.put((Object)422822, (Object)"\u5efa\u59cb\u53bf");
        b.put((Object)422823, (Object)"\u5df4\u4e1c\u53bf");
        b.put((Object)422825, (Object)"\u5ba3\u6069\u53bf");
        b.put((Object)422826, (Object)"\u54b8\u4e30\u53bf");
        b.put((Object)422827, (Object)"\u6765\u51e4\u53bf");
        b.put((Object)422828, (Object)"\u9e64\u5cf0\u53bf");
        b.put((Object)429004, (Object)"\u4ed9\u6843\u5e02");
        b.put((Object)429005, (Object)"\u6f5c\u6c5f\u5e02");
        b.put((Object)429006, (Object)"\u5929\u95e8\u5e02");
        b.put((Object)429021, (Object)"\u795e\u519c\u67b6\u6797\u533a");
        b.put((Object)430000, (Object)"\u6e56\u5357\u7701");
        b.put((Object)430100, (Object)"\u957f\u6c99\u5e02");
        b.put((Object)430102, (Object)"\u8299\u84c9\u533a");
        b.put((Object)430103, (Object)"\u5929\u5fc3\u533a");
        b.put((Object)430104, (Object)"\u5cb3\u9e93\u533a");
        b.put((Object)430105, (Object)"\u5f00\u798f\u533a");
        b.put((Object)430111, (Object)"\u96e8\u82b1\u533a");
        b.put((Object)430112, (Object)"\u671b\u57ce\u533a");
        b.put((Object)430121, (Object)"\u957f\u6c99\u53bf");
        b.put((Object)430181, (Object)"\u6d4f\u9633\u5e02");
        b.put((Object)430182, (Object)"\u5b81\u4e61\u5e02");
        b.put((Object)430200, (Object)"\u682a\u6d32\u5e02");
        b.put((Object)430202, (Object)"\u8377\u5858\u533a");
        b.put((Object)430203, (Object)"\u82a6\u6dde\u533a");
        b.put((Object)430204, (Object)"\u77f3\u5cf0\u533a");
        b.put((Object)430211, (Object)"\u5929\u5143\u533a");
        b.put((Object)430212, (Object)"\u6e0c\u53e3\u533a");
        b.put((Object)430223, (Object)"\u6538\u53bf");
        b.put((Object)430224, (Object)"\u8336\u9675\u53bf");
        b.put((Object)430225, (Object)"\u708e\u9675\u53bf");
        b.put((Object)430281, (Object)"\u91b4\u9675\u5e02");
        b.put((Object)430300, (Object)"\u6e58\u6f6d\u5e02");
        b.put((Object)430302, (Object)"\u96e8\u6e56\u533a");
        b.put((Object)430304, (Object)"\u5cb3\u5858\u533a");
        b.put((Object)430321, (Object)"\u6e58\u6f6d\u53bf");
        b.put((Object)430381, (Object)"\u6e58\u4e61\u5e02");
        b.put((Object)430382, (Object)"\u97f6\u5c71\u5e02");
        b.put((Object)430400, (Object)"\u8861\u9633\u5e02");
        b.put((Object)430405, (Object)"\u73e0\u6656\u533a");
        b.put((Object)430406, (Object)"\u96c1\u5cf0\u533a");
        b.put((Object)430407, (Object)"\u77f3\u9f13\u533a");
        b.put((Object)430408, (Object)"\u84b8\u6e58\u533a");
        b.put((Object)430412, (Object)"\u5357\u5cb3\u533a");
        b.put((Object)430421, (Object)"\u8861\u9633\u53bf");
        b.put((Object)430422, (Object)"\u8861\u5357\u53bf");
        b.put((Object)430423, (Object)"\u8861\u5c71\u53bf");
        b.put((Object)430424, (Object)"\u8861\u4e1c\u53bf");
        b.put((Object)430426, (Object)"\u7941\u4e1c\u53bf");
        b.put((Object)430481, (Object)"\u8012\u9633\u5e02");
        b.put((Object)430482, (Object)"\u5e38\u5b81\u5e02");
        b.put((Object)430500, (Object)"\u90b5\u9633\u5e02");
        b.put((Object)430502, (Object)"\u53cc\u6e05\u533a");
        b.put((Object)430503, (Object)"\u5927\u7965\u533a");
        b.put((Object)430511, (Object)"\u5317\u5854\u533a");
        b.put((Object)430521, (Object)"\u90b5\u4e1c\u53bf");
        b.put((Object)430522, (Object)"\u65b0\u90b5\u53bf");
        b.put((Object)430523, (Object)"\u90b5\u9633\u53bf");
        b.put((Object)430524, (Object)"\u9686\u56de\u53bf");
        b.put((Object)430525, (Object)"\u6d1e\u53e3\u53bf");
        b.put((Object)430527, (Object)"\u7ee5\u5b81\u53bf");
        b.put((Object)430528, (Object)"\u65b0\u5b81\u53bf");
        b.put((Object)430529, (Object)"\u57ce\u6b65\u82d7\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)430581, (Object)"\u6b66\u5188\u5e02");
        b.put((Object)430600, (Object)"\u5cb3\u9633\u5e02");
        b.put((Object)430602, (Object)"\u5cb3\u9633\u697c\u533a");
        b.put((Object)430603, (Object)"\u4e91\u6eaa\u533a");
        b.put((Object)430611, (Object)"\u541b\u5c71\u533a");
        b.put((Object)430621, (Object)"\u5cb3\u9633\u53bf");
        b.put((Object)430623, (Object)"\u534e\u5bb9\u53bf");
        b.put((Object)430624, (Object)"\u6e58\u9634\u53bf");
        b.put((Object)430626, (Object)"\u5e73\u6c5f\u53bf");
        b.put((Object)430681, (Object)"\u6c68\u7f57\u5e02");
        b.put((Object)430682, (Object)"\u4e34\u6e58\u5e02");
        b.put((Object)430700, (Object)"\u5e38\u5fb7\u5e02");
        b.put((Object)430702, (Object)"\u6b66\u9675\u533a");
        b.put((Object)430703, (Object)"\u9f0e\u57ce\u533a");
        b.put((Object)430721, (Object)"\u5b89\u4e61\u53bf");
        b.put((Object)430722, (Object)"\u6c49\u5bff\u53bf");
        b.put((Object)430723, (Object)"\u6fa7\u53bf");
        b.put((Object)430724, (Object)"\u4e34\u6fa7\u53bf");
        b.put((Object)430725, (Object)"\u6843\u6e90\u53bf");
        b.put((Object)430726, (Object)"\u77f3\u95e8\u53bf");
        b.put((Object)430781, (Object)"\u6d25\u5e02\u5e02");
        b.put((Object)430800, (Object)"\u5f20\u5bb6\u754c\u5e02");
        b.put((Object)430802, (Object)"\u6c38\u5b9a\u533a");
        b.put((Object)430811, (Object)"\u6b66\u9675\u6e90\u533a");
        b.put((Object)430821, (Object)"\u6148\u5229\u53bf");
        b.put((Object)430822, (Object)"\u6851\u690d\u53bf");
        b.put((Object)430900, (Object)"\u76ca\u9633\u5e02");
        b.put((Object)430902, (Object)"\u8d44\u9633\u533a");
        b.put((Object)430903, (Object)"\u8d6b\u5c71\u533a");
        b.put((Object)430921, (Object)"\u5357\u53bf");
        b.put((Object)430922, (Object)"\u6843\u6c5f\u53bf");
        b.put((Object)430923, (Object)"\u5b89\u5316\u53bf");
        b.put((Object)430981, (Object)"\u6c85\u6c5f\u5e02");
        b.put((Object)431000, (Object)"\u90f4\u5dde\u5e02");
        b.put((Object)431002, (Object)"\u5317\u6e56\u533a");
        b.put((Object)431003, (Object)"\u82cf\u4ed9\u533a");
        b.put((Object)431021, (Object)"\u6842\u9633\u53bf");
        b.put((Object)431022, (Object)"\u5b9c\u7ae0\u53bf");
        b.put((Object)431023, (Object)"\u6c38\u5174\u53bf");
        b.put((Object)431024, (Object)"\u5609\u79be\u53bf");
        b.put((Object)431025, (Object)"\u4e34\u6b66\u53bf");
        b.put((Object)431026, (Object)"\u6c5d\u57ce\u53bf");
        b.put((Object)431027, (Object)"\u6842\u4e1c\u53bf");
        b.put((Object)431028, (Object)"\u5b89\u4ec1\u53bf");
        b.put((Object)431081, (Object)"\u8d44\u5174\u5e02");
        b.put((Object)431100, (Object)"\u6c38\u5dde\u5e02");
        b.put((Object)431102, (Object)"\u96f6\u9675\u533a");
        b.put((Object)431103, (Object)"\u51b7\u6c34\u6ee9\u533a");
        b.put((Object)431121, (Object)"\u7941\u9633\u53bf");
        b.put((Object)431122, (Object)"\u4e1c\u5b89\u53bf");
        b.put((Object)431123, (Object)"\u53cc\u724c\u53bf");
        b.put((Object)431124, (Object)"\u9053\u53bf");
        b.put((Object)431125, (Object)"\u6c5f\u6c38\u53bf");
        b.put((Object)431126, (Object)"\u5b81\u8fdc\u53bf");
        b.put((Object)431127, (Object)"\u84dd\u5c71\u53bf");
        b.put((Object)431128, (Object)"\u65b0\u7530\u53bf");
        b.put((Object)431129, (Object)"\u6c5f\u534e\u7476\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)431200, (Object)"\u6000\u5316\u5e02");
        b.put((Object)431202, (Object)"\u9e64\u57ce\u533a");
        b.put((Object)431221, (Object)"\u4e2d\u65b9\u53bf");
        b.put((Object)431222, (Object)"\u6c85\u9675\u53bf");
        b.put((Object)431223, (Object)"\u8fb0\u6eaa\u53bf");
        b.put((Object)431224, (Object)"\u6e86\u6d66\u53bf");
        b.put((Object)431225, (Object)"\u4f1a\u540c\u53bf");
        b.put((Object)431226, (Object)"\u9ebb\u9633\u82d7\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)431227, (Object)"\u65b0\u6643\u4f97\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)431228, (Object)"\u82b7\u6c5f\u4f97\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)431229, (Object)"\u9756\u5dde\u82d7\u65cf\u4f97\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)431230, (Object)"\u901a\u9053\u4f97\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)431281, (Object)"\u6d2a\u6c5f\u5e02");
        b.put((Object)431300, (Object)"\u5a04\u5e95\u5e02");
        b.put((Object)431302, (Object)"\u5a04\u661f\u533a");
        b.put((Object)431321, (Object)"\u53cc\u5cf0\u53bf");
        b.put((Object)431322, (Object)"\u65b0\u5316\u53bf");
        b.put((Object)431381, (Object)"\u51b7\u6c34\u6c5f\u5e02");
        b.put((Object)431382, (Object)"\u6d9f\u6e90\u5e02");
        b.put((Object)433100, (Object)"\u6e58\u897f\u571f\u5bb6\u65cf\u82d7\u65cf\u81ea\u6cbb\u5dde");
        b.put((Object)433101, (Object)"\u5409\u9996\u5e02");
        b.put((Object)433122, (Object)"\u6cf8\u6eaa\u53bf");
        b.put((Object)433123, (Object)"\u51e4\u51f0\u53bf");
        b.put((Object)433124, (Object)"\u82b1\u57a3\u53bf");
        b.put((Object)433125, (Object)"\u4fdd\u9756\u53bf");
        b.put((Object)433126, (Object)"\u53e4\u4e08\u53bf");
        b.put((Object)433127, (Object)"\u6c38\u987a\u53bf");
        b.put((Object)433130, (Object)"\u9f99\u5c71\u53bf");
        b.put((Object)440000, (Object)"\u5e7f\u4e1c\u7701");
        b.put((Object)440100, (Object)"\u5e7f\u5dde\u5e02");
        b.put((Object)440103, (Object)"\u8354\u6e7e\u533a");
        b.put((Object)440104, (Object)"\u8d8a\u79c0\u533a");
        b.put((Object)440105, (Object)"\u6d77\u73e0\u533a");
        b.put((Object)440106, (Object)"\u5929\u6cb3\u533a");
        b.put((Object)440111, (Object)"\u767d\u4e91\u533a");
        b.put((Object)440112, (Object)"\u9ec4\u57d4\u533a");
        b.put((Object)440113, (Object)"\u756a\u79ba\u533a");
        b.put((Object)440114, (Object)"\u82b1\u90fd\u533a");
        b.put((Object)440115, (Object)"\u5357\u6c99\u533a");
        b.put((Object)440117, (Object)"\u4ece\u5316\u533a");
        b.put((Object)440118, (Object)"\u589e\u57ce\u533a");
        b.put((Object)440200, (Object)"\u97f6\u5173\u5e02");
        b.put((Object)440203, (Object)"\u6b66\u6c5f\u533a");
        b.put((Object)440204, (Object)"\u6d48\u6c5f\u533a");
        b.put((Object)440205, (Object)"\u66f2\u6c5f\u533a");
        b.put((Object)440222, (Object)"\u59cb\u5174\u53bf");
        b.put((Object)440224, (Object)"\u4ec1\u5316\u53bf");
        b.put((Object)440229, (Object)"\u7fc1\u6e90\u53bf");
        b.put((Object)440232, (Object)"\u4e73\u6e90\u7476\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)440233, (Object)"\u65b0\u4e30\u53bf");
        b.put((Object)440281, (Object)"\u4e50\u660c\u5e02");
        b.put((Object)440282, (Object)"\u5357\u96c4\u5e02");
        b.put((Object)440300, (Object)"\u6df1\u5733\u5e02");
        b.put((Object)440303, (Object)"\u7f57\u6e56\u533a");
        b.put((Object)440304, (Object)"\u798f\u7530\u533a");
        b.put((Object)440305, (Object)"\u5357\u5c71\u533a");
        b.put((Object)440306, (Object)"\u5b9d\u5b89\u533a");
        b.put((Object)440307, (Object)"\u9f99\u5c97\u533a");
        b.put((Object)440308, (Object)"\u76d0\u7530\u533a");
        b.put((Object)440309, (Object)"\u9f99\u534e\u533a");
        b.put((Object)440310, (Object)"\u576a\u5c71\u533a");
        b.put((Object)440311, (Object)"\u5149\u660e\u533a");
        b.put((Object)440400, (Object)"\u73e0\u6d77\u5e02");
        b.put((Object)440402, (Object)"\u9999\u6d32\u533a");
        b.put((Object)440403, (Object)"\u6597\u95e8\u533a");
        b.put((Object)440404, (Object)"\u91d1\u6e7e\u533a");
        b.put((Object)440500, (Object)"\u6c55\u5934\u5e02");
        b.put((Object)440507, (Object)"\u9f99\u6e56\u533a");
        b.put((Object)440511, (Object)"\u91d1\u5e73\u533a");
        b.put((Object)440512, (Object)"\u6fe0\u6c5f\u533a");
        b.put((Object)440513, (Object)"\u6f6e\u9633\u533a");
        b.put((Object)440514, (Object)"\u6f6e\u5357\u533a");
        b.put((Object)440515, (Object)"\u6f84\u6d77\u533a");
        b.put((Object)440523, (Object)"\u5357\u6fb3\u53bf");
        b.put((Object)440600, (Object)"\u4f5b\u5c71\u5e02");
        b.put((Object)440604, (Object)"\u7985\u57ce\u533a");
        b.put((Object)440605, (Object)"\u5357\u6d77\u533a");
        b.put((Object)440606, (Object)"\u987a\u5fb7\u533a");
        b.put((Object)440607, (Object)"\u4e09\u6c34\u533a");
        b.put((Object)440608, (Object)"\u9ad8\u660e\u533a");
        b.put((Object)440700, (Object)"\u6c5f\u95e8\u5e02");
        b.put((Object)440703, (Object)"\u84ec\u6c5f\u533a");
        b.put((Object)440704, (Object)"\u6c5f\u6d77\u533a");
        b.put((Object)440705, (Object)"\u65b0\u4f1a\u533a");
        b.put((Object)440781, (Object)"\u53f0\u5c71\u5e02");
        b.put((Object)440783, (Object)"\u5f00\u5e73\u5e02");
        b.put((Object)440784, (Object)"\u9e64\u5c71\u5e02");
        b.put((Object)440785, (Object)"\u6069\u5e73\u5e02");
        b.put((Object)440800, (Object)"\u6e5b\u6c5f\u5e02");
        b.put((Object)440802, (Object)"\u8d64\u574e\u533a");
        b.put((Object)440803, (Object)"\u971e\u5c71\u533a");
        b.put((Object)440804, (Object)"\u5761\u5934\u533a");
        b.put((Object)440811, (Object)"\u9ebb\u7ae0\u533a");
        b.put((Object)440823, (Object)"\u9042\u6eaa\u53bf");
        b.put((Object)440825, (Object)"\u5f90\u95fb\u53bf");
        b.put((Object)440881, (Object)"\u5ec9\u6c5f\u5e02");
        b.put((Object)440882, (Object)"\u96f7\u5dde\u5e02");
        b.put((Object)440883, (Object)"\u5434\u5ddd\u5e02");
        b.put((Object)440900, (Object)"\u8302\u540d\u5e02");
        b.put((Object)440902, (Object)"\u8302\u5357\u533a");
        b.put((Object)440904, (Object)"\u7535\u767d\u533a");
        b.put((Object)440981, (Object)"\u9ad8\u5dde\u5e02");
        b.put((Object)440982, (Object)"\u5316\u5dde\u5e02");
        b.put((Object)440983, (Object)"\u4fe1\u5b9c\u5e02");
        b.put((Object)441200, (Object)"\u8087\u5e86\u5e02");
        b.put((Object)441202, (Object)"\u7aef\u5dde\u533a");
        b.put((Object)441203, (Object)"\u9f0e\u6e56\u533a");
        b.put((Object)441204, (Object)"\u9ad8\u8981\u533a");
        b.put((Object)441223, (Object)"\u5e7f\u5b81\u53bf");
        b.put((Object)441224, (Object)"\u6000\u96c6\u53bf");
        b.put((Object)441225, (Object)"\u5c01\u5f00\u53bf");
        b.put((Object)441226, (Object)"\u5fb7\u5e86\u53bf");
        b.put((Object)441284, (Object)"\u56db\u4f1a\u5e02");
        b.put((Object)441300, (Object)"\u60e0\u5dde\u5e02");
        b.put((Object)441302, (Object)"\u60e0\u57ce\u533a");
        b.put((Object)441303, (Object)"\u60e0\u9633\u533a");
        b.put((Object)441322, (Object)"\u535a\u7f57\u53bf");
        b.put((Object)441323, (Object)"\u60e0\u4e1c\u53bf");
        b.put((Object)441324, (Object)"\u9f99\u95e8\u53bf");
        b.put((Object)441400, (Object)"\u6885\u5dde\u5e02");
        b.put((Object)441402, (Object)"\u6885\u6c5f\u533a");
        b.put((Object)441403, (Object)"\u6885\u53bf\u533a");
        b.put((Object)441422, (Object)"\u5927\u57d4\u53bf");
        b.put((Object)441423, (Object)"\u4e30\u987a\u53bf");
        b.put((Object)441424, (Object)"\u4e94\u534e\u53bf");
        b.put((Object)441426, (Object)"\u5e73\u8fdc\u53bf");
        b.put((Object)441427, (Object)"\u8549\u5cad\u53bf");
        b.put((Object)441481, (Object)"\u5174\u5b81\u5e02");
        b.put((Object)441500, (Object)"\u6c55\u5c3e\u5e02");
        b.put((Object)441502, (Object)"\u57ce\u533a");
        b.put((Object)441521, (Object)"\u6d77\u4e30\u53bf");
        b.put((Object)441523, (Object)"\u9646\u6cb3\u53bf");
        b.put((Object)441581, (Object)"\u9646\u4e30\u5e02");
        b.put((Object)441600, (Object)"\u6cb3\u6e90\u5e02");
        b.put((Object)441602, (Object)"\u6e90\u57ce\u533a");
        b.put((Object)441621, (Object)"\u7d2b\u91d1\u53bf");
        b.put((Object)441622, (Object)"\u9f99\u5ddd\u53bf");
        b.put((Object)441623, (Object)"\u8fde\u5e73\u53bf");
        b.put((Object)441624, (Object)"\u548c\u5e73\u53bf");
        b.put((Object)441625, (Object)"\u4e1c\u6e90\u53bf");
        b.put((Object)441700, (Object)"\u9633\u6c5f\u5e02");
        b.put((Object)441702, (Object)"\u6c5f\u57ce\u533a");
        b.put((Object)441704, (Object)"\u9633\u4e1c\u533a");
        b.put((Object)441721, (Object)"\u9633\u897f\u53bf");
        b.put((Object)441781, (Object)"\u9633\u6625\u5e02");
        b.put((Object)441800, (Object)"\u6e05\u8fdc\u5e02");
        b.put((Object)441802, (Object)"\u6e05\u57ce\u533a");
        b.put((Object)441803, (Object)"\u6e05\u65b0\u533a");
        b.put((Object)441821, (Object)"\u4f5b\u5188\u53bf");
        b.put((Object)441823, (Object)"\u9633\u5c71\u53bf");
        b.put((Object)441825, (Object)"\u8fde\u5c71\u58ee\u65cf\u7476\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)441826, (Object)"\u8fde\u5357\u7476\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)441881, (Object)"\u82f1\u5fb7\u5e02");
        b.put((Object)441882, (Object)"\u8fde\u5dde\u5e02");
        b.put((Object)441900, (Object)"\u4e1c\u839e\u5e02");
        b.put((Object)442000, (Object)"\u4e2d\u5c71\u5e02");
        b.put((Object)445100, (Object)"\u6f6e\u5dde\u5e02");
        b.put((Object)445102, (Object)"\u6e58\u6865\u533a");
        b.put((Object)445103, (Object)"\u6f6e\u5b89\u533a");
        b.put((Object)445122, (Object)"\u9976\u5e73\u53bf");
        b.put((Object)445200, (Object)"\u63ed\u9633\u5e02");
        b.put((Object)445202, (Object)"\u6995\u57ce\u533a");
        b.put((Object)445203, (Object)"\u63ed\u4e1c\u533a");
        b.put((Object)445222, (Object)"\u63ed\u897f\u53bf");
        b.put((Object)445224, (Object)"\u60e0\u6765\u53bf");
        b.put((Object)445281, (Object)"\u666e\u5b81\u5e02");
        b.put((Object)445300, (Object)"\u4e91\u6d6e\u5e02");
        b.put((Object)445302, (Object)"\u4e91\u57ce\u533a");
        b.put((Object)445303, (Object)"\u4e91\u5b89\u533a");
        b.put((Object)445321, (Object)"\u65b0\u5174\u53bf");
        b.put((Object)445322, (Object)"\u90c1\u5357\u53bf");
        b.put((Object)445381, (Object)"\u7f57\u5b9a\u5e02");
        b.put((Object)450000, (Object)"\u5e7f\u897f\u58ee\u65cf\u81ea\u6cbb\u533a");
        b.put((Object)450100, (Object)"\u5357\u5b81\u5e02");
        b.put((Object)450102, (Object)"\u5174\u5b81\u533a");
        b.put((Object)450103, (Object)"\u9752\u79c0\u533a");
        b.put((Object)450105, (Object)"\u6c5f\u5357\u533a");
        b.put((Object)450107, (Object)"\u897f\u4e61\u5858\u533a");
        b.put((Object)450108, (Object)"\u826f\u5e86\u533a");
        b.put((Object)450109, (Object)"\u9095\u5b81\u533a");
        b.put((Object)450110, (Object)"\u6b66\u9e23\u533a");
        b.put((Object)450123, (Object)"\u9686\u5b89\u53bf");
        b.put((Object)450124, (Object)"\u9a6c\u5c71\u53bf");
        b.put((Object)450125, (Object)"\u4e0a\u6797\u53bf");
        b.put((Object)450126, (Object)"\u5bbe\u9633\u53bf");
        b.put((Object)450127, (Object)"\u6a2a\u53bf");
        b.put((Object)450200, (Object)"\u67f3\u5dde\u5e02");
        b.put((Object)450202, (Object)"\u57ce\u4e2d\u533a");
        b.put((Object)450203, (Object)"\u9c7c\u5cf0\u533a");
        b.put((Object)450204, (Object)"\u67f3\u5357\u533a");
        b.put((Object)450205, (Object)"\u67f3\u5317\u533a");
        b.put((Object)450206, (Object)"\u67f3\u6c5f\u533a");
        b.put((Object)450222, (Object)"\u67f3\u57ce\u53bf");
        b.put((Object)450223, (Object)"\u9e7f\u5be8\u53bf");
        b.put((Object)450224, (Object)"\u878d\u5b89\u53bf");
        b.put((Object)450225, (Object)"\u878d\u6c34\u82d7\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)450226, (Object)"\u4e09\u6c5f\u4f97\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)450300, (Object)"\u6842\u6797\u5e02");
        b.put((Object)450302, (Object)"\u79c0\u5cf0\u533a");
        b.put((Object)450303, (Object)"\u53e0\u5f69\u533a");
        b.put((Object)450304, (Object)"\u8c61\u5c71\u533a");
        b.put((Object)450305, (Object)"\u4e03\u661f\u533a");
        b.put((Object)450311, (Object)"\u96c1\u5c71\u533a");
        b.put((Object)450312, (Object)"\u4e34\u6842\u533a");
        b.put((Object)450321, (Object)"\u9633\u6714\u53bf");
        b.put((Object)450323, (Object)"\u7075\u5ddd\u53bf");
        b.put((Object)450324, (Object)"\u5168\u5dde\u53bf");
        b.put((Object)450325, (Object)"\u5174\u5b89\u53bf");
        b.put((Object)450326, (Object)"\u6c38\u798f\u53bf");
        b.put((Object)450327, (Object)"\u704c\u9633\u53bf");
        b.put((Object)450328, (Object)"\u9f99\u80dc\u5404\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)450329, (Object)"\u8d44\u6e90\u53bf");
        b.put((Object)450330, (Object)"\u5e73\u4e50\u53bf");
        b.put((Object)450381, (Object)"\u8354\u6d66\u5e02");
        b.put((Object)450332, (Object)"\u606d\u57ce\u7476\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)450400, (Object)"\u68a7\u5dde\u5e02");
        b.put((Object)450403, (Object)"\u4e07\u79c0\u533a");
        b.put((Object)450405, (Object)"\u957f\u6d32\u533a");
        b.put((Object)450406, (Object)"\u9f99\u5729\u533a");
        b.put((Object)450421, (Object)"\u82cd\u68a7\u53bf");
        b.put((Object)450422, (Object)"\u85e4\u53bf");
        b.put((Object)450423, (Object)"\u8499\u5c71\u53bf");
        b.put((Object)450481, (Object)"\u5c91\u6eaa\u5e02");
        b.put((Object)450500, (Object)"\u5317\u6d77\u5e02");
        b.put((Object)450502, (Object)"\u6d77\u57ce\u533a");
        b.put((Object)450503, (Object)"\u94f6\u6d77\u533a");
        b.put((Object)450512, (Object)"\u94c1\u5c71\u6e2f\u533a");
        b.put((Object)450521, (Object)"\u5408\u6d66\u53bf");
        b.put((Object)450600, (Object)"\u9632\u57ce\u6e2f\u5e02");
        b.put((Object)450602, (Object)"\u6e2f\u53e3\u533a");
        b.put((Object)450603, (Object)"\u9632\u57ce\u533a");
        b.put((Object)450621, (Object)"\u4e0a\u601d\u53bf");
        b.put((Object)450681, (Object)"\u4e1c\u5174\u5e02");
        b.put((Object)450700, (Object)"\u94a6\u5dde\u5e02");
        b.put((Object)450702, (Object)"\u94a6\u5357\u533a");
        b.put((Object)450703, (Object)"\u94a6\u5317\u533a");
        b.put((Object)450721, (Object)"\u7075\u5c71\u53bf");
        b.put((Object)450722, (Object)"\u6d66\u5317\u53bf");
        b.put((Object)450800, (Object)"\u8d35\u6e2f\u5e02");
        b.put((Object)450802, (Object)"\u6e2f\u5317\u533a");
        b.put((Object)450803, (Object)"\u6e2f\u5357\u533a");
        b.put((Object)450804, (Object)"\u8983\u5858\u533a");
        b.put((Object)450821, (Object)"\u5e73\u5357\u53bf");
        b.put((Object)450881, (Object)"\u6842\u5e73\u5e02");
        b.put((Object)450900, (Object)"\u7389\u6797\u5e02");
        b.put((Object)450902, (Object)"\u7389\u5dde\u533a");
        b.put((Object)450903, (Object)"\u798f\u7ef5\u533a");
        b.put((Object)450921, (Object)"\u5bb9\u53bf");
        b.put((Object)450922, (Object)"\u9646\u5ddd\u53bf");
        b.put((Object)450923, (Object)"\u535a\u767d\u53bf");
        b.put((Object)450924, (Object)"\u5174\u4e1a\u53bf");
        b.put((Object)450981, (Object)"\u5317\u6d41\u5e02");
        b.put((Object)451000, (Object)"\u767e\u8272\u5e02");
        b.put((Object)451002, (Object)"\u53f3\u6c5f\u533a");
        b.put((Object)451021, (Object)"\u7530\u9633\u53bf");
        b.put((Object)451022, (Object)"\u7530\u4e1c\u53bf");
        b.put((Object)451023, (Object)"\u5e73\u679c\u53bf");
        b.put((Object)451024, (Object)"\u5fb7\u4fdd\u53bf");
        b.put((Object)451026, (Object)"\u90a3\u5761\u53bf");
        b.put((Object)451027, (Object)"\u51cc\u4e91\u53bf");
        b.put((Object)451028, (Object)"\u4e50\u4e1a\u53bf");
        b.put((Object)451029, (Object)"\u7530\u6797\u53bf");
        b.put((Object)451030, (Object)"\u897f\u6797\u53bf");
        b.put((Object)451031, (Object)"\u9686\u6797\u5404\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)451081, (Object)"\u9756\u897f\u5e02");
        b.put((Object)451100, (Object)"\u8d3a\u5dde\u5e02");
        b.put((Object)451102, (Object)"\u516b\u6b65\u533a");
        b.put((Object)451103, (Object)"\u5e73\u6842\u533a");
        b.put((Object)451121, (Object)"\u662d\u5e73\u53bf");
        b.put((Object)451122, (Object)"\u949f\u5c71\u53bf");
        b.put((Object)451123, (Object)"\u5bcc\u5ddd\u7476\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)451200, (Object)"\u6cb3\u6c60\u5e02");
        b.put((Object)451202, (Object)"\u91d1\u57ce\u6c5f\u533a");
        b.put((Object)451203, (Object)"\u5b9c\u5dde\u533a");
        b.put((Object)451221, (Object)"\u5357\u4e39\u53bf");
        b.put((Object)451222, (Object)"\u5929\u5ce8\u53bf");
        b.put((Object)451223, (Object)"\u51e4\u5c71\u53bf");
        b.put((Object)451224, (Object)"\u4e1c\u5170\u53bf");
        b.put((Object)451225, (Object)"\u7f57\u57ce\u4eeb\u4f6c\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)451226, (Object)"\u73af\u6c5f\u6bdb\u5357\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)451227, (Object)"\u5df4\u9a6c\u7476\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)451228, (Object)"\u90fd\u5b89\u7476\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)451229, (Object)"\u5927\u5316\u7476\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)451300, (Object)"\u6765\u5bbe\u5e02");
        b.put((Object)451302, (Object)"\u5174\u5bbe\u533a");
        b.put((Object)451321, (Object)"\u5ffb\u57ce\u53bf");
        b.put((Object)451322, (Object)"\u8c61\u5dde\u53bf");
        b.put((Object)451323, (Object)"\u6b66\u5ba3\u53bf");
        b.put((Object)451324, (Object)"\u91d1\u79c0\u7476\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)451381, (Object)"\u5408\u5c71\u5e02");
        b.put((Object)451400, (Object)"\u5d07\u5de6\u5e02");
        b.put((Object)451402, (Object)"\u6c5f\u5dde\u533a");
        b.put((Object)451421, (Object)"\u6276\u7ee5\u53bf");
        b.put((Object)451422, (Object)"\u5b81\u660e\u53bf");
        b.put((Object)451423, (Object)"\u9f99\u5dde\u53bf");
        b.put((Object)451424, (Object)"\u5927\u65b0\u53bf");
        b.put((Object)451425, (Object)"\u5929\u7b49\u53bf");
        b.put((Object)451481, (Object)"\u51ed\u7965\u5e02");
        b.put((Object)460000, (Object)"\u6d77\u5357\u7701");
        b.put((Object)460100, (Object)"\u6d77\u53e3\u5e02");
        b.put((Object)460105, (Object)"\u79c0\u82f1\u533a");
        b.put((Object)460106, (Object)"\u9f99\u534e\u533a");
        b.put((Object)460107, (Object)"\u743c\u5c71\u533a");
        b.put((Object)460108, (Object)"\u7f8e\u5170\u533a");
        b.put((Object)460200, (Object)"\u4e09\u4e9a\u5e02");
        b.put((Object)460202, (Object)"\u6d77\u68e0\u533a");
        b.put((Object)460203, (Object)"\u5409\u9633\u533a");
        b.put((Object)460204, (Object)"\u5929\u6daf\u533a");
        b.put((Object)460205, (Object)"\u5d16\u5dde\u533a");
        b.put((Object)460300, (Object)"\u4e09\u6c99\u5e02");
        b.put((Object)460400, (Object)"\u510b\u5dde\u5e02");
        b.put((Object)469001, (Object)"\u4e94\u6307\u5c71\u5e02");
        b.put((Object)469002, (Object)"\u743c\u6d77\u5e02");
        b.put((Object)469005, (Object)"\u6587\u660c\u5e02");
        b.put((Object)469006, (Object)"\u4e07\u5b81\u5e02");
        b.put((Object)469007, (Object)"\u4e1c\u65b9\u5e02");
        b.put((Object)469021, (Object)"\u5b9a\u5b89\u53bf");
        b.put((Object)469022, (Object)"\u5c6f\u660c\u53bf");
        b.put((Object)469023, (Object)"\u6f84\u8fc8\u53bf");
        b.put((Object)469024, (Object)"\u4e34\u9ad8\u53bf");
        b.put((Object)469025, (Object)"\u767d\u6c99\u9ece\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)469026, (Object)"\u660c\u6c5f\u9ece\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)469027, (Object)"\u4e50\u4e1c\u9ece\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)469028, (Object)"\u9675\u6c34\u9ece\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)469029, (Object)"\u4fdd\u4ead\u9ece\u65cf\u82d7\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)469030, (Object)"\u743c\u4e2d\u9ece\u65cf\u82d7\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)500000, (Object)"\u91cd\u5e86\u5e02");
        b.put((Object)500101, (Object)"\u4e07\u5dde\u533a");
        b.put((Object)500102, (Object)"\u6daa\u9675\u533a");
        b.put((Object)500103, (Object)"\u6e1d\u4e2d\u533a");
        b.put((Object)500104, (Object)"\u5927\u6e21\u53e3\u533a");
        b.put((Object)500105, (Object)"\u6c5f\u5317\u533a");
        b.put((Object)500106, (Object)"\u6c99\u576a\u575d\u533a");
        b.put((Object)500107, (Object)"\u4e5d\u9f99\u5761\u533a");
        b.put((Object)500108, (Object)"\u5357\u5cb8\u533a");
        b.put((Object)500109, (Object)"\u5317\u789a\u533a");
        b.put((Object)500110, (Object)"\u7da6\u6c5f\u533a");
        b.put((Object)500111, (Object)"\u5927\u8db3\u533a");
        b.put((Object)500112, (Object)"\u6e1d\u5317\u533a");
        b.put((Object)500113, (Object)"\u5df4\u5357\u533a");
        b.put((Object)500114, (Object)"\u9ed4\u6c5f\u533a");
        b.put((Object)500115, (Object)"\u957f\u5bff\u533a");
        b.put((Object)500116, (Object)"\u6c5f\u6d25\u533a");
        b.put((Object)500117, (Object)"\u5408\u5ddd\u533a");
        b.put((Object)500118, (Object)"\u6c38\u5ddd\u533a");
        b.put((Object)500119, (Object)"\u5357\u5ddd\u533a");
        b.put((Object)500120, (Object)"\u74a7\u5c71\u533a");
        b.put((Object)500151, (Object)"\u94dc\u6881\u533a");
        b.put((Object)500152, (Object)"\u6f7c\u5357\u533a");
        b.put((Object)500153, (Object)"\u8363\u660c\u533a");
        b.put((Object)500154, (Object)"\u5f00\u5dde\u533a");
        b.put((Object)500155, (Object)"\u6881\u5e73\u533a");
        b.put((Object)500156, (Object)"\u6b66\u9686\u533a");
        b.put((Object)500229, (Object)"\u57ce\u53e3\u53bf");
        b.put((Object)500230, (Object)"\u4e30\u90fd\u53bf");
        b.put((Object)500231, (Object)"\u57ab\u6c5f\u53bf");
        b.put((Object)500233, (Object)"\u5fe0\u53bf");
        b.put((Object)500235, (Object)"\u4e91\u9633\u53bf");
        b.put((Object)500236, (Object)"\u5949\u8282\u53bf");
        b.put((Object)500237, (Object)"\u5deb\u5c71\u53bf");
        b.put((Object)500238, (Object)"\u5deb\u6eaa\u53bf");
        b.put((Object)500240, (Object)"\u77f3\u67f1\u571f\u5bb6\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)500241, (Object)"\u79c0\u5c71\u571f\u5bb6\u65cf\u82d7\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)500242, (Object)"\u9149\u9633\u571f\u5bb6\u65cf\u82d7\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)500243, (Object)"\u5f6d\u6c34\u82d7\u65cf\u571f\u5bb6\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)510000, (Object)"\u56db\u5ddd\u7701");
        b.put((Object)510100, (Object)"\u6210\u90fd\u5e02");
        b.put((Object)510104, (Object)"\u9526\u6c5f\u533a");
        b.put((Object)510105, (Object)"\u9752\u7f8a\u533a");
        b.put((Object)510106, (Object)"\u91d1\u725b\u533a");
        b.put((Object)510107, (Object)"\u6b66\u4faf\u533a");
        b.put((Object)510108, (Object)"\u6210\u534e\u533a");
        b.put((Object)510112, (Object)"\u9f99\u6cc9\u9a7f\u533a");
        b.put((Object)510113, (Object)"\u9752\u767d\u6c5f\u533a");
        b.put((Object)510114, (Object)"\u65b0\u90fd\u533a");
        b.put((Object)510115, (Object)"\u6e29\u6c5f\u533a");
        b.put((Object)510116, (Object)"\u53cc\u6d41\u533a");
        b.put((Object)510117, (Object)"\u90eb\u90fd\u533a");
        b.put((Object)510121, (Object)"\u91d1\u5802\u53bf");
        b.put((Object)510129, (Object)"\u5927\u9091\u53bf");
        b.put((Object)510131, (Object)"\u84b2\u6c5f\u53bf");
        b.put((Object)510132, (Object)"\u65b0\u6d25\u53bf");
        b.put((Object)510181, (Object)"\u90fd\u6c5f\u5830\u5e02");
        b.put((Object)510182, (Object)"\u5f6d\u5dde\u5e02");
        b.put((Object)510183, (Object)"\u909b\u5d03\u5e02");
        b.put((Object)510184, (Object)"\u5d07\u5dde\u5e02");
        b.put((Object)510185, (Object)"\u7b80\u9633\u5e02");
        b.put((Object)510300, (Object)"\u81ea\u8d21\u5e02");
        b.put((Object)510302, (Object)"\u81ea\u6d41\u4e95\u533a");
        b.put((Object)510303, (Object)"\u8d21\u4e95\u533a");
        b.put((Object)510304, (Object)"\u5927\u5b89\u533a");
        b.put((Object)510311, (Object)"\u6cbf\u6ee9\u533a");
        b.put((Object)510321, (Object)"\u8363\u53bf");
        b.put((Object)510322, (Object)"\u5bcc\u987a\u53bf");
        b.put((Object)510400, (Object)"\u6500\u679d\u82b1\u5e02");
        b.put((Object)510402, (Object)"\u4e1c\u533a");
        b.put((Object)510403, (Object)"\u897f\u533a");
        b.put((Object)510411, (Object)"\u4ec1\u548c\u533a");
        b.put((Object)510421, (Object)"\u7c73\u6613\u53bf");
        b.put((Object)510422, (Object)"\u76d0\u8fb9\u53bf");
        b.put((Object)510500, (Object)"\u6cf8\u5dde\u5e02");
        b.put((Object)510502, (Object)"\u6c5f\u9633\u533a");
        b.put((Object)510503, (Object)"\u7eb3\u6eaa\u533a");
        b.put((Object)510504, (Object)"\u9f99\u9a6c\u6f6d\u533a");
        b.put((Object)510521, (Object)"\u6cf8\u53bf");
        b.put((Object)510522, (Object)"\u5408\u6c5f\u53bf");
        b.put((Object)510524, (Object)"\u53d9\u6c38\u53bf");
        b.put((Object)510525, (Object)"\u53e4\u853a\u53bf");
        b.put((Object)510600, (Object)"\u5fb7\u9633\u5e02");
        b.put((Object)510603, (Object)"\u65cc\u9633\u533a");
        b.put((Object)510604, (Object)"\u7f57\u6c5f\u533a");
        b.put((Object)510623, (Object)"\u4e2d\u6c5f\u53bf");
        b.put((Object)510681, (Object)"\u5e7f\u6c49\u5e02");
        b.put((Object)510682, (Object)"\u4ec0\u90a1\u5e02");
        b.put((Object)510683, (Object)"\u7ef5\u7af9\u5e02");
        b.put((Object)510700, (Object)"\u7ef5\u9633\u5e02");
        b.put((Object)510703, (Object)"\u6daa\u57ce\u533a");
        b.put((Object)510704, (Object)"\u6e38\u4ed9\u533a");
        b.put((Object)510705, (Object)"\u5b89\u5dde\u533a");
        b.put((Object)510722, (Object)"\u4e09\u53f0\u53bf");
        b.put((Object)510723, (Object)"\u76d0\u4ead\u53bf");
        b.put((Object)510725, (Object)"\u6893\u6f7c\u53bf");
        b.put((Object)510726, (Object)"\u5317\u5ddd\u7f8c\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)510727, (Object)"\u5e73\u6b66\u53bf");
        b.put((Object)510781, (Object)"\u6c5f\u6cb9\u5e02");
        b.put((Object)510800, (Object)"\u5e7f\u5143\u5e02");
        b.put((Object)510802, (Object)"\u5229\u5dde\u533a");
        b.put((Object)510811, (Object)"\u662d\u5316\u533a");
        b.put((Object)510812, (Object)"\u671d\u5929\u533a");
        b.put((Object)510821, (Object)"\u65fa\u82cd\u53bf");
        b.put((Object)510822, (Object)"\u9752\u5ddd\u53bf");
        b.put((Object)510823, (Object)"\u5251\u9601\u53bf");
        b.put((Object)510824, (Object)"\u82cd\u6eaa\u53bf");
        b.put((Object)510900, (Object)"\u9042\u5b81\u5e02");
        b.put((Object)510903, (Object)"\u8239\u5c71\u533a");
        b.put((Object)510904, (Object)"\u5b89\u5c45\u533a");
        b.put((Object)510921, (Object)"\u84ec\u6eaa\u53bf");
        b.put((Object)510922, (Object)"\u5c04\u6d2a\u53bf");
        b.put((Object)510923, (Object)"\u5927\u82f1\u53bf");
        b.put((Object)511000, (Object)"\u5185\u6c5f\u5e02");
        b.put((Object)511002, (Object)"\u5e02\u4e2d\u533a");
        b.put((Object)511011, (Object)"\u4e1c\u5174\u533a");
        b.put((Object)511024, (Object)"\u5a01\u8fdc\u53bf");
        b.put((Object)511025, (Object)"\u8d44\u4e2d\u53bf");
        b.put((Object)511083, (Object)"\u9686\u660c\u5e02");
        b.put((Object)511100, (Object)"\u4e50\u5c71\u5e02");
        b.put((Object)511102, (Object)"\u5e02\u4e2d\u533a");
        b.put((Object)511111, (Object)"\u6c99\u6e7e\u533a");
        b.put((Object)511112, (Object)"\u4e94\u901a\u6865\u533a");
        b.put((Object)511113, (Object)"\u91d1\u53e3\u6cb3\u533a");
        b.put((Object)511123, (Object)"\u728d\u4e3a\u53bf");
        b.put((Object)511124, (Object)"\u4e95\u7814\u53bf");
        b.put((Object)511126, (Object)"\u5939\u6c5f\u53bf");
        b.put((Object)511129, (Object)"\u6c90\u5ddd\u53bf");
        b.put((Object)511132, (Object)"\u5ce8\u8fb9\u5f5d\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)511133, (Object)"\u9a6c\u8fb9\u5f5d\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)511181, (Object)"\u5ce8\u7709\u5c71\u5e02");
        b.put((Object)511300, (Object)"\u5357\u5145\u5e02");
        b.put((Object)511302, (Object)"\u987a\u5e86\u533a");
        b.put((Object)511303, (Object)"\u9ad8\u576a\u533a");
        b.put((Object)511304, (Object)"\u5609\u9675\u533a");
        b.put((Object)511321, (Object)"\u5357\u90e8\u53bf");
        b.put((Object)511322, (Object)"\u8425\u5c71\u53bf");
        b.put((Object)511323, (Object)"\u84ec\u5b89\u53bf");
        b.put((Object)511324, (Object)"\u4eea\u9647\u53bf");
        b.put((Object)511325, (Object)"\u897f\u5145\u53bf");
        b.put((Object)511381, (Object)"\u9606\u4e2d\u5e02");
        b.put((Object)511400, (Object)"\u7709\u5c71\u5e02");
        b.put((Object)511402, (Object)"\u4e1c\u5761\u533a");
        b.put((Object)511403, (Object)"\u5f6d\u5c71\u533a");
        b.put((Object)511421, (Object)"\u4ec1\u5bff\u53bf");
        b.put((Object)511423, (Object)"\u6d2a\u96c5\u53bf");
        b.put((Object)511424, (Object)"\u4e39\u68f1\u53bf");
        b.put((Object)511425, (Object)"\u9752\u795e\u53bf");
        b.put((Object)511500, (Object)"\u5b9c\u5bbe\u5e02");
        b.put((Object)511502, (Object)"\u7fe0\u5c4f\u533a");
        b.put((Object)511503, (Object)"\u5357\u6eaa\u533a");
        b.put((Object)511521, (Object)"\u5b9c\u5bbe\u53bf");
        b.put((Object)511523, (Object)"\u6c5f\u5b89\u53bf");
        b.put((Object)511524, (Object)"\u957f\u5b81\u53bf");
        b.put((Object)511525, (Object)"\u9ad8\u53bf");
        b.put((Object)511526, (Object)"\u73d9\u53bf");
        b.put((Object)511527, (Object)"\u7b60\u8fde\u53bf");
        b.put((Object)511528, (Object)"\u5174\u6587\u53bf");
        b.put((Object)511529, (Object)"\u5c4f\u5c71\u53bf");
        b.put((Object)511600, (Object)"\u5e7f\u5b89\u5e02");
        b.put((Object)511602, (Object)"\u5e7f\u5b89\u533a");
        b.put((Object)511603, (Object)"\u524d\u950b\u533a");
        b.put((Object)511621, (Object)"\u5cb3\u6c60\u53bf");
        b.put((Object)511622, (Object)"\u6b66\u80dc\u53bf");
        b.put((Object)511623, (Object)"\u90bb\u6c34\u53bf");
        b.put((Object)511681, (Object)"\u534e\u84e5\u5e02");
        b.put((Object)511700, (Object)"\u8fbe\u5dde\u5e02");
        b.put((Object)511702, (Object)"\u901a\u5ddd\u533a");
        b.put((Object)511703, (Object)"\u8fbe\u5ddd\u533a");
        b.put((Object)511722, (Object)"\u5ba3\u6c49\u53bf");
        b.put((Object)511723, (Object)"\u5f00\u6c5f\u53bf");
        b.put((Object)511724, (Object)"\u5927\u7af9\u53bf");
        b.put((Object)511725, (Object)"\u6e20\u53bf");
        b.put((Object)511781, (Object)"\u4e07\u6e90\u5e02");
        b.put((Object)511800, (Object)"\u96c5\u5b89\u5e02");
        b.put((Object)511802, (Object)"\u96e8\u57ce\u533a");
        b.put((Object)511803, (Object)"\u540d\u5c71\u533a");
        b.put((Object)511822, (Object)"\u8365\u7ecf\u53bf");
        b.put((Object)511823, (Object)"\u6c49\u6e90\u53bf");
        b.put((Object)511824, (Object)"\u77f3\u68c9\u53bf");
        b.put((Object)511825, (Object)"\u5929\u5168\u53bf");
        b.put((Object)511826, (Object)"\u82a6\u5c71\u53bf");
        b.put((Object)511827, (Object)"\u5b9d\u5174\u53bf");
        b.put((Object)511900, (Object)"\u5df4\u4e2d\u5e02");
        b.put((Object)511902, (Object)"\u5df4\u5dde\u533a");
        b.put((Object)511903, (Object)"\u6069\u9633\u533a");
        b.put((Object)511921, (Object)"\u901a\u6c5f\u53bf");
        b.put((Object)511922, (Object)"\u5357\u6c5f\u53bf");
        b.put((Object)511923, (Object)"\u5e73\u660c\u53bf");
        b.put((Object)512000, (Object)"\u8d44\u9633\u5e02");
        b.put((Object)512002, (Object)"\u96c1\u6c5f\u533a");
        b.put((Object)512021, (Object)"\u5b89\u5cb3\u53bf");
        b.put((Object)512022, (Object)"\u4e50\u81f3\u53bf");
        b.put((Object)513200, (Object)"\u963f\u575d\u85cf\u65cf\u7f8c\u65cf\u81ea\u6cbb\u5dde");
        b.put((Object)513201, (Object)"\u9a6c\u5c14\u5eb7\u5e02");
        b.put((Object)513221, (Object)"\u6c76\u5ddd\u53bf");
        b.put((Object)513222, (Object)"\u7406\u53bf");
        b.put((Object)513223, (Object)"\u8302\u53bf");
        b.put((Object)513224, (Object)"\u677e\u6f58\u53bf");
        b.put((Object)513225, (Object)"\u4e5d\u5be8\u6c9f\u53bf");
        b.put((Object)513226, (Object)"\u91d1\u5ddd\u53bf");
        b.put((Object)513227, (Object)"\u5c0f\u91d1\u53bf");
        b.put((Object)513228, (Object)"\u9ed1\u6c34\u53bf");
        b.put((Object)513230, (Object)"\u58e4\u5858\u53bf");
        b.put((Object)513231, (Object)"\u963f\u575d\u53bf");
        b.put((Object)513232, (Object)"\u82e5\u5c14\u76d6\u53bf");
        b.put((Object)513233, (Object)"\u7ea2\u539f\u53bf");
        b.put((Object)513300, (Object)"\u7518\u5b5c\u85cf\u65cf\u81ea\u6cbb\u5dde");
        b.put((Object)513301, (Object)"\u5eb7\u5b9a\u5e02");
        b.put((Object)513322, (Object)"\u6cf8\u5b9a\u53bf");
        b.put((Object)513323, (Object)"\u4e39\u5df4\u53bf");
        b.put((Object)513324, (Object)"\u4e5d\u9f99\u53bf");
        b.put((Object)513325, (Object)"\u96c5\u6c5f\u53bf");
        b.put((Object)513326, (Object)"\u9053\u5b5a\u53bf");
        b.put((Object)513327, (Object)"\u7089\u970d\u53bf");
        b.put((Object)513328, (Object)"\u7518\u5b5c\u53bf");
        b.put((Object)513329, (Object)"\u65b0\u9f99\u53bf");
        b.put((Object)513330, (Object)"\u5fb7\u683c\u53bf");
        b.put((Object)513331, (Object)"\u767d\u7389\u53bf");
        b.put((Object)513332, (Object)"\u77f3\u6e20\u53bf");
        b.put((Object)513333, (Object)"\u8272\u8fbe\u53bf");
        b.put((Object)513334, (Object)"\u7406\u5858\u53bf");
        b.put((Object)513335, (Object)"\u5df4\u5858\u53bf");
        b.put((Object)513336, (Object)"\u4e61\u57ce\u53bf");
        b.put((Object)513337, (Object)"\u7a3b\u57ce\u53bf");
        b.put((Object)513338, (Object)"\u5f97\u8363\u53bf");
        b.put((Object)513400, (Object)"\u51c9\u5c71\u5f5d\u65cf\u81ea\u6cbb\u5dde");
        b.put((Object)513401, (Object)"\u897f\u660c\u5e02");
        b.put((Object)513422, (Object)"\u6728\u91cc\u85cf\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)513423, (Object)"\u76d0\u6e90\u53bf");
        b.put((Object)513424, (Object)"\u5fb7\u660c\u53bf");
        b.put((Object)513425, (Object)"\u4f1a\u7406\u53bf");
        b.put((Object)513426, (Object)"\u4f1a\u4e1c\u53bf");
        b.put((Object)513427, (Object)"\u5b81\u5357\u53bf");
        b.put((Object)513428, (Object)"\u666e\u683c\u53bf");
        b.put((Object)513429, (Object)"\u5e03\u62d6\u53bf");
        b.put((Object)513430, (Object)"\u91d1\u9633\u53bf");
        b.put((Object)513431, (Object)"\u662d\u89c9\u53bf");
        b.put((Object)513432, (Object)"\u559c\u5fb7\u53bf");
        b.put((Object)513433, (Object)"\u5195\u5b81\u53bf");
        b.put((Object)513434, (Object)"\u8d8a\u897f\u53bf");
        b.put((Object)513435, (Object)"\u7518\u6d1b\u53bf");
        b.put((Object)513436, (Object)"\u7f8e\u59d1\u53bf");
        b.put((Object)513437, (Object)"\u96f7\u6ce2\u53bf");
        b.put((Object)520000, (Object)"\u8d35\u5dde\u7701");
        b.put((Object)520100, (Object)"\u8d35\u9633\u5e02");
        b.put((Object)520102, (Object)"\u5357\u660e\u533a");
        b.put((Object)520103, (Object)"\u4e91\u5ca9\u533a");
        b.put((Object)520111, (Object)"\u82b1\u6eaa\u533a");
        b.put((Object)520112, (Object)"\u4e4c\u5f53\u533a");
        b.put((Object)520113, (Object)"\u767d\u4e91\u533a");
        b.put((Object)520115, (Object)"\u89c2\u5c71\u6e56\u533a");
        b.put((Object)520121, (Object)"\u5f00\u9633\u53bf");
        b.put((Object)520122, (Object)"\u606f\u70fd\u53bf");
        b.put((Object)520123, (Object)"\u4fee\u6587\u53bf");
        b.put((Object)520181, (Object)"\u6e05\u9547\u5e02");
        b.put((Object)520200, (Object)"\u516d\u76d8\u6c34\u5e02");
        b.put((Object)520201, (Object)"\u949f\u5c71\u533a");
        b.put((Object)520203, (Object)"\u516d\u679d\u7279\u533a");
        b.put((Object)520221, (Object)"\u6c34\u57ce\u53bf");
        b.put((Object)520281, (Object)"\u76d8\u5dde\u5e02");
        b.put((Object)520300, (Object)"\u9075\u4e49\u5e02");
        b.put((Object)520302, (Object)"\u7ea2\u82b1\u5c97\u533a");
        b.put((Object)520303, (Object)"\u6c47\u5ddd\u533a");
        b.put((Object)520304, (Object)"\u64ad\u5dde\u533a");
        b.put((Object)520322, (Object)"\u6850\u6893\u53bf");
        b.put((Object)520323, (Object)"\u7ee5\u9633\u53bf");
        b.put((Object)520324, (Object)"\u6b63\u5b89\u53bf");
        b.put((Object)520325, (Object)"\u9053\u771f\u4ee1\u4f6c\u65cf\u82d7\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)520326, (Object)"\u52a1\u5ddd\u4ee1\u4f6c\u65cf\u82d7\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)520327, (Object)"\u51e4\u5188\u53bf");
        b.put((Object)520328, (Object)"\u6e44\u6f6d\u53bf");
        b.put((Object)520329, (Object)"\u4f59\u5e86\u53bf");
        b.put((Object)520330, (Object)"\u4e60\u6c34\u53bf");
        b.put((Object)520381, (Object)"\u8d64\u6c34\u5e02");
        b.put((Object)520382, (Object)"\u4ec1\u6000\u5e02");
        b.put((Object)520400, (Object)"\u5b89\u987a\u5e02");
        b.put((Object)520402, (Object)"\u897f\u79c0\u533a");
        b.put((Object)520403, (Object)"\u5e73\u575d\u533a");
        b.put((Object)520422, (Object)"\u666e\u5b9a\u53bf");
        b.put((Object)520423, (Object)"\u9547\u5b81\u5e03\u4f9d\u65cf\u82d7\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)520424, (Object)"\u5173\u5cad\u5e03\u4f9d\u65cf\u82d7\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)520425, (Object)"\u7d2b\u4e91\u82d7\u65cf\u5e03\u4f9d\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)520500, (Object)"\u6bd5\u8282\u5e02");
        b.put((Object)520502, (Object)"\u4e03\u661f\u5173\u533a");
        b.put((Object)520521, (Object)"\u5927\u65b9\u53bf");
        b.put((Object)520522, (Object)"\u9ed4\u897f\u53bf");
        b.put((Object)520523, (Object)"\u91d1\u6c99\u53bf");
        b.put((Object)520524, (Object)"\u7ec7\u91d1\u53bf");
        b.put((Object)520525, (Object)"\u7eb3\u96cd\u53bf");
        b.put((Object)520526, (Object)"\u5a01\u5b81\u5f5d\u65cf\u56de\u65cf\u82d7\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)520527, (Object)"\u8d6b\u7ae0\u53bf");
        b.put((Object)520600, (Object)"\u94dc\u4ec1\u5e02");
        b.put((Object)520602, (Object)"\u78a7\u6c5f\u533a");
        b.put((Object)520603, (Object)"\u4e07\u5c71\u533a");
        b.put((Object)520621, (Object)"\u6c5f\u53e3\u53bf");
        b.put((Object)520622, (Object)"\u7389\u5c4f\u4f97\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)520623, (Object)"\u77f3\u9621\u53bf");
        b.put((Object)520624, (Object)"\u601d\u5357\u53bf");
        b.put((Object)520625, (Object)"\u5370\u6c5f\u571f\u5bb6\u65cf\u82d7\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)520626, (Object)"\u5fb7\u6c5f\u53bf");
        b.put((Object)520627, (Object)"\u6cbf\u6cb3\u571f\u5bb6\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)520628, (Object)"\u677e\u6843\u82d7\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)522300, (Object)"\u9ed4\u897f\u5357\u5e03\u4f9d\u65cf\u82d7\u65cf\u81ea\u6cbb\u5dde");
        b.put((Object)522301, (Object)"\u5174\u4e49\u5e02");
        b.put((Object)522322, (Object)"\u5174\u4ec1\u53bf");
        b.put((Object)522323, (Object)"\u666e\u5b89\u53bf");
        b.put((Object)522324, (Object)"\u6674\u9686\u53bf");
        b.put((Object)522325, (Object)"\u8d1e\u4e30\u53bf");
        b.put((Object)522326, (Object)"\u671b\u8c1f\u53bf");
        b.put((Object)522327, (Object)"\u518c\u4ea8\u53bf");
        b.put((Object)522328, (Object)"\u5b89\u9f99\u53bf");
        b.put((Object)522600, (Object)"\u9ed4\u4e1c\u5357\u82d7\u65cf\u4f97\u65cf\u81ea\u6cbb\u5dde");
        b.put((Object)522601, (Object)"\u51ef\u91cc\u5e02");
        b.put((Object)522622, (Object)"\u9ec4\u5e73\u53bf");
        b.put((Object)522623, (Object)"\u65bd\u79c9\u53bf");
        b.put((Object)522624, (Object)"\u4e09\u7a57\u53bf");
        b.put((Object)522625, (Object)"\u9547\u8fdc\u53bf");
        b.put((Object)522626, (Object)"\u5c91\u5de9\u53bf");
        b.put((Object)522627, (Object)"\u5929\u67f1\u53bf");
        b.put((Object)522628, (Object)"\u9526\u5c4f\u53bf");
        b.put((Object)522629, (Object)"\u5251\u6cb3\u53bf");
        b.put((Object)522630, (Object)"\u53f0\u6c5f\u53bf");
        b.put((Object)522631, (Object)"\u9ece\u5e73\u53bf");
        b.put((Object)522632, (Object)"\u6995\u6c5f\u53bf");
        b.put((Object)522633, (Object)"\u4ece\u6c5f\u53bf");
        b.put((Object)522634, (Object)"\u96f7\u5c71\u53bf");
        b.put((Object)522635, (Object)"\u9ebb\u6c5f\u53bf");
        b.put((Object)522636, (Object)"\u4e39\u5be8\u53bf");
        b.put((Object)522700, (Object)"\u9ed4\u5357\u5e03\u4f9d\u65cf\u82d7\u65cf\u81ea\u6cbb\u5dde");
        b.put((Object)522701, (Object)"\u90fd\u5300\u5e02");
        b.put((Object)522702, (Object)"\u798f\u6cc9\u5e02");
        b.put((Object)522722, (Object)"\u8354\u6ce2\u53bf");
        b.put((Object)522723, (Object)"\u8d35\u5b9a\u53bf");
        b.put((Object)522725, (Object)"\u74ee\u5b89\u53bf");
        b.put((Object)522726, (Object)"\u72ec\u5c71\u53bf");
        b.put((Object)522727, (Object)"\u5e73\u5858\u53bf");
        b.put((Object)522728, (Object)"\u7f57\u7538\u53bf");
        b.put((Object)522729, (Object)"\u957f\u987a\u53bf");
        b.put((Object)522730, (Object)"\u9f99\u91cc\u53bf");
        b.put((Object)522731, (Object)"\u60e0\u6c34\u53bf");
        b.put((Object)522732, (Object)"\u4e09\u90fd\u6c34\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)530000, (Object)"\u4e91\u5357\u7701");
        b.put((Object)530100, (Object)"\u6606\u660e\u5e02");
        b.put((Object)530102, (Object)"\u4e94\u534e\u533a");
        b.put((Object)530103, (Object)"\u76d8\u9f99\u533a");
        b.put((Object)530111, (Object)"\u5b98\u6e21\u533a");
        b.put((Object)530112, (Object)"\u897f\u5c71\u533a");
        b.put((Object)530113, (Object)"\u4e1c\u5ddd\u533a");
        b.put((Object)530114, (Object)"\u5448\u8d21\u533a");
        b.put((Object)530115, (Object)"\u664b\u5b81\u533a");
        b.put((Object)530124, (Object)"\u5bcc\u6c11\u53bf");
        b.put((Object)530125, (Object)"\u5b9c\u826f\u53bf");
        b.put((Object)530126, (Object)"\u77f3\u6797\u5f5d\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)530127, (Object)"\u5d69\u660e\u53bf");
        b.put((Object)530128, (Object)"\u7984\u529d\u5f5d\u65cf\u82d7\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)530129, (Object)"\u5bfb\u7538\u56de\u65cf\u5f5d\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)530181, (Object)"\u5b89\u5b81\u5e02");
        b.put((Object)530300, (Object)"\u66f2\u9756\u5e02");
        b.put((Object)530302, (Object)"\u9e92\u9e9f\u533a");
        b.put((Object)530303, (Object)"\u6cbe\u76ca\u533a");
        b.put((Object)530304, (Object)"\u9a6c\u9f99\u533a");
        b.put((Object)530322, (Object)"\u9646\u826f\u53bf");
        b.put((Object)530323, (Object)"\u5e08\u5b97\u53bf");
        b.put((Object)530324, (Object)"\u7f57\u5e73\u53bf");
        b.put((Object)530325, (Object)"\u5bcc\u6e90\u53bf");
        b.put((Object)530326, (Object)"\u4f1a\u6cfd\u53bf");
        b.put((Object)530381, (Object)"\u5ba3\u5a01\u5e02");
        b.put((Object)530400, (Object)"\u7389\u6eaa\u5e02");
        b.put((Object)530402, (Object)"\u7ea2\u5854\u533a");
        b.put((Object)530403, (Object)"\u6c5f\u5ddd\u533a");
        b.put((Object)530422, (Object)"\u6f84\u6c5f\u53bf");
        b.put((Object)530423, (Object)"\u901a\u6d77\u53bf");
        b.put((Object)530424, (Object)"\u534e\u5b81\u53bf");
        b.put((Object)530425, (Object)"\u6613\u95e8\u53bf");
        b.put((Object)530426, (Object)"\u5ce8\u5c71\u5f5d\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)530427, (Object)"\u65b0\u5e73\u5f5d\u65cf\u50a3\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)530428, (Object)"\u5143\u6c5f\u54c8\u5c3c\u65cf\u5f5d\u65cf\u50a3\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)530500, (Object)"\u4fdd\u5c71\u5e02");
        b.put((Object)530502, (Object)"\u9686\u9633\u533a");
        b.put((Object)530521, (Object)"\u65bd\u7538\u53bf");
        b.put((Object)530523, (Object)"\u9f99\u9675\u53bf");
        b.put((Object)530524, (Object)"\u660c\u5b81\u53bf");
        b.put((Object)530581, (Object)"\u817e\u51b2\u5e02");
        b.put((Object)530600, (Object)"\u662d\u901a\u5e02");
        b.put((Object)530602, (Object)"\u662d\u9633\u533a");
        b.put((Object)530621, (Object)"\u9c81\u7538\u53bf");
        b.put((Object)530622, (Object)"\u5de7\u5bb6\u53bf");
        b.put((Object)530623, (Object)"\u76d0\u6d25\u53bf");
        b.put((Object)530624, (Object)"\u5927\u5173\u53bf");
        b.put((Object)530625, (Object)"\u6c38\u5584\u53bf");
        b.put((Object)530626, (Object)"\u7ee5\u6c5f\u53bf");
        b.put((Object)530627, (Object)"\u9547\u96c4\u53bf");
        b.put((Object)530628, (Object)"\u5f5d\u826f\u53bf");
        b.put((Object)530629, (Object)"\u5a01\u4fe1\u53bf");
        b.put((Object)530681, (Object)"\u6c34\u5bcc\u5e02");
        b.put((Object)530700, (Object)"\u4e3d\u6c5f\u5e02");
        b.put((Object)530702, (Object)"\u53e4\u57ce\u533a");
        b.put((Object)530721, (Object)"\u7389\u9f99\u7eb3\u897f\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)530722, (Object)"\u6c38\u80dc\u53bf");
        b.put((Object)530723, (Object)"\u534e\u576a\u53bf");
        b.put((Object)530724, (Object)"\u5b81\u8497\u5f5d\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)530800, (Object)"\u666e\u6d31\u5e02");
        b.put((Object)530802, (Object)"\u601d\u8305\u533a");
        b.put((Object)530821, (Object)"\u5b81\u6d31\u54c8\u5c3c\u65cf\u5f5d\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)530822, (Object)"\u58a8\u6c5f\u54c8\u5c3c\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)530823, (Object)"\u666f\u4e1c\u5f5d\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)530824, (Object)"\u666f\u8c37\u50a3\u65cf\u5f5d\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)530825, (Object)"\u9547\u6c85\u5f5d\u65cf\u54c8\u5c3c\u65cf\u62c9\u795c\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)530826, (Object)"\u6c5f\u57ce\u54c8\u5c3c\u65cf\u5f5d\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)530827, (Object)"\u5b5f\u8fde\u50a3\u65cf\u62c9\u795c\u65cf\u4f64\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)530828, (Object)"\u6f9c\u6ca7\u62c9\u795c\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)530829, (Object)"\u897f\u76df\u4f64\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)530900, (Object)"\u4e34\u6ca7\u5e02");
        b.put((Object)530902, (Object)"\u4e34\u7fd4\u533a");
        b.put((Object)530921, (Object)"\u51e4\u5e86\u53bf");
        b.put((Object)530922, (Object)"\u4e91\u53bf");
        b.put((Object)530923, (Object)"\u6c38\u5fb7\u53bf");
        b.put((Object)530924, (Object)"\u9547\u5eb7\u53bf");
        b.put((Object)530925, (Object)"\u53cc\u6c5f\u62c9\u795c\u65cf\u4f64\u65cf\u5e03\u6717\u65cf\u50a3\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)530926, (Object)"\u803f\u9a6c\u50a3\u65cf\u4f64\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)530927, (Object)"\u6ca7\u6e90\u4f64\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)532300, (Object)"\u695a\u96c4\u5f5d\u65cf\u81ea\u6cbb\u5dde");
        b.put((Object)532301, (Object)"\u695a\u96c4\u5e02");
        b.put((Object)532322, (Object)"\u53cc\u67cf\u53bf");
        b.put((Object)532323, (Object)"\u725f\u5b9a\u53bf");
        b.put((Object)532324, (Object)"\u5357\u534e\u53bf");
        b.put((Object)532325, (Object)"\u59da\u5b89\u53bf");
        b.put((Object)532326, (Object)"\u5927\u59da\u53bf");
        b.put((Object)532327, (Object)"\u6c38\u4ec1\u53bf");
        b.put((Object)532328, (Object)"\u5143\u8c0b\u53bf");
        b.put((Object)532329, (Object)"\u6b66\u5b9a\u53bf");
        b.put((Object)532331, (Object)"\u7984\u4e30\u53bf");
        b.put((Object)532500, (Object)"\u7ea2\u6cb3\u54c8\u5c3c\u65cf\u5f5d\u65cf\u81ea\u6cbb\u5dde");
        b.put((Object)532501, (Object)"\u4e2a\u65e7\u5e02");
        b.put((Object)532502, (Object)"\u5f00\u8fdc\u5e02");
        b.put((Object)532503, (Object)"\u8499\u81ea\u5e02");
        b.put((Object)532504, (Object)"\u5f25\u52d2\u5e02");
        b.put((Object)532523, (Object)"\u5c4f\u8fb9\u82d7\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)532524, (Object)"\u5efa\u6c34\u53bf");
        b.put((Object)532525, (Object)"\u77f3\u5c4f\u53bf");
        b.put((Object)532527, (Object)"\u6cf8\u897f\u53bf");
        b.put((Object)532528, (Object)"\u5143\u9633\u53bf");
        b.put((Object)532529, (Object)"\u7ea2\u6cb3\u53bf");
        b.put((Object)532530, (Object)"\u91d1\u5e73\u82d7\u65cf\u7476\u65cf\u50a3\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)532531, (Object)"\u7eff\u6625\u53bf");
        b.put((Object)532532, (Object)"\u6cb3\u53e3\u7476\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)532600, (Object)"\u6587\u5c71\u58ee\u65cf\u82d7\u65cf\u81ea\u6cbb\u5dde");
        b.put((Object)532601, (Object)"\u6587\u5c71\u5e02");
        b.put((Object)532622, (Object)"\u781a\u5c71\u53bf");
        b.put((Object)532623, (Object)"\u897f\u7574\u53bf");
        b.put((Object)532624, (Object)"\u9ebb\u6817\u5761\u53bf");
        b.put((Object)532625, (Object)"\u9a6c\u5173\u53bf");
        b.put((Object)532626, (Object)"\u4e18\u5317\u53bf");
        b.put((Object)532627, (Object)"\u5e7f\u5357\u53bf");
        b.put((Object)532628, (Object)"\u5bcc\u5b81\u53bf");
        b.put((Object)532800, (Object)"\u897f\u53cc\u7248\u7eb3\u50a3\u65cf\u81ea\u6cbb\u5dde");
        b.put((Object)532801, (Object)"\u666f\u6d2a\u5e02");
        b.put((Object)532822, (Object)"\u52d0\u6d77\u53bf");
        b.put((Object)532823, (Object)"\u52d0\u814a\u53bf");
        b.put((Object)532900, (Object)"\u5927\u7406\u767d\u65cf\u81ea\u6cbb\u5dde");
        b.put((Object)532901, (Object)"\u5927\u7406\u5e02");
        b.put((Object)532922, (Object)"\u6f3e\u6fde\u5f5d\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)532923, (Object)"\u7965\u4e91\u53bf");
        b.put((Object)532924, (Object)"\u5bbe\u5ddd\u53bf");
        b.put((Object)532925, (Object)"\u5f25\u6e21\u53bf");
        b.put((Object)532926, (Object)"\u5357\u6da7\u5f5d\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)532927, (Object)"\u5dcd\u5c71\u5f5d\u65cf\u56de\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)532928, (Object)"\u6c38\u5e73\u53bf");
        b.put((Object)532929, (Object)"\u4e91\u9f99\u53bf");
        b.put((Object)532930, (Object)"\u6d31\u6e90\u53bf");
        b.put((Object)532931, (Object)"\u5251\u5ddd\u53bf");
        b.put((Object)532932, (Object)"\u9e64\u5e86\u53bf");
        b.put((Object)533100, (Object)"\u5fb7\u5b8f\u50a3\u65cf\u666f\u9887\u65cf\u81ea\u6cbb\u5dde");
        b.put((Object)533102, (Object)"\u745e\u4e3d\u5e02");
        b.put((Object)533103, (Object)"\u8292\u5e02");
        b.put((Object)533122, (Object)"\u6881\u6cb3\u53bf");
        b.put((Object)533123, (Object)"\u76c8\u6c5f\u53bf");
        b.put((Object)533124, (Object)"\u9647\u5ddd\u53bf");
        b.put((Object)533300, (Object)"\u6012\u6c5f\u5088\u50f3\u65cf\u81ea\u6cbb\u5dde");
        b.put((Object)533301, (Object)"\u6cf8\u6c34\u5e02");
        b.put((Object)533323, (Object)"\u798f\u8d21\u53bf");
        b.put((Object)533324, (Object)"\u8d21\u5c71\u72ec\u9f99\u65cf\u6012\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)533325, (Object)"\u5170\u576a\u767d\u65cf\u666e\u7c73\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)533400, (Object)"\u8fea\u5e86\u85cf\u65cf\u81ea\u6cbb\u5dde");
        b.put((Object)533401, (Object)"\u9999\u683c\u91cc\u62c9\u5e02");
        b.put((Object)533422, (Object)"\u5fb7\u94a6\u53bf");
        b.put((Object)533423, (Object)"\u7ef4\u897f\u5088\u50f3\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)540000, (Object)"\u897f\u85cf\u81ea\u6cbb\u533a");
        b.put((Object)540100, (Object)"\u62c9\u8428\u5e02");
        b.put((Object)540102, (Object)"\u57ce\u5173\u533a");
        b.put((Object)540103, (Object)"\u5806\u9f99\u5fb7\u5e86\u533a");
        b.put((Object)540104, (Object)"\u8fbe\u5b5c\u533a");
        b.put((Object)540121, (Object)"\u6797\u5468\u53bf");
        b.put((Object)540122, (Object)"\u5f53\u96c4\u53bf");
        b.put((Object)540123, (Object)"\u5c3c\u6728\u53bf");
        b.put((Object)540124, (Object)"\u66f2\u6c34\u53bf");
        b.put((Object)540127, (Object)"\u58a8\u7af9\u5de5\u5361\u53bf");
        b.put((Object)540200, (Object)"\u65e5\u5580\u5219\u5e02");
        b.put((Object)540202, (Object)"\u6851\u73e0\u5b5c\u533a");
        b.put((Object)540221, (Object)"\u5357\u6728\u6797\u53bf");
        b.put((Object)540222, (Object)"\u6c5f\u5b5c\u53bf");
        b.put((Object)540223, (Object)"\u5b9a\u65e5\u53bf");
        b.put((Object)540224, (Object)"\u8428\u8fe6\u53bf");
        b.put((Object)540225, (Object)"\u62c9\u5b5c\u53bf");
        b.put((Object)540226, (Object)"\u6602\u4ec1\u53bf");
        b.put((Object)540227, (Object)"\u8c22\u901a\u95e8\u53bf");
        b.put((Object)540228, (Object)"\u767d\u6717\u53bf");
        b.put((Object)540229, (Object)"\u4ec1\u5e03\u53bf");
        b.put((Object)540230, (Object)"\u5eb7\u9a6c\u53bf");
        b.put((Object)540231, (Object)"\u5b9a\u7ed3\u53bf");
        b.put((Object)540232, (Object)"\u4ef2\u5df4\u53bf");
        b.put((Object)540233, (Object)"\u4e9a\u4e1c\u53bf");
        b.put((Object)540234, (Object)"\u5409\u9686\u53bf");
        b.put((Object)540235, (Object)"\u8042\u62c9\u6728\u53bf");
        b.put((Object)540236, (Object)"\u8428\u560e\u53bf");
        b.put((Object)540237, (Object)"\u5c97\u5df4\u53bf");
        b.put((Object)540300, (Object)"\u660c\u90fd\u5e02");
        b.put((Object)540302, (Object)"\u5361\u82e5\u533a");
        b.put((Object)540321, (Object)"\u6c5f\u8fbe\u53bf");
        b.put((Object)540322, (Object)"\u8d21\u89c9\u53bf");
        b.put((Object)540323, (Object)"\u7c7b\u4e4c\u9f50\u53bf");
        b.put((Object)540324, (Object)"\u4e01\u9752\u53bf");
        b.put((Object)540325, (Object)"\u5bdf\u96c5\u53bf");
        b.put((Object)540326, (Object)"\u516b\u5bbf\u53bf");
        b.put((Object)540327, (Object)"\u5de6\u8d21\u53bf");
        b.put((Object)540328, (Object)"\u8292\u5eb7\u53bf");
        b.put((Object)540329, (Object)"\u6d1b\u9686\u53bf");
        b.put((Object)540330, (Object)"\u8fb9\u575d\u53bf");
        b.put((Object)540400, (Object)"\u6797\u829d\u5e02");
        b.put((Object)540402, (Object)"\u5df4\u5b9c\u533a");
        b.put((Object)540421, (Object)"\u5de5\u5e03\u6c5f\u8fbe\u53bf");
        b.put((Object)540422, (Object)"\u7c73\u6797\u53bf");
        b.put((Object)540423, (Object)"\u58a8\u8131\u53bf");
        b.put((Object)540424, (Object)"\u6ce2\u5bc6\u53bf");
        b.put((Object)540425, (Object)"\u5bdf\u9685\u53bf");
        b.put((Object)540426, (Object)"\u6717\u53bf");
        b.put((Object)540500, (Object)"\u5c71\u5357\u5e02");
        b.put((Object)540502, (Object)"\u4e43\u4e1c\u533a");
        b.put((Object)540521, (Object)"\u624e\u56ca\u53bf");
        b.put((Object)540522, (Object)"\u8d21\u560e\u53bf");
        b.put((Object)540523, (Object)"\u6851\u65e5\u53bf");
        b.put((Object)540524, (Object)"\u743c\u7ed3\u53bf");
        b.put((Object)540525, (Object)"\u66f2\u677e\u53bf");
        b.put((Object)540526, (Object)"\u63aa\u7f8e\u53bf");
        b.put((Object)540527, (Object)"\u6d1b\u624e\u53bf");
        b.put((Object)540528, (Object)"\u52a0\u67e5\u53bf");
        b.put((Object)540529, (Object)"\u9686\u5b50\u53bf");
        b.put((Object)540530, (Object)"\u9519\u90a3\u53bf");
        b.put((Object)540531, (Object)"\u6d6a\u5361\u5b50\u53bf");
        b.put((Object)540600, (Object)"\u90a3\u66f2\u5e02");
        b.put((Object)540602, (Object)"\u8272\u5c3c\u533a");
        b.put((Object)540621, (Object)"\u5609\u9ece\u53bf");
        b.put((Object)540622, (Object)"\u6bd4\u5982\u53bf");
        b.put((Object)540623, (Object)"\u8042\u8363\u53bf");
        b.put((Object)540624, (Object)"\u5b89\u591a\u53bf");
        b.put((Object)540625, (Object)"\u7533\u624e\u53bf");
        b.put((Object)540626, (Object)"\u7d22\u53bf");
        b.put((Object)540627, (Object)"\u73ed\u6208\u53bf");
        b.put((Object)540628, (Object)"\u5df4\u9752\u53bf");
        b.put((Object)540629, (Object)"\u5c3c\u739b\u53bf");
        b.put((Object)540630, (Object)"\u53cc\u6e56\u53bf");
        b.put((Object)542500, (Object)"\u963f\u91cc\u5730\u533a");
        b.put((Object)542521, (Object)"\u666e\u5170\u53bf");
        b.put((Object)542522, (Object)"\u672d\u8fbe\u53bf");
        b.put((Object)542523, (Object)"\u5676\u5c14\u53bf");
        b.put((Object)542524, (Object)"\u65e5\u571f\u53bf");
        b.put((Object)542525, (Object)"\u9769\u5409\u53bf");
        b.put((Object)542526, (Object)"\u6539\u5219\u53bf");
        b.put((Object)542527, (Object)"\u63aa\u52e4\u53bf");
        b.put((Object)610000, (Object)"\u9655\u897f\u7701");
        b.put((Object)610100, (Object)"\u897f\u5b89\u5e02");
        b.put((Object)610102, (Object)"\u65b0\u57ce\u533a");
        b.put((Object)610103, (Object)"\u7891\u6797\u533a");
        b.put((Object)610104, (Object)"\u83b2\u6e56\u533a");
        b.put((Object)610111, (Object)"\u705e\u6865\u533a");
        b.put((Object)610112, (Object)"\u672a\u592e\u533a");
        b.put((Object)610113, (Object)"\u96c1\u5854\u533a");
        b.put((Object)610114, (Object)"\u960e\u826f\u533a");
        b.put((Object)610115, (Object)"\u4e34\u6f7c\u533a");
        b.put((Object)610116, (Object)"\u957f\u5b89\u533a");
        b.put((Object)610117, (Object)"\u9ad8\u9675\u533a");
        b.put((Object)610118, (Object)"\u9120\u9091\u533a");
        b.put((Object)610122, (Object)"\u84dd\u7530\u53bf");
        b.put((Object)610124, (Object)"\u5468\u81f3\u53bf");
        b.put((Object)610200, (Object)"\u94dc\u5ddd\u5e02");
        b.put((Object)610202, (Object)"\u738b\u76ca\u533a");
        b.put((Object)610203, (Object)"\u5370\u53f0\u533a");
        b.put((Object)610204, (Object)"\u8000\u5dde\u533a");
        b.put((Object)610222, (Object)"\u5b9c\u541b\u53bf");
        b.put((Object)610300, (Object)"\u5b9d\u9e21\u5e02");
        b.put((Object)610302, (Object)"\u6e2d\u6ee8\u533a");
        b.put((Object)610303, (Object)"\u91d1\u53f0\u533a");
        b.put((Object)610304, (Object)"\u9648\u4ed3\u533a");
        b.put((Object)610322, (Object)"\u51e4\u7fd4\u53bf");
        b.put((Object)610323, (Object)"\u5c90\u5c71\u53bf");
        b.put((Object)610324, (Object)"\u6276\u98ce\u53bf");
        b.put((Object)610326, (Object)"\u7709\u53bf");
        b.put((Object)610327, (Object)"\u9647\u53bf");
        b.put((Object)610328, (Object)"\u5343\u9633\u53bf");
        b.put((Object)610329, (Object)"\u9e9f\u6e38\u53bf");
        b.put((Object)610330, (Object)"\u51e4\u53bf");
        b.put((Object)610331, (Object)"\u592a\u767d\u53bf");
        b.put((Object)610400, (Object)"\u54b8\u9633\u5e02");
        b.put((Object)610402, (Object)"\u79e6\u90fd\u533a");
        b.put((Object)610403, (Object)"\u6768\u9675\u533a");
        b.put((Object)610404, (Object)"\u6e2d\u57ce\u533a");
        b.put((Object)610422, (Object)"\u4e09\u539f\u53bf");
        b.put((Object)610423, (Object)"\u6cfe\u9633\u53bf");
        b.put((Object)610424, (Object)"\u4e7e\u53bf");
        b.put((Object)610425, (Object)"\u793c\u6cc9\u53bf");
        b.put((Object)610426, (Object)"\u6c38\u5bff\u53bf");
        b.put((Object)610428, (Object)"\u957f\u6b66\u53bf");
        b.put((Object)610429, (Object)"\u65ec\u9091\u53bf");
        b.put((Object)610430, (Object)"\u6df3\u5316\u53bf");
        b.put((Object)610431, (Object)"\u6b66\u529f\u53bf");
        b.put((Object)610481, (Object)"\u5174\u5e73\u5e02");
        b.put((Object)610482, (Object)"\u5f6c\u5dde\u5e02");
        b.put((Object)610500, (Object)"\u6e2d\u5357\u5e02");
        b.put((Object)610502, (Object)"\u4e34\u6e2d\u533a");
        b.put((Object)610503, (Object)"\u534e\u5dde\u533a");
        b.put((Object)610522, (Object)"\u6f7c\u5173\u53bf");
        b.put((Object)610523, (Object)"\u5927\u8354\u53bf");
        b.put((Object)610524, (Object)"\u5408\u9633\u53bf");
        b.put((Object)610525, (Object)"\u6f84\u57ce\u53bf");
        b.put((Object)610526, (Object)"\u84b2\u57ce\u53bf");
        b.put((Object)610527, (Object)"\u767d\u6c34\u53bf");
        b.put((Object)610528, (Object)"\u5bcc\u5e73\u53bf");
        b.put((Object)610581, (Object)"\u97e9\u57ce\u5e02");
        b.put((Object)610582, (Object)"\u534e\u9634\u5e02");
        b.put((Object)610600, (Object)"\u5ef6\u5b89\u5e02");
        b.put((Object)610602, (Object)"\u5b9d\u5854\u533a");
        b.put((Object)610603, (Object)"\u5b89\u585e\u533a");
        b.put((Object)610621, (Object)"\u5ef6\u957f\u53bf");
        b.put((Object)610622, (Object)"\u5ef6\u5ddd\u53bf");
        b.put((Object)610623, (Object)"\u5b50\u957f\u53bf");
        b.put((Object)610625, (Object)"\u5fd7\u4e39\u53bf");
        b.put((Object)610626, (Object)"\u5434\u8d77\u53bf");
        b.put((Object)610627, (Object)"\u7518\u6cc9\u53bf");
        b.put((Object)610628, (Object)"\u5bcc\u53bf");
        b.put((Object)610629, (Object)"\u6d1b\u5ddd\u53bf");
        b.put((Object)610630, (Object)"\u5b9c\u5ddd\u53bf");
        b.put((Object)610631, (Object)"\u9ec4\u9f99\u53bf");
        b.put((Object)610632, (Object)"\u9ec4\u9675\u53bf");
        b.put((Object)610700, (Object)"\u6c49\u4e2d\u5e02");
        b.put((Object)610702, (Object)"\u6c49\u53f0\u533a");
        b.put((Object)610703, (Object)"\u5357\u90d1\u533a");
        b.put((Object)610722, (Object)"\u57ce\u56fa\u53bf");
        b.put((Object)610723, (Object)"\u6d0b\u53bf");
        b.put((Object)610724, (Object)"\u897f\u4e61\u53bf");
        b.put((Object)610725, (Object)"\u52c9\u53bf");
        b.put((Object)610726, (Object)"\u5b81\u5f3a\u53bf");
        b.put((Object)610727, (Object)"\u7565\u9633\u53bf");
        b.put((Object)610728, (Object)"\u9547\u5df4\u53bf");
        b.put((Object)610729, (Object)"\u7559\u575d\u53bf");
        b.put((Object)610730, (Object)"\u4f5b\u576a\u53bf");
        b.put((Object)610800, (Object)"\u6986\u6797\u5e02");
        b.put((Object)610802, (Object)"\u6986\u9633\u533a");
        b.put((Object)610803, (Object)"\u6a2a\u5c71\u533a");
        b.put((Object)610822, (Object)"\u5e9c\u8c37\u53bf");
        b.put((Object)610824, (Object)"\u9756\u8fb9\u53bf");
        b.put((Object)610825, (Object)"\u5b9a\u8fb9\u53bf");
        b.put((Object)610826, (Object)"\u7ee5\u5fb7\u53bf");
        b.put((Object)610827, (Object)"\u7c73\u8102\u53bf");
        b.put((Object)610828, (Object)"\u4f73\u53bf");
        b.put((Object)610829, (Object)"\u5434\u5821\u53bf");
        b.put((Object)610830, (Object)"\u6e05\u6da7\u53bf");
        b.put((Object)610831, (Object)"\u5b50\u6d32\u53bf");
        b.put((Object)610881, (Object)"\u795e\u6728\u5e02");
        b.put((Object)610900, (Object)"\u5b89\u5eb7\u5e02");
        b.put((Object)610902, (Object)"\u6c49\u6ee8\u533a");
        b.put((Object)610921, (Object)"\u6c49\u9634\u53bf");
        b.put((Object)610922, (Object)"\u77f3\u6cc9\u53bf");
        b.put((Object)610923, (Object)"\u5b81\u9655\u53bf");
        b.put((Object)610924, (Object)"\u7d2b\u9633\u53bf");
        b.put((Object)610925, (Object)"\u5c9a\u768b\u53bf");
        b.put((Object)610926, (Object)"\u5e73\u5229\u53bf");
        b.put((Object)610927, (Object)"\u9547\u576a\u53bf");
        b.put((Object)610928, (Object)"\u65ec\u9633\u53bf");
        b.put((Object)610929, (Object)"\u767d\u6cb3\u53bf");
        b.put((Object)611000, (Object)"\u5546\u6d1b\u5e02");
        b.put((Object)611002, (Object)"\u5546\u5dde\u533a");
        b.put((Object)611021, (Object)"\u6d1b\u5357\u53bf");
        b.put((Object)611022, (Object)"\u4e39\u51e4\u53bf");
        b.put((Object)611023, (Object)"\u5546\u5357\u53bf");
        b.put((Object)611024, (Object)"\u5c71\u9633\u53bf");
        b.put((Object)611025, (Object)"\u9547\u5b89\u53bf");
        b.put((Object)611026, (Object)"\u67de\u6c34\u53bf");
        b.put((Object)620000, (Object)"\u7518\u8083\u7701");
        b.put((Object)620100, (Object)"\u5170\u5dde\u5e02");
        b.put((Object)620102, (Object)"\u57ce\u5173\u533a");
        b.put((Object)620103, (Object)"\u4e03\u91cc\u6cb3\u533a");
        b.put((Object)620104, (Object)"\u897f\u56fa\u533a");
        b.put((Object)620105, (Object)"\u5b89\u5b81\u533a");
        b.put((Object)620111, (Object)"\u7ea2\u53e4\u533a");
        b.put((Object)620121, (Object)"\u6c38\u767b\u53bf");
        b.put((Object)620122, (Object)"\u768b\u5170\u53bf");
        b.put((Object)620123, (Object)"\u6986\u4e2d\u53bf");
        b.put((Object)620200, (Object)"\u5609\u5cea\u5173\u5e02");
        b.put((Object)620300, (Object)"\u91d1\u660c\u5e02");
        b.put((Object)620302, (Object)"\u91d1\u5ddd\u533a");
        b.put((Object)620321, (Object)"\u6c38\u660c\u53bf");
        b.put((Object)620400, (Object)"\u767d\u94f6\u5e02");
        b.put((Object)620402, (Object)"\u767d\u94f6\u533a");
        b.put((Object)620403, (Object)"\u5e73\u5ddd\u533a");
        b.put((Object)620421, (Object)"\u9756\u8fdc\u53bf");
        b.put((Object)620422, (Object)"\u4f1a\u5b81\u53bf");
        b.put((Object)620423, (Object)"\u666f\u6cf0\u53bf");
        b.put((Object)620500, (Object)"\u5929\u6c34\u5e02");
        b.put((Object)620502, (Object)"\u79e6\u5dde\u533a");
        b.put((Object)620503, (Object)"\u9ea6\u79ef\u533a");
        b.put((Object)620521, (Object)"\u6e05\u6c34\u53bf");
        b.put((Object)620522, (Object)"\u79e6\u5b89\u53bf");
        b.put((Object)620523, (Object)"\u7518\u8c37\u53bf");
        b.put((Object)620524, (Object)"\u6b66\u5c71\u53bf");
        b.put((Object)620525, (Object)"\u5f20\u5bb6\u5ddd\u56de\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)620600, (Object)"\u6b66\u5a01\u5e02");
        b.put((Object)620602, (Object)"\u51c9\u5dde\u533a");
        b.put((Object)620621, (Object)"\u6c11\u52e4\u53bf");
        b.put((Object)620622, (Object)"\u53e4\u6d6a\u53bf");
        b.put((Object)620623, (Object)"\u5929\u795d\u85cf\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)620700, (Object)"\u5f20\u6396\u5e02");
        b.put((Object)620702, (Object)"\u7518\u5dde\u533a");
        b.put((Object)620721, (Object)"\u8083\u5357\u88d5\u56fa\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)620722, (Object)"\u6c11\u4e50\u53bf");
        b.put((Object)620723, (Object)"\u4e34\u6cfd\u53bf");
        b.put((Object)620724, (Object)"\u9ad8\u53f0\u53bf");
        b.put((Object)620725, (Object)"\u5c71\u4e39\u53bf");
        b.put((Object)620800, (Object)"\u5e73\u51c9\u5e02");
        b.put((Object)620802, (Object)"\u5d06\u5cd2\u533a");
        b.put((Object)620821, (Object)"\u6cfe\u5ddd\u53bf");
        b.put((Object)620822, (Object)"\u7075\u53f0\u53bf");
        b.put((Object)620823, (Object)"\u5d07\u4fe1\u53bf");
        b.put((Object)620825, (Object)"\u5e84\u6d6a\u53bf");
        b.put((Object)620826, (Object)"\u9759\u5b81\u53bf");
        b.put((Object)620881, (Object)"\u534e\u4ead\u5e02");
        b.put((Object)620900, (Object)"\u9152\u6cc9\u5e02");
        b.put((Object)620902, (Object)"\u8083\u5dde\u533a");
        b.put((Object)620921, (Object)"\u91d1\u5854\u53bf");
        b.put((Object)620922, (Object)"\u74dc\u5dde\u53bf");
        b.put((Object)620923, (Object)"\u8083\u5317\u8499\u53e4\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)620924, (Object)"\u963f\u514b\u585e\u54c8\u8428\u514b\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)620981, (Object)"\u7389\u95e8\u5e02");
        b.put((Object)620982, (Object)"\u6566\u714c\u5e02");
        b.put((Object)621000, (Object)"\u5e86\u9633\u5e02");
        b.put((Object)621002, (Object)"\u897f\u5cf0\u533a");
        b.put((Object)621021, (Object)"\u5e86\u57ce\u53bf");
        b.put((Object)621022, (Object)"\u73af\u53bf");
        b.put((Object)621023, (Object)"\u534e\u6c60\u53bf");
        b.put((Object)621024, (Object)"\u5408\u6c34\u53bf");
        b.put((Object)621025, (Object)"\u6b63\u5b81\u53bf");
        b.put((Object)621026, (Object)"\u5b81\u53bf");
        b.put((Object)621027, (Object)"\u9547\u539f\u53bf");
        b.put((Object)621100, (Object)"\u5b9a\u897f\u5e02");
        b.put((Object)621102, (Object)"\u5b89\u5b9a\u533a");
        b.put((Object)621121, (Object)"\u901a\u6e2d\u53bf");
        b.put((Object)621122, (Object)"\u9647\u897f\u53bf");
        b.put((Object)621123, (Object)"\u6e2d\u6e90\u53bf");
        b.put((Object)621124, (Object)"\u4e34\u6d2e\u53bf");
        b.put((Object)621125, (Object)"\u6f33\u53bf");
        b.put((Object)621126, (Object)"\u5cb7\u53bf");
        b.put((Object)621200, (Object)"\u9647\u5357\u5e02");
        b.put((Object)621202, (Object)"\u6b66\u90fd\u533a");
        b.put((Object)621221, (Object)"\u6210\u53bf");
        b.put((Object)621222, (Object)"\u6587\u53bf");
        b.put((Object)621223, (Object)"\u5b95\u660c\u53bf");
        b.put((Object)621224, (Object)"\u5eb7\u53bf");
        b.put((Object)621225, (Object)"\u897f\u548c\u53bf");
        b.put((Object)621226, (Object)"\u793c\u53bf");
        b.put((Object)621227, (Object)"\u5fbd\u53bf");
        b.put((Object)621228, (Object)"\u4e24\u5f53\u53bf");
        b.put((Object)622900, (Object)"\u4e34\u590f\u56de\u65cf\u81ea\u6cbb\u5dde");
        b.put((Object)622901, (Object)"\u4e34\u590f\u5e02");
        b.put((Object)622921, (Object)"\u4e34\u590f\u53bf");
        b.put((Object)622922, (Object)"\u5eb7\u4e50\u53bf");
        b.put((Object)622923, (Object)"\u6c38\u9756\u53bf");
        b.put((Object)622924, (Object)"\u5e7f\u6cb3\u53bf");
        b.put((Object)622925, (Object)"\u548c\u653f\u53bf");
        b.put((Object)622926, (Object)"\u4e1c\u4e61\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)622927, (Object)"\u79ef\u77f3\u5c71\u4fdd\u5b89\u65cf\u4e1c\u4e61\u65cf\u6492\u62c9\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)623000, (Object)"\u7518\u5357\u85cf\u65cf\u81ea\u6cbb\u5dde");
        b.put((Object)623001, (Object)"\u5408\u4f5c\u5e02");
        b.put((Object)623021, (Object)"\u4e34\u6f6d\u53bf");
        b.put((Object)623022, (Object)"\u5353\u5c3c\u53bf");
        b.put((Object)623023, (Object)"\u821f\u66f2\u53bf");
        b.put((Object)623024, (Object)"\u8fed\u90e8\u53bf");
        b.put((Object)623025, (Object)"\u739b\u66f2\u53bf");
        b.put((Object)623026, (Object)"\u788c\u66f2\u53bf");
        b.put((Object)623027, (Object)"\u590f\u6cb3\u53bf");
        b.put((Object)630000, (Object)"\u9752\u6d77\u7701");
        b.put((Object)630100, (Object)"\u897f\u5b81\u5e02");
        b.put((Object)630102, (Object)"\u57ce\u4e1c\u533a");
        b.put((Object)630103, (Object)"\u57ce\u4e2d\u533a");
        b.put((Object)630104, (Object)"\u57ce\u897f\u533a");
        b.put((Object)630105, (Object)"\u57ce\u5317\u533a");
        b.put((Object)630121, (Object)"\u5927\u901a\u56de\u65cf\u571f\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)630122, (Object)"\u6e5f\u4e2d\u53bf");
        b.put((Object)630123, (Object)"\u6e5f\u6e90\u53bf");
        b.put((Object)630200, (Object)"\u6d77\u4e1c\u5e02");
        b.put((Object)630202, (Object)"\u4e50\u90fd\u533a");
        b.put((Object)630203, (Object)"\u5e73\u5b89\u533a");
        b.put((Object)630222, (Object)"\u6c11\u548c\u56de\u65cf\u571f\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)630223, (Object)"\u4e92\u52a9\u571f\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)630224, (Object)"\u5316\u9686\u56de\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)630225, (Object)"\u5faa\u5316\u6492\u62c9\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)632200, (Object)"\u6d77\u5317\u85cf\u65cf\u81ea\u6cbb\u5dde");
        b.put((Object)632221, (Object)"\u95e8\u6e90\u56de\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)632222, (Object)"\u7941\u8fde\u53bf");
        b.put((Object)632223, (Object)"\u6d77\u664f\u53bf");
        b.put((Object)632224, (Object)"\u521a\u5bdf\u53bf");
        b.put((Object)632300, (Object)"\u9ec4\u5357\u85cf\u65cf\u81ea\u6cbb\u5dde");
        b.put((Object)632321, (Object)"\u540c\u4ec1\u53bf");
        b.put((Object)632322, (Object)"\u5c16\u624e\u53bf");
        b.put((Object)632323, (Object)"\u6cfd\u5e93\u53bf");
        b.put((Object)632324, (Object)"\u6cb3\u5357\u8499\u53e4\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)632500, (Object)"\u6d77\u5357\u85cf\u65cf\u81ea\u6cbb\u5dde");
        b.put((Object)632521, (Object)"\u5171\u548c\u53bf");
        b.put((Object)632522, (Object)"\u540c\u5fb7\u53bf");
        b.put((Object)632523, (Object)"\u8d35\u5fb7\u53bf");
        b.put((Object)632524, (Object)"\u5174\u6d77\u53bf");
        b.put((Object)632525, (Object)"\u8d35\u5357\u53bf");
        b.put((Object)632600, (Object)"\u679c\u6d1b\u85cf\u65cf\u81ea\u6cbb\u5dde");
        b.put((Object)632621, (Object)"\u739b\u6c81\u53bf");
        b.put((Object)632622, (Object)"\u73ed\u739b\u53bf");
        b.put((Object)632623, (Object)"\u7518\u5fb7\u53bf");
        b.put((Object)632624, (Object)"\u8fbe\u65e5\u53bf");
        b.put((Object)632625, (Object)"\u4e45\u6cbb\u53bf");
        b.put((Object)632626, (Object)"\u739b\u591a\u53bf");
        b.put((Object)632700, (Object)"\u7389\u6811\u85cf\u65cf\u81ea\u6cbb\u5dde");
        b.put((Object)632701, (Object)"\u7389\u6811\u5e02");
        b.put((Object)632722, (Object)"\u6742\u591a\u53bf");
        b.put((Object)632723, (Object)"\u79f0\u591a\u53bf");
        b.put((Object)632724, (Object)"\u6cbb\u591a\u53bf");
        b.put((Object)632725, (Object)"\u56ca\u8c26\u53bf");
        b.put((Object)632726, (Object)"\u66f2\u9ebb\u83b1\u53bf");
        b.put((Object)632800, (Object)"\u6d77\u897f\u8499\u53e4\u65cf\u85cf\u65cf\u81ea\u6cbb\u5dde");
        b.put((Object)632801, (Object)"\u683c\u5c14\u6728\u5e02");
        b.put((Object)632802, (Object)"\u5fb7\u4ee4\u54c8\u5e02");
        b.put((Object)632803, (Object)"\u832b\u5d16\u5e02");
        b.put((Object)632821, (Object)"\u4e4c\u5170\u53bf");
        b.put((Object)632822, (Object)"\u90fd\u5170\u53bf");
        b.put((Object)632823, (Object)"\u5929\u5cfb\u53bf");
        b.put((Object)640000, (Object)"\u5b81\u590f\u56de\u65cf\u81ea\u6cbb\u533a");
        b.put((Object)640100, (Object)"\u94f6\u5ddd\u5e02");
        b.put((Object)640104, (Object)"\u5174\u5e86\u533a");
        b.put((Object)640105, (Object)"\u897f\u590f\u533a");
        b.put((Object)640106, (Object)"\u91d1\u51e4\u533a");
        b.put((Object)640121, (Object)"\u6c38\u5b81\u53bf");
        b.put((Object)640122, (Object)"\u8d3a\u5170\u53bf");
        b.put((Object)640181, (Object)"\u7075\u6b66\u5e02");
        b.put((Object)640200, (Object)"\u77f3\u5634\u5c71\u5e02");
        b.put((Object)640202, (Object)"\u5927\u6b66\u53e3\u533a");
        b.put((Object)640205, (Object)"\u60e0\u519c\u533a");
        b.put((Object)640221, (Object)"\u5e73\u7f57\u53bf");
        b.put((Object)640300, (Object)"\u5434\u5fe0\u5e02");
        b.put((Object)640302, (Object)"\u5229\u901a\u533a");
        b.put((Object)640303, (Object)"\u7ea2\u5bfa\u5821\u533a");
        b.put((Object)640323, (Object)"\u76d0\u6c60\u53bf");
        b.put((Object)640324, (Object)"\u540c\u5fc3\u53bf");
        b.put((Object)640381, (Object)"\u9752\u94dc\u5ce1\u5e02");
        b.put((Object)640400, (Object)"\u56fa\u539f\u5e02");
        b.put((Object)640402, (Object)"\u539f\u5dde\u533a");
        b.put((Object)640422, (Object)"\u897f\u5409\u53bf");
        b.put((Object)640423, (Object)"\u9686\u5fb7\u53bf");
        b.put((Object)640424, (Object)"\u6cfe\u6e90\u53bf");
        b.put((Object)640425, (Object)"\u5f6d\u9633\u53bf");
        b.put((Object)640500, (Object)"\u4e2d\u536b\u5e02");
        b.put((Object)640502, (Object)"\u6c99\u5761\u5934\u533a");
        b.put((Object)640521, (Object)"\u4e2d\u5b81\u53bf");
        b.put((Object)640522, (Object)"\u6d77\u539f\u53bf");
        b.put((Object)650000, (Object)"\u65b0\u7586\u7ef4\u543e\u5c14\u81ea\u6cbb\u533a");
        b.put((Object)650100, (Object)"\u4e4c\u9c81\u6728\u9f50\u5e02");
        b.put((Object)650102, (Object)"\u5929\u5c71\u533a");
        b.put((Object)650103, (Object)"\u6c99\u4f9d\u5df4\u514b\u533a");
        b.put((Object)650104, (Object)"\u65b0\u5e02\u533a");
        b.put((Object)650105, (Object)"\u6c34\u78e8\u6c9f\u533a");
        b.put((Object)650106, (Object)"\u5934\u5c6f\u6cb3\u533a");
        b.put((Object)650107, (Object)"\u8fbe\u5742\u57ce\u533a");
        b.put((Object)650109, (Object)"\u7c73\u4e1c\u533a");
        b.put((Object)650121, (Object)"\u4e4c\u9c81\u6728\u9f50\u53bf");
        b.put((Object)650200, (Object)"\u514b\u62c9\u739b\u4f9d\u5e02");
        b.put((Object)650202, (Object)"\u72ec\u5c71\u5b50\u533a");
        b.put((Object)650203, (Object)"\u514b\u62c9\u739b\u4f9d\u533a");
        b.put((Object)650204, (Object)"\u767d\u78b1\u6ee9\u533a");
        b.put((Object)650205, (Object)"\u4e4c\u5c14\u79be\u533a");
        b.put((Object)650400, (Object)"\u5410\u9c81\u756a\u5e02");
        b.put((Object)650402, (Object)"\u9ad8\u660c\u533a");
        b.put((Object)650421, (Object)"\u912f\u5584\u53bf");
        b.put((Object)650422, (Object)"\u6258\u514b\u900a\u53bf");
        b.put((Object)650500, (Object)"\u54c8\u5bc6\u5e02");
        b.put((Object)650502, (Object)"\u4f0a\u5dde\u533a");
        b.put((Object)650521, (Object)"\u5df4\u91cc\u5764\u54c8\u8428\u514b\u81ea\u6cbb\u53bf");
        b.put((Object)650522, (Object)"\u4f0a\u543e\u53bf");
        b.put((Object)652300, (Object)"\u660c\u5409\u56de\u65cf\u81ea\u6cbb\u5dde");
        b.put((Object)652301, (Object)"\u660c\u5409\u5e02");
        b.put((Object)652302, (Object)"\u961c\u5eb7\u5e02");
        b.put((Object)652323, (Object)"\u547c\u56fe\u58c1\u53bf");
        b.put((Object)652324, (Object)"\u739b\u7eb3\u65af\u53bf");
        b.put((Object)652325, (Object)"\u5947\u53f0\u53bf");
        b.put((Object)652327, (Object)"\u5409\u6728\u8428\u5c14\u53bf");
        b.put((Object)652328, (Object)"\u6728\u5792\u54c8\u8428\u514b\u81ea\u6cbb\u53bf");
        b.put((Object)652700, (Object)"\u535a\u5c14\u5854\u62c9\u8499\u53e4\u81ea\u6cbb\u5dde");
        b.put((Object)652701, (Object)"\u535a\u4e50\u5e02");
        b.put((Object)652702, (Object)"\u963f\u62c9\u5c71\u53e3\u5e02");
        b.put((Object)652722, (Object)"\u7cbe\u6cb3\u53bf");
        b.put((Object)652723, (Object)"\u6e29\u6cc9\u53bf");
        b.put((Object)652800, (Object)"\u5df4\u97f3\u90ed\u695e\u8499\u53e4\u81ea\u6cbb\u5dde");
        b.put((Object)652801, (Object)"\u5e93\u5c14\u52d2\u5e02");
        b.put((Object)652822, (Object)"\u8f6e\u53f0\u53bf");
        b.put((Object)652823, (Object)"\u5c09\u7281\u53bf");
        b.put((Object)652824, (Object)"\u82e5\u7f8c\u53bf");
        b.put((Object)652825, (Object)"\u4e14\u672b\u53bf");
        b.put((Object)652826, (Object)"\u7109\u8006\u56de\u65cf\u81ea\u6cbb\u53bf");
        b.put((Object)652827, (Object)"\u548c\u9759\u53bf");
        b.put((Object)652828, (Object)"\u548c\u7855\u53bf");
        b.put((Object)652829, (Object)"\u535a\u6e56\u53bf");
        b.put((Object)652900, (Object)"\u963f\u514b\u82cf\u5730\u533a");
        b.put((Object)652901, (Object)"\u963f\u514b\u82cf\u5e02");
        b.put((Object)652922, (Object)"\u6e29\u5bbf\u53bf");
        b.put((Object)652923, (Object)"\u5e93\u8f66\u53bf");
        b.put((Object)652924, (Object)"\u6c99\u96c5\u53bf");
        b.put((Object)652925, (Object)"\u65b0\u548c\u53bf");
        b.put((Object)652926, (Object)"\u62dc\u57ce\u53bf");
        b.put((Object)652927, (Object)"\u4e4c\u4ec0\u53bf");
        b.put((Object)652928, (Object)"\u963f\u74e6\u63d0\u53bf");
        b.put((Object)652929, (Object)"\u67ef\u576a\u53bf");
        b.put((Object)653000, (Object)"\u514b\u5b5c\u52d2\u82cf\u67ef\u5c14\u514b\u5b5c\u81ea\u6cbb\u5dde");
        b.put((Object)653001, (Object)"\u963f\u56fe\u4ec0\u5e02");
        b.put((Object)653022, (Object)"\u963f\u514b\u9676\u53bf");
        b.put((Object)653023, (Object)"\u963f\u5408\u5947\u53bf");
        b.put((Object)653024, (Object)"\u4e4c\u6070\u53bf");
        b.put((Object)653100, (Object)"\u5580\u4ec0\u5730\u533a");
        b.put((Object)653101, (Object)"\u5580\u4ec0\u5e02");
        b.put((Object)653121, (Object)"\u758f\u9644\u53bf");
        b.put((Object)653122, (Object)"\u758f\u52d2\u53bf");
        b.put((Object)653123, (Object)"\u82f1\u5409\u6c99\u53bf");
        b.put((Object)653124, (Object)"\u6cfd\u666e\u53bf");
        b.put((Object)653125, (Object)"\u838e\u8f66\u53bf");
        b.put((Object)653126, (Object)"\u53f6\u57ce\u53bf");
        b.put((Object)653127, (Object)"\u9ea6\u76d6\u63d0\u53bf");
        b.put((Object)653128, (Object)"\u5cb3\u666e\u6e56\u53bf");
        b.put((Object)653129, (Object)"\u4f3d\u5e08\u53bf");
        b.put((Object)653130, (Object)"\u5df4\u695a\u53bf");
        b.put((Object)653131, (Object)"\u5854\u4ec0\u5e93\u5c14\u5e72\u5854\u5409\u514b\u81ea\u6cbb\u53bf");
        b.put((Object)653200, (Object)"\u548c\u7530\u5730\u533a");
        b.put((Object)653201, (Object)"\u548c\u7530\u5e02");
        b.put((Object)653221, (Object)"\u548c\u7530\u53bf");
        b.put((Object)653222, (Object)"\u58a8\u7389\u53bf");
        b.put((Object)653223, (Object)"\u76ae\u5c71\u53bf");
        b.put((Object)653224, (Object)"\u6d1b\u6d66\u53bf");
        b.put((Object)653225, (Object)"\u7b56\u52d2\u53bf");
        b.put((Object)653226, (Object)"\u4e8e\u7530\u53bf");
        b.put((Object)653227, (Object)"\u6c11\u4e30\u53bf");
        b.put((Object)654000, (Object)"\u4f0a\u7281\u54c8\u8428\u514b\u81ea\u6cbb\u5dde");
        b.put((Object)654002, (Object)"\u4f0a\u5b81\u5e02");
        b.put((Object)654003, (Object)"\u594e\u5c6f\u5e02");
        b.put((Object)654004, (Object)"\u970d\u5c14\u679c\u65af\u5e02");
        b.put((Object)654021, (Object)"\u4f0a\u5b81\u53bf");
        b.put((Object)654022, (Object)"\u5bdf\u5e03\u67e5\u5c14\u9521\u4f2f\u81ea\u6cbb\u53bf");
        b.put((Object)654023, (Object)"\u970d\u57ce\u53bf");
        b.put((Object)654024, (Object)"\u5de9\u7559\u53bf");
        b.put((Object)654025, (Object)"\u65b0\u6e90\u53bf");
        b.put((Object)654026, (Object)"\u662d\u82cf\u53bf");
        b.put((Object)654027, (Object)"\u7279\u514b\u65af\u53bf");
        b.put((Object)654028, (Object)"\u5c3c\u52d2\u514b\u53bf");
        b.put((Object)654200, (Object)"\u5854\u57ce\u5730\u533a");
        b.put((Object)654201, (Object)"\u5854\u57ce\u5e02");
        b.put((Object)654202, (Object)"\u4e4c\u82cf\u5e02");
        b.put((Object)654221, (Object)"\u989d\u654f\u53bf");
        b.put((Object)654223, (Object)"\u6c99\u6e7e\u53bf");
        b.put((Object)654224, (Object)"\u6258\u91cc\u53bf");
        b.put((Object)654225, (Object)"\u88d5\u6c11\u53bf");
        b.put((Object)654226, (Object)"\u548c\u5e03\u514b\u8d5b\u5c14\u8499\u53e4\u81ea\u6cbb\u53bf");
        b.put((Object)654300, (Object)"\u963f\u52d2\u6cf0\u5730\u533a");
        b.put((Object)654301, (Object)"\u963f\u52d2\u6cf0\u5e02");
        b.put((Object)654321, (Object)"\u5e03\u5c14\u6d25\u53bf");
        b.put((Object)654322, (Object)"\u5bcc\u8574\u53bf");
        b.put((Object)654323, (Object)"\u798f\u6d77\u53bf");
        b.put((Object)654324, (Object)"\u54c8\u5df4\u6cb3\u53bf");
        b.put((Object)654325, (Object)"\u9752\u6cb3\u53bf");
        b.put((Object)654326, (Object)"\u5409\u6728\u4e43\u53bf");
        b.put((Object)659001, (Object)"\u77f3\u6cb3\u5b50\u5e02");
        b.put((Object)659002, (Object)"\u963f\u62c9\u5c14\u5e02");
        b.put((Object)659003, (Object)"\u56fe\u6728\u8212\u514b\u5e02");
        b.put((Object)659004, (Object)"\u4e94\u5bb6\u6e20\u5e02");
        b.put((Object)659005, (Object)"\u5317\u5c6f\u5e02");
        b.put((Object)659006, (Object)"\u94c1\u95e8\u5173\u5e02");
        b.put((Object)659007, (Object)"\u53cc\u6cb3\u5e02");
        b.put((Object)659008, (Object)"\u53ef\u514b\u8fbe\u62c9\u5e02");
        b.put((Object)659009, (Object)"\u6606\u7389\u5e02");
        b.put((Object)710000, (Object)"\u53f0\u6e7e\u7701");
        b.put((Object)810000, (Object)"\u9999\u6e2f\u7279\u522b\u884c\u653f\u533a");
        b.put((Object)820000, (Object)"\u6fb3\u95e8\u7279\u522b\u884c\u653f\u533a");
        DISTRICT_CODE_MAPPING = b.build();
        AREA_CODE_LIST = new ArrayList<Integer>(DISTRICT_CODE_MAPPING.keySet());
    }

    public static enum Sex {
        M,
        F,
        N;

    }

    public static enum CertType {
        FIRST,
        SECOND,
        HONGKONG,
        MACAO,
        TAIWAN,
        PASSPORT;

    }
}

