/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.util;

import cn.ponfee.commons.http.Http;
import cn.ponfee.commons.http.HttpParams;
import cn.ponfee.commons.jce.digest.DigestUtils;
import cn.ponfee.commons.json.Jsons;
import cn.ponfee.commons.util.ObjectUtils;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class Wechats {
    public static String buildAuthorizeUrl(String appid, String redirect, String state) {
        return Wechats.buildAuthorizeUrl(appid, "UTF-8", redirect, state);
    }

    public static String buildAuthorizeUrl(String appid, String charset, String redirect, String state) {
        return Wechats.buildAuthorizeUrl(appid, charset, redirect, state, "snsapi_base");
    }

    public static String buildAuthorizeUrl(String appid, String charset, String redirect, String state, String scope) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("appid", appid);
        params.put("redirect_uri", redirect);
        params.put("response_type", "code");
        params.put("scope", scope);
        params.put("state", state);
        return HttpParams.buildUrlPath("https://open.weixin.qq.com/connect/oauth2/authorize", charset, params) + "#wechat_redirect";
    }

    public static Map<String, Object> getOAuth2(String appid, String secret, String code) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("appid", appid);
        params.put("secret", secret);
        params.put("code", code);
        params.put("grant_type", "authorization_code");
        Map result = Http.post("https://api.weixin.qq.com/sns/oauth2/access_token").data(params).request(Map.class);
        Wechats.checkError(result);
        return result;
    }

    public static Map<String, Object> refreshAccessToken(String appid, String refreshToken) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("grant_type", "refresh_token");
        params.put("appid", appid);
        params.put("refresh_token", refreshToken);
        Map result = Http.post("https://api.weixin.qq.com/sns/oauth2/refresh_token").data(params).request(Map.class);
        Wechats.checkError(result);
        return result;
    }

    public static Map<String, Object> getUserInfoByOAuth2(String accessToken, String openid) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("access_token", accessToken);
        params.put("openid", openid);
        params.put("lang", "zh_CN");
        Map result = Http.post("https://api.weixin.qq.com/sns/userinfo").data(params).request(Map.class);
        Wechats.checkError(result);
        return result;
    }

    public static String getAccessToken(String appid, String secret) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("grant_type", "client_credential");
        params.put("appid", appid);
        params.put("secret", secret);
        Map result = Http.post("https://api.weixin.qq.com/cgi-bin/token").data(params).request(Map.class);
        Wechats.checkError(result);
        return (String)result.get("access_token");
    }

    public static Map<String, Object> getUserInfoByGlobal(String accessToken, String openid) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("access_token", accessToken);
        params.put("openid", openid);
        Map result = Http.post("https://api.weixin.qq.com/cgi-bin/user/info").data(params).request(Map.class);
        Wechats.checkError(result);
        return result;
    }

    public static String getJsapiTicket(String accessToken) {
        return Wechats.getTicket("jsapi", accessToken);
    }

    public static String getTicket(String type, String accessToken) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("access_token", accessToken);
        params.put("type", type);
        Map result = Http.post("https://api.weixin.qq.com/cgi-bin/ticket/getticket").data(params).request(Map.class);
        Wechats.checkError(result);
        return (String)result.get("ticket");
    }

    public static Map<String, String> shareUrl(String jsapiTicket, String appid, String url) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("jsapi_ticket", jsapiTicket);
        map.put("noncestr", ObjectUtils.uuid22());
        map.put("timestamp", Long.toString(System.currentTimeMillis() / 1000L));
        map.put("url", !url.contains("#") ? url : url.substring(0, url.indexOf("#")));
        map.put("signature", DigestUtils.sha1Hex(HttpParams.buildSigning(map)));
        map.put("appid", appid);
        return map;
    }

    private static void checkError(Map<String, ?> result) {
        Object errcode = result.get("errcode");
        if (errcode != null && !"0".equals(errcode.toString())) {
            throw new RuntimeException("Wechat server response error:" + Jsons.toJson(result));
        }
    }
}

