/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.web;

import cn.ponfee.commons.io.Files;
import cn.ponfee.commons.util.RegexUtils;
import cn.ponfee.commons.util.Strings;
import cn.ponfee.commons.web.LiteDevice;
import cn.ponfee.commons.web.WebUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebContext {
    private static final ThreadLocal<HttpServletRequest> REQUEST = new ThreadLocal();
    private static final ThreadLocal<HttpServletResponse> RESPONSE = new ThreadLocal();
    private static final ThreadLocal<Map<String, String[]>> INJECTED_PARAMS = ThreadLocal.withInitial(HashMap::new);

    public static HttpServletRequest getRequest() {
        return REQUEST.get();
    }

    public static HttpServletResponse getResponse() {
        return RESPONSE.get();
    }

    public static void setParameter(String name, String value) {
        Object[] values = INJECTED_PARAMS.get().get(name);
        values = values == null || values.length == 0 ? new String[]{value} : (String[])ArrayUtils.add((Object[])values, (Object)value);
        INJECTED_PARAMS.get().put(name, (String[])values);
    }

    public static void clearParameter() {
        INJECTED_PARAMS.remove();
    }

    public static String getParameter(String name) {
        HttpServletRequest request = WebContext.getRequest();
        if (null != request) {
            return request.getParameter(name);
        }
        String[] values = INJECTED_PARAMS.get().get(name);
        return values == null || values.length == 0 ? null : values[0];
    }

    public static String[] getParameterValues(String name) {
        HttpServletRequest request = WebContext.getRequest();
        if (null != request) {
            return request.getParameterValues(name);
        }
        return INJECTED_PARAMS.get().get(name);
    }

    public String getText() {
        return this.getText(Files.DEFAULT_CHARSET_NAME);
    }

    public String getText(String charset) {
        return WebUtils.getText(WebContext.getRequest(), charset);
    }

    public static String getClientIp() {
        return WebUtils.getClientIp(WebContext.getRequest());
    }

    public static LiteDevice getClientDevice() {
        return WebUtils.getClientDevice(WebContext.getRequest());
    }

    private static void setRequest(HttpServletRequest req) {
        REQUEST.set(req);
    }

    private static void setResponse(HttpServletResponse resp) {
        RESPONSE.set(resp);
    }

    private static void removeRequest() {
        REQUEST.remove();
    }

    private static void removeResponse() {
        RESPONSE.remove();
    }

    public static class WebContextFilter
    implements Filter {
        private static final Logger LOG = LoggerFactory.getLogger(WebContextFilter.class);
        private static final String ORIGIN_HEADER = "Origin";
        public static final String ACCESS_CONTROL_REQUEST_METHOD_HEADER = "Access-Control-Request-Method";
        public static final String ACCESS_CONTROL_REQUEST_HEADERS_HEADER = "Access-Control-Request-Headers";
        public static final String ACCESS_CONTROL_ALLOW_ORIGIN_HEADER = "Access-Control-Allow-Origin";
        public static final String ACCESS_CONTROL_ALLOW_METHODS_HEADER = "Access-Control-Allow-Methods";
        public static final String ACCESS_CONTROL_ALLOW_HEADERS_HEADER = "Access-Control-Allow-Headers";
        public static final String ACCESS_CONTROL_MAX_AGE_HEADER = "Access-Control-Max-Age";
        public static final String ACCESS_CONTROL_ALLOW_CREDENTIALS_HEADER = "Access-Control-Allow-Credentials";
        public static final String ACCESS_CONTROL_EXPOSE_HEADERS_HEADER = "Access-Control-Expose-Headers";
        public static final String TIMING_ALLOW_ORIGIN_HEADER = "Timing-Allow-Origin";
        public static final String ALLOWED_ORIGINS_PARAM = "allowedOrigins";
        public static final String ALLOWED_TIMING_ORIGINS_PARAM = "allowedTimingOrigins";
        public static final String ALLOWED_METHODS_PARAM = "allowedMethods";
        public static final String ALLOWED_HEADERS_PARAM = "allowedHeaders";
        public static final String PREFLIGHT_MAX_AGE_PARAM = "preflightMaxAge";
        public static final String ALLOW_CREDENTIALS_PARAM = "allowCredentials";
        public static final String EXPOSED_HEADERS_PARAM = "exposedHeaders";
        public static final String CHAIN_PREFLIGHT_PARAM = "chainPreflight";
        private static final String ANY_ORIGIN = "*";
        private static final String DEFAULT_ALLOWED_ORIGINS = "*";
        private static final String DEFAULT_ALLOWED_TIMING_ORIGINS = "";
        private static final List<String> SIMPLE_HTTP_METHODS = Arrays.asList("GET", "POST", "HEAD");
        private static final List<String> DEFAULT_ALLOWED_METHODS = Arrays.asList("GET", "POST", "HEAD");
        private static final List<String> DEFAULT_ALLOWED_HEADERS = Arrays.asList("X-Requested-With", "Content-Type", "Accept", "Origin");
        private boolean corsEnable;
        private boolean anyOriginAllowed;
        private boolean anyTimingOriginAllowed;
        private boolean anyHeadersAllowed;
        private final List<String> allowedOrigins = new ArrayList<String>();
        private final List<String> allowedTimingOrigins = new ArrayList<String>();
        private final List<String> allowedMethods = new ArrayList<String>();
        private final List<String> allowedHeaders = new ArrayList<String>();
        private final List<String> exposedHeaders = new ArrayList<String>();
        private int preflightMaxAge;
        private boolean allowCredentials;
        private boolean chainPreflight;

        public void init(FilterConfig config) {
            String allowedOriginsConfig = config.getInitParameter(ALLOWED_ORIGINS_PARAM);
            String allowedTimingOriginsConfig = config.getInitParameter(ALLOWED_TIMING_ORIGINS_PARAM);
            this.corsEnable = Boolean.parseBoolean(Strings.ifBlank(config.getInitParameter("cors"), "true"));
            this.anyOriginAllowed = this.generateAllowedOrigins(this.allowedOrigins, allowedOriginsConfig, "*");
            this.anyTimingOriginAllowed = this.generateAllowedOrigins(this.allowedTimingOrigins, allowedTimingOriginsConfig, DEFAULT_ALLOWED_TIMING_ORIGINS);
            String allowedMethodsConfig = config.getInitParameter(ALLOWED_METHODS_PARAM);
            if (allowedMethodsConfig == null) {
                this.allowedMethods.addAll(DEFAULT_ALLOWED_METHODS);
            } else {
                this.allowedMethods.addAll(Arrays.asList(Strings.csvSplit(allowedMethodsConfig)));
            }
            String allowedHeadersConfig = config.getInitParameter(ALLOWED_HEADERS_PARAM);
            if (allowedHeadersConfig == null) {
                this.allowedHeaders.addAll(DEFAULT_ALLOWED_HEADERS);
            } else if ("*".equals(allowedHeadersConfig)) {
                this.anyHeadersAllowed = true;
            } else {
                this.allowedHeaders.addAll(Arrays.asList(Strings.csvSplit(allowedHeadersConfig)));
            }
            String preflightMaxAgeConfig = config.getInitParameter(PREFLIGHT_MAX_AGE_PARAM);
            if (preflightMaxAgeConfig == null) {
                preflightMaxAgeConfig = "1800";
            }
            try {
                this.preflightMaxAge = Integer.parseInt(preflightMaxAgeConfig);
            }
            catch (NumberFormatException x) {
                LOG.info("Cross-origin filter, could not parse '{}' parameter as integer: {}", (Object)PREFLIGHT_MAX_AGE_PARAM, (Object)preflightMaxAgeConfig);
            }
            String allowedCredentialsConfig = config.getInitParameter(ALLOW_CREDENTIALS_PARAM);
            if (allowedCredentialsConfig == null) {
                allowedCredentialsConfig = "true";
            }
            this.allowCredentials = Boolean.parseBoolean(allowedCredentialsConfig);
            String exposedHeadersConfig = config.getInitParameter(EXPOSED_HEADERS_PARAM);
            if (exposedHeadersConfig == null) {
                exposedHeadersConfig = DEFAULT_ALLOWED_TIMING_ORIGINS;
            }
            this.exposedHeaders.addAll(Arrays.asList(Strings.csvSplit(exposedHeadersConfig)));
            String chainPreflightConfig = config.getInitParameter(CHAIN_PREFLIGHT_PARAM);
            if (chainPreflightConfig == null) {
                chainPreflightConfig = "true";
            }
            this.chainPreflight = Boolean.parseBoolean(chainPreflightConfig);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cross-origin filter configuration: {}={}, {}={}, {}={}, {}={}, {}={}, {}={}, {}={}, {}={}", new Object[]{ALLOWED_ORIGINS_PARAM, allowedOriginsConfig, ALLOWED_TIMING_ORIGINS_PARAM, allowedTimingOriginsConfig, ALLOWED_METHODS_PARAM, allowedMethodsConfig, ALLOWED_HEADERS_PARAM, allowedHeadersConfig, PREFLIGHT_MAX_AGE_PARAM, preflightMaxAgeConfig, ALLOW_CREDENTIALS_PARAM, allowedCredentialsConfig, EXPOSED_HEADERS_PARAM, exposedHeadersConfig, CHAIN_PREFLIGHT_PARAM, chainPreflightConfig});
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
            HttpServletRequest request = (HttpServletRequest)req;
            HttpServletResponse response = (HttpServletResponse)resp;
            try {
                if (this.cros(request, response, chain)) {
                    WebContext.setRequest(request);
                    WebContext.setResponse(response);
                    chain.doFilter((ServletRequest)request, (ServletResponse)response);
                }
            }
            finally {
                WebContext.removeRequest();
                WebContext.removeResponse();
            }
        }

        public void destroy() {
            this.anyOriginAllowed = false;
            this.allowedOrigins.clear();
            this.allowedMethods.clear();
            this.allowedHeaders.clear();
            this.preflightMaxAge = 0;
            this.allowCredentials = false;
        }

        protected boolean isEnabled(HttpServletRequest request) {
            Enumeration elm = request.getHeaders("Connection");
            while (elm.hasMoreElements()) {
                String connection = (String)elm.nextElement();
                if (!"Upgrade".equalsIgnoreCase(connection)) continue;
                Enumeration upg = request.getHeaders("Upgrade");
                while (upg.hasMoreElements()) {
                    String upgrade = (String)upg.nextElement();
                    if (!"WebSocket".equalsIgnoreCase(upgrade)) continue;
                    return false;
                }
            }
            return true;
        }

        private boolean generateAllowedOrigins(List<String> allowedOriginStore, String allowedOriginsConfig, String defaultOrigin) {
            String[] allowedOrigins;
            if (allowedOriginsConfig == null) {
                allowedOriginsConfig = defaultOrigin;
            }
            for (String allowedOrigin : allowedOrigins = Strings.csvSplit(allowedOriginsConfig)) {
                if (allowedOrigin.length() <= 0) continue;
                if ("*".equals(allowedOrigin)) {
                    allowedOriginStore.clear();
                    return true;
                }
                allowedOriginStore.add(allowedOrigin);
            }
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean cros(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException {
            String origin = request.getHeader(ORIGIN_HEADER);
            if (origin == null || !this.corsEnable || !this.isEnabled(request)) {
                return true;
            }
            if (!this.anyOriginAllowed && !this.originMatches(this.allowedOrigins, origin)) {
                LOG.debug("Cross-origin request to {} with origin {} does not match allowed origins {}", new Object[]{request.getRequestURI(), origin, this.allowedOrigins});
                response.sendError(403, "Invalid CORS request.");
                return false;
            }
            if (this.isSimpleRequest(request)) {
                LOG.debug("Cross-origin request to {} is a simple cross-origin request", (Object)request.getRequestURI());
                this.handleSimpleResponse(request, response, origin);
            } else if (this.isPreflightRequest(request)) {
                LOG.debug("Cross-origin request to {} is a preflight cross-origin request", (Object)request.getRequestURI());
                this.handlePreflightResponse(request, response, origin);
                if (!this.chainPreflight) return false;
                LOG.debug("Preflight cross-origin request to {} forwarded to application", (Object)request.getRequestURI());
            } else {
                LOG.debug("Cross-origin request to {} is a non-simple cross-origin request", (Object)request.getRequestURI());
                this.handleSimpleResponse(request, response, origin);
            }
            if (this.anyTimingOriginAllowed || this.originMatches(this.allowedTimingOrigins, origin)) {
                response.setHeader(TIMING_ALLOW_ORIGIN_HEADER, origin);
                return true;
            } else {
                LOG.debug("Cross-origin request to {} with origin {} does not match allowed timing origins {}", new Object[]{request.getRequestURI(), origin, this.allowedTimingOrigins});
            }
            return true;
        }

        private boolean originMatches(List<String> allowedOrigins, String originList) {
            String[] origins;
            if (originList.trim().length() == 0) {
                return false;
            }
            for (String origin : origins = originList.split(" ")) {
                if (origin.trim().length() == 0) continue;
                for (String allowedOrigin : allowedOrigins) {
                    String regex;
                    if (!(allowedOrigin.contains("*") ? RegexUtils.matches(origin, regex = allowedOrigin.replace(".", "\\.").replace("*", ".*")) : allowedOrigin.equals(origin))) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean isSimpleRequest(HttpServletRequest request) {
            String method = request.getMethod();
            if (SIMPLE_HTTP_METHODS.contains(method)) {
                return request.getHeader(ACCESS_CONTROL_REQUEST_METHOD_HEADER) == null;
            }
            return false;
        }

        private boolean isPreflightRequest(HttpServletRequest request) {
            String method = request.getMethod();
            if (!"OPTIONS".equalsIgnoreCase(method)) {
                return false;
            }
            return request.getHeader(ACCESS_CONTROL_REQUEST_METHOD_HEADER) != null;
        }

        private void handleSimpleResponse(HttpServletRequest request, HttpServletResponse response, String origin) {
            response.setHeader(ACCESS_CONTROL_ALLOW_ORIGIN_HEADER, origin);
            if (!this.anyOriginAllowed) {
                response.addHeader("Vary", ORIGIN_HEADER);
            }
            if (this.allowCredentials) {
                response.setHeader(ACCESS_CONTROL_ALLOW_CREDENTIALS_HEADER, "true");
            }
            if (!this.exposedHeaders.isEmpty()) {
                response.setHeader(ACCESS_CONTROL_EXPOSE_HEADERS_HEADER, this.commify(this.exposedHeaders));
            }
        }

        private void handlePreflightResponse(HttpServletRequest request, HttpServletResponse response, String origin) {
            boolean methodAllowed = this.isMethodAllowed(request);
            if (!methodAllowed) {
                return;
            }
            List<String> headersRequested = this.getAccessControlRequestHeaders(request);
            boolean headersAllowed = this.areHeadersAllowed(headersRequested);
            if (!headersAllowed) {
                return;
            }
            response.setHeader(ACCESS_CONTROL_ALLOW_ORIGIN_HEADER, origin);
            if (!this.anyOriginAllowed) {
                response.addHeader("Vary", ORIGIN_HEADER);
            }
            if (this.allowCredentials) {
                response.setHeader(ACCESS_CONTROL_ALLOW_CREDENTIALS_HEADER, "true");
            }
            if (this.preflightMaxAge > 0) {
                response.setHeader(ACCESS_CONTROL_MAX_AGE_HEADER, String.valueOf(this.preflightMaxAge));
            }
            response.setHeader(ACCESS_CONTROL_ALLOW_METHODS_HEADER, this.commify(this.allowedMethods));
            if (this.anyHeadersAllowed) {
                response.setHeader(ACCESS_CONTROL_ALLOW_HEADERS_HEADER, this.commify(headersRequested));
            } else {
                response.setHeader(ACCESS_CONTROL_ALLOW_HEADERS_HEADER, this.commify(this.allowedHeaders));
            }
        }

        private boolean isMethodAllowed(HttpServletRequest request) {
            String accessControlRequestMethod = request.getHeader(ACCESS_CONTROL_REQUEST_METHOD_HEADER);
            LOG.debug("{} is {}", (Object)ACCESS_CONTROL_REQUEST_METHOD_HEADER, (Object)accessControlRequestMethod);
            boolean result = false;
            if (accessControlRequestMethod != null) {
                result = this.allowedMethods.contains(accessControlRequestMethod);
            }
            LOG.debug("Method {} is{} among allowed methods {}", new Object[]{accessControlRequestMethod, result ? DEFAULT_ALLOWED_TIMING_ORIGINS : " not", this.allowedMethods});
            return result;
        }

        private List<String> getAccessControlRequestHeaders(HttpServletRequest request) {
            String[] headers;
            String accessControlRequestHeaders = request.getHeader(ACCESS_CONTROL_REQUEST_HEADERS_HEADER);
            LOG.debug("{} is {}", (Object)ACCESS_CONTROL_REQUEST_HEADERS_HEADER, (Object)accessControlRequestHeaders);
            if (accessControlRequestHeaders == null) {
                return Collections.emptyList();
            }
            ArrayList<String> requestedHeaders = new ArrayList<String>();
            for (String header : headers = Strings.csvSplit(accessControlRequestHeaders)) {
                String h = header.trim();
                if (h.length() <= 0) continue;
                requestedHeaders.add(h);
            }
            return requestedHeaders;
        }

        private boolean areHeadersAllowed(List<String> requestedHeaders) {
            if (this.anyHeadersAllowed) {
                LOG.debug("Any header is allowed");
                return true;
            }
            boolean result = true;
            for (String requestedHeader : requestedHeaders) {
                boolean headerAllowed = false;
                for (String allowedHeader : this.allowedHeaders) {
                    if (!requestedHeader.equalsIgnoreCase(allowedHeader.trim())) continue;
                    headerAllowed = true;
                    break;
                }
                if (headerAllowed) continue;
                result = false;
                break;
            }
            LOG.debug("Headers {} are{} among allowed headers {}", new Object[]{requestedHeaders, result ? DEFAULT_ALLOWED_TIMING_ORIGINS : " not", this.allowedHeaders});
            return result;
        }

        private String commify(List<String> strings) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < strings.size(); ++i) {
                if (i > 0) {
                    builder.append(",");
                }
                builder.append(strings.get(i));
            }
            return builder.toString();
        }
    }
}

