/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.ws.adapter;

import cn.ponfee.commons.model.Page;
import cn.ponfee.commons.model.Result;
import cn.ponfee.commons.reflect.GenericUtils;
import cn.ponfee.commons.ws.adapter.model.MapEntry;
import cn.ponfee.commons.ws.adapter.model.MapItem;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.apache.commons.collections4.CollectionUtils;

public abstract class ResultPageMapAdapter<K, V>
extends XmlAdapter<Result<Page<MapItem>>, Result<Page<Map<K, V>>>> {
    protected final Class<K> ktype = GenericUtils.getActualTypeArgument(((Object)((Object)this)).getClass(), 0);
    protected final Class<V> vtype = GenericUtils.getActualTypeArgument(((Object)((Object)this)).getClass(), 1);

    protected ResultPageMapAdapter() {
    }

    public Result<Page<Map<K, V>>> unmarshal(Result<Page<MapItem>> v) {
        if (v.getData() == null || CollectionUtils.isEmpty(v.getData().getRows())) {
            return v;
        }
        return v.from(v.getData().map(items -> {
            if (items == null) {
                return null;
            }
            return Arrays.stream(items.getItem()).collect(Collectors.toMap(MapEntry::getKey, MapEntry::getValue));
        }));
    }

    public Result<Page<MapItem>> marshal(Result<Page<Map<K, V>>> v) {
        if (v.getData() == null || CollectionUtils.isEmpty(v.getData().getRows())) {
            return v;
        }
        return v.from(v.getData().map(e -> {
            if (e == null) {
                return null;
            }
            return new MapItem((MapEntry[])e.entrySet().stream().map(MapEntry::new).toArray(MapEntry[]::new));
        }));
    }
}

